/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0002H\u0000\u001a\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u001a\u0015\u0010\u0007\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\u0002H\u0007\u001a\u0015\u0010\n\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\u001a\u0015\u0010\f\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\r\u001a\u00020\u0002H\u0007\u001a\u0015\u0010\u000e\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\u001a\u0015\u0010\u000f\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0007\u001a\u0015\u0010\u0011\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0015\u0010\u0013\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\u001a\u0015\u0010\u0015\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001a\u0015\u0010\u0017\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0000\u001a\u0015\u0010\u0018\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0000\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u00a8\u0006\u001b"}, d2={"toPathSafe", "Ljava/nio/file/Path;", "", "resolveLanguageFromSwitches", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "switches", "", "clangFeatureMacro", "Lorg/jetbrains/annotations/NonNls;", "feature", "clangExtensionMacro", "extension", "clangAttributeMacro", "attribute", "clangBuiltinMacro", "clangTargetArchMacro", "arch", "clangTargetVendorMacro", "vendor", "clangTargetOsMacro", "os", "clangTargetEnvironmentMacro", "environment", "clangTargetVariantOsMacro", "clangTargetVariantEnvironmentMacro", "resolveOptionLanguage", "option", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nGCCCompilerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GCCCompilerUtils.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n388#2,7:102\n*S KotlinDebug\n*F\n+ 1 GCCCompilerUtils.kt\ncom/jetbrains/cidr/lang/workspace/compiler/GCCCompilerUtilsKt\n*L\n24#1:102,7\n*E\n"})
public final class GCCCompilerUtilsKt {
    @Nullable
    public static final Path toPathSafe(@Nullable String $this$toPathSafe) {
        Path path;
        if ($this$toPathSafe == null) {
            return null;
        }
        try {
            path = Path.of($this$toPathSafe, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            OCCompilerBase.LOG.warn("Invalid path: " + $this$toPathSafe);
            path = null;
        }
        return path;
    }

    @Nullable
    public static final OCLanguageKind resolveLanguageFromSwitches(@NotNull List<String> switches) {
        int indexOfLanguageSwitch;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(switches, (String)"switches");
            List<String> $this$indexOfLast$iv = switches;
            boolean $i$f$indexOfLast = false;
            ListIterator<String> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-x", (boolean)false, (int)2, null)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = indexOfLanguageSwitch = -1;
        }
        if (!(0 <= indexOfLanguageSwitch ? indexOfLanguageSwitch < ((Collection)switches).size() : false)) {
            return null;
        }
        String currentSwitch = StringsKt.substringAfter$default((String)switches.get(indexOfLanguageSwitch), (String)"-x", null, (int)2, null);
        OCLanguageKind kind = GCCCompilerUtilsKt.resolveOptionLanguage(currentSwitch);
        if (kind != null) {
            return kind;
        }
        return StringsKt.isBlank((CharSequence)currentSwitch) && indexOfLanguageSwitch < CollectionsKt.getLastIndex(switches) ? GCCCompilerUtilsKt.resolveOptionLanguage(switches.get(indexOfLanguageSwitch + 1)) : null;
    }

    @VisibleForTesting
    @NotNull
    public static final String clangFeatureMacro(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return "__CIDR_clang__has_feature_" + feature;
    }

    @VisibleForTesting
    @NotNull
    public static final String clangExtensionMacro(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return "__CIDR_clang__has_extension_" + extension;
    }

    @VisibleForTesting
    @NotNull
    public static final String clangAttributeMacro(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return "__CIDR_clang__has_attribute_" + attribute;
    }

    @VisibleForTesting
    @NotNull
    public static final String clangBuiltinMacro(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return "__CIDR_clang__has_builtin_" + extension;
    }

    @VisibleForTesting
    @NotNull
    public static final String clangTargetArchMacro(@NotNull String arch) {
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        return "__CIDR_clang__is_target_arch_" + arch;
    }

    @NotNull
    public static final String clangTargetVendorMacro(@NotNull String vendor) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        return "__CIDR_clang__is_target_vendor_" + vendor;
    }

    @NotNull
    public static final String clangTargetOsMacro(@NotNull String os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return "__CIDR_clang__is_target_os_" + os;
    }

    @NotNull
    public static final String clangTargetEnvironmentMacro(@NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return "__CIDR_clang__is_target_environment_" + environment;
    }

    @NotNull
    public static final String clangTargetVariantOsMacro(@NotNull String os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return "__CIDR_clang__is_target_variant_os_" + os;
    }

    @NotNull
    public static final String clangTargetVariantEnvironmentMacro(@NotNull String environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return "__CIDR_clang__is_target_variant_environment_" + environment;
    }

    private static final OCLanguageKind resolveOptionLanguage(String option) {
        return switch (((Object)StringsKt.trim((CharSequence)option)).toString()) {
            case "objective-c" -> (OCLanguageKind)CLanguageKind.OBJ_C;
            case "objective-c++" -> (OCLanguageKind)CLanguageKind.OBJ_CPP;
            case "c" -> (OCLanguageKind)CLanguageKind.C;
            case "c++" -> (OCLanguageKind)CLanguageKind.CPP;
            case "cu" -> (OCLanguageKind)CUDALanguageKind.CUDA;
            case "cuda" -> (OCLanguageKind)CUDALanguageKind.CUDA;
            default -> null;
        };
    }
}

