/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.jetbrains.cidr.lang.workspace.compiler.DefaultOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.GCCOptionsFilterKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/GCCOptionsFilter;", "Lcom/jetbrains/cidr/lang/workspace/compiler/DefaultOptionsFilter;", "skipOptions", "", "", "<init>", "(Ljava/util/Set;)V", "archAdded", "", "skipRest", "isSwitch", "parameter", "apply", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCOptionsFilter$Result;", "nextParameter", "intellij.cidr.projectModel"})
public final class GCCOptionsFilter
extends DefaultOptionsFilter {
    private boolean archAdded;
    private boolean skipRest;

    public GCCOptionsFilter(@NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        super(SetsKt.plus(skipOptions, (Iterable)GCCOptionsFilterKt.access$getSKIP_SWITCHES$p()));
    }

    @Override
    public boolean isSwitch(@NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return StringsKt.startsWith$default((CharSequence)parameter, (char)'-', (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public OCOptionsFilter.Result apply(@NotNull String parameter, @Nullable String nextParameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (this.skipRest) {
            return OCOptionsFilter.Result.SKIP;
        }
        OCOptionsFilter.Result result = super.apply(parameter, nextParameter);
        if (result != OCOptionsFilter.Result.KEEP) {
            return result;
        }
        if (StringsKt.startsWith$default((String)parameter, (String)"-Werror", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)parameter, (String)"-Wno-error", (boolean)false, (int)2, null)) {
            return OCOptionsFilter.Result.SKIP;
        }
        if (Intrinsics.areEqual((Object)"-arch", (Object)parameter)) {
            if (this.archAdded) {
                return OCOptionsFilter.Result.SKIP_WITH_VALUE;
            }
            this.archAdded = true;
        }
        if (StringsKt.startsWith$default((String)parameter, (String)"-include", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)parameter, (String)"--include", (boolean)false, (int)2, null)) {
            if ((Intrinsics.areEqual((Object)"-include", (Object)parameter) || Intrinsics.areEqual((Object)"--include", (Object)parameter)) && CollectionsKt.contains((Iterable)this.getSkipValues(), (Object)nextParameter)) {
                return OCOptionsFilter.Result.SKIP;
            }
            if (StringsKt.startsWith$default((String)parameter, (String)"--include=", (boolean)false, (int)2, null)) {
                String string = parameter.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String includeArg = string;
                if (this.getSkipValues().contains(includeArg)) {
                    return OCOptionsFilter.Result.SKIP;
                }
            } else {
                String string = parameter.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String includeArg = string;
                if (this.getSkipValues().contains(includeArg)) {
                    return OCOptionsFilter.Result.SKIP;
                }
            }
        }
        if (Intrinsics.areEqual((Object)parameter, (Object)"--")) {
            this.skipRest = true;
            return OCOptionsFilter.Result.SKIP;
        }
        return OCOptionsFilter.Result.KEEP;
    }
}

