/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CUDAToolkitInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCOutputParser;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilter;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001cH\u0016J\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0016J\u0016\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0016J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001cH\u0002J \u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u0012H\u0002J\u0018\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0012H\u0002J\u0018\u00105\u001a\u00020\u00122\u0006\u00102\u001a\u0002032\u0006\u00106\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler;", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerBase;", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Ljava/io/File;", "workingDirectory", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "tempFilesPool", "Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/io/File;Ljava/io/File;Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;Lcom/jetbrains/cidr/lang/workspace/compiler/TempFilesPool;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myVersion", "Lcom/intellij/openapi/util/Version;", "readVersion", "", "supportsForwardingUnknownArguments", "", "parseVersionString", "getCUDAArchFromMacro", "switches", "", "fromCUDAArch", "getComputeCapability", "orig", "Lcom/jetbrains/cidr/lang/toolchains/CidrCompilerSwitches;", "adjustMSVCFlags", "collectInfo", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfo;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "originalSwitches", "filterOptions", "skipOptions", "", "createOptionsFilter", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCOptionsFilter;", "filterDuplicateCCBin", "list", "getHostCompiler", "parser", "Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCOutputParser;", "runNVCC", "addExtraSwitches", "ccInfo", "cxxStandard", "resolveCUDAInstallDirectory", "hostMachine", "Lcom/jetbrains/cidr/system/HostMachine;", "cudaInstallPath", "syncRemoteCUDAHeaders", "cudaInstall", "Companion", "intellij.cidr.projectModel"})
@SourceDebugExtension(value={"SMAP\nNVCCCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NVCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,430:1\n1#2:431\n1563#3:432\n1634#3,3:433\n967#3,7:436\n1788#3,4:443\n388#3,7:447\n1563#3:454\n1634#3,3:455\n1563#3:458\n1634#3,3:459\n37#4:462\n36#4,3:463\n*S KotlinDebug\n*F\n+ 1 NVCCCompiler.kt\ncom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler\n*L\n120#1:432\n120#1:433,3\n139#1:436,7\n148#1:443,4\n152#1:447,7\n201#1:454\n201#1:455,3\n209#1:458\n209#1:459,3\n215#1:462\n215#1:463,3\n*E\n"})
public final class NVCCCompiler
extends OCCompilerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Version myVersion;

    public NVCCCompiler(@NotNull Project project, @NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment environment, @NotNull TempFilesPool tempFilesPool) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)tempFilesPool, (String)"tempFilesPool");
        super(executable, workingDirectory, environment, tempFilesPool);
        this.project = project;
        this.myVersion = this.parseVersionString();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @VisibleForTesting
    @Nullable
    public final String readVersion() {
        return this.doReadVersion(CollectionsKt.listOf((Object)"--version"), (Function<? super ProcessOutput, String>)((Function)arg_0 -> NVCCCompiler.readVersion$lambda$2(NVCCCompiler::readVersion$lambda$1, arg_0)));
    }

    private final boolean supportsForwardingUnknownArguments() {
        Version version = this.myVersion;
        return version != null ? version.isOrGreaterThan(Integer.valueOf(10), Integer.valueOf(2), Integer.valueOf(19)) : false;
    }

    private final Version parseVersionString() {
        String string = this.readVersion();
        if (string == null) {
            return null;
        }
        String version = string;
        MatchResult matchResult = NVCCCompilerKt.access$getNVCC_VERSION_TRIPLET_RE$p().matchEntire((CharSequence)version);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String major = (String)matchResult2.getMatch().getGroupValues().get(1);
        String minor = (String)matchResult2.getMatch().getGroupValues().get(2);
        String patch = (String)matchResult2.getMatch().getGroupValues().get(3);
        return new Version(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch));
    }

    private final String getCUDAArchFromMacro(List<String> switches) {
        Object v1;
        block4: {
            Object object;
            Object object22;
            block3: {
                Iterable iterable = switches;
                for (Object object22 : iterable) {
                    String it = (String)object22;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"-D__CUDA_ARCH__", (boolean)false, (int)2, null)) continue;
                    object = object22;
                    break block3;
                }
                object = null;
            }
            String cudaArch = (String)object;
            if (cudaArch != null) {
                return cudaArch;
            }
            Iterable iterable = switches;
            object22 = iterable.iterator();
            while (object22.hasNext()) {
                Object e = object22.next();
                String it = (String)e;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-D__CUDA_ARCH_LIST__", (boolean)false, (int)2, null)) continue;
                v1 = e;
                break block4;
            }
            v1 = null;
        }
        String string = v1;
        return string != null ? StringsKt.substringBefore$default((String)string, (String)",", null, (int)2, null) : null;
    }

    private final String fromCUDAArch(List<String> switches) {
        String string = this.getCUDAArchFromMacro(switches);
        if (string == null) {
            return null;
        }
        String cudaArch = string;
        String subStr = StringsKt.dropLast((String)StringsKt.substringAfter$default((String)cudaArch, (String)"=", null, (int)2, null), (int)1);
        return "sm_" + subStr;
    }

    private final String getComputeCapability(List<String> switches, CidrCompilerSwitches orig) {
        Collection collection = switches;
        List<String> list = orig.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List switchList = CollectionsKt.plus((Collection)collection, (Iterable)list);
        String string = this.fromCUDAArch(switchList);
        if (string == null) {
            string = "sm_52";
        }
        String gpuArch = string;
        return "--cuda-gpu-arch=" + gpuArch;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> adjustMSVCFlags(List<String> switches) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = switches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null) ? "-" + StringsKt.drop((String)it, (int)1) : it);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches originalSwitches) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
        Intrinsics.checkNotNullParameter((Object)originalSwitches, (String)"originalSwitches");
        return this.runNVCC(this.filterOptions(originalSwitches, SetsKt.emptySet()));
    }

    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, @NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter((Object)switches, (String)"switches");
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        List<String> list = switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        Iterable $this$takeWhile$iv = list;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            String it = (String)item$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"&&"))) break;
            list$iv.add(item$iv);
        }
        List list2 = list$iv;
        CidrCompilerSwitches cleanSwitches = new CidrCompilerSwitches(list2);
        return super.filterOptions(cleanSwitches, skipOptions);
    }

    @Override
    @NotNull
    public OCOptionsFilter createOptionsFilter(@NotNull Set<String> skipOptions) {
        Intrinsics.checkNotNullParameter(skipOptions, (String)"skipOptions");
        return new NVCCOptionsFilter(skipOptions);
    }

    private final List<String> filterDuplicateCCBin(List<String> list) {
        int n;
        block8: {
            int n2;
            Iterable $this$count$iv = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            if (n2 <= 1) {
                return list;
            }
            List<String> $this$indexOfLast$iv = list;
            boolean $i$f$indexOfLast = false;
            ListIterator<String> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"--compiler-bindir", (boolean)false, (int)2, null))) continue;
                n = iterator$iv.nextIndex();
                break block8;
            }
            n = -1;
        }
        int lastIndex = n;
        List result = new ArrayList();
        boolean lastWasCCBin = false;
        int n3 = ((Collection)list).size();
        for (int idx = 0; idx < n3; ++idx) {
            String elem = list.get(idx);
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir=", (boolean)false, (int)2, null)) {
                if (idx != lastIndex) continue;
                result.add(elem);
                continue;
            }
            if (StringsKt.startsWith$default((String)elem, (String)"-ccbin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)elem, (String)"--compiler-bindir", (boolean)false, (int)2, null)) {
                lastWasCCBin = true;
                if (idx != lastIndex) continue;
                result.add(elem);
                continue;
            }
            if (lastWasCCBin && lastIndex != idx - 1) continue;
            result.add(elem);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getHostCompiler(NVCCOutputParser parser) {
        String string;
        String compiler = parser.getCompiler();
        Path path = parser.getFullCompilerPath(compiler);
        if (path == null) {
            return compiler;
        }
        Path fullCompiler = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(fullCompiler, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(fullCompiler, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                string = ((Object)fullCompiler).toString();
                return string;
            }
        }
        string = compiler;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompilerInfo runNVCC(CidrCompilerSwitches switches) throws ExecutionException {
        Path path;
        CompilerInfo compilerInfo;
        Path emptyFile = null;
        try {
            Collection collection;
            HostMachine host = this.myEnvironment.getHostMachine();
            Path path2 = host.getTempDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getTempDirectory(...)");
            Path tempDir = path2;
            emptyFile = this.myTempFilesPool.writeToTempFile(host, "", tempDir, "compiler-file", ".cu");
            Pair<GeneralCommandLine, String> pair = NVCCCompiler.runNVCC$createCompilerExecutionCommandLine(this, switches, emptyFile);
            GeneralCommandLine commandLine1 = (GeneralCommandLine)pair.component1();
            String userFriendlyCommandLine1 = (String)pair.component2();
            OCCompilerBase.LOG.debug("Running: " + userFriendlyCommandLine1);
            ProcessOutput processOutput = OCCompilerBase.outCompilerRunner.run(commandLine1, this.myEnvironment);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"run(...)");
            ProcessOutput output = processOutput;
            OCCompilerBase.checkCompilerOutput(output, userFriendlyCommandLine1);
            OCCompilerBase.LOG.debug("Got stderr:\n" + output.getStderr() + "\nstdout:\n" + output.getStdout());
            Collection collection2 = output.getStderrLines();
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = output.getStdoutLines();
            } else {
                collection = collection2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ifEmpty(...)");
            List outputLines = (List)collection;
            CidrToolEnvironment cidrToolEnvironment = this.myEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"myEnvironment");
            NVCCOutputParser outputParser = new NVCCOutputParser(outputLines, cidrToolEnvironment);
            String compiler = this.getHostCompiler(outputParser);
            List<String> compilerFlags = outputParser.getFlags();
            Path path3 = host.getPath(compiler, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getPath(...)");
            CidrToolEnvironment cidrToolEnvironment2 = this.myEnvironment;
            Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment2, (String)"myEnvironment");
            OCCompilerKind compKind = OCCompilerResolver.Companion.resolve(this.project, path3, cidrToolEnvironment2);
            if (Intrinsics.areEqual((Object)compKind, (Object)NVCCCompilerKind.INSTANCE)) {
                throw new ExecutionException(CidrProjectModelBundle.message("nvcc.should.not.invoke.itself", new Object[0]));
            }
            OCCompiler oCCompiler = compKind.getCompilerInstance(this.project, new File(compiler), this.myWorkingDirectory, this.myEnvironment, this.myTempFilesPool);
            Intrinsics.checkNotNull((Object)oCCompiler);
            OCCompiler comp = oCCompiler;
            CidrCompilerSwitches cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(compilerFlags).build();
            Intrinsics.checkNotNullExpressionValue((Object)cidrCompilerSwitches, (String)"build(...)");
            CidrCompilerSwitches resultSwitches = cidrCompilerSwitches;
            CompilerInfo compilerInfo2 = comp.collectInfo((OCLanguageKind)CLanguageKind.CPP, resultSwitches);
            Intrinsics.checkNotNullExpressionValue((Object)compilerInfo2, (String)"collectInfo(...)");
            CompilerInfo ccInfo = compilerInfo2;
            CidrCompilerSwitches hostCompilerFlags = this.addExtraSwitches(ccInfo, switches, outputParser.getCxxStandard());
            Intrinsics.checkNotNull((Object)host);
            String cudaPath = this.resolveCUDAInstallDirectory(host, outputParser.getCUDAInstallDir());
            if (host.isRemote() && !host.isWsl() && ((CharSequence)cudaPath).length() > 0) {
                cudaPath = this.syncRemoteCUDAHeaders(host, cudaPath);
            }
            Map features = MapsKt.toMutableMap(ccInfo.getFeatures());
            features.put(OCCompilerFeatures.HostCompilerKind.HOST_COMPILER_KIND, compKind);
            features.put(OCCompilerFeatures.HostCompilerFlags.HOST_COMPILER_FLAGS, hostCompilerFlags);
            features.put(OCCompilerFeatures.CUDA_TOOLKIT, new CUDAToolkitInfo(cudaPath, host.isWsl()));
            compilerInfo = new CompilerInfo(switches, ccInfo.getDefines(), features, ccInfo.getHeadersSearchPaths(), ccInfo.getImplicitIncludes(), ccInfo.getPrecompiledIncludes(), ccInfo.getWarnings(), ccInfo.getCompilerExitCode(), null, 256, null);
            path = emptyFile;
        }
        catch (IOException e) {
            try {
                throw new ExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                block9: {
                    Path path4 = emptyFile;
                    if (path4 == null) break block9;
                    Path it = path4;
                    boolean bl = false;
                    this.myTempFilesPool.delete(it);
                }
                throw throwable;
            }
        }
        if (path != null) {
            Path it = path;
            boolean bl = false;
            this.myTempFilesPool.delete(it);
        }
        return compilerInfo;
    }

    private final CidrCompilerSwitches addExtraSwitches(CompilerInfo ccInfo, CidrCompilerSwitches originalSwitches, String cxxStandard) {
        Object[] objectArray = new String[]{"-x", "-FI"};
        List<String> list = this.filterOptions(ccInfo.getSwitches(), SetsKt.mutableSetOf((Object[])objectArray)).getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List<String> switchesList = list;
        objectArray = new String[]{this.getComputeCapability(switchesList, originalSwitches)};
        List additionalArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        boolean hasCXXFlag = OCLanguageStandard.Companion.findLanguageStandard(switchesList) != null;
        if (((CharSequence)cxxStandard).length() > 0 && !hasCXXFlag) {
            ((Collection)additionalArgs).add(cxxStandard);
        }
        List allFlags = CollectionsKt.plus((Collection)this.adjustMSVCFlags(switchesList), (Iterable)additionalArgs);
        return new CidrCompilerSwitches(allFlags);
    }

    private final String resolveCUDAInstallDirectory(HostMachine hostMachine, String cudaInstallPath) {
        String string;
        if (((CharSequence)cudaInstallPath).length() > 0) {
            String string2 = FileUtil.toSystemIndependentName((String)cudaInstallPath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            string = NVCCCompilerKt.access$toCanonicalPath(hostMachine, string2);
        } else if (hostMachine.getOS() == OS.Linux) {
            string = "";
        } else {
            OCCompilerBase.LOG.debug("Could not find cuda install path on " + hostMachine.getOS().name());
            string = "";
        }
        return string;
    }

    private final String syncRemoteCUDAHeaders(HostMachine hostMachine, String cudaInstall) {
        String string;
        Path path = hostMachine.getPath(cudaInstall, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path path2 = path;
        Object[] objectArray = hostMachine.toCanonicalPath(CollectionsKt.listOf((Object)FileUtil.toSystemIndependentName((String)((Object)path2.resolve("include")).toString())), true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toCanonicalPath(...)");
        Object[] includeDirectory = objectArray;
        List list = hostMachine.resolveAndCache(ArraysKt.toList((Object[])includeDirectory));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolveAndCache(...)");
        List resolvedPaths = list;
        if (resolvedPaths.isEmpty()) {
            string = "";
        } else {
            Path firstPath = Path.of((String)CollectionsKt.first((List)resolvedPaths), new String[0]);
            Path path3 = firstPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            string = ((Object)path3.toAbsolutePath()).toString();
        }
        return string;
    }

    private static final String readVersion$lambda$1(ProcessOutput it) {
        CharSequence charSequence;
        Regex regex = NVCCCompilerKt.access$getNVCC_VERSION_RE$p();
        CharSequence charSequence2 = it.getStdout();
        if (charSequence2.length() == 0) {
            Regex regex2 = regex;
            boolean bl = false;
            charSequence = it.getStderr();
            regex = regex2;
        } else {
            charSequence = charSequence2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifEmpty(...)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)charSequence, (int)0, (int)2, null);
        return matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
    }

    private static final String readVersion$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Pair<GeneralCommandLine, String> runNVCC$createCompilerExecutionCommandLine(NVCCCompiler this$0, CidrCompilerSwitches $switches, Path parameter) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        GeneralCommandLine cl = new GeneralCommandLine();
        this$0.myEnvironment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        List<String> list = $switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List<String> switchesList = this$0.filterDuplicateCCBin(list);
        String[] stringArray = (String[])switchesList;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"-isystem", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"-isystem=", (boolean)false, (int)2, null)) {
                String string3 = it.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string = "-isystem=" + string3;
            } else {
                string = it;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"'", (String)"\"", (boolean)false, (int)4, null));
        }
        List extraFlags = (List)destination$iv$iv;
        cl.withExePath(this$0.getExecutable().getPath());
        cl.withWorkingDirectory(this$0.myWorkingDirectory.toPath());
        Collection $this$toTypedArray$iv = extraFlags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        cl.addParameters(Arrays.copyOf(stringArray, stringArray.length));
        cl.addParameter("--dryrun");
        if (this$0.supportsForwardingUnknownArguments()) {
            cl.addParameter("-forward-unknown-to-host-compiler");
        }
        stringArray = new String[]{this$0.myEnvironment.toEnvPath(((Object)parameter.toAbsolutePath()).toString())};
        cl.addParameters(stringArray);
        return new Pair((Object)cl, (Object)cl.getCommandLineString());
    }

    @JvmStatic
    @Nullable
    public static final String getCCBinOption(@NotNull List<String> combinedCompilerFlags) {
        return Companion.getCCBinOption(combinedCompilerFlags);
    }

    @JvmStatic
    @NotNull
    public static final String getHostCompilerFlag(@NotNull String hostCompiler) {
        return Companion.getHostCompilerFlag(hostCompiler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/NVCCCompiler$Companion;", "", "<init>", "()V", "getCCBinOption", "", "combinedCompilerFlags", "", "getHostCompilerFlag", "hostCompiler", "intellij.cidr.projectModel"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final String getCCBinOption(@NotNull List<String> combinedCompilerFlags) {
            Intrinsics.checkNotNullParameter(combinedCompilerFlags, (String)"combinedCompilerFlags");
            String cudaCCBinOption = null;
            int n = ((Collection)combinedCompilerFlags).size();
            for (int idx = 0; idx < n; ++idx) {
                String currentFlag = combinedCompilerFlags.get(idx);
                if (!StringsKt.startsWith$default((String)currentFlag, (String)"-ccbin", (boolean)false, (int)2, null)) {
                    if (!StringsKt.startsWith$default((String)currentFlag, (String)"--compiler-bindir", (boolean)false, (int)2, null)) continue;
                }
                cudaCCBinOption = StringsKt.contains$default((CharSequence)currentFlag, (CharSequence)"=", (boolean)false, (int)2, null) ? currentFlag : (idx + 1 < combinedCompilerFlags.size() ? "-ccbin=" + combinedCompilerFlags.get(idx + 1) : null);
                break;
            }
            return cudaCCBinOption;
        }

        @JvmStatic
        @NotNull
        public final String getHostCompilerFlag(@NotNull String hostCompiler) {
            Intrinsics.checkNotNullParameter((Object)hostCompiler, (String)"hostCompiler");
            return "-ccbin=" + hostCompiler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

