/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.util.system.CpuArch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ArchitectureType {
    I386(32, 3, 332, "i386", "i486", "i586", "i686", "x86"),
    X86_64(64, 62, 34404, "x86_64", "x64", "amd64"),
    ARM(32, 40, 448, "arm", "xscale", "arm64_32"),
    ARM64(64, 183, 43620, "arm64", "armv8", "aarch64"),
    MIPS(32, 8, null, "mips"),
    MIPS64(64, 8, null, "mips64"),
    PPC(32, 20, null, "ppc", "powerpc"),
    PPC64(64, 21, null, "powerpc64", "ppc970-64"),
    SPARC(32, 2, null, "sparc"),
    SPARCV9(64, 43, null, "sparcv9"),
    RISCV32(32, 243, 20530, "riscv32"),
    RISCV64(64, 243, 20580, "riscv64"),
    UNKNOWN(0, null, null, "unknown");

    private final byte myBits;
    private final String @NotNull [] myIdPrefixArray;
    private final short myElfMachineCode;
    private final short myPeMachineCode;

    private ArchitectureType(@Nullable int bits, @NotNull Integer elfMachineCode, Integer peMachineCode, String ... idPrefix) {
        if (idPrefix == null) {
            ArchitectureType.$$$reportNull$$$0(0);
        }
        this.myElfMachineCode = elfMachineCode != null ? elfMachineCode.shortValue() : (short)0;
        short s = this.myPeMachineCode = peMachineCode != null ? peMachineCode.shortValue() : (short)0;
        if (idPrefix.length == 0) {
            throw new IllegalArgumentException("Missing architecture name");
        }
        this.myBits = (byte)bits;
        this.myIdPrefixArray = idPrefix;
    }

    @NotNull
    public String getId() {
        String string = this.myIdPrefixArray[0];
        if (string == null) {
            ArchitectureType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getBits() {
        return this.myBits;
    }

    @NotNull
    public static ArchitectureType forArchitecture(@Nullable String arch) {
        ArchitectureType found = UNKNOWN;
        if (arch != null) {
            int foundPrefixLength = 0;
            for (ArchitectureType value : ArchitectureType.values()) {
                for (String prefix : value.myIdPrefixArray) {
                    if (foundPrefixLength >= prefix.length() || !arch.startsWith(prefix)) continue;
                    foundPrefixLength = prefix.length();
                    found = value;
                    if (foundPrefixLength != arch.length()) continue;
                    ArchitectureType architectureType = found;
                    if (architectureType == null) {
                        ArchitectureType.$$$reportNull$$$0(2);
                    }
                    return architectureType;
                }
            }
        }
        ArchitectureType architectureType = found;
        if (architectureType == null) {
            ArchitectureType.$$$reportNull$$$0(3);
        }
        return architectureType;
    }

    @NotNull
    public static ArchitectureType forVmCpuArch(@NotNull CpuArch cpuArch) {
        if (cpuArch == null) {
            ArchitectureType.$$$reportNull$$$0(4);
        }
        ArchitectureType architectureType = switch (cpuArch) {
            default -> throw new IncompatibleClassChangeError();
            case CpuArch.X86 -> I386;
            case CpuArch.X86_64 -> X86_64;
            case CpuArch.ARM32 -> ARM;
            case CpuArch.ARM64 -> ARM64;
            case CpuArch.OTHER, CpuArch.UNKNOWN -> UNKNOWN;
        };
        if (architectureType == null) {
            ArchitectureType.$$$reportNull$$$0(5);
        }
        return architectureType;
    }

    @NotNull
    public static ArchitectureType forPeMachineType(short peCode) {
        for (ArchitectureType value : ArchitectureType.values()) {
            if (value.myPeMachineCode != peCode) continue;
            ArchitectureType architectureType = value;
            if (architectureType == null) {
                ArchitectureType.$$$reportNull$$$0(6);
            }
            return architectureType;
        }
        ArchitectureType architectureType = UNKNOWN;
        if (architectureType == null) {
            ArchitectureType.$$$reportNull$$$0(7);
        }
        return architectureType;
    }

    @NotNull
    public static ArchitectureType forElfMachineType(short elfCode) {
        for (ArchitectureType value : ArchitectureType.values()) {
            if (value.myElfMachineCode != elfCode) continue;
            ArchitectureType architectureType = value;
            if (architectureType == null) {
                ArchitectureType.$$$reportNull$$$0(8);
            }
            return architectureType;
        }
        ArchitectureType architectureType = UNKNOWN;
        if (architectureType == null) {
            ArchitectureType.$$$reportNull$$$0(9);
        }
        return architectureType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ArchitectureType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuArch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ArchitectureType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forArchitecture";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "forVmCpuArch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forPeMachineType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forElfMachineType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forVmCpuArch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

