/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrRunProcessUtil {
    @Deprecated
    public static final int READ_VERSION_TIMEOUT = 10000;

    public static int getReadVersionTimeout(@NotNull OS os) {
        if (os == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(0);
        }
        return os.equals((Object)OS.Windows) ? 30000 : 10000;
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull BaseProcessHandler<?> handler, @Nullable ProgressIndicator indicator, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(1);
        }
        return CidrRunProcessUtil.runProcess(handler, indicator, timeout);
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull ProcessHandler handler, @Nullable ProgressIndicator indicator, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(2);
        }
        ProcessOutput processOutput = CidrRunProcessUtil.runProcess(new CapturingProcessRunner(handler), indicator, timeout);
        if (processOutput == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    private static ProcessOutput runProcess(@NotNull CapturingProcessRunner runner, @Nullable ProgressIndicator indicator, int timeout) {
        if (runner == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(4);
        }
        try {
            return (ProcessOutput)CidrCoroutineHelper.execOnIO(() -> indicator == null ? runner.runProcess(timeout) : runner.runProcess(indicator, timeout));
        }
        catch (CancellationException e) {
            runner.destroyProcess();
            throw e;
        }
    }

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrRunProcessUtil.runWithProgress(handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler<?> handler, int timeout) {
        if (handler == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(5);
        }
        return CidrRunProcessUtil.runWithProgress(handler, timeout);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull ProcessHandler handler, int timeout) {
        ProgressIndicator indicator;
        ProcessOutput result;
        if (handler == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(6);
        }
        if ((result = CidrRunProcessUtil.runProcess(handler, indicator = CidrRunProcessUtil.getProgressIndicator(), timeout)).isCancelled()) {
            throw new ProcessCanceledException();
        }
        ProcessOutput processOutput = result;
        if (processOutput == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(7);
        }
        return processOutput;
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        if (commandLine == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(8);
        }
        try {
            ProcessOutput output = CidrRunProcessUtil.runWithProgress(new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (processHandler == null) {
            CidrRunProcessUtil.$$$reportNull$$$0(9);
        }
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunProcessUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunProcessUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReadVersionTimeout";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runWithProgress";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readOneLineWithProgress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHasPty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

