/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrExecutionStack;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSuspendContext
extends XSuspendContext {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final CidrExecutionStack myActiveStack;
    @NotNull
    private final CidrExecutionStack myCurrentStack;
    @NotNull
    private final Map<LLThread, CidrExecutionStack> myLoadedStacks;

    public CidrSuspendContext(@NotNull CidrDebugProcess process, @NotNull DebuggerDriver.StopPlace stopPlace, @Nullable CidrSuspensionCause cause) {
        if (process == null) {
            CidrSuspendContext.$$$reportNull$$$0(0);
        }
        if (stopPlace == null) {
            CidrSuspendContext.$$$reportNull$$$0(1);
        }
        this(process, process.newExecutionStack(stopPlace.thread, stopPlace.frame, true, cause, stopPlace.returnValue), stopPlace.thread, null);
    }

    public CidrSuspendContext(@NotNull CidrDebugProcess process, @NotNull CidrExecutionStack currentStack, @NotNull LLThread activeThread, @Nullable LLFrame preferableFrameToSelect) {
        if (process == null) {
            CidrSuspendContext.$$$reportNull$$$0(2);
        }
        if (currentStack == null) {
            CidrSuspendContext.$$$reportNull$$$0(3);
        }
        if (activeThread == null) {
            CidrSuspendContext.$$$reportNull$$$0(4);
        }
        this.myLoadedStacks = new HashMap<LLThread, CidrExecutionStack>();
        this.myProcess = process;
        this.myCurrentStack = currentStack;
        this.myLoadedStacks.put(this.myCurrentStack.getThread(), this.myCurrentStack);
        if (activeThread.equals(this.myCurrentStack.getThread())) {
            this.myActiveStack = this.myCurrentStack;
        } else {
            this.myActiveStack = this.myProcess.newExecutionStack(activeThread, null, false, null, null);
            this.myLoadedStacks.put(activeThread, this.myActiveStack);
        }
        this.myActiveStack.setPreferableFrameToSelect(preferableFrameToSelect);
    }

    @NotNull
    public CidrExecutionStack getActiveExecutionStack() {
        CidrExecutionStack cidrExecutionStack = this.myActiveStack;
        if (cidrExecutionStack == null) {
            CidrSuspendContext.$$$reportNull$$$0(5);
        }
        return cidrExecutionStack;
    }

    @NotNull
    public CidrExecutionStack getCurrentExecutionStack() {
        CidrExecutionStack cidrExecutionStack = this.myCurrentStack;
        if (cidrExecutionStack == null) {
            CidrSuspendContext.$$$reportNull$$$0(6);
        }
        return cidrExecutionStack;
    }

    @NotNull
    public CidrExecutionStack getOrCreateExecutionStack(@NotNull LLThread llThread) {
        if (llThread == null) {
            CidrSuspendContext.$$$reportNull$$$0(7);
        }
        CidrExecutionStack cidrExecutionStack = this.myLoadedStacks.computeIfAbsent(llThread, t -> this.myProcess.newExecutionStack((LLThread)t, null, false, null, null));
        if (cidrExecutionStack == null) {
            CidrSuspendContext.$$$reportNull$$$0(8);
        }
        return cidrExecutionStack;
    }

    public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(container, this.myProcess.getSession())) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                if (container.isObsolete()) {
                    return;
                }
                ThrowInTest.doThrow((UserDataHolder)this.myProcess, CidrDebugProcess.THROW_ON_THREAD_COLLECTION);
                List<LLThread> threads2 = driver.getThreads();
                ArrayList<CidrExecutionStack> stacks = new ArrayList<CidrExecutionStack>(threads2.size());
                for (LLThread each : threads2) {
                    stacks.add(this.getOrCreateExecutionStack(each));
                }
                container.addExecutionStack(stacks, true);
            }
            catch (DebuggerCommandException e) {
                container.errorOccurred(e.getMessage());
            }
            catch (ExecutionException e) {
                container.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentStack";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeThread";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrSuspendContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "llThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrSuspendContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveExecutionStack";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExecutionStack";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExecutionStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateExecutionStack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

