/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugLogConsole;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerDevToolWindowKt;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.time.Duration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/execution/debugger/TimelineModel;)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "showDetails", "", "element", "Lcom/jetbrains/cidr/execution/debugger/TimelineElement;", "intellij.cidr.debugger.core"})
public final class TimelineElementDetailsConsole
extends ConsoleViewImpl {
    @NotNull
    private final TimelineModel model;

    public TimelineElementDetailsConsole(@NotNull Project project, @NotNull TimelineModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project, true);
        this.model = model;
    }

    @NotNull
    public final TimelineModel getModel() {
        return this.model;
    }

    public final void showDetails(@NotNull TimelineElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.clear();
        long finishTime = TimelineModel.finishTimeOrNow$default(this.model, element, null, 2, null);
        Duration duration = Duration.ofMillis(finishTime - element.getStartTime());
        String string = duration.toSeconds() + "s" + duration.toMillisPart() + "ms\n";
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"LOG_DEBUG_OUTPUT");
        this.print(string, consoleViewContentType);
        Iterator<Pair<String, Long>> iterator = element.getMessages().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Pair<String, Long>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Pair<String, Long> pair;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
            String message = (String)pair.component1();
            long time = ((Number)pair.component2()).longValue();
            String formattedTime = CidrDebuggerDevToolWindowKt.access$formatTime(CidrDebugLogConsole.Companion.getLOG_TIME_FORMAT(), time);
            String string2 = "[" + formattedTime + "] " + message + "\n";
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
            this.print(string2, consoleViewContentType2);
        }
        this.scrollTo(0);
        this.setVisible(true);
        this.repaint();
    }
}

