/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.VersionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.UserExpirable;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandExpiredException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverTimeouts;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverUtilKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInferior;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLMissingThread;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLRegisterSet;
import com.jetbrains.cidr.execution.debugger.backend.LLRegistersKt;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.features.DisabledRawViewSupport;
import com.jetbrains.cidr.execution.debugger.backend.features.RawViewSupport;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBExclusiveThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBRegisterValue;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBRegistersKt;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbCommandExecutor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbCommandExecutorService;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbExtractedDescription;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexingSession;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbRawViewSupport;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbUtil;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbValueDescription;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSDebugSymbols;
import com.jetbrains.cidr.execution.debugger.backend.gdb.MacOSSierraDuringStartupProgramTerminatedException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegisterValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrDisasmOptions;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.PrintFormat;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public class GDBDriver
extends DebuggerDriver {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^GNU gdb (?:\\([^()]*(?:\\([^()]+\\)[^()]*)*\\))+[^\\d]*(\\d+\\.\\d+(?:\\.\\d+)?).*");
    public static final Key<String> PRETTY_PRINTERS_PATH = Key.create((String)"GDBDriver.PRETTY_PRINTERS_PATH");
    public static final Key<Boolean> ENABLE_STL_PRETTY_PRINTERS = Key.create((String)"GDBDriver.ENABLE_STL_PRETTY_PRINTERS");
    static final Key<LLValueLoader> LLVALUE_DATA_LOADER = Key.create((String)"GDBDriver.LLVALUE_DATA_LOADER");
    private static final Key<LLValueLoadedData> LLVALUE_DATA = Key.create((String)"GDBDriver.LLVALUE_DATA");
    private static final Key<GDBTuple> LLVALUE_CLASS_CHILDREN_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN");
    private static final Key<Integer> LLVALUE_CLASS_CHILDREN_COUNT_CACHE = Key.create((String)"GDBDriver.LLVALUE_CLASS_CHILDREN_COUNT_CACHE");
    private static final Key<MapElement> LLVALUE_MAP_ELEMENT = Key.create((String)"GDBDriver.LLVALUE_MAP_ELEMENT");
    private static final Key<LLValue> REGISTER_CHILDREN_VAR = Key.create((String)"GDBDriver.REGISTER_CHILDREN_VAR");
    private static final Key<String> FRAME_VAR_KEY = Key.create((String)"GDBDriver.FRAME_VAR_KEY");
    private static final Key<LLValue> PARENT_VALUE = Key.create((String)"GDBDriver.PARENT_VALUE");
    private static final Key<String> EVALUATED_EXPRESSION = Key.create((String)"GDBDriver.EVALUATED_EXPRESSION");
    @NonNls
    private static final String INFERIOR_NOT_EXECUTING = "mi_cmd_exec_interrupt: Inferior not executing.";
    @NonNls
    private static final String MAX_COMPLETIONS_REACHED = "*** List may be truncated, max-completions reached. ***";
    @NonNls
    private static final String FINISH_NOT_MEANINGFUL_IN_THE_OUTERMOST_FRAME = "\"finish\" not meaningful in the outermost frame.";
    @NonNls
    private static final String CANNOT_SET_WATCHPOINT_FOR_EXPRESSION = "Cannot set a watchpoint for this expression";
    private static final Pattern CANNOT_ACCESS_MEMORY_AT_ADDRESS = Pattern.compile("Cannot access memory at address 0x([0-9a-f]+)(?: .*)?");
    private static final Pattern INSTRUCTION_LINE = Pattern.compile("^.{0,4}0x([0-9a-f]+)(?: (<.*>))?:\t((?:[0-9a-f]{2} ?)+) *\t(.*)$");
    @VisibleForTesting
    public static final Pattern BAD_INSTRUCTION_WITH_PREFIX_SUFFIX = Pattern.compile("^[^#]*(\\(bad\\)).*$");
    private static final Pattern WHATIS_TYPE_OUTPUT = Pattern.compile("^(?:\\+.*?\\n)*type = (?:/\\* real type = (.*) \\*/\\n.*|(.*))\\n");
    private static final Pattern NON_ID_PATTERN = Pattern.compile("\\W+");
    private static final Pattern PROMPT = Pattern.compile("[ ]*>");
    private static final Pattern OBJECT_FILE_HEADER = Pattern.compile("^(?: {2}Object file: (.*)|\\w+ file: `(.+)', file type .+\\.)$");
    private static final Pattern SECTIONS_INFO = Pattern.compile("^(?: \\[\\d+])?\\s*(0x[0-9a-f]+)->(0x[0-9a-f]+) at 0x[0-9a-f]+: (\\S+)(.*)$");
    private static final Pattern LINE_INFO_RESULT = Pattern.compile("^Line ([0-9]+) of .* starts at address 0x([0-9a-f]+)(?: (<.*>))? and ends at 0x([0-9a-f]+)(?: (<.*>))?.*");
    private static final Pattern LINE_INFO_NO_CODE_RESULT = Pattern.compile("^Line ([0-9]+) of .* is at address 0x([0-9a-f]+)(?: (<.*>))? but contains no code.*");
    private static final int IGNORE_RESPONSE_COMMAND_TOKEN = 0;
    private static final Pattern INFO_INFERIOR_HEADER_PATTERN = Pattern.compile(" *Num +Description +Connection +(Executable) *");
    private static final Pattern SHOW_ARCH_PATTERN = Pattern.compile("^The target architecture is set to \"auto\" \\(currently \"(.*)\"\\)\\.$");
    private static final Pattern SHOW_ARCH_PATTERN_GDB9 = Pattern.compile("^The target architecture is set automatically \\(currently (.*)\\)$");
    private static final LLValueLoadedData EMPTY_LOADED_VALUE = new LLValueLoadedData("", null, 0, false, false, "", "");
    @Nullable
    private static Boolean ourShellAvailable;
    @TestOnly
    @Nullable
    private volatile MIResponseFilter myMIResponseFilter;
    @NotNull
    private final GDBDriverConfiguration myStarter;
    @NotNull
    private final ArchitectureType myArchitectureType;
    @NlsSafe
    @NotNull
    private final String myInterruptSignalName;
    @Nullable
    private Version myGdbVersion;
    @Nullable
    private String myWinBreakPath;
    private boolean myWindowsIoRedirectionEnabled;
    private boolean myUseExternalConsoleRequested;
    private volatile GeneralCommandLine myGdbCommandLine;
    private volatile BaseProcessHandler myProcessHandler;
    private final boolean myEmulateStepMode;
    private volatile boolean myMIAsyncMode;
    private volatile boolean myStepMode;
    private final Deque<Integer> myPromptLevelStack;
    private volatile Writer mySink;
    @Nullable
    private volatile OutputStream myProcessInput;
    @Nullable
    private Pty myPty;
    private final Collection<String> allocatedVariables;
    private final AtomicReference<GDBArchInfo> myCachedArchInfo;
    @Nullable
    private volatile Boolean mySupportsFreezeOtherThreads;
    @Nullable
    private volatile String myDefaultSchedulerLockingMode;
    private final AtomicReference<@NotNull GDBExclusiveThread> myExclusiveThread;
    private final AtomicReference<@Nullable Expirable> myExpirable;
    private volatile DebuggerDriver.DisasmFlavor myDisasmFlavor;
    private volatile boolean myPythonCommandsLoaded;
    private volatile boolean myUsePythonToLoadData;
    private volatile boolean myStopSteppingOnFunctionFinish;
    private volatile String myVarCreateCommandName;
    private volatile boolean myValueFilteringEnabled;
    @Nullable
    private volatile GdbIndexingSession myGdbIndexingSession;
    private final AtomicReference<RawViewSupport> myRawViewSupport;
    private final OutputStream myProcessInputProxy;
    private final Semaphore myCommandSemaphore;
    private volatile GdbCommandExecutor myCommandExecutor;
    private final Map<@NotNull Long, @NotNull Communication> myResultMap;
    private static final Long CONSOLE_COMMAND_RESPONSE_TOKEN;
    private static final Long ASYNC_COMMAND_RESPONSE_TOKEN;
    private final AtomicLong myCommandCounter;
    private final Semaphore myStopSemaphore;
    private boolean myIsInterruptedStop;
    private volatile boolean myProcessingStopPlace;
    private final Semaphore myPendingForAttachNotification;
    @Nullable
    private volatile LongSet myIndirectSymbols;
    @Nullable
    private Map<String, List<LLSection>> mySectionsMap;
    @NotNull
    private final ModuleMap myModuleMap;
    @Nullable
    private volatile LLModule myTargetModule;
    private final Map<Integer, String> myThreadToInferiorMap;
    private final Map<String, LLInferior> myInferiorsMap;
    @Nullable
    private volatile LLInferior myExecutingInferior;
    @Nullable
    private volatile DebuggerDriver.StopPlace myStopPlace;
    @NotNull
    private volatile Communication myCommunication;
    @NotNull
    private volatile Communication myPromptCommunication;
    @Nullable
    private volatile String myLastCommand;
    private boolean myIsConsoleCommand;
    private volatile boolean myExtractRichStrings;
    private ThreadFrameInfoDriverDelegate myThreadFrameInfoDriverDelegate;
    private static final Key<String> PROCESS_SIGNATURE_KEY;
    private final Bridge myBridge;

    @TestOnly
    public void setMIOutputFilterInTests(@NotNull @RegExp String regexp, @NotNull String replacement) {
        if (regexp == null) {
            GDBDriver.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            GDBDriver.$$$reportNull$$$0(1);
        }
        this.setMIOutputFilterInTests((NotNullFunction<? super String, String>)((NotNullFunction)s -> s.replaceAll(regexp, replacement)));
    }

    @TestOnly
    public void setMIOutputFilterInTests(@Nullable NotNullFunction<? super String, String> miOutputFilter) {
        this.setMIResponseFilterInTests(miOutputFilter == null ? null : (request, s) -> (String)miOutputFilter.fun((Object)s));
    }

    @TestOnly
    public void setMIResponseFilterInTests(@Nullable MIResponseFilter miResponseFilter) {
        this.myMIResponseFilter = miResponseFilter;
    }

    public GDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull GDBDriverConfiguration starter, @NotNull ArchitectureType architectureType) throws com.intellij.execution.ExecutionException {
        if (handler == null) {
            GDBDriver.$$$reportNull$$$0(2);
        }
        if (starter == null) {
            GDBDriver.$$$reportNull$$$0(3);
        }
        if (architectureType == null) {
            GDBDriver.$$$reportNull$$$0(4);
        }
        super(handler);
        this.myMIAsyncMode = false;
        this.myStepMode = false;
        this.myPromptLevelStack = new ArrayDeque<Integer>();
        this.allocatedVariables = new ArrayList<String>();
        this.myCachedArchInfo = new AtomicReference();
        this.myExclusiveThread = new AtomicReference<GDBExclusiveThread.None>(GDBExclusiveThread.None.INSTANCE);
        this.myExpirable = new AtomicReference();
        this.myVarCreateCommandName = "-var-create";
        this.myRawViewSupport = new AtomicReference();
        this.myProcessInputProxy = new OutputStream(){

            @Override
            public void write(int i) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(i);
                }
            }

            @Override
            public void write(byte[] bytes, int i, int i1) throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.write(bytes, i, i1);
                }
            }

            @Override
            public void close() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.close();
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream input = GDBDriver.this.myProcessInput;
                if (input != null) {
                    input.flush();
                }
            }
        };
        this.myCommandSemaphore = new Semaphore();
        this.myResultMap = ContainerUtil.createWeakValueMap();
        this.myCommandCounter = new AtomicLong(1L);
        this.myStopSemaphore = new Semaphore();
        this.myPendingForAttachNotification = new Semaphore();
        this.myModuleMap = new ModuleMap();
        this.myTargetModule = null;
        this.myThreadToInferiorMap = new HashMap<Integer, String>();
        this.myInferiorsMap = new HashMap<String, LLInferior>();
        this.myExecutingInferior = null;
        this.myStopPlace = null;
        this.myCommunication = new Communication(this, "");
        this.myPromptCommunication = new Communication(this, "");
        this.myLastCommand = null;
        this.myThreadFrameInfoDriverDelegate = new ThreadFrameInfoDriverDelegate(){};
        this.myBridge = new Bridge(){

            @Override
            @NotNull
            public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> c) {
                if (c == null) {
                    17.$$$reportNull$$$0(0);
                }
                CompletableFuture<T> completableFuture = GDBDriver.this.executeAsyncCommand(c);
                if (completableFuture == null) {
                    17.$$$reportNull$$$0(1);
                }
                return completableFuture;
            }

            @Override
            @NotNull
            public <T> T executeCommand(@NotNull Command<T> c) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (c == null) {
                    17.$$$reportNull$$$0(2);
                }
                T t = GDBDriver.this.executeCommand(c);
                if (t == null) {
                    17.$$$reportNull$$$0(3);
                }
                return t;
            }

            @Override
            @NotNull
            public String sendSilentRequestAndGetOutput(@NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (command == null) {
                    17.$$$reportNull$$$0(4);
                }
                if (args == null) {
                    17.$$$reportNull$$$0(5);
                }
                String string = GDBDriver.this.sendSilentRequestAndWaitForDone(command, args).getOutput();
                if (string == null) {
                    17.$$$reportNull$$$0(6);
                }
                return string;
            }

            @Override
            @NotNull
            public LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
                if (frameTuple == null) {
                    17.$$$reportNull$$$0(7);
                }
                LLFrame lLFrame = GDBDriver.this.doReadFrame(level, frameTuple);
                if (lLFrame == null) {
                    17.$$$reportNull$$$0(8);
                }
                return lLFrame;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                DebuggerDriver.ResultList<LLFrame> resultList = GDBDriver.this.doGetFrames(threadId, from, count);
                if (resultList == null) {
                    17.$$$reportNull$$$0(9);
                }
                return resultList;
            }

            @Override
            @NotNull
            public List<LLValue> doGetVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                List<LLValue> list = GDBDriver.this.doGetFrameVariables(threadId, frameIndex).getVariables();
                if (list == null) {
                    17.$$$reportNull$$$0(10);
                }
                return list;
            }

            @Override
            @NotNull
            public DebuggerDriver.FrameVariables doGetFrameVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                DebuggerDriver.FrameVariables frameVariables = GDBDriver.this.doGetFrameVariables(threadId, frameIndex);
                if (frameVariables == null) {
                    17.$$$reportNull$$$0(11);
                }
                return frameVariables;
            }

            @Override
            @NotNull
            public LLValueData doEvaluateAndLoad(long threadId, int frameIndex, String expression, @Nullable String language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                LLValue threadIdValue = GDBDriver.this.doEvaluate(threadId, frameIndex, expression, language);
                LLValueData lLValueData = GDBDriver.this.doLoadVariable((LLValue)threadIdValue).data;
                if (lLValueData == null) {
                    17.$$$reportNull$$$0(12);
                }
                return lLValueData;
            }

            @Override
            @Nullable
            public DebuggerDriver.StopPlace getStopPlace() {
                return GDBDriver.this.myStopPlace;
            }

            @Override
            @NotNull
            public LLValueData doLoadVariableData(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (value == null) {
                    17.$$$reportNull$$$0(13);
                }
                LLValueData lLValueData = GDBDriver.this.doLoadVariable((LLValue)value).data;
                if (lLValueData == null) {
                    17.$$$reportNull$$$0(14);
                }
                return lLValueData;
            }

            @Override
            @NotNull
            public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (var == null) {
                    17.$$$reportNull$$$0(15);
                }
                DebuggerDriver.ResultList<LLValue> resultList = GDBDriver.this.doGetVariableChildren(var, offset, count);
                if (resultList == null) {
                    17.$$$reportNull$$$0(16);
                }
                return resultList;
            }

            @Override
            @NotNull
            public LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                String debuggerLanguage = GDBDriver.convertLanguage(language);
                LLValue lLValue = GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage);
                if (lLValue == null) {
                    17.$$$reportNull$$$0(17);
                }
                return lLValue;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public LLValue doReadReturnValue(@NotNull GDBTuple stopTuple, long threadId, int n) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                void frameIndex;
                if (stopTuple == null) {
                    17.$$$reportNull$$$0(18);
                }
                return GDBDriver.this.doReadReturnValue(stopTuple, threadId, (int)frameIndex);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 6, 8, 9, 10, 11, 12, 14, 16, 17 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "c";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$17";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frameTuple";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stopTuple";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$17";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeAsyncCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeCommand";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "sendSilentRequestAndGetOutput";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doReadFrame";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetFrames";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetVariables";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetFrameVariables";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doEvaluateAndLoad";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doLoadVariableData";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doGetVariableChildren";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doEvaluate";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "executeAsyncCommand";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "executeCommand";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "sendSilentRequestAndGetOutput";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "doReadFrame";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "doLoadVariableData";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "doGetVariableChildren";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "doReadReturnValue";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 6, 8, 9, 10, 11, 12, 14, 16, 17 -> new IllegalStateException(string);
                };
            }
        };
        this.myStarter = starter;
        this.myArchitectureType = architectureType;
        this.myExtractRichStrings = starter.shouldExtractRichStrings();
        this.myInterruptSignalName = this.getInterruptSignalName();
        this.myEmulateStepMode = this.isMac();
    }

    @Override
    public void startDebuggerProcess() throws com.intellij.execution.ExecutionException {
        this.myCommandExecutor = GdbCommandExecutorService.getInstance().createExecutor(this.myStarter.getDebugProcessName());
        this.myGdbCommandLine = this.myStarter.createDriverCommandLine(this, this.myArchitectureType);
        this.myProcessHandler = this.createDebugProcessHandler(this.myGdbCommandLine, this.myStarter);
        this.myProcessHandler.addProcessListener(new ProcessListener(){
            @NotNull
            private StringBuilder myBuffer = new StringBuilder();
            private Boolean myGotAnyStdout = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                @NotNull String text = event.getText();
                if (outputType == ProcessOutputTypes.STDERR && !this.myGotAnyStdout.booleanValue()) {
                    GDBDriver.this.handleTargetOutput(text, outputType);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    int end;
                    this.myGotAnyStdout = true;
                    this.myBuffer.append(text);
                    String content = this.myBuffer.toString();
                    boolean changed = false;
                    while ((end = content.indexOf("\n")) != -1) {
                        String response = content.substring(0, end).trim();
                        content = content.substring(end + 1);
                        changed = true;
                        MIResponseFilter filter = GDBDriver.this.myMIResponseFilter;
                        if (filter != null) {
                            String commandWithToken = String.valueOf(GDBDriver.this.myCommunication.commandToken != null ? GDBDriver.this.myCommunication.commandToken : "") + GDBDriver.this.myCommunication.command;
                            for (String line : StringUtil.splitByLines((String)filter.apply(commandWithToken, response))) {
                                GDBDriver.this.processResponse(line);
                            }
                            continue;
                        }
                        GDBDriver.this.processResponse(response);
                    }
                    if (changed) {
                        this.myBuffer = new StringBuilder(content);
                    }
                } else {
                    if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                        CidrDebuggerLog.LOG.debug(GDBDriver.this.processSignature() + "<" + text);
                    }
                    if (ProcessOutputType.isStderr((Key)outputType)) {
                        GDBDriver.this.handleDebuggerOutput(text, outputType);
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(2);
                }
                CidrDebuggerLog.LOG.debug(GDBDriver.this.processSignature() + "<[terminated]");
                GDBDriver.this.cleanupOnTermination();
                GDBDriver.this.handleExited(event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        OutputStream input = this.myProcessHandler.getProcessInput();
        Charset charset = this.myProcessHandler.getCharset();
        assert (charset != null);
        this.mySink = new OutputStreamWriter(input, charset);
        this.myCommandSemaphore.down();
        this.executeCommandNoUserException(() -> this.handlePrompt());
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return true;
    }

    @Override
    public boolean supportsJumpToLine() {
        return true;
    }

    @Override
    @NotNull
    public BaseProcessHandler getProcessHandler() {
        BaseProcessHandler baseProcessHandler = this.myProcessHandler;
        if (baseProcessHandler == null) {
            GDBDriver.$$$reportNull$$$0(5);
        }
        return baseProcessHandler;
    }

    @Override
    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcessInputProxy;
    }

    @Override
    public void removeWatchpoint(@NotNull List<Integer> ids) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (ids == null) {
            GDBDriver.$$$reportNull$$$0(6);
        }
        this.removeCodepoints(ids);
    }

    @Override
    public void addSymbolsFile(@NotNull File file, @Nullable File module) {
        if (file == null) {
            GDBDriver.$$$reportNull$$$0(7);
        }
    }

    @Override
    public boolean isInPromptMode() {
        return this.getPromptLevel() > 0;
    }

    @Override
    public String getPromptText() {
        return "gdb";
    }

    @Override
    protected void setState(@NotNull DebuggerDriver.TargetState state) {
        if (state == null) {
            GDBDriver.$$$reportNull$$$0(8);
        }
        super.setState(state);
        this.myProcessingStopPlace = false;
        if (this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            this.executeAsyncCommand(new VoidCommand(){

                @Override
                public void run() {
                    GDBDriver.this.allocatedVariables.forEach(GDBDriver.this::doDeleteVar);
                    GDBDriver.this.allocatedVariables.clear();
                }
            });
            if (this.myUsePythonToLoadData) {
                try {
                    this.sendRequestAndWaitForDone("-cidr-var-delete-all", new Object[0]);
                }
                catch (com.intellij.execution.ExecutionException | DebuggerCommandException e) {
                    CidrDebuggerLog.LOG.warn(e);
                }
            }
        }
    }

    private void doDeleteVar(String varId) {
        try {
            this.sendRequestAndWaitForDone("-var-delete %s", varId);
        }
        catch (com.intellij.execution.ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug(e);
        }
    }

    @NotNull
    private String getInterruptSignalName() {
        String signalName;
        if (this.isWindows()) {
            return "INT";
        }
        try {
            String signalNameFromRegistry = Registry.stringValue((String)"cidr.debugger.gdb.interrupt.signal");
            signalName = StringUtil.trimStart((String)StringUtil.toUpperCase((String)signalNameFromRegistry.trim()), (String)"SIG");
            if (!StringUtil.isLatinAlphanumeric((CharSequence)signalName)) {
                this.warnUser("Invalid interrupt signal name '" + signalNameFromRegistry + "'; falling back to SIGSTOP");
                signalName = "STOP";
            }
        }
        catch (MissingResourceException e) {
            signalName = "STOP";
        }
        if (!this.getHostMachine().isRemote() && UnixProcessManager.getSignalNumber((String)signalName) == -1) {
            this.warnUser("Unknown interrupt signal SIG" + signalName);
        }
        String string = signalName;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String shellQuote(@NotNull String s) {
        if (s == null) {
            GDBDriver.$$$reportNull$$$0(10);
        }
        if (this.isWindows()) {
            String string = CommandLineUtil.escapeParameterOnWindows((String)s, (boolean)false);
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = GDBDriver.format("'%s'", s.replace("'", "'\\''"));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void warnUser(@NlsSafe @NotNull String message) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(13);
        }
        this.warnUser(message, null);
    }

    private void warnUser(@NlsSafe @NotNull String message, @Nullable Throwable e) {
        if (message == null) {
            GDBDriver.$$$reportNull$$$0(14);
        }
        message = message.trim();
        this.myHandler.handleNotification(message, DebuggerDriver.NotificationType.WARNING);
        CidrDebuggerLog.LOG.warn(message, e);
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) {
        this.myValueFilteringEnabled = enabled;
    }

    private void doSetUpGDB(boolean isRemoteTarget) throws com.intellij.execution.ExecutionException {
        boolean isElevated = this.myStarter.isElevated();
        this.readGdbVersionViaPython();
        CidrDebuggerUsagesCollector.logGdbVersion(this.myGdbVersion);
        try {
            this.doSetMaxDescription(256);
            this.gdbSet("print repeats", 0);
            this.gdbSet("print object", true);
            this.gdbSet("print asm-demangle", true);
            this.gdbSet("python print-stack", "full");
            if (this.myEmulateStepMode) {
                this.gdbSet("step-mode", true);
            }
            this.gdbSet("backtrace past-main", true);
            this.gdbSet("backtrace past-entry", true);
            this.gdbSet("follow-fork-mode", CidrDebuggerSettings.getInstance().isFollowChildOnFork() ? "child" : "parent");
            this.gdbSet("detach-on-fork", CidrDebuggerSettings.getInstance().isDetachOnFork());
            this.gdbSet("mem inaccessible-by-default", Registry.is((String)"cidr.debugger.gdb.mem.inaccessible", (boolean)false));
            if (this.myGdbVersion != null && this.myGdbVersion.isOrGreaterThan(Integer.valueOf(9))) {
                this.gdbSet("print finish", false);
            }
            this.doSetMIAsync(isRemoteTarget || isElevated || Registry.is((String)"cidr.debugger.gdb.forceMIAsync", (boolean)false));
            if (!isRemoteTarget && !"INT".equals(this.myInterruptSignalName)) {
                try {
                    this.sendSilentRequestAndWaitForDone("handle SIG%s stop nopass", this.myInterruptSignalName);
                }
                catch (GDBCommandException e) {
                    this.warnUser("Unable to setup interrupt signal '" + this.myInterruptSignalName + "': " + e.getMessage());
                }
            }
        }
        catch (DebuggerCommandException e) {
            this.warnUser("Cannot configure GDB defaults: " + e.getMessage(), e);
        }
        try {
            @NonNls Object script = "import sys; sys.dont_write_bytecode = True; ";
            String printersPath = (String)this.myGdbCommandLine.getUserData(PRETTY_PRINTERS_PATH);
            if (printersPath != null) {
                script = (String)script + "sys.path.insert(0, " + GDBDriver.stringify(this.toEnvPath(printersPath)) + "); ";
                script = (String)script + "from default.printers import register_default_printers; register_default_printers(None); ";
                if (this.myGdbCommandLine.getUserData(ENABLE_STL_PRETTY_PRINTERS) == Boolean.TRUE) {
                    Response response = this.sendSilentRequestAndWaitForDone("info pretty-printer", new Object[0]);
                    boolean hasSTLprinters = response.getOutput().contains("libstdc++-v6");
                    if (!hasSTLprinters) {
                        script = (String)script + "from libstdcxx.v6.printers import register_libstdcxx_printers; register_libstdcxx_printers(None); ";
                    }
                    script = (String)script + "from default.libstdcxx_printers import patch_libstdcxx_printers_module; patch_libstdcxx_printers_module(); ";
                }
                this.sendSilentRequestAndWaitForDone("python %s", script);
                if (CidrDebuggerSettings.getInstance().isQtRenderersEnabled() && this.supportsQtRenderers()) {
                    File qtRenderers = CidrDebuggerPathManager.getBundledQtPrinters();
                    if (qtRenderers.exists()) {
                        String qtRenderersPath = this.toEnvPath(qtRenderers.getAbsolutePath());
                        script = "sys.path.append(" + GDBDriver.stringify(qtRenderersPath) + "); ";
                        script = (String)script + "from default.gdb_qt_init import init_qt_support; init_qt_support(); ";
                        this.sendSilentRequestAndWaitForDone("python %s", script);
                    } else {
                        CidrDebuggerLog.LOG.debug("Not found Qt renderers; skip enabling Qt support");
                    }
                }
                this.sendRequestAndWaitForDone("-enable-pretty-printing", new Object[0]);
                this.loadPythonGdbMiCommands();
            }
        }
        catch (DebuggerCommandException e) {
            String msg = "Error during python setup: " + e.getMessage() + "\n\nSome features and performance optimizations will not be available.";
            if (e instanceof GDBCommandException) {
                GDBCommandException gdbCommandException = (GDBCommandException)e;
                msg = msg + "\n\n" + gdbCommandException.getResponse().getOutput();
            }
            this.warnUser(msg, e);
        }
    }

    private void readGdbVersionViaPython() throws com.intellij.execution.ExecutionException {
        try {
            Response response = this.sendSilentRequestAndWaitForDone("python import gdb; print(gdb.VERSION);", new Object[0]);
            String output = response.getOutput().trim();
            Version gdbVersion = Version.parseVersion((String)output);
            if (gdbVersion != null) {
                this.myGdbVersion = gdbVersion;
            }
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug("Failed to parse gdb version via python", (Throwable)e);
        }
    }

    private void loadPythonGdbMiCommands() throws com.intellij.execution.ExecutionException {
        if (!Registry.is((String)"cidr.debugger.gdb.usePythonGdbMiCommands")) {
            return;
        }
        if (this.myGdbVersion == null) {
            CidrDebuggerLog.LOG.debug("Unknown gdb version, skip loading python gdb/mi commands");
            return;
        }
        if (this.myGdbVersion.lessThan(Integer.valueOf(14), Integer.valueOf(1))) {
            CidrDebuggerLog.LOG.debug("Old gdb version, skip loading python gdb/mi commands");
            return;
        }
        try {
            String script = "from default.commands import register_commands; register_commands();";
            this.sendSilentRequestAndWaitForDone("python %s", script);
            this.myPythonCommandsLoaded = true;
            this.myVarCreateCommandName = "-cidr-mi-var-create";
            this.myUsePythonToLoadData = Registry.is((String)"cidr.debugger.gdb.usePythonToLoadData");
            this.myStopSteppingOnFunctionFinish = Registry.is((String)"cidr.debugger.gdb.stopSteppingOnFunctionFinish");
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Failed to load python gdb/mi commands", (Throwable)e);
        }
    }

    private void doSetStepMode(boolean enabled) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (this.myStepMode == enabled) {
            return;
        }
        if (!this.myEmulateStepMode) {
            this.gdbSet("step-mode", enabled);
        }
        this.myStepMode = enabled;
    }

    public boolean isMIAsyncMode() {
        return this.myMIAsyncMode;
    }

    private void doSetMIAsync(boolean enabled) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        try {
            boolean actualAsync = this.gdbShow("mi-async").getBoolean("value");
            if (enabled == actualAsync) {
                this.myMIAsyncMode = actualAsync;
                return;
            }
            this.gdbSet("mi-async", enabled);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Can't enable 'mi-async' mode (too old GDB?); falling back to 'target-async'");
            this.gdbSet("target-async", enabled);
        }
        this.myMIAsyncMode = enabled;
    }

    private void doSetMaxDescription(int maxLength) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        this.gdbSet("print elements", maxLength);
    }

    protected void gdbSet(@NonNls @NotNull String setting, boolean enabled) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(15);
        }
        this.gdbSet(setting, enabled ? "on" : "off");
    }

    protected void gdbSet(@NonNls @NotNull String setting, int value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(16);
        }
        this.gdbSet(setting, String.valueOf(value));
    }

    public void gdbSet(@NonNls @NotNull String setting, @NonNls @Nullable String value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String command;
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(17);
        }
        String string = command = value != null ? GDBDriver.format("-gdb-set %s %s", setting, value) : GDBDriver.format("unset %s", setting);
        if (StringUtil.containsLineBreak((CharSequence)command)) {
            this.createMI2RequestWithToken(command, -1L, -1).send().waitFor(GDBResponse.ResultRecord.Type.done);
        } else {
            this.sendRequestAndWaitForDone("%s", command);
        }
    }

    @NotNull
    protected GDBTuple gdbShow(@NonNls @NotNull String setting) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (setting == null) {
            GDBDriver.$$$reportNull$$$0(18);
        }
        GDBTuple gDBTuple = this.sendRequestAndWaitForDone("-gdb-show %s", setting).getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(19);
        }
        return gDBTuple;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForLaunch(@NotNull Installer installer, @Nullable String architecture) throws com.intellij.execution.ExecutionException {
        GeneralCommandLine targetCommandLine;
        if (installer == null) {
            GDBDriver.$$$reportNull$$$0(20);
        }
        boolean bl = this.myUseExternalConsoleRequested = (targetCommandLine = installer.install()).getUserData(USE_EXTERNAL_CONSOLE_KEY) == Boolean.TRUE;
        if (this.isMac()) {
            this.tryLoadIndirectSymbols(targetCommandLine);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            GdbIndexingSession indexingSession = this.myGdbIndexingSession;
            if (indexingSession != null) {
                GdbIndexer.getInstance().waitForCompletion(indexingSession);
            }
            this.doLoadExecutable(installer.getExecutableFile());
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws com.intellij.execution.ExecutionException {
                return GDBDriver.this.launch(targetCommandLine);
            }

            @Override
            protected void detachImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws com.intellij.execution.ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(@NotNull String name, boolean wait) throws com.intellij.execution.ExecutionException {
        if (name == null) {
            GDBDriver.$$$reportNull$$$0(21);
        }
        throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.attaching.by.name.not.implemented", new Object[0]));
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(@NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings) throws com.intellij.execution.ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(22);
        }
        if (sourcePathMappings == null) {
            GDBDriver.$$$reportNull$$$0(23);
        }
        DebuggerDriver.Inferior inferior = this.loadCoreDump(coreFile, symbolFile, sysroot, sourcePathMappings, Collections.emptyList());
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(24);
        }
        return inferior;
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadCoreDump(final @NotNull File coreFile, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> sourcePathMappings, @NotNull List<String> execSearchPaths) throws com.intellij.execution.ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(25);
        }
        if (sourcePathMappings == null) {
            GDBDriver.$$$reportNull$$$0(26);
        }
        if (execSearchPaths == null) {
            GDBDriver.$$$reportNull$$$0(27);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(false);
            if (symbolFile != null) {
                this.doLoadExecutable(symbolFile);
            }
            if (sysroot != null) {
                this.gdbSet("sysroot", sysroot.getPath());
            }
            this.doAddPathMapping(sourcePathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.targetSelectCore(coreFile);
                return 0L;
            }

            @Override
            protected void detachImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws com.intellij.execution.ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    private void targetSelectCore(@NotNull File coreFile) throws com.intellij.execution.ExecutionException {
        if (coreFile == null) {
            GDBDriver.$$$reportNull$$$0(28);
        }
        this.executeCommandNoUserException(() -> {
            this.doReadTargetInfo();
            Response response = this.sendRequest("-target-select core %s", this.toEnvPath(coreFile.getPath())).waitFor(GDBResponse.ResultRecord.Type.connected);
            GDBTuple frameTuple = response.getResultList().getRequiredTuple("frame");
            LLFrame frame = this.doReadFrame(frameTuple.getInt("level", 0), frameTuple);
            int threadId = 1;
            try {
                LLValue threadIdValue = this.doEvaluate(-1L, -1, "$_gthread", null);
                threadId = (int)this.doLoadVariable((LLValue)threadIdValue).data.intValue();
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn("Unable to retrieve thread id using $_gthread: " + e.getMessage());
            }
            LLThread thread = this.doGetThread(threadId);
            DebuggerDriver.StopPlace stopPlace = new DebuggerDriver.StopPlace(thread, frame);
            this.handleInterrupted(stopPlace);
            return -1;
        });
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(final @NotNull List<String> connectionScript, final @NlsSafe @NotNull String connectionDescription, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, final boolean strictStateControl) throws com.intellij.execution.ExecutionException {
        if (connectionScript == null) {
            GDBDriver.$$$reportNull$$$0(29);
        }
        if (connectionDescription == null) {
            GDBDriver.$$$reportNull$$$0(30);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(31);
        }
        this.executeCommandNoUserException(() -> {
            this.doSetUpGDB(true);
            if (symbolFile != null) {
                try {
                    this.doLoadExecutable(symbolFile);
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot load symbol file: " + e.getMessage(), e);
                }
            }
            if (sysroot != null) {
                try {
                    this.gdbSet("sysroot", sysroot.getPath());
                }
                catch (DebuggerCommandException e) {
                    throw new DebuggerCommandException("Cannot set sysroot: " + e.getMessage(), e);
                }
            }
            this.doAddPathMapping(pathMappings);
        });
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.connectTo(connectionScript, connectionDescription, strictStateControl);
                return 0L;
            }

            @Override
            protected void detachImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.detach(true);
            }

            @Override
            protected boolean destroyImpl() throws com.intellij.execution.ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForAttach(final int pid) throws com.intellij.execution.ExecutionException {
        if (this.isMac()) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.attaching.unsupported.for.gdb.on.os.x", new Object[0]));
        }
        this.executeCommandNoUserException(() -> this.doSetUpGDB(false));
        return new DebuggerDriver.Inferior(){

            @Override
            protected long startImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.attachTo(pid);
                return pid;
            }

            @Override
            protected void detachImpl() throws com.intellij.execution.ExecutionException {
                GDBDriver.this.detach(false);
            }

            @Override
            protected boolean destroyImpl() throws com.intellij.execution.ExecutionException {
                return GDBDriver.this.abort();
            }
        };
    }

    @Override
    @NotNull
    public DebuggerDriver.Inferior loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings) throws com.intellij.execution.ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(32);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(33);
        }
        DebuggerDriver.Inferior inferior = this.loadForRemote(connectionString, symbolFile, sysroot, pathMappings, Collections.emptyList());
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(34);
        }
        return inferior;
    }

    @NotNull
    public DebuggerDriver.Inferior loadForRemote(@NotNull String connectionString, @Nullable File symbolFile, @Nullable File sysroot, @NotNull List<DebuggerDriver.PathMapping> pathMappings, @NotNull List<String> additionalCommands) throws com.intellij.execution.ExecutionException {
        if (connectionString == null) {
            GDBDriver.$$$reportNull$$$0(35);
        }
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(36);
        }
        if (additionalCommands == null) {
            GDBDriver.$$$reportNull$$$0(37);
        }
        ArrayList<String> connectionScript = new ArrayList<String>(additionalCommands.size() + 1);
        connectionScript.add(GDBDriver.format("-target-select remote %s", connectionString));
        connectionScript.addAll(additionalCommands);
        DebuggerDriver.Inferior inferior = this.loadForRemote(connectionScript, connectionString, symbolFile, sysroot, pathMappings, true);
        if (inferior == null) {
            GDBDriver.$$$reportNull$$$0(38);
        }
        return inferior;
    }

    private void doAddPathMapping(@NotNull List<DebuggerDriver.PathMapping> pathMappings) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (pathMappings == null) {
            GDBDriver.$$$reportNull$$$0(39);
        }
        for (DebuggerDriver.PathMapping each : pathMappings) {
            String from = FileUtil.toSystemIndependentName((String)each.from);
            String to = FileUtil.toSystemIndependentName((String)each.to);
            try {
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(from), GDBDriver.stringify(to));
                String envFrom = this.toEnvPath(from);
                if (from.equals(envFrom)) continue;
                this.sendRequestAndWaitForDone("-gdb-set substitute-path %s %s", GDBDriver.stringify(envFrom), GDBDriver.stringify(to));
            }
            catch (DebuggerCommandException e) {
                throw new DebuggerCommandException("Cannot set path mapping: " + e.getMessage(), e);
            }
        }
    }

    private void tryLoadIndirectSymbols(@NotNull GeneralCommandLine line) {
        if (line == null) {
            GDBDriver.$$$reportNull$$$0(40);
        }
        try {
            this.myIndirectSymbols = MacOSDebugSymbols.load(line);
        }
        catch (IOException e) {
            this.warnUser("Cannot create and read debug symbols: " + ExceptionUtil.getMessage((Throwable)e), e);
        }
    }

    private void doLoadExecutable(@NotNull File file) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (file == null) {
            GDBDriver.$$$reportNull$$$0(41);
        }
        String path = this.toEnvPath(file.getPath());
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        try {
            this.sendRequestAndWaitForDone("-file-exec-and-symbols %s", GDBDriver.stringify(systemIndependentPath));
        }
        catch (DebuggerCommandException e) {
            if (GDBDriver.isErrorOpeningNonAsciiPath(e, this.getHostMachine(), systemIndependentPath)) {
                throw new DebuggerCommandException(GDBBundle.message("failed.to.load.executable.due.to.non.ascii.characters", path));
            }
            throw e;
        }
        this.handleModulesLoaded(Collections.singletonList(new LLModule(path)));
    }

    private int launch(@NotNull GeneralCommandLine targetCommandLine) throws com.intellij.execution.ExecutionException {
        if (targetCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(42);
        }
        return this.executeCommandNoUserException(() -> {
            String ldPreloadValue;
            this.printTargetCommandLine(targetCommandLine);
            Charset charset = targetCommandLine.getCharset();
            try {
                this.gdbSet("charset", charset.name());
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn(e.getMessage());
            }
            Path workDirectory = targetCommandLine.getWorkingDirectory();
            if (workDirectory != null) {
                this.sendRequestAndWaitForDone("-environment-cd %s", GDBDriver.stringify(this.toEnvPath(workDirectory.normalize().toString())));
            }
            Map gdbEnv = this.myGdbCommandLine.getEffectiveEnvironment();
            if (this.getHostMachine().isRemote() && (ldPreloadValue = (String)targetCommandLine.getEnvironment().remove("LD_PRELOAD")) != null) {
                this.doWrapExec(GDBDriver.format("env LD_PRELOAD=%s", this.shellQuote(ldPreloadValue)));
            }
            this.doPrepareInferiorEnv(targetCommandLine, gdbEnv);
            boolean useStartupWithShellWorkaroundOnSierra = this.isMacOSSierra() && Registry.is((String)"cidr.debugger.gdb.workaround.macOS.startupWithShell", (boolean)true);
            Request execRunRequest = this.buildRequest("-exec-run", new Object[0]);
            Object params = this.getInferiorArgs(targetCommandLine.getParametersList(), !useStartupWithShellWorkaroundOnSierra, this.isWindowsIoRedirectionEnabled());
            boolean emulateTerminal = this.myStarter.emulateTerminal();
            try {
                File inputFile = targetCommandLine.getInputFile();
                if (inputFile != null) {
                    Path inputPath = this.getHostMachine().getPath(inputFile.getPath(), new String[0]);
                    if (!Files.exists(inputPath, new LinkOption[0]) || !Files.isReadable(inputPath)) {
                        throw new FileNotFoundException(CidrDebuggerBundle.message("debug.driver.cannotReadInputFile", inputFile.getPath()));
                    }
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(this.toEnvPath(inputFile.getPath())));
                    if (emulateTerminal && !this.isWindows() && !this.getHostMachine().isRemote()) {
                        this.myPty = new Pty();
                        this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(this.myPty.getSlaveName()));
                        this.myProcessInput = this.myPty.getOutputStream();
                        this.myToRedirect = false;
                        this.initTerminalReader(targetCommandLine, this.myPty.getInputStream());
                    }
                } else if (!this.isWindows() && !this.getHostMachine().isRemote()) {
                    this.myPty = new Pty();
                    this.sendRequestAndWaitForDone("-inferior-tty-set %s", GDBDriver.stringify(this.myPty.getSlaveName()));
                    this.myProcessInput = this.myPty.getOutputStream();
                    if (emulateTerminal) {
                        this.myToRedirect = false;
                        this.initTerminalReader(targetCommandLine, this.myPty.getInputStream());
                    }
                } else if (this.getHostMachine().isRemote()) {
                    pipe = this.getHostMachine().openNamedPipe();
                    params = (String)params + GDBDriver.format(" < %s ", this.shellQuote(pipe.getName()));
                    this.myProcessInput = pipe.getOutputStream();
                } else if (this.isWindowsIoRedirectionEnabled()) {
                    pipe = WinPipe.createOutboundPipe("stdin");
                    params = GDBDriver.format(" < %s ", this.shellQuote(pipe.getName())) + (String)params;
                    this.myProcessInput = pipe.getOutputStream();
                }
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.error((Throwable)e);
                throw new com.intellij.execution.ExecutionException(CidrDebuggerBundle.message("debug.driver.cannotCreatePipe", e.getMessage()));
            }
            if (this.myToRedirect) {
                if (this.isWindows() && !this.isWindowsIoRedirectionEnabled()) {
                    this.gdbSet("new-console", true);
                } else {
                    boolean isCsh;
                    ProcessOutputReaders readers = this.initReaders(this.getHostMachine(), targetCommandLine, !this.isWindows(), false);
                    String redirectParams = GDBDriver.format(" 1> %s 2> %s ", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())), this.shellQuote(this.toEnvPath(readers.getErrFileAbsolutePath())));
                    String gdbShell = gdbEnv.getOrDefault("SHELL", "/bin/sh");
                    boolean bl = isCsh = this.isUnix() && gdbShell.endsWith("csh");
                    if (useStartupWithShellWorkaroundOnSierra) {
                        this.gdbSet("startup-with-shell", false);
                        String[] symbolNames = new String[]{"main", "__cxx_global_var_init", "__libc_csu_init", "__static_initialization_and_destruction_0"};
                        ArrayList<Integer> startBreakpointNumbers = new ArrayList<Integer>(symbolNames.length);
                        for (String symbolName : symbolNames) {
                            startBreakpointNumbers.add(this.doInsertSymbolicBreakpoint(symbolName, null, true).getId());
                        }
                        ThreadPlan.BreakpointHit startThreadPlan = (stopPlace, breakpointNumber) -> {
                            this.executeAsyncCommand(() -> {
                                this.sendSilentRequestAndWaitForDone("-break-delete %s", StringUtil.join((Iterable)startBreakpointNumbers, (String)" "));
                                try {
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getOutFileAbsolutePath()), 1)));
                                    this.sendSilentRequestAndWaitForDone("-data-evaluate-expression %s %s", GDBDriver.onThreadAndFrame(stopPlace), GDBDriver.stringify(GDBDriver.createDupFdCall(this.toEnvPath(readers.getErrFileAbsolutePath()), 2)));
                                }
                                catch (GDBCommandException e) {
                                    this.warnUser("Unable to setup IO redirection: " + e.getMessage(), e);
                                }
                                if (!startBreakpointNumbers.contains(breakpointNumber) || !this.doResumeInternal(stopPlace.thread, false)) {
                                    this.handleBreakpoint(stopPlace, breakpointNumber);
                                }
                            });
                            return false;
                        };
                        execRunRequest = execRunRequest.withThreadPlan(startThreadPlan).suppressRunningEvent();
                        if (ContainerUtil.find((Iterable)targetCommandLine.getParametersList().getList(), StringUtil::containsWhitespaces) != null) {
                            this.warnUser("'startup-with-shell' is turned off in order to make GDB run on macOS Sierra and higher.\nThe program arguments might be passed incorrectly");
                        }
                    } else if (this.isWindows()) {
                        params = redirectParams + (String)params;
                    } else if (!isCsh) {
                        boolean isZsh = gdbShell.endsWith("zsh");
                        String ARGV0 = "ARGV0";
                        if (isZsh && gdbEnv.containsKey("ARGV0") && !targetCommandLine.getEnvironment().containsKey("ARGV0")) {
                            this.gdbSet("env ARGV0", null);
                        }
                        params = (String)params + redirectParams;
                    } else if (GDBDriver.isBourneShellAvailable()) {
                        this.doWrapExec(this.getShellCommandLineString("exec \"$@\" " + redirectParams));
                    } else {
                        params = (String)params + GDBDriver.format(" >&! %s", this.shellQuote(this.toEnvPath(readers.getOutFileAbsolutePath())));
                        this.warnUser(gdbShell + " doesn't support separate IO redirection.\nThe output will appear without stderr coloring");
                    }
                }
            }
            this.doReadTargetInfo();
            this.gdbSet("args", (String)params);
            try {
                execRunRequest.send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
            catch (GDBCommandException e) {
                if (this.isMacOSSierra() && e.getMessage().startsWith("During startup program terminated with")) {
                    throw new MacOSSierraDuringStartupProgramTerminatedException(e);
                }
                throw e;
            }
            LLInferior executingInferior = this.myExecutingInferior;
            Integer pid = executingInferior != null ? Integer.valueOf(executingInferior.getPid()) : null;
            CidrDebuggerLog.LOG.assertTrue(pid != null);
            return pid;
        });
    }

    protected boolean isWindowsIoRedirectionEnabled() {
        return this.myWindowsIoRedirectionEnabled;
    }

    @NotNull
    protected static String createDupFdCall(@NotNull String path, int fd) {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(43);
        }
        String open = "((int (*)(const char *, int))open)";
        String dup2 = "((int (*)(int, int))dup2)";
        String openCall = GDBDriver.format("%s(%s, %o)", "((int (*)(const char *, int))open)", GDBDriver.stringify(path), 1);
        String string = GDBDriver.format("%s(%s, %d)", "((int (*)(int, int))dup2)", openCall, fd);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(44);
        }
        return string;
    }

    protected void doWrapExec(@NotNull String wrapper) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String oldWrapper;
        if (wrapper == null) {
            GDBDriver.$$$reportNull$$$0(45);
        }
        if ((oldWrapper = this.gdbShow("exec-wrapper").getString("value")) != null) {
            wrapper = (String)wrapper + " " + oldWrapper;
        }
        this.gdbSet("exec-wrapper", (String)wrapper);
    }

    protected static boolean isBourneShellAvailable() throws com.intellij.execution.ExecutionException {
        if (ourShellAvailable == null) {
            ourShellAvailable = ExecUtil.execAndGetOutput((GeneralCommandLine)GDBDriver.getShellWrapper("exit \"$@\" 1> /dev/null 2> /dev/null", "0")).checkSuccess(CidrDebuggerLog.LOG);
        }
        return ourShellAvailable;
    }

    @NotNull
    protected static GeneralCommandLine getShellWrapper(@NotNull String command, String ... parameters) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(46);
        }
        if (parameters == null) {
            GDBDriver.$$$reportNull$$$0(47);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{"/bin/sh", "-c", command, "--"}).withParameters(parameters);
        if (generalCommandLine == null) {
            GDBDriver.$$$reportNull$$$0(48);
        }
        return generalCommandLine;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull String command) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(49);
        }
        String string = this.getShellCommandLineString(GDBDriver.getShellWrapper(command, new String[0]));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    protected String getShellCommandLineString(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            GDBDriver.$$$reportNull$$$0(51);
        }
        String string = commandLine.getCommandLineList(null).stream().map(s -> this.shellQuote((String)s)).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    protected String getInferiorArgs(@NotNull ParametersList parametersList, boolean escapeParameters, boolean escapeForIORedirectionOnWindows) {
        if (parametersList == null) {
            GDBDriver.$$$reportNull$$$0(53);
        }
        Function<String, String> quoteFunction = parameter -> parameter;
        List<String> params = parametersList.getList();
        if (escapeParameters) {
            if (!this.isWindows()) {
                quoteFunction = parameter -> this.shellQuote((String)parameter);
            } else if (!escapeForIORedirectionOnWindows) {
                quoteFunction = parameter -> CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            } else {
                params = GDBDriver.quoteParametersForIORedirectionOnWindows(params);
            }
        }
        String string = params.stream().map(quoteFunction).collect(Collectors.joining(" "));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    private static List<String> quoteParametersForIORedirectionOnWindows(@NotNull List<String> params) {
        if (params == null) {
            GDBDriver.$$$reportNull$$$0(55);
        }
        ArrayList<String> quotedParams = new ArrayList<String>(params.size());
        boolean quote = false;
        for (String parameter : params) {
            String escapedParameter = CommandLineUtil.escapeParameterOnWindows((String)parameter, (boolean)false);
            StringBuilder sb = new StringBuilder();
            boolean wildRedirection = false;
            char prev = '\u0000';
            for (int i = 0; i < escapedParameter.length(); ++i) {
                char ch = escapedParameter.charAt(i);
                if (ch == '\"') {
                    if (prev == '\\') {
                        sb.append(prev);
                    } else {
                        boolean bl = quote = !quote;
                    }
                }
                if (!(ch != '<' && ch != '>' || quote)) {
                    wildRedirection = true;
                }
                sb.append(ch);
                prev = ch;
            }
            if (wildRedirection) {
                if (sb.charAt(0) == '\"') {
                    sb.insert(0, '\\');
                } else {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
            }
            quotedParams.add(sb.toString());
        }
        ArrayList<String> arrayList = quotedParams;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    protected void doPrepareInferiorEnv(GeneralCommandLine targetCommandLine, Map<String, String> gdbEnv) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        boolean unbufferedIO;
        if (!targetCommandLine.isPassParentEnvironment()) {
            this.sendSilentRequestAndWaitForDone("unset env", new Object[0]);
            gdbEnv = Collections.emptyMap();
        }
        Map targetEnv = targetCommandLine.getEffectiveEnvironment();
        for (Map.Entry entry : ContainerUtil.diff((Map)targetEnv, gdbEnv).entrySet()) {
            String key = StringUtil.escapeLineBreak((String)((String)entry.getKey()));
            String value = (String)((Couple)entry.getValue()).first;
            if (key.contains("=")) {
                CidrDebuggerLog.LOG.warn("Ignoring '" + key + "' env variable.");
                continue;
            }
            this.gdbSet("env " + key, value);
        }
        if (this.isMac() && !(unbufferedIO = "YES".equalsIgnoreCase((String)targetEnv.get("NSUnbufferedIO")))) {
            this.warnUser("NSUnbufferedIO is not set, output may be delayed");
        }
    }

    protected void doReadTargetInfo() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        this.initTargetModule();
        if (this.isWindows() && !this.myMIAsyncMode) {
            this.initWinBreakPath();
        }
    }

    private void initTargetModule() {
        String infoInferiorsOutput;
        try {
            infoInferiorsOutput = this.sendSilentRequestAndWaitForDone("info inferiors", new Object[0]).getOutput();
        }
        catch (com.intellij.execution.ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Failed to detect target module due to failed 'info inferiors' command");
            return;
        }
        String[] lines = StringUtil.splitByLines((String)infoInferiorsOutput);
        int executableOffset = -1;
        for (int headerIndex = 0; headerIndex < lines.length; ++headerIndex) {
            Matcher matcher = INFO_INFERIOR_HEADER_PATTERN.matcher(lines[headerIndex]);
            if (!matcher.matches()) continue;
            executableOffset = matcher.start(1);
            break;
        }
        if (executableOffset == -1) {
            CidrDebuggerLog.LOG.warn("Failed to detect a target module: 'info inferiors' output doesn't have the 'Executable' header");
            return;
        }
        for (int i = headerIndex + 1; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.startsWith("*")) continue;
            if (line.length() <= executableOffset) {
                return;
            }
            String executable = line.substring(executableOffset).trim();
            this.myTargetModule = new LLModule(executable);
            break;
        }
        if (this.myTargetModule == null) {
            CidrDebuggerLog.LOG.warn("Failed to detect a target module");
        }
    }

    private void initWinBreakPath() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        this.initWinBreakUsingArch();
        if (this.myWinBreakPath == null) {
            this.initWinBreakUsingInfoSections();
        }
    }

    private void initWinBreakUsingArch() {
        String arch;
        try {
            arch = this.computeArchitecture();
        }
        catch (com.intellij.execution.ExecutionException | DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Failed to get architecture for winbreak selection", e);
            return;
        }
        if (arch.contains("x86_64") || arch.contains("x86-64")) {
            this.myWinBreakPath = this.myStarter.getWinbreakFile("winbreak64.exe").getPath();
        } else if (arch.matches(".*\\bi\\d86.*")) {
            this.myWinBreakPath = this.myStarter.getWinbreakFile("winbreak32.exe").getPath();
        }
        if (this.myWinBreakPath == null) {
            CidrDebuggerLog.LOG.warn("Cannot select winbreak executable for target architecture: " + arch);
        }
    }

    private void initWinBreakUsingInfoSections() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendSilentRequestAndWaitForDone("maintenance info sections", new Object[0]);
        String consoleOutput = response.getOutput();
        Pattern pattern = Pattern.compile(".*`.+', file type (.+)\\.");
        for (String eachLine : StringUtil.splitByLines((String)consoleOutput)) {
            Matcher matcher = pattern.matcher(eachLine);
            if (!matcher.matches()) continue;
            String fileType = matcher.group(1);
            this.doSelectWinBreakBinary(fileType);
            break;
        }
    }

    protected void doSelectWinBreakBinary(@NotNull String targetFileType) throws com.intellij.execution.ExecutionException {
        String winBreakName;
        if (targetFileType == null) {
            GDBDriver.$$$reportNull$$$0(57);
        }
        if (targetFileType.matches(".*\\bi\\d86\\b.*")) {
            winBreakName = "winbreak32.exe";
        } else if (targetFileType.contains("86_64") || targetFileType.contains("86-64")) {
            winBreakName = "winbreak64.exe";
        } else {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.determine.architecture.target", targetFileType));
        }
        CidrDebuggerLog.LOG.debug("Winbreak selected: " + winBreakName + " for: " + targetFileType);
        File winBreakFile = this.myStarter.getWinbreakFile(winBreakName);
        if (!winBreakFile.exists()) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.find.winbreak.executable", winBreakFile.getPath()));
        }
        this.myWinBreakPath = winBreakFile.getPath();
    }

    private void attachTo(final int pid) throws com.intellij.execution.ExecutionException {
        this.executeCommandNoUserException(new AttachConnectCommand(){

            @Override
            protected int attach() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                GDBDriver.this.buildRequest("-target-attach %d", pid).suppressRunningEvent(GDBDriver.this.isWindows()).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                return pid;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleAttached(pid);
            }
        });
    }

    private void detach(boolean isRemoteTarget) throws com.intellij.execution.ExecutionException {
        this.executeCommandNoUserException(() -> {
            this.doInterruptAndWait();
            Response response = this.buildRequest("-target-detach", new Object[0]).suppressTargetFinishedEvent().send().waitFor(new GDBResponse.ResultRecord.Type[0]);
            String message = response.getGDBErrorMessage();
            if (message != null) {
                if (message.equals("Remote connection closed") || message.matches("Remote communication error\\. *Target disconnected.*") || message.equals("Remote doesn't know how to detach") || message.equals("Can't detach process.")) {
                    this.warnUser(message);
                } else if (!message.equals("The program is not being run.")) {
                    throw new GDBCommandException(response, message);
                }
            }
            if (isRemoteTarget) {
                this.handleDisconnected();
            } else {
                this.handleDetached();
            }
        });
    }

    private void connectTo(final @NotNull List<String> connectionScript, final @NotNull String connectionDescription, final boolean controlState) throws com.intellij.execution.ExecutionException {
        if (connectionScript == null) {
            GDBDriver.$$$reportNull$$$0(58);
        }
        if (connectionDescription == null) {
            GDBDriver.$$$reportNull$$$0(59);
        }
        this.executeCommandNoUserException(new AttachConnectCommand(){
            private static final GDBResponse.ResultRecord.Type[] CONNECTED = new GDBResponse.ResultRecord.Type[]{GDBResponse.ResultRecord.Type.connected};
            private static final GDBResponse.ResultRecord.Type[] DONE = new GDBResponse.ResultRecord.Type[]{GDBResponse.ResultRecord.Type.done};
            private static final GDBResponse.ResultRecord.Type[] NONE = new GDBResponse.ResultRecord.Type[0];

            @Override
            protected int attach() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                GDBResponse.ResultRecord.Type[] expectedTypes = controlState ? CONNECTED : NONE;
                for (String command : connectionScript) {
                    GDBDriver.this.sendRequest("%s", command).waitFor(expectedTypes);
                    if (!controlState) continue;
                    expectedTypes = DONE;
                }
                return -1;
            }

            @Override
            protected void whenAttached() {
                GDBDriver.this.handleConnected(connectionDescription);
            }
        });
    }

    @Override
    public boolean interrupt() throws com.intellij.execution.ExecutionException {
        return this.executeCommandNoUserException(() -> this.doInterrupt(false));
    }

    private boolean doInterrupt(boolean tearDownRequest) throws com.intellij.execution.ExecutionException {
        boolean needInterrupt;
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        LLInferior executingInferior = this.myExecutingInferior;
        Integer pid = executingInferior != null ? Integer.valueOf(executingInferior.getPid()) : null;
        DebuggerDriver.TargetStateTransition transition = this.getStateTransition();
        boolean bl = needInterrupt = transition.getCurrentState() == DebuggerDriver.TargetState.RUNNING || transition.getCurrentState() == DebuggerDriver.TargetState.FINISHING && transition.getPreviousState() == DebuggerDriver.TargetState.RUNNING;
        if (pid == null || !needInterrupt || this.myProcessingStopPlace) {
            return false;
        }
        if (this.myMIAsyncMode) {
            return this.doInterruptAsync(tearDownRequest);
        }
        this.doInterruptWithSignal(pid, tearDownRequest);
        return true;
    }

    protected boolean doInterruptAsync(boolean tearDownRequest) throws com.intellij.execution.ExecutionException {
        try {
            this.buildRequest("-exec-interrupt", new Object[0]).tearDownRequest(tearDownRequest).send().waitFor(GDBResponse.ResultRecord.Type.done);
            return true;
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn((Throwable)e);
            return false;
        }
    }

    protected void doInterruptWithSignal(int pid, boolean tearDownRequest) throws com.intellij.execution.ExecutionException {
        this.sendRequestOrSpecialCommunication("interrupt", tearDownRequest, (ThrowableRunnable<? extends com.intellij.execution.ExecutionException>)((ThrowableRunnable)() -> {
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(this.processSignature() + ">interrupt");
            }
            if (this.isWindows()) {
                this.doInterruptWinBreak(pid);
            } else {
                this.doInterruptUnixSignal(pid);
            }
        }));
    }

    private String processSignature() {
        String signature = (String)PROCESS_SIGNATURE_KEY.get((UserDataHolder)this.myProcessHandler);
        if (signature == null) {
            Long pid = DebuggerDriverUtilKt.getProcessPid(this.myProcessHandler.getProcess());
            signature = String.valueOf(pid == null ? (long)this.myProcessHandler.hashCode() : pid);
            PROCESS_SIGNATURE_KEY.set((UserDataHolder)this.myProcessHandler, (Object)signature);
        }
        return signature;
    }

    private void doInterruptWinBreak(int pid) throws com.intellij.execution.ExecutionException {
        CidrDebuggerLog.LOG.debug(">Sending interrupt signal using 'winbreak'");
        if (this.myWinBreakPath == null) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.winbreak.was.not.selected", new Object[0]));
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{this.myWinBreakPath, Integer.toString(pid)}));
        String stderr = output.getStderr();
        CidrDebuggerLog.LOG.debug(stderr);
        int exitCode = output.getExitCode();
        if (exitCode != 0) {
            CidrDebuggerLog.LOG.debug("winbreak failed with exit code " + exitCode);
            throw new com.intellij.execution.ExecutionException(GDBDriver.extractErrorLinesFromOutput(stderr));
        }
    }

    @NlsSafe
    @NotNull
    private static String extractErrorLinesFromOutput(@Nls @NotNull String stderr) {
        if (stderr == null) {
            GDBDriver.$$$reportNull$$$0(60);
        }
        Scanner scanner = new Scanner(stderr);
        StringBuilder errorMessage = new StringBuilder();
        while (scanner.hasNext()) {
            if (scanner.findInLine("ERROR: (.*)") != null) {
                MatchResult result = scanner.match();
                if (!errorMessage.isEmpty()) {
                    errorMessage.append('\n');
                }
                errorMessage.append(result.group(1));
            }
            scanner.nextLine();
        }
        String string = errorMessage.toString();
        String string2 = string;
        if (string2 == null) {
            GDBDriver.$$$reportNull$$$0(61);
        }
        return string2;
        finally {
            scanner.close();
        }
    }

    private void doInterruptUnixSignal(int pid) throws com.intellij.execution.ExecutionException {
        @NlsSafe String SIG = "SIG";
        String signalDisplayName = SIG + this.myInterruptSignalName;
        String signalCommand = "Sending " + signalDisplayName + " to " + pid;
        CidrDebuggerLog.LOG.debug(">" + signalCommand);
        int err = this.getHostMachine().sendSignal(pid, this.myInterruptSignalName, this.myProcessHandler.getProcess());
        if (err == -1) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.send.signal.to.pid", signalDisplayName, pid));
        }
    }

    private boolean doInterruptAndWait() throws com.intellij.execution.ExecutionException {
        return this.doInterruptAndWait(false);
    }

    private boolean doInterruptAndWait(boolean tearDownRequest) throws com.intellij.execution.ExecutionException {
        this.myStopSemaphore.down();
        try {
            if (this.doInterrupt(tearDownRequest)) {
                if (tearDownRequest && !GdbUtil.waitForSemaphore(this.myStopSemaphore, 1500L, (Function0<Boolean>)((Function0)() -> this.myProcessingStopPlace))) {
                    throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.interrupt.gdb.to.request.exit", new Object[0]));
                }
                GdbUtil.waitForSemaphore(this.myStopSemaphore, -1L, (Function0<Boolean>)((Function0)() -> this.myProcessingStopPlace));
                boolean bl = this.myIsInterruptedStop;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myStopSemaphore.up();
        }
    }

    @TestOnly
    public String @NotNull [] listVarObjects() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String[] stringArray = this.executeCommand(new SuspendedCommand<String[]>(){

            @Override
            public String[] call() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                Response response = GDBDriver.this.sendRequestAndWaitForDone("-var-update 0 *", new Object[0]);
                GDBTuple changelist = Objects.requireNonNull(response.getResultList().getTuple("changelist"));
                return (String[])changelist.stream().map(t -> ((GDBTuple)t).getString("name")).toArray(String[]::new);
            }
        });
        if (stringArray == null) {
            GDBDriver.$$$reportNull$$$0(62);
        }
        return stringArray;
    }

    @Override
    public boolean resume() throws com.intellij.execution.ExecutionException {
        return this.executeCommandNoUserException(() -> this.doResume(null, false));
    }

    @Override
    public boolean resume(@NotNull LLThread thread) throws com.intellij.execution.ExecutionException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(63);
        }
        return this.executeCommandNoUserException(() -> this.doResume(thread, false));
    }

    private boolean doResume(@Nullable LLThread thread, boolean suppressRunningEvent) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.NOT_READY) {
            return false;
        }
        return this.doResumeInternal(thread, suppressRunningEvent);
    }

    private boolean doResumeInternal(@Nullable LLThread thread, boolean suppressRunningEvent) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        try {
            GDBExclusiveThread exclusiveThread = this.myExclusiveThread.get();
            Long exclusiveThreadId = exclusiveThread.getThreadId();
            String onThread = exclusiveThreadId != null ? GDBDriver.onThread(exclusiveThreadId) : (thread != null ? GDBDriver.onThread(thread.getId()) : this.onStoppedThreadAndFrame());
            this.buildRequest("-exec-continue %s", onThread).suppressRunningEvent(suppressRunningEvent).send().waitFor(GDBResponse.ResultRecord.Type.running);
            return true;
        }
        catch (GDBCommandException e) {
            if (GDBDriver.messageContains(e, "The program is not being run.")) {
                return false;
            }
            DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
            if (stopPlace != null && GDBDriver.messageContains(e, "Cannot execute this command without a live selected thread")) {
                this.myHandler.handleInterrupted(stopPlace);
                this.myHandler.handleNotification(GDBBundle.message("notification.failed.to.resume.no.live.thread", new Object[0]), DebuggerDriver.NotificationType.WARNING);
                return false;
            }
            throw e;
        }
    }

    @Override
    public void stepInto(boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        this.stepInto(this.getLastStopThread(), forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
    }

    @Override
    public void stepOver(boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        this.stepOver(this.getLastStopThread(), stepByInstruction);
    }

    @Override
    public void stepOut(boolean stopInFramesWithNoDebugInfo) throws com.intellij.execution.ExecutionException {
        this.stepOut(this.getLastStopThread(), stopInFramesWithNoDebugInfo);
    }

    @NotNull
    private LLThread getLastStopThread() throws com.intellij.execution.ExecutionException {
        DebuggerDriver.StopPlace stopPlace = this.myStopPlace;
        if (stopPlace == null) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.retrieve.stopped.thread", new Object[0]));
        }
        LLThread lLThread = stopPlace.thread;
        if (lLThread == null) {
            GDBDriver.$$$reportNull$$$0(64);
        }
        return lLThread;
    }

    @Override
    public void stepInto(@NotNull LLThread thread, boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(65);
        }
        this.executeCommandNoUserException(() -> {
            if (!stepByInstruction) {
                this.doSetStepMode(forceStepIntoFramesWithNoDebugInfo);
            }
            String commandName = stepByInstruction ? "-exec-step-instruction" : (this.myStopSteppingOnFunctionFinish ? "-cidr-exec-step" : "-exec-step");
            this.buildRequest("%s %s", commandName, GDBDriver.onThread(thread.getId())).onSteppingFinished(stopPlace -> {
                if (stepByInstruction || forceStepIntoFramesWithNoDebugInfo || stopPlace.frame.hasDebugInfo()) {
                    return true;
                }
                if (this.isMac() && this.isIndirectSymbolFrame(stopPlace.frame)) {
                    this.executeAsyncCommand(() -> this.sendSilentRequest("-exec-step %s", GDBDriver.onThread(thread.getId())));
                    return false;
                }
                return this.asyncStepOutUntilFrameWithDebugInfo(stopPlace);
            }).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        });
    }

    @Override
    public void stepOver(@NotNull LLThread thread, boolean stepByInstruction) throws com.intellij.execution.ExecutionException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(66);
        }
        this.executeCommandNoUserException(() -> {
            try (CidrEventSpan ignored = new CidrEventSpan("debug", "stepOver", null);){
                if (!stepByInstruction) {
                    this.doSetStepMode(false);
                }
                String commandName = stepByInstruction ? "-exec-next-instruction" : (this.myStopSteppingOnFunctionFinish ? "-cidr-exec-next" : "-exec-next");
                this.buildRequest("%s %s", commandName, GDBDriver.onThread(thread.getId())).onSteppingFinished(stepByInstruction ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
            }
        });
    }

    @Override
    public void stepOut(@NotNull LLThread thread, boolean stopInFramesWithNoDebugInfo) throws com.intellij.execution.ExecutionException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(67);
        }
        this.executeCommandNoUserException(() -> {
            block2: {
                this.doSetStepMode(false);
                try {
                    this.buildRequest("-exec-finish %s", GDBDriver.onThread(thread.getId())).onSteppingFinished(stopInFramesWithNoDebugInfo ? null : this::asyncStepOutUntilFrameWithDebugInfo).send().waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
                }
                catch (GDBCommandException e) {
                    if (GDBDriver.messageContains(e, FINISH_NOT_MEANINGFUL_IN_THE_OUTERMOST_FRAME) && this.doResume(thread, false)) break block2;
                    throw e;
                }
            }
        });
    }

    private boolean asyncStepOutUntilFrameWithDebugInfo(@NotNull DebuggerDriver.StopPlace stopPlace) {
        boolean shouldStop;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(68);
        }
        if (!(shouldStop = stopPlace.frame.hasDebugInfo())) {
            LLThread thread = stopPlace.thread;
            this.executeAsyncCommand(() -> this.buildRequest("-exec-next %s", GDBDriver.onThread(thread.getId())).suppressAll().onSteppingFinished(this::asyncStepOutUntilFrameWithDebugInfo).send());
        }
        return shouldStop;
    }

    @Override
    public void runTo(@NotNull String path, int line) throws com.intellij.execution.ExecutionException {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(69);
        }
        this.runTo(GDBDriver.atSourceLine(this.toEnvPath(path), line));
    }

    @Override
    public void runTo(@NotNull Address address) throws com.intellij.execution.ExecutionException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(70);
        }
        this.runTo(GDBDriver.atAddress(address));
    }

    protected void runTo(@NotNull String location) throws com.intellij.execution.ExecutionException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(71);
        }
        this.executeCommandNoUserException(() -> {
            String command = GDBDriver.format("advance %s", location);
            String consoleCommand = GDBDriver.createConsoleCommand(command, this.myStopPlace);
            return this.sendRequestAndWaitForRunning("%s", consoleCommand);
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToLine(@NotNull LLThread thread, @NotNull String path, int line, boolean canLeaveFunction) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(72);
        }
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(73);
        }
        DebuggerDriver.StopPlace stopPlace = this.executeCommand(() -> {
            void var10_12;
            String sourceLine = GDBDriver.atSourceLine(this.toEnvPath(path), line);
            Response lineInfoResponse = this.sendSilentRequestAndWaitForDone("info line %s", sourceLine);
            String[] outputLines = StringUtil.splitByLines((String)lineInfoResponse.getOutput(), (boolean)true);
            HashSet<CallSite> result = new HashSet<CallSite>();
            String[] stringArray = outputLines;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_12 < n) {
                String lineInfo = stringArray[var10_12];
                Matcher lineMatcher = LINE_INFO_RESULT.matcher(lineInfo);
                if (lineMatcher.matches()) {
                    result.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                } else {
                    lineMatcher = LINE_INFO_NO_CODE_RESULT.matcher(lineInfo);
                    if (lineMatcher.matches()) {
                        result.add((CallSite)((Object)("0x" + lineMatcher.group(2))));
                    }
                }
                ++var10_12;
            }
            if (result.isEmpty()) {
                throw new DebuggerCommandException(String.format("Can't resolve address for line %s", sourceLine));
            }
            if (result.size() > 1) {
                StringBuilder errMsg = new StringBuilder("Too many candidates found :\n");
                for (String string : result) {
                    errMsg.append("\t").append(string).append("\n");
                }
                throw new DebuggerCommandException(errMsg.toString());
            }
            String address = (String)result.iterator().next();
            return this.doJumpToAddress(thread, address);
        });
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(74);
        }
        return stopPlace;
    }

    @Override
    @NotNull
    public DebuggerDriver.StopPlace jumpToAddress(@NotNull LLThread thread, @NotNull Address address, boolean canLeaveFunction) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(75);
        }
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(76);
        }
        DebuggerDriver.StopPlace stopPlace = this.executeCommand(() -> this.doJumpToAddress(thread, address.toString()));
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(77);
        }
        return stopPlace;
    }

    @NotNull
    private DebuggerDriver.StopPlace doJumpToAddress(@NotNull LLThread thread, @NotNull String value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(78);
        }
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(79);
        }
        this.sendRequestAndWaitForDone("-gdb-set $pc=%s", value);
        DebuggerDriver.ResultList<LLFrame> frames2 = this.doGetFrames(thread.getId(), 0, 1);
        return new DebuggerDriver.StopPlace(thread, (LLFrame)frames2.list.get(0));
    }

    @Override
    public void addPathMapping(int index, @NotNull String from, @NotNull String to) throws com.intellij.execution.ExecutionException {
        if (from == null) {
            GDBDriver.$$$reportNull$$$0(80);
        }
        if (to == null) {
            GDBDriver.$$$reportNull$$$0(81);
        }
        DebuggerDriver.PathMapping pathMapping = new DebuggerDriver.PathMapping(from, to);
        List<DebuggerDriver.PathMapping> list = Collections.singletonList(pathMapping);
        this.executeCommandNoUserException(() -> this.doAddPathMapping(list));
    }

    @Override
    public void addForcedFileMapping(int index, @NotNull String from, @Nullable DebuggerSourceFileHash hash, @NotNull String to) throws com.intellij.execution.ExecutionException {
        if (from == null) {
            GDBDriver.$$$reportNull$$$0(82);
        }
        if (to == null) {
            GDBDriver.$$$reportNull$$$0(83);
        }
        this.addPathMapping(index, from, to);
    }

    private boolean abort() throws com.intellij.execution.ExecutionException {
        return this.executeCommandNoUserException(() -> {
            DebuggerDriver.TargetState state = this.getState();
            if (state == DebuggerDriver.TargetState.NOT_READY || state == DebuggerDriver.TargetState.FINISHED) {
                return false;
            }
            this.doInterruptAndWait();
            try {
                this.sendSilentRequest("kill", new Object[0]).waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                String message = e.getMessage();
                if ("The program is not being run.".equals(message) || "You can't do that without a process to debug.".equals(message)) {
                    return false;
                }
                throw e;
            }
            return true;
        });
    }

    @Override
    protected boolean doExit() throws com.intellij.execution.ExecutionException {
        return this.executeCommandNoUserException(() -> {
            boolean sendGdbExit;
            boolean bl = sendGdbExit = !this.isInPromptMode();
            if (sendGdbExit) {
                try {
                    this.doInterruptAndWait(true);
                }
                catch (ExecutionFinishedException executionFinishedException) {
                    // empty catch block
                }
                this.buildRequest("-gdb-exit", new Object[0]).tearDownRequest(true).send();
            }
            return sendGdbExit;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(long threadId, int frameIndex, @NotNull LLValue value, @NotNull String expr, @Nullable LLWatchpoint.Lifetime lifetime, @NotNull LLWatchpoint.AccessType accessType) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void accessType2;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(84);
        }
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(85);
        }
        if (accessType == null) {
            GDBDriver.$$$reportNull$$$0(86);
        }
        LLWatchpoint lLWatchpoint = this.executeCommand(() -> this.lambda$addWatchpoint$34(threadId, frameIndex, lifetime, expr, (LLWatchpoint.AccessType)accessType2));
        if (lLWatchpoint == null) {
            GDBDriver.$$$reportNull$$$0(87);
        }
        return lLWatchpoint;
    }

    @NotNull
    private String doGetWatchpointExpression(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expression) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (lifetime == LLWatchpoint.Lifetime.PERSISTENT) {
            LLValue evaluated = this.doEvaluate(threadId, frameIndex, "&(" + (String)expression + ")", null);
            String value = this.doLoadVariable((LLValue)evaluated).data.getValue();
            if (value.isEmpty()) {
                throw new DebuggerCommandException(CANNOT_SET_WATCHPOINT_FOR_EXPRESSION);
            }
            expression = "*" + value;
        }
        String string = expression;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(88);
        }
        return string;
    }

    private static LLWatchpoint readWatchpoint(GDBTuple resultList, LLWatchpoint.AccessType accessType) throws com.intellij.execution.ExecutionException {
        GDBTuple tuple = resultList.getRequiredTuple(accessType.getTupleKey());
        return new LLWatchpoint(tuple.getRequiredInt("number"), tuple.getRequiredString("exp"));
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addBreakpoint(@NotNull String path, int line, @Nullable String condition, boolean ignoreSourceHash) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(89);
        }
        DebuggerDriver.AddBreakpointResult addBreakpointResult = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                DebuggerDriver.AddBreakpointResult addBreakpointResult = this.doInsertBreakpoint(GDBDriver.atSourceLine(this.toEnvPath(path), line), condition);
                return addBreakpointResult;
            }
            finally {
                if (interrupted) {
                    this.doResume(null, true);
                }
            }
        });
        if (addBreakpointResult == null) {
            GDBDriver.$$$reportNull$$$0(90);
        }
        return addBreakpointResult;
    }

    @Override
    @NotNull
    public DebuggerDriver.AddBreakpointResult addAddressBreakpoint(@NotNull Address address, @Nullable String condition) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(91);
        }
        DebuggerDriver.AddBreakpointResult addBreakpointResult = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                DebuggerDriver.AddBreakpointResult addBreakpointResult = this.doInsertAddressBreakpoint(address, condition);
                return addBreakpointResult;
            }
            finally {
                if (interrupted) {
                    this.doResume(null, true);
                }
            }
        });
        if (addBreakpointResult == null) {
            GDBDriver.$$$reportNull$$$0(92);
        }
        return addBreakpointResult;
    }

    public String interruptAndExecuteConsole(@NotNull String command) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(93);
        }
        return this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                String miCommand = GDBDriver.createConsoleCommand(command);
                String string = this.sendSilentRequestAndWaitForDone("%s", miCommand).getOutput();
                return string;
            }
            finally {
                if (interrupted) {
                    this.doResume(null, true);
                }
            }
        });
    }

    @NotNull
    private DebuggerDriver.AddBreakpointResult doInsertBreakpoint(@NotNull String location, @Nullable String condition) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(94);
        }
        GDBTuple resultList = this.doGdbBreakInsert(location, condition, false);
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private DebuggerDriver.AddBreakpointResult doInsertAddressBreakpoint(@NotNull Address address, @Nullable String condition) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(95);
        }
        GDBTuple resultList = this.sendRequestAndWaitForDone("-break-insert %s *%s", GDBDriver.withCondition(condition), address.toString()).getResultList();
        return GDBDriver.readBreakpoint(resultList);
    }

    @NotNull
    private GDBTuple doGdbBreakInsert(@NotNull String location, @Nullable String condition, boolean temporary) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (location == null) {
            GDBDriver.$$$reportNull$$$0(96);
        }
        GDBTuple gDBTuple = this.sendRequestAndWaitForDone("-break-insert -f %s %s %s", temporary ? "-t" : "", GDBDriver.withCondition(condition), location).getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(97);
        }
        return gDBTuple;
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (symBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(98);
        }
        LLSymbolicBreakpoint lLSymbolicBreakpoint = this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                LLSymbolicBreakpoint lLSymbolicBreakpoint = this.doInsertSymbolicBreakpoint(symBreakpoint.getPattern(), symBreakpoint.getCondition(), false);
                return lLSymbolicBreakpoint;
            }
            finally {
                if (interrupted) {
                    this.doResume(null, true);
                }
            }
        });
        if (lLSymbolicBreakpoint == null) {
            GDBDriver.$$$reportNull$$$0(99);
        }
        return lLSymbolicBreakpoint;
    }

    @NotNull
    private LLSymbolicBreakpoint doInsertSymbolicBreakpoint(@NotNull String function, @Nullable String condition, boolean temporary) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (function == null) {
            GDBDriver.$$$reportNull$$$0(100);
        }
        GDBTuple bkpt = this.doGdbBreakInsert(GDBDriver.atFunction(function), condition, temporary).getRequiredTuple("bkpt");
        int number = bkpt.getRequiredInt("number");
        return new LLSymbolicBreakpoint(number);
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (ids == null) {
            GDBDriver.$$$reportNull$$$0(101);
        }
        this.executeCommand(() -> {
            boolean interrupted = this.doInterruptAndWait();
            try {
                for (Integer each : ids) {
                    this.sendRequestAndWaitForDone("-break-delete %d", each);
                }
            }
            finally {
                if (interrupted) {
                    this.doResume(null, true);
                }
            }
        });
    }

    @Nullable
    private static LLBreakpointLocation readBreakpointLocation(@NotNull GDBTuple info, @NotNull String id) {
        Address address;
        if (info == null) {
            GDBDriver.$$$reportNull$$$0(102);
        }
        if (id == null) {
            GDBDriver.$$$reportNull$$$0(103);
        }
        String addr = info.getString("addr");
        boolean pending = "<PENDING>".equals(addr);
        FileLocation location = info.getLocation("fullname", "line");
        if (location == null && pending) {
            location = info.getLocation("pending");
        }
        if ((address = info.getAddress("addr")) == null) {
            return null;
        }
        return new LLBreakpointLocation(id, address, location);
    }

    @NotNull
    private static DebuggerDriver.AddBreakpointResult readBreakpoint(@NotNull GDBTuple info) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Object locations;
        boolean multipleLocations;
        if (info == null) {
            GDBDriver.$$$reportNull$$$0(104);
        }
        Pair<GDBTuple, List<GDBTuple>> breakpointWithLocations = info.getWithSuccessors("bkpt", GDBTuple.class);
        GDBTuple breakpointTuple = (GDBTuple)breakpointWithLocations.first;
        List multipleLocationTuples = (List)breakpointWithLocations.second;
        if (breakpointTuple == null) {
            throw new DebuggerCommandException("No code at this line");
        }
        int number = breakpointTuple.getRequiredInt("number");
        String addr = breakpointTuple.getString("addr");
        boolean bl = multipleLocations = "<MULTIPLE>".equals(addr) && !multipleLocationTuples.isEmpty();
        if (multipleLocations) {
            locations = new SmartList();
            for (GDBTuple locTuple : multipleLocationTuples) {
                String locId;
                LLBreakpointLocation location = GDBDriver.readBreakpointLocation(locTuple, locId = locTuple.getRequiredString("number"));
                if (location == null) continue;
                locations.add(location);
            }
        } else {
            String locId = number + ".1";
            LLBreakpointLocation location = GDBDriver.readBreakpointLocation(breakpointTuple, locId);
            locations = location != null ? Collections.singletonList(location) : Collections.emptyList();
        }
        FileLocation originalLocation = breakpointTuple.getLocation("original-location");
        String origFilePath = originalLocation != null ? originalLocation.getPath() : "<address>";
        int origLine = originalLocation != null ? originalLocation.getLine() : 0;
        String condition = breakpointTuple.getString("cond");
        return new DebuggerDriver.AddBreakpointResult(new LLBreakpoint(number, origFilePath, origLine, condition), (List<LLBreakpointLocation>)locations);
    }

    @NotNull
    private DebuggerDriver.StopPlace doReadStopPlace(@NotNull GDBTuple stopTuple) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(105);
        }
        Integer optionalThreadId = stopTuple.getInteger("thread-id", null);
        Communication savedCommunication = this.myCommunication;
        if (optionalThreadId != null) {
            LLThread thread = this.doGetThread(optionalThreadId);
            this.myCommunication = savedCommunication;
            LLFrame frame = this.getTopFrameFromThreadTuple(stopTuple);
            return new DebuggerDriver.StopPlace(thread, frame, this.doReadReturnValue(stopTuple, thread.getId(), frame.getIndex()));
        }
        DebuggerDriver.StopPlace stopPlace = this.tryExtractStopPlaceFromThreadInfo();
        this.myCommunication = savedCommunication;
        if (stopPlace == null) {
            LLFrame missingFrame = new LLFrame(0, null, null, null, 0, 0L, null, false, false, null);
            return new DebuggerDriver.StopPlace(new LLMissingThread(), missingFrame);
        }
        DebuggerDriver.StopPlace stopPlace2 = stopPlace;
        if (stopPlace2 == null) {
            GDBDriver.$$$reportNull$$$0(106);
        }
        return stopPlace2;
    }

    @NotNull
    private LLFrame getTopFrameFromThreadTuple(@NotNull GDBTuple tuple) throws com.intellij.execution.ExecutionException {
        if (tuple == null) {
            GDBDriver.$$$reportNull$$$0(107);
        }
        GDBTuple frameTuple = tuple.getRequiredTupleOrThrow("frame", () -> new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.read.stop.place", tuple)));
        return this.doReadFrame(0, frameTuple);
    }

    @Nullable
    private DebuggerDriver.StopPlace tryExtractStopPlaceFromThreadInfo() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        Integer currentStoppedThreadId = response.getResultList().getInteger("current-thread-id", null);
        if (currentStoppedThreadId == null) {
            return null;
        }
        GDBTuple threads2 = response.getResultList().getRequiredTuple("threads");
        for (GDBTuple each : threads2) {
            if (each.getRequiredInt("id") != currentStoppedThreadId.intValue()) continue;
            LLThread thread = GDBDriver.doReadThreadInfo(each, this.myExclusiveThread.get(), this.getInferiorId(currentStoppedThreadId));
            return new DebuggerDriver.StopPlace(thread, this.getTopFrameFromThreadTuple(each));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private LLValue doReadReturnValue(@NotNull GDBTuple stopTuple, long threadId, int n) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void frameIndex;
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(108);
        }
        if (frameIndex != false) {
            return null;
        }
        String returnVarName = stopTuple.getString("gdb-result-var");
        if (returnVarName != null && !returnVarName.isBlank()) {
            String frameAddress = this.doGetFrameAddr(threadId, 0);
            return this.doLoadFrameVariable(returnVarName, threadId, 0, frameAddress);
        }
        return null;
    }

    @NotNull
    private CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBTuple stopTuple) {
        if (stopTuple == null) {
            GDBDriver.$$$reportNull$$$0(109);
        }
        CompletableFuture<DebuggerDriver.StopPlace> completableFuture = this.myThreadFrameInfoDriverDelegate.doReadStopPlaceAsync(this.myBridge, this, stopTuple);
        if (completableFuture == null) {
            GDBDriver.$$$reportNull$$$0(110);
        }
        return completableFuture;
    }

    private void doReadSelectedFrameChangedAsync(@NotNull GDBTuple resultTuple) {
        if (resultTuple == null) {
            GDBDriver.$$$reportNull$$$0(111);
        }
        this.executeAsyncCommand(() -> {
            try {
                int threadId = resultTuple.getRequiredInt("id");
                GDBTuple frameInfo = resultTuple.getTuple("frame");
                if (frameInfo == null) {
                    return;
                }
                Integer frameIdx = frameInfo.getInteger("level", null);
                if (frameIdx == null) {
                    return;
                }
                LLThread thread = this.doGetThread(threadId);
                LLFrame frame = this.doReadFrame(frameIdx, frameInfo);
                this.handleSelectedFrameChanged(thread, frame);
            }
            catch (Throwable t) {
                CidrDebuggerLog.LOG.error("Failed to handle selected frame change", t);
            }
        });
    }

    @Override
    @NotNull
    public List<LLThread> getThreads() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        List<LLThread> list = this.myThreadFrameInfoDriverDelegate.getThreads(this.myBridge, this);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(112);
        }
        return list;
    }

    @NotNull
    private List<LLThread> doGetThreads() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-thread-info", new Object[0]);
        GDBTuple threads2 = response.getResultList().getRequiredTuple("threads");
        ArrayList<LLThread> result = new ArrayList<LLThread>(threads2.size());
        for (GDBTuple each : threads2) {
            result.add(GDBDriver.doReadThreadInfo(each, this.myExclusiveThread.get(), this.getInferiorId(each.getRequiredInt("id"))));
        }
        result.sort(Comparator.comparingLong(LLThread::getId));
        ArrayList<LLThread> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(113);
        }
        return arrayList;
    }

    @Nullable
    private String getInferiorId(int threadId) {
        String inferiorId = null;
        if (this.myInferiorsMap.size() > 1) {
            inferiorId = this.myThreadToInferiorMap.get(threadId);
        }
        return inferiorId;
    }

    @NotNull
    private LLThread doGetThread(int threadId) throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        Response response = this.sendRequestAndWaitForDone("-thread-info %d", threadId);
        GDBTuple threads2 = response.getResultList().getRequiredTuple("threads");
        if (threads2.size() != 1) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.get.thread.info.by.id", threadId));
        }
        return GDBDriver.doReadThreadInfo((GDBTuple)threads2.get(0), this.myExclusiveThread.get(), this.getInferiorId(threadId));
    }

    @NotNull
    private static LLThread doReadThreadInfo(@NotNull GDBTuple threadTuple, @NotNull GDBExclusiveThread exclusiveThread, @Nullable String inferiorId) throws com.intellij.execution.ExecutionException {
        if (threadTuple == null) {
            GDBDriver.$$$reportNull$$$0(114);
        }
        if (exclusiveThread == null) {
            GDBDriver.$$$reportNull$$$0(115);
        }
        int id = threadTuple.getRequiredInt("id");
        String name = threadTuple.getString("name");
        @NonNls String state = threadTuple.getRequiredString("state");
        String tid = threadTuple.getString("target-id");
        if (tid != null) {
            tid = GDBDriver.extractThreadId(tid);
        }
        boolean frozen = exclusiveThread.isFrozen(id);
        return new LLThread(id, StringUtil.toUpperCase((String)state), null, name, tid, inferiorId, frozen);
    }

    @NotNull
    private static String extractThreadId(@NotNull String tid) {
        if (tid == null) {
            GDBDriver.$$$reportNull$$$0(116);
        }
        String string = StringUtil.trimStart((String)tid, (String)"Thread ");
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(117);
        }
        return string;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(118);
        }
        DebuggerDriver.ResultList<LLFrame> resultList = this.myThreadFrameInfoDriverDelegate.getFrames(this.myBridge, thread, from, count, untilFirstLineWithCode);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(119);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLFrame> doGetFrames(long threadId, int from, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendRequest("-stack-list-frames --thread %d %d %d", threadId, from, from + count).waitFor(new GDBResponse.ResultRecord.Type[0]);
        GDBTuple stack = response.getResultList().getTuple("stack");
        List<GDBTuple> frames2 = stack == null ? null : stack.getAll("frame", GDBTuple.class);
        String msg = response.getGDBErrorMessage();
        if (frames2 == null) {
            if (msg != null && msg.contains(" Not enough frames in stack")) {
                DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.empty();
                if (resultList == null) {
                    GDBDriver.$$$reportNull$$$0(120);
                }
                return resultList;
            }
            throw new DebuggerCommandException(msg != null ? msg : "Cannot collect frames");
        }
        if (msg != null) {
            this.warnUser(msg);
        }
        ArrayList<LLFrame> result = new ArrayList<LLFrame>(frames2.size());
        for (int i = 0; i < Math.min(frames2.size(), count); ++i) {
            GDBTuple each = frames2.get(i);
            LLFrame frame = this.doReadFrame(each.getRequiredInt("level"), each);
            result.add(frame);
        }
        boolean hasMore = result.size() < frames2.size();
        DebuggerDriver.ResultList<LLFrame> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(121);
        }
        return resultList;
    }

    @NotNull
    private LLFrame doReadFrame(int level, @NotNull GDBTuple frameTuple) {
        if (frameTuple == null) {
            GDBDriver.$$$reportNull$$$0(122);
        }
        String func = frameTuple.getString("func");
        String addrStr = frameTuple.getString("addr");
        String fullname = frameTuple.getString("fullname");
        String file = this.myStarter.convertToLocalPath(fullname != null ? fullname : frameTuple.getString("file"));
        String module = frameTuple.getString("from");
        int line = -1;
        if (file != null) {
            line = frameTuple.getInt("line", 0) - 1;
        }
        Address addr = Address.NULL;
        if (addrStr != null) {
            try {
                addr = GDBDriver.parseAddress(addrStr);
            }
            catch (com.intellij.execution.ExecutionException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        if (module == null && !addr.isNull()) {
            LLModule mod = this.myModuleMap.findModuleByAddress(addr);
            if (mod != null) {
                module = mod.getPath();
            } else {
                LLModule targetModule = this.myTargetModule;
                if (targetModule != null) {
                    module = targetModule.getPath();
                }
            }
        }
        if (module != null) {
            module = PathUtil.getFileName((String)module);
        }
        if (func != null) {
            func = func.substring(func.indexOf(33) + 1);
        }
        return new LLFrame(level, "??".equals(func) ? null : func, file, null, line, addr, null, false, false, module);
    }

    private boolean isIndirectSymbolFrame(@NotNull LLFrame frame) {
        LongSet indirectSymbols;
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(123);
        }
        if ((indirectSymbols = this.myIndirectSymbols) == null) {
            return false;
        }
        return !frame.hasDebugInfo() && !frame.hasSymbolInfo() && indirectSymbols.contains(frame.getProgramCounter().unsignedLongValue());
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(124);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(125);
        }
        List<LLValue> list = this.myThreadFrameInfoDriverDelegate.getVariables(this.myBridge, thread, frame);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(126);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        List list = (List)this.executeCommand(() -> this.doGetFrameVariables(threadId, frameIndex).getVariables());
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(127);
        }
        return list;
    }

    @Override
    @NotNull
    public DebuggerDriver.FrameVariables getFrameVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(128);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(129);
        }
        DebuggerDriver.FrameVariables frameVariables = this.myThreadFrameInfoDriverDelegate.getFrameVariables(this.myBridge, thread, frame);
        if (frameVariables == null) {
            GDBDriver.$$$reportNull$$$0(130);
        }
        return frameVariables;
    }

    @NotNull
    private String doGetFrameAddr(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-data-evaluate-expression %s $fp", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        String string = response.getResultList().getRequiredStringOrThrow("value", () -> new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.evaluate.frame.address.for.thread.frame", threadId, frameIndex)));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(131);
        }
        return string;
    }

    @NotNull
    private DebuggerDriver.FrameVariables doGetFrameVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (this.myPythonCommandsLoaded) {
            return this.doGetFrameVariablesPython(threadId, frameIndex);
        }
        DebuggerDriver.FrameVariables frameVariables = this.doGetFrameVariablesGdbMi(threadId, frameIndex);
        if (frameVariables == null) {
            GDBDriver.$$$reportNull$$$0(132);
        }
        return frameVariables;
    }

    @ApiStatus.Internal
    @NotNull
    public DebuggerDriver.FrameVariables doGetFrameVariablesGdbMi(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        SmartList result = new SmartList();
        String frameAddress = this.doGetFrameAddr(threadId, frameIndex);
        for (String varName : this.doListFrameVariables(threadId, frameIndex)) {
            result.add(this.doLoadFrameVariable(varName, threadId, frameIndex, frameAddress));
        }
        return new DebuggerDriver.FrameVariables((List<LLValue>)result, false);
    }

    @NotNull
    private DebuggerDriver.FrameVariables doGetFrameVariablesPython(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        SmartList result = new SmartList();
        String frameAddress = this.doGetFrameAddr(threadId, frameIndex);
        String filterValues = this.myValueFilteringEnabled ? "1" : "0";
        GDBTuple resultList = this.sendRequestAndWaitForDone("-cidr-stack-list-frame-variables %s %s", GDBDriver.onThreadAndFrame(threadId, frameIndex), filterValues).getResultList();
        GDBTuple variables = resultList.getRequiredTuple("variables");
        HashSet<String> uniqNames = new HashSet<String>();
        for (Object v : variables) {
            GDBTuple varTuple;
            String varName;
            if (!(v instanceof GDBTuple) || !uniqNames.add(varName = (varTuple = (GDBTuple)v).getString("name", ""))) continue;
            Pair<Boolean, String> typePair = this.doGetExpressionType(varName, threadId, frameIndex);
            LLValue llValue = new LLValue(varName.isEmpty() ? "<unknown>" : varName, (String)typePair.second, null, null, varName);
            String fvKey = GDBDriver.makeFVKey(frameAddress, varName);
            llValue.putUserData(FRAME_VAR_KEY, fvKey);
            if (((Boolean)typePair.first).booleanValue()) {
                FrameValueLoader loader = new FrameValueLoader(fvKey, threadId, frameIndex, this.myUsePythonToLoadData);
                llValue.putUserData(LLVALUE_DATA_LOADER, loader);
            } else {
                GDBDriver.doUpdateLoadedData(llValue, EMPTY_LOADED_VALUE);
            }
            result.add(llValue);
        }
        return new DebuggerDriver.FrameVariables((List<LLValue>)result, resultList.getBoolean("filtered", false) && Registry.is((String)"cidr.debugger.gdb.trust.frame.variables.filtering"));
    }

    @NotNull
    private LLValue doLoadFrameVariable(String varName, long threadId, int frameIndex, String frameAddress) throws com.intellij.execution.ExecutionException {
        Pair<Boolean, String> typePair = this.doGetExpressionType(varName, threadId, frameIndex);
        String fvKey = GDBDriver.makeFVKey(frameAddress, varName);
        LLValue llValue = new LLValue(varName.isEmpty() ? "<unknown>" : varName, (String)typePair.second, null, null, varName);
        llValue.putUserData(FRAME_VAR_KEY, fvKey);
        if (((Boolean)typePair.first).booleanValue()) {
            FrameValueLoader loader = new FrameValueLoader(fvKey, threadId, frameIndex, false);
            llValue.putUserData(LLVALUE_DATA_LOADER, loader);
        } else {
            GDBDriver.doUpdateLoadedData(llValue, EMPTY_LOADED_VALUE);
        }
        LLValue lLValue = llValue;
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(133);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public LLValueData getData(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(134);
        }
        LLValueData lLValueData = this.myThreadFrameInfoDriverDelegate.getData(this.myBridge, value);
        if (lLValueData == null) {
            GDBDriver.$$$reportNull$$$0(135);
        }
        return lLValueData;
    }

    @Override
    @Nullable
    public String getDescription(@NotNull LLValue value, int maxLength) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(136);
        }
        return (String)this.executeCommand(() -> {
            Response response;
            boolean lengthChanged;
            LLValueLoadedData data = this.doLoadVariable(value);
            String id = data.id;
            boolean bl = lengthChanged = maxLength != 256;
            if (lengthChanged) {
                this.doSetMaxDescription(maxLength);
            }
            try {
                if (data.isCidrVar) {
                    GDBTuple result = this.loadPythonVarDetails(id);
                    String string = GdbValueDescription.extractDescription(result.getString("value", ""), this.myExtractRichStrings).getDescription();
                    return string;
                }
                if (lengthChanged) {
                    this.sendRequestAndWaitForDone("-var-update --no-values %s", GDBDriver.stringify(id));
                }
                response = this.sendRequestAndWaitForDone("-var-evaluate-expression %s", GDBDriver.stringify(id));
            }
            finally {
                if (lengthChanged) {
                    this.doSetMaxDescription(256);
                }
            }
            return GdbValueDescription.extractDescription(response.getResultList().getRequiredString("value"), this.myExtractRichStrings).getDescription();
        });
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull LLValue value, int from, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(137);
        }
        DebuggerDriver.ResultList<LLValue> resultList = this.myThreadFrameInfoDriverDelegate.getVariableChildren(this.myBridge, value, from, count);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(138);
        }
        return resultList;
    }

    @NotNull
    protected DebuggerDriver.ResultList<LLValue> doGetVariableChildren(final @NotNull LLValue var, final int offset, final int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(139);
        }
        LLValueLoadedData data = this.doLoadVariable(var);
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            int endOffset2 = offset + count;
            List<LLValue> all = Arrays.asList(mapElement.getKey(), mapElement.getValue());
            List<LLValue> list = all.subList(Math.min(offset, 2), Math.min(endOffset2, 2));
            boolean hasMore = endOffset2 < 2;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(list, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(140);
            }
            return resultList;
        }
        if (data.isMap) {
            return this.doGetMapChildren(var, offset, count);
        }
        if (data.isRegister) {
            return this.doGetRegisterChildren(var, offset, count);
        }
        final ArrayList result = new ArrayList();
        boolean readAsStruct = this.doVisitCppClassChildren(var, new StructChildrenVisitor(){
            int currentOffset;
            int restCount;
            {
                this.currentOffset = offset;
                this.restCount = count;
            }

            @Override
            public boolean visitRealChild(@NotNull GDBTuple child) {
                if (child == null) {
                    12.$$$reportNull$$$0(0);
                }
                if (this.currentOffset >= 1) {
                    --this.currentOffset;
                    return true;
                }
                result.add(GDBDriver.this.doReadVariable(child, var, null));
                --this.restCount;
                this.currentOffset = Math.max(0, this.currentOffset - 1);
                return this.restCount != 0;
            }

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (fakeChild == null) {
                    12.$$$reportNull$$$0(1);
                }
                if (this.currentOffset >= childrenCount) {
                    this.currentOffset -= childrenCount;
                    return true;
                }
                int innerEndPos = Math.min(this.currentOffset + this.restCount, childrenCount);
                result.addAll(GDBDriver.this.doGetPlainVariableChildren((LLValue)fakeChild, (int)this.currentOffset, (int)innerEndPos).list);
                this.restCount -= innerEndPos - this.currentOffset;
                this.currentOffset = 0;
                return this.restCount != 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "child";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fakeChild";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$12";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRealChild";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFakeChild";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (readAsStruct) {
            int childrenCount = this.doGetChildrenCount(var);
            boolean hasMore = offset + result.size() < childrenCount;
            DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(141);
            }
            return resultList;
        }
        return this.doGetPlainVariableChildren(var, offset, offset + count);
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetPlainVariableChildren(@NotNull LLValue var, int offset, int endPos) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(142);
        }
        if (offset > endPos) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.incorrect.children.range.from.to", offset, endPos));
        }
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset, endPos);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        for (Object o : (GDBTuple)childList.first) {
            GDBTuple each = GDBDriver.getChildTuple((GDBTuple)childList.first, o);
            if (each == null) {
                hasMore = false;
                break;
            }
            result.add(this.doReadVariable(each, var, null));
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(143);
        }
        return resultList;
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildren(@NotNull LLValue var, int offset, int endPos) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        LLValueLoadedData loaded;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(144);
        }
        if (!(loaded = this.doLoadVariable(var)).mayHaveChildren()) {
            Pair pair = Pair.create((Object)new GDBTuple(), (Object)false);
            if (pair == null) {
                GDBDriver.$$$reportNull$$$0(145);
            }
            return pair;
        }
        if (loaded.isCidrVar) {
            return this.doListChildrenPython(var, loaded.id, offset, endPos);
        }
        String id = loaded.id;
        String listChildrenArg = Registry.is((String)"cidr.debugger.gdb.listChildrenWithoutValues", (boolean)false) ? "--no-values" : "--all-values";
        Response response = this.sendRequestAndWaitForDone("-var-list-children %s %s %d %d", listChildrenArg, GDBDriver.stringify(id), offset, endPos);
        GDBTuple resultList = response.getResultList();
        GDBTuple children = resultList.getTupleOrEmpty("children");
        boolean hasMore = resultList.getBoolean("has_more");
        if (hasMore) {
            this.sendRequestAndWaitForDone("-var-set-update-range %s 0 %d", GDBDriver.stringify(id), endPos);
        }
        Pair pair = Pair.create((Object)children, (Object)hasMore);
        if (pair == null) {
            GDBDriver.$$$reportNull$$$0(146);
        }
        return pair;
    }

    @NotNull
    private Pair<GDBTuple, Boolean> doListChildrenPython(@NotNull LLValue value, @NotNull String varId, int offset, int endPos) throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        Request request;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(147);
        }
        if (varId == null) {
            GDBDriver.$$$reportNull$$$0(148);
        }
        RawViewSupport support = this.getRawViewSupport();
        Collection<Object> rawChildren = Collections.emptyList();
        if (support instanceof GdbRawViewSupport) {
            GdbRawViewSupport gdbRawViewSupport = (GdbRawViewSupport)support;
            rawChildren = gdbRawViewSupport.getRawChildrenNames(value);
        }
        if (rawChildren.isEmpty()) {
            request = this.createMI2RequestWithToken(GDBDriver.format("-cidr-var-list-children %s %d %d", varId, offset, endPos), -1L, -1);
        } else {
            String rawArg = "--raw " + rawChildren.stream().map(it -> "\"" + StringUtil.escapeChar((String)it, (char)'\"') + "\"").collect(Collectors.joining(" "));
            request = this.createMI2RequestWithToken(GDBDriver.format("-cidr-var-list-children %s %d %d %s", varId, offset, endPos, rawArg), -1L, -1);
        }
        Response response = request.send().waitFor(GDBResponse.ResultRecord.Type.done);
        GDBTuple resultList = response.getResultList();
        GDBTuple childrenTuple = resultList.getTupleOrEmpty("children");
        GDBTuple repacked = new GDBTuple();
        for (Object child : childrenTuple) {
            repacked.add(Pair.create((Object)"child", child));
        }
        Pair pair = Pair.create((Object)repacked, (Object)resultList.getBoolean("has_more"));
        if (pair == null) {
            GDBDriver.$$$reportNull$$$0(149);
        }
        return pair;
    }

    private boolean doVisitCppClassChildren(@NotNull LLValue var, @NotNull StructChildrenVisitor visitor) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Object o;
        GDBTuple each;
        Integer childrenCount;
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(150);
        }
        if (visitor == null) {
            GDBDriver.$$$reportNull$$$0(151);
        }
        if ((childrenCount = this.doLoadVariable((LLValue)var).childrenCount) == null) {
            return false;
        }
        if (childrenCount == 0) {
            return true;
        }
        if (childrenCount > 10) {
            return false;
        }
        GDBTuple children = (GDBTuple)var.getUserData(LLVALUE_CLASS_CHILDREN_CACHE);
        if (children == null) {
            children = (GDBTuple)this.doListChildren((LLValue)var, (int)-1, (int)-1).first;
            var.putUserData(LLVALUE_CLASS_CHILDREN_CACHE, children);
        }
        Iterator iterator = children.iterator();
        while (iterator.hasNext() && (each = GDBDriver.getChildTuple(children, o = iterator.next())) != null) {
            if (each.getString("type") != null) {
                if (visitor.visitRealChild(each)) continue;
                break;
            }
            String name = each.getRequiredStringOrThrow("name", msg -> new com.intellij.execution.ExecutionException(GDBBundle.message("error.unexpected.gdb.fake.variable", msg)));
            GdbVarId varId = GDBDriver.getGdbVarId(name, each.getString("cidr-id"));
            LLValue fakeValue = new LLValue("", "", null, null, name);
            fakeValue.putUserData(PARENT_VALUE, (Object)var);
            int numchild = each.getInt("numchild", 0);
            boolean defaultPrinterFailed = GDBDriver.isDefaultPrinterFailed(each);
            GDBDriver.doUpdateLoadedData(fakeValue, new LLValueLoadedData(varId, null, numchild, false, false, "", null, false, defaultPrinterFailed, this.myExtractRichStrings));
            if (visitor.visitFakeChild(fakeValue, numchild)) continue;
            break;
        }
        return true;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetRegisterChildren(LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        LLValue childrenVar = (LLValue)((Object)var.getUserData(REGISTER_CHILDREN_VAR));
        if (childrenVar != null) {
            DebuggerDriver.ResultList<LLValue> resultList = this.doGetVariableChildren(childrenVar, offset, count);
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(152);
            }
            return resultList;
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(Collections.emptyList(), false);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(153);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<LLValue> doGetMapChildren(LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Pair<GDBTuple, Boolean> childList = this.doListChildren(var, offset * 2, (offset + count) * 2);
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        boolean hasMore = (Boolean)childList.second;
        int size = ((GDBTuple)childList.first).size();
        for (int i = 0; i < size - 1; i += 2) {
            GDBTuple keyTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i));
            GDBTuple valueTuple = GDBDriver.getChildTuple((GDBTuple)childList.first, ((GDBTuple)childList.first).get(i + 1));
            if (keyTuple == null || valueTuple == null) {
                hasMore = false;
                break;
            }
            LLValue key = this.doReadVariable(keyTuple, var, "first");
            LLValue value = this.doReadVariable(valueTuple, var, "second");
            LLValue element = new LLValue("[" + (offset + i / 2) + "]", "std::pair<" + key.getType() + ", " + value.getType() + ">", null, null, value.getReferenceExpression());
            element.putUserData(LLVALUE_DATA, new LLValueLoadedData("<map element>", null, 2, false, false, "", null));
            element.putUserData(LLVALUE_MAP_ELEMENT, new MapElement(key, value));
            result.add(element);
        }
        DebuggerDriver.ResultList<LLValue> resultList = DebuggerDriver.ResultList.create(result, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(154);
        }
        return resultList;
    }

    @Nullable
    private static GDBTuple getChildTuple(GDBTuple varObjList, Object o) throws com.intellij.execution.ExecutionException {
        if (!(o instanceof Pair)) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.invalid.object.in.list", varObjList));
        }
        Pair p = (Pair)o;
        if (!"child".equals(p.first)) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.pair.first.required.to.be.child", p));
        }
        GDBTuple result = (GDBTuple)p.second;
        String name = result.getString("name");
        return name != null && name.matches(".*\\.<error at.*") ? null : result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private GDBResponse.Record doCreateVarPython(@NotNull String expression, long threadId, int frameIndex, boolean bl) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void raw;
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(155);
        }
        Request request = this.createMI2RequestWithToken(GDBDriver.format("-cidr-var-create %s %s", GDBDriver.stringify(GDBDriver.escapeVariadicArgIfNeeded(expression)), raw != false ? "--raw" : ""), threadId, frameIndex);
        Response response = request.send().waitFor(GDBResponse.ResultRecord.Type.done);
        GDBResponse.Record record = response.getRecord();
        if (record == null) {
            GDBDriver.$$$reportNull$$$0(156);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private GDBResponse.Record doCreateVar(@NotNull String expression, long threadId, int n) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response;
        block13: {
            void frameIndex;
            if (expression == null) {
                GDBDriver.$$$reportNull$$$0(157);
            }
            String varId = GDBDriver.format("var%d_%s", this.allocatedVariables.size() + 1, NON_ID_PATTERN.matcher(expression).replaceAll(""));
            this.allocatedVariables.add(varId);
            Request request = this.createMI2RequestWithToken(GDBDriver.format("%s %s * %s", this.myVarCreateCommandName, varId, GDBDriver.stringify(GDBDriver.escapeVariadicArgIfNeeded(expression))), threadId, (int)frameIndex);
            GDBCommandException err = null;
            response = null;
            try {
                response = request.send().waitFor(GDBResponse.ResultRecord.Type.done);
            }
            catch (GDBCommandException e) {
                err = e;
            }
            if (response == null || response.getReceivedSignalCount() != 0) {
                try {
                    this.sendRequestAndWaitForDone("-var-set-frozen %s 1", GDBDriver.stringify(varId));
                }
                catch (GDBCommandException e) {
                    if (!"Variable object not found".equals(e.getResponse().getGDBErrorMessage())) {
                        if (err != null) {
                            err.addSuppressed(e);
                        }
                    }
                }
                finally {
                    if (err == null) break block13;
                    throw err;
                }
            }
        }
        GDBResponse.Record record = response.getRecord();
        if (record == null) {
            GDBDriver.$$$reportNull$$$0(158);
        }
        return record;
    }

    @NotNull
    private LLValue doReadVariable(@NotNull GDBTuple varTuple, @Nullable LLValue parentValue, @Nullable String displayName) {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(159);
        }
        String parentRef = parentValue != null ? parentValue.getReferenceExpression() : "";
        String name = varTuple.getString("name");
        String type = varTuple.getString("type");
        boolean invalid = name == null || type == null;
        name = StringUtil.notNullize((String)name, (String)"<unknown>");
        type = StringUtil.notNullize((String)type, (String)"<unknown>");
        GdbVarId dataId = GDBDriver.getGdbVarId(name, varTuple.getString("cidr-id"));
        String value = varTuple.getString("value");
        String displayHint = varTuple.getString("displayhint");
        String exp = varTuple.getString("exp");
        if (exp != null) {
            String childName = StringUtil.substringAfterLast((String)name, (String)".");
            boolean isAnonymous = childName != null && childName.endsWith("_anonymous") && StringUtil.parseInt((String)StringUtil.trimEnd((String)childName, (String)"_anonymous"), (int)-1) != -1;
            name = isAnonymous ? "" : exp;
        }
        LLValue result = new LLValue(displayName != null ? displayName : name, GDBDriver.fixType(type), null, null, (String)(parentRef.isEmpty() ? name : parentRef + "." + name));
        result.putUserData(PARENT_VALUE, (Object)parentValue);
        if (invalid) {
            boolean defaultPrinterFailed = GDBDriver.isDefaultPrinterFailed(varTuple);
            GDBDriver.doUpdateLoadedData(result, new LLValueLoadedData(dataId, null, 0, false, false, StringUtil.notNullize((String)value), displayHint, false, defaultPrinterFailed, this.myExtractRichStrings));
        } else {
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varTuple, dataId, null, StringUtil.notNullize((String)value), this.myExtractRichStrings);
            if (value == null) {
                result.putUserData(LLVALUE_DATA_LOADER, new CreatedValueLoader(data));
            } else {
                GDBDriver.doUpdateLoadedData(result, data);
            }
        }
        LLValue lLValue = result;
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(160);
        }
        return lLValue;
    }

    @NotNull
    private static LLValueLoadedData doLoadVariableStatic(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        LLValueLoadedData data;
        LLValueLoader loader;
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(161);
        }
        if ((loader = (LLValueLoader)value.getUserData(LLVALUE_DATA_LOADER)) != null) {
            loader.loadValue(value);
            value.putUserData(LLVALUE_DATA_LOADER, null);
        }
        if ((data = (LLValueLoadedData)value.getUserData(LLVALUE_DATA)) == null) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.variable.not.initialized", new Object[]{value}));
        }
        LLValueLoadedData lLValueLoadedData = data;
        if (lLValueLoadedData == null) {
            GDBDriver.$$$reportNull$$$0(162);
        }
        return lLValueLoadedData;
    }

    @NotNull
    protected LLValueLoadedData doLoadVariable(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(163);
        }
        return GDBDriver.doLoadVariableStatic(value);
    }

    @NotNull
    private static LLValueLoadedData doReadLoadedData(@NotNull GDBTuple varTuple, @NotNull GdbVarId dataId, @Nullable String fvKey, @NotNull String value, boolean extractRichStrings) {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(164);
        }
        if (dataId == null) {
            GDBDriver.$$$reportNull$$$0(165);
        }
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(166);
        }
        Integer childrenCount = null;
        boolean isDynamic = varTuple.getBoolean("dynamic");
        boolean hasDynamicChildren = false;
        if (isDynamic) {
            hasDynamicChildren = varTuple.getBoolean("has_more", true);
        } else {
            childrenCount = varTuple.getInt("numchild", 0);
        }
        String displayHint = varTuple.getString("displayhint");
        boolean defaultPrinterFailed = GDBDriver.isDefaultPrinterFailed(varTuple);
        return new LLValueLoadedData(dataId, fvKey, childrenCount, isDynamic, hasDynamicChildren, value, displayHint, false, defaultPrinterFailed, extractRichStrings);
    }

    private static boolean isDefaultPrinterFailed(@NotNull GDBTuple varTuple) {
        if (varTuple == null) {
            GDBDriver.$$$reportNull$$$0(167);
        }
        return varTuple.getBoolean("cidr-default-printer-failed", false);
    }

    private static void doUpdateLoadedData(@NotNull LLValue var, @NotNull LLValueLoadedData data) {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(168);
        }
        if (data == null) {
            GDBDriver.$$$reportNull$$$0(169);
        }
        var.putUserData(LLVALUE_DATA, data);
    }

    @Override
    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (var == null) {
            GDBDriver.$$$reportNull$$$0(170);
        }
        return (Integer)this.executeCommand(() -> this.doGetChildrenCount(var));
    }

    @Nullable
    private Integer doGetChildrenCount(LLValue var) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        LLValueLoadedData data = this.doLoadVariable(var);
        Integer nullableChildrenCount = data.childrenCount;
        if (nullableChildrenCount == null) {
            return null;
        }
        MapElement mapElement = (MapElement)var.getUserData(LLVALUE_MAP_ELEMENT);
        if (mapElement != null) {
            return nullableChildrenCount;
        }
        Integer classChildrenCountCache = (Integer)var.getUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE);
        if (classChildrenCountCache != null) {
            return classChildrenCountCache;
        }
        final int[] childrenCount = new int[]{nullableChildrenCount};
        if (this.doVisitCppClassChildren(var, new StructChildrenVisitor(){

            @Override
            public boolean visitFakeChild(@NotNull LLValue fakeChild, int fakeChildrenCount) {
                if (fakeChild == null) {
                    13.$$$reportNull$$$0(0);
                }
                childrenCount[0] = childrenCount[0] - 1;
                childrenCount[0] = childrenCount[0] + fakeChildrenCount;
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeChild", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$13", "visitFakeChild"));
            }
        })) {
            var.putUserData(LLVALUE_CLASS_CHILDREN_COUNT_CACHE, childrenCount[0]);
        }
        return childrenCount[0];
    }

    private static String fixType(@Nullable String type) {
        return type == null ? null : type.replace("'", "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LLValue evaluate(final long threadId, final int frameIndex, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage debuggerLanguage) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void language;
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(171);
        }
        final String debuggerLanguage2 = GDBDriver.convertLanguage((DebuggerDriver.DebuggerLanguage)language);
        LLValue lLValue = this.executeCommand(new EvaluationCommand<LLValue>(expression){

            @Override
            public LLValue call() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                return GDBDriver.this.doEvaluate(threadId, frameIndex, expression, debuggerLanguage2);
            }
        });
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(172);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(173);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(174);
        }
        if (expression == null) {
            GDBDriver.$$$reportNull$$$0(175);
        }
        LLValue lLValue = this.myThreadFrameInfoDriverDelegate.evaluate(this.myBridge, thread, frame, expression, language);
        if (lLValue == null) {
            GDBDriver.$$$reportNull$$$0(176);
        }
        return lLValue;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(177);
        }
        if (fallbackRange == null) {
            GDBDriver.$$$reportNull$$$0(178);
        }
        List list = this.executeCommand(() -> this.doDisassembleFunction(address, fallbackRange));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(179);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLInstruction> disassemble(@NotNull AddressRange range) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(180);
        }
        List list = this.executeCommand(() -> this.doDisassembleRange(range));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(181);
        }
        return list;
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleFunction(@NotNull Address address, @NotNull AddressRange fallbackRange) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(182);
        }
        if (fallbackRange == null) {
            GDBDriver.$$$reportNull$$$0(183);
        }
        assert (fallbackRange.contains(address));
        Pair<Address, String> functionStart = this.doGetFunctionStart(address);
        if (functionStart == null) {
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange);
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(184);
            }
            return arrayList;
        }
        Address startAddress = (Address)functionStart.first;
        String functionName = (String)functionStart.second;
        if (address.minus(startAddress) > 65536L) {
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange);
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(185);
            }
            return arrayList;
        }
        Pair<Address, String> pastFunctionEnd = this.doGetFunctionStart(startAddress.plus(65536));
        if (pastFunctionEnd != null && ((Address)pastFunctionEnd.first).equals(startAddress)) {
            AddressRange startUntilFallbackEndRange = AddressUtil.addressRangeInclusive(startAddress, fallbackRange.getEndInclusive());
            ArrayList<LLInstruction> arrayList = this.doDisassembleRange(fallbackRange.intersectWith(startUntilFallbackEndRange));
            if (arrayList == null) {
                GDBDriver.$$$reportNull$$$0(186);
            }
            return arrayList;
        }
        return this.doDisassemble(startAddress.toString(), functionName);
    }

    @NotNull
    protected ArrayList<LLInstruction> doDisassembleRange(@NotNull AddressRange range) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(187);
        }
        return this.doDisassemble(GDBDriver.format("%s,+%d", range.getStart(), range.getSize()), null);
    }

    @NotNull
    private ArrayList<LLInstruction> doDisassemble(@NotNull String disassembleAddressArg, @Nullable String functionName) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (disassembleAddressArg == null) {
            GDBDriver.$$$reportNull$$$0(188);
        }
        Response response = this.buildRequest("disassemble /r %s", disassembleAddressArg).uninterruptible().suppressAll().send().waitFor(GDBResponse.ResultRecord.Type.done);
        String[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        ArrayList<LLInstruction> result = new ArrayList<LLInstruction>(outputLines.length);
        for (String line : outputLines) {
            LLInstruction instruction;
            Matcher lineMatcher = INSTRUCTION_LINE.matcher(line);
            if (!lineMatcher.matches() || (instruction = GDBDriver.parseInstruction(functionName, lineMatcher.group(1), lineMatcher.group(2), lineMatcher.group(3), lineMatcher.group(4))) == null) continue;
            result.add(instruction);
        }
        ArrayList<LLInstruction> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(189);
        }
        return arrayList;
    }

    @Nullable
    protected static LLInstruction parseInstruction(@Nullable String functionName, @NotNull String addressString, @Nullable String functionOffsetStr, @NotNull String opcodes, @NotNull String disassembly) {
        if (addressString == null) {
            GDBDriver.$$$reportNull$$$0(190);
        }
        if (opcodes == null) {
            GDBDriver.$$$reportNull$$$0(191);
        }
        if (disassembly == null) {
            GDBDriver.$$$reportNull$$$0(192);
        }
        if (CANNOT_ACCESS_MEMORY_AT_ADDRESS.matcher(disassembly).matches()) {
            return null;
        }
        String instruction = null;
        String comment = null;
        if (!BAD_INSTRUCTION_WITH_PREFIX_SUFFIX.matcher(disassembly).matches()) {
            instruction = disassembly;
        }
        Address address = Address.parseHexString(addressString);
        LLSymbolOffset functionOffset = functionOffsetStr == null ? null : LLSymbolOffset.parseAngleBrackets(functionOffsetStr, functionName);
        List<Byte> bytes = GDBDriver.parseOpcodeBytes(opcodes);
        if (bytes == null) {
            CidrDebuggerLog.LOG.warn("Failed to parse opcodes '" + opcodes + "'");
            return null;
        }
        return LLInstruction.create(address, bytes, (String)ObjectUtils.notNull((Object)instruction, (Object)("/* BAD: " + opcodes + " */")), comment, functionOffset);
    }

    @Nullable
    private static List<Byte> parseOpcodeBytes(@NotNull String opcodes) {
        String hex;
        if (opcodes == null) {
            GDBDriver.$$$reportNull$$$0(193);
        }
        if ((hex = opcodes.replace(" ", "")).length() % 2 != 0) {
            return null;
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (int i = 0; i < hex.length(); i += 2) {
            try {
                int b = Integer.parseUnsignedInt(hex.substring(i, i + 2), 16);
                if (0 > b || b > 255) {
                    return null;
                }
                result.add((byte)b);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    @Nullable
    protected Pair<Address, String> doGetFunctionStart(@NotNull Address address) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response;
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(194);
        }
        if ((response = this.doDataDisassemble(AddressUtil.addressToRange(address, 1L))).getRecord().getType() == GDBResponse.ResultRecord.Type.error) {
            return null;
        }
        GDBTuple asmInsns = response.getResultList().getRequiredTuple("asm_insns");
        if (asmInsns.isEmpty()) {
            return null;
        }
        GDBTuple insn = (GDBTuple)asmInsns.get(0);
        String funcName = insn.getString("func-name");
        Integer offset = insn.getInteger("offset", null);
        if (funcName == null || offset == null) {
            return null;
        }
        Address functionStart = insn.getRequiredAddress("address").minus(offset);
        if (functionStart.equals(Address.NULL)) {
            return null;
        }
        return Pair.create((Object)functionStart, (Object)funcName);
    }

    @NotNull
    private Response doDataDisassemble(@NotNull AddressRange range) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(195);
        }
        Response response = this.sendRequest("-data-disassemble -s %s -e %s -- 2", range.getStart(), AddressUtil.getEndCoerced(range)).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.error);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(196);
        }
        return response;
    }

    @Override
    public @Unmodifiable @NotNull List<LLModule> getLoadedModules() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
        List list = ContainerUtil.map(sectionsMap.keySet(), LLModule::new);
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(197);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LLSection> getModuleSections(@NotNull LLModule module) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (module == null) {
            GDBDriver.$$$reportNull$$$0(198);
        }
        List list = this.executeCommand(() -> {
            Map<String, List<LLSection>> sectionsMap = this.doGetSectionsMap();
            List<LLSection> sections = sectionsMap.get(module.getPath());
            if (sections == null) {
                throw new DebuggerCommandException("Unknown module '" + String.valueOf(module) + "'");
            }
            return sections;
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(199);
        }
        return list;
    }

    @NotNull
    protected Map<String, List<LLSection>> doGetSectionsMap() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (this.mySectionsMap == null) {
            String allObjectsFlag = this.myGdbVersion == null || this.myGdbVersion.lessThan(Integer.valueOf(11)) ? "ALLOBJ" : "-all-objects";
            Response response = this.sendSilentRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("maintenance info sections " + allObjectsFlag));
            this.mySectionsMap = GDBDriver.doReadSectionsMap(response.getOutput());
        }
        Map<String, List<LLSection>> map = this.mySectionsMap;
        if (map == null) {
            GDBDriver.$$$reportNull$$$0(200);
        }
        return map;
    }

    @NotNull
    protected static Map<String, List<LLSection>> doReadSectionsMap(@NotNull String output) throws com.intellij.execution.ExecutionException {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(201);
        }
        LinkedHashMap<String, List<LLSection>> sectionsMap = new LinkedHashMap<String, List<LLSection>>();
        ArrayList<LLSection> sections = null;
        for (String str : output.split("\n")) {
            Matcher matcher;
            Matcher headerMatcher = OBJECT_FILE_HEADER.matcher(str);
            if (headerMatcher.matches()) {
                String objectName = headerMatcher.group(1);
                if (objectName == null) {
                    objectName = headerMatcher.group(2);
                }
                sections = new ArrayList<LLSection>();
                sectionsMap.putIfAbsent(objectName, Collections.unmodifiableList(sections));
                continue;
            }
            if (sections == null || !(matcher = SECTIONS_INFO.matcher(str)).matches()) continue;
            Address start = GDBDriver.parseAddress(matcher.group(1));
            Address end = GDBDriver.parseAddress(matcher.group(2));
            String name = matcher.group(3);
            List flags = StringUtil.split((String)matcher.group(4), (String)" ");
            sections.add(new LLSection(name, flags, AddressUtil.addressRangeExclusive(start, end)));
        }
        LinkedHashMap<String, List<LLSection>> linkedHashMap = sectionsMap;
        if (linkedHashMap == null) {
            GDBDriver.$$$reportNull$$$0(202);
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public List<LLMemoryHunk> dumpMemory(@NotNull AddressRange range) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (range == null) {
            GDBDriver.$$$reportNull$$$0(203);
        }
        List list = this.executeCommand(() -> {
            Response response = this.sendRequestAndWaitForDone("-data-read-memory-bytes %s %d", range.getStart(), range.getSize());
            ArrayList<LLMemoryHunk> list = new ArrayList<LLMemoryHunk>();
            for (Object o : response.getResultList().getRequiredTuple("memory")) {
                GDBTuple tuple = (GDBTuple)o;
                Address begin = tuple.getRequiredAddress("begin").plus(tuple.getInt("offset", 0));
                Address end = tuple.getRequiredAddress("end");
                AddressRange hunkRange = AddressUtil.addressRangeExclusive(begin, end);
                String contents = tuple.getRequiredString("contents");
                byte[] bytes = GDBDriver.bytesFromString(contents);
                if ((long)bytes.length != range.getSize()) {
                    CidrDebuggerLog.LOG.warn("Memory range of size " + range.getSize() + "; content size is " + bytes.length);
                    continue;
                }
                LLMemoryHunk hunk = new LLMemoryHunk(hunkRange, bytes);
                list.add(hunk);
            }
            return list;
        });
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(204);
        }
        return list;
    }

    private static byte[] bytesFromString(@NotNull String data) {
        if (data == null) {
            GDBDriver.$$$reportNull$$$0(205);
        }
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((Character.digit(data.charAt(i * 2), 16) << 4) + Character.digit(data.charAt(i * 2 + 1), 16));
        }
        return bytes;
    }

    private LLValue doEvaluate(long threadId, int frameIndex, String expression, @Nullable String language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (language != null) {
            this.sendRequestAndWaitForDone("-gdb-set language %s", language);
        }
        try {
            CidrEventSpan ignored = new CidrEventSpan("debug", "doEvaluate", expression);
            try {
                RawViewSupport rawViewSupport = this.getRawViewSupport();
                boolean isRaw = false;
                if (rawViewSupport instanceof GdbRawViewSupport) {
                    GdbRawViewSupport gdbRawViewSupport = (GdbRawViewSupport)rawViewSupport;
                    isRaw = gdbRawViewSupport.isRawViewEnabledForExpression(expression);
                }
                GDBResponse.Record response = this.myUsePythonToLoadData ? this.doCreateVarPython(expression, threadId, frameIndex, isRaw) : this.doCreateVar(expression, threadId, frameIndex);
                LLValue result = this.doReadVariable(response.getResultList(), null, null);
                result.putUserData(EVALUATED_EXPRESSION, expression);
                LLValue lLValue = result;
                ignored.close();
                return lLValue;
            }
            catch (Throwable throwable) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (language != null) {
                this.sendRequestAndWaitForDone("-gdb-set language auto", new Object[0]);
            }
        }
    }

    @Nullable
    private static String convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DebuggerCommandException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            return switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case DebuggerDriver.StandardDebuggerLanguage.C -> "c";
                case DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS -> "c++";
                case DebuggerDriver.StandardDebuggerLanguage.OBJC -> "objective-c";
                default -> throw new DebuggerCommandException(String.valueOf(language) + " is not supported by GDB");
            };
        }
        throw new DebuggerCommandException(String.valueOf(language) + " is not supported by GDB");
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws com.intellij.execution.ExecutionException {
        if (executable == null) {
            GDBDriver.$$$reportNull$$$0(206);
        }
        throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.executing.shell.commands.not.implemented.yet", new Object[0]));
    }

    @Override
    @NotNull
    public String executeInterpreterCommand(@NotNull String command) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(207);
        }
        String string = this.executeInterpreterCommand(-1L, -1, command);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(208);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String executeInterpreterCommand(long threadId, int frameIndex, @NotNull String string) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void command;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(209);
        }
        String string2 = this.executeCommand(new ConsoleCommand<String>((String)command, (String)command, threadId, frameIndex){
            final /* synthetic */ String val$command;
            final /* synthetic */ long val$threadId;
            final /* synthetic */ int val$frameIndex;
            {
                this.val$command = string;
                this.val$threadId = l;
                this.val$frameIndex = n;
                super(expression);
            }

            @Override
            public String call() throws com.intellij.execution.ExecutionException {
                String commandToSend;
                if (GDBDriver.this.checkIsInPromptModeWhenSettled(300)) {
                    commandToSend = this.val$command;
                } else {
                    String trimmed;
                    long actualThreadId = this.val$threadId;
                    int actualFrameIndex = this.val$frameIndex;
                    DebuggerDriver.StopPlace currentPlace = GDBDriver.this.myStopPlace;
                    if (actualThreadId < 0L && currentPlace != null) {
                        actualThreadId = currentPlace.thread.getId();
                        actualFrameIndex = currentPlace.frame.getIndex();
                    }
                    if ("run".equals(trimmed = this.val$command.trim())) {
                        GDBDriver.this.handleDebuggerOutput(GDBBundle.message("command.0.is.not.supported", trimmed) + "\n", ProcessOutputTypes.STDOUT);
                        return "";
                    }
                    commandToSend = GDBDriver.createConsoleCommand(trimmed, actualThreadId, actualFrameIndex);
                }
                return GDBDriver.this.sendRequest("%s", commandToSend).waitAndPokeForPrompt((int)this.getTimeout()).getOutput();
            }
        });
        if (string2 == null) {
            GDBDriver.$$$reportNull$$$0(210);
        }
        return string2;
    }

    @Override
    @NotNull
    public DebuggerDriver.ResultList<String> completeConsoleCommand(@NotNull String command, int pos) throws com.intellij.execution.ExecutionException {
        DebuggerDriver.ResultList resultList;
        String completionPrefix;
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(211);
        }
        if ((completionPrefix = StringUtil.trimLeading((String)command.substring(0, pos))).startsWith("!")) {
            DebuggerDriver.ResultList<String> resultList2 = DebuggerDriver.ResultList.empty();
            if (resultList2 == null) {
                GDBDriver.$$$reportNull$$$0(212);
            }
            return resultList2;
        }
        try {
            resultList = this.executeCommand(() -> this.doCompleteConsoleCommand(completionPrefix));
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug((Throwable)e);
            DebuggerDriver.ResultList<String> resultList3 = DebuggerDriver.ResultList.empty();
            if (resultList3 == null) {
                GDBDriver.$$$reportNull$$$0(214);
            }
            return resultList3;
        }
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(213);
        }
        return resultList;
    }

    @NotNull
    private DebuggerDriver.ResultList<String> doCompleteConsoleCommand(@NotNull String completionPrefix) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        List fullCompletions;
        if (completionPrefix == null) {
            GDBDriver.$$$reportNull$$$0(215);
        }
        if (this.checkIsInPromptModeWhenSettled(300)) {
            DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(216);
            }
            return resultList;
        }
        Response response = this.sendSilentRequestAndWaitForDone("complete %s", completionPrefix);
        Object[] outputLines = StringUtil.splitByLines((String)response.getOutput(), (boolean)true);
        boolean hasMore = false;
        if (outputLines.length > 0 && ((String)outputLines[outputLines.length - 1]).endsWith(MAX_COMPLETIONS_REACHED)) {
            outputLines[outputLines.length - 1] = "";
            hasMore = true;
        }
        if ((fullCompletions = ContainerUtil.filter((Object[])outputLines, line -> !StringUtil.isEmptyOrSpaces((String)line) && !line.startsWith("!"))).isEmpty()) {
            DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.empty();
            if (resultList == null) {
                GDBDriver.$$$reportNull$$$0(217);
            }
            return resultList;
        }
        int indexOfSpace = completionPrefix.lastIndexOf(32);
        String trimPrefix = indexOfSpace == -1 ? "" : completionPrefix.substring(0, indexOfSpace + 1);
        List completions = ContainerUtil.map((Collection)fullCompletions, line -> StringUtil.trimStart((String)line, (String)trimPrefix));
        DebuggerDriver.ResultList<String> resultList = DebuggerDriver.ResultList.create(completions, hasMore);
        if (resultList == null) {
            GDBDriver.$$$reportNull$$$0(218);
        }
        return resultList;
    }

    @Override
    public void handleSignal(@NotNull String signalName, boolean stop, boolean pass, boolean notify) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (signalName == null) {
            GDBDriver.$$$reportNull$$$0(219);
        }
        this.executeCommand(() -> {
            ArrayList<String> options = new ArrayList<String>(3);
            options.add(GDBDriver.handleSignalOption(stop, "stop"));
            options.add(GDBDriver.handleSignalOption(pass, "pass"));
            options.add(GDBDriver.handleSignalOption(notify, "print"));
            String command = GDBDriver.format("handle %s %s", signalName, StringUtil.join(options, (String)" "));
            this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand(command));
        });
    }

    @Override
    public void cancelSymbolsDownload(@NotNull String details) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (details == null) {
            GDBDriver.$$$reportNull$$$0(220);
        }
    }

    private static String handleSignalOption(boolean on, String option) {
        String prefix = "";
        if (!on) {
            prefix = "no";
        }
        return prefix + option;
    }

    @NotNull
    public static String createConsoleCommand(@NotNull String request) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(221);
        }
        return GDBDriver.createConsoleCommand(request, -1L, -1);
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @Nullable DebuggerDriver.StopPlace stopPlace) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(222);
        }
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(stopPlace));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static String createConsoleCommand(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(223);
        }
        return GDBDriver.createConsoleCommand(request, GDBDriver.onThreadAndFrame(threadId, (int)frameIndex));
    }

    @NotNull
    protected static String createConsoleCommand(@NotNull String request, @NotNull String onThreadAndFrame) {
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(224);
        }
        if (onThreadAndFrame == null) {
            GDBDriver.$$$reportNull$$$0(225);
        }
        String string = GDBDriver.format("-interpreter-exec %s console %s", onThreadAndFrame, GDBDriver.stringify(request));
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(226);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Request createMI2RequestWithToken(@NotNull String request, long threadId, int n) {
        void frameIndex;
        if (request == null) {
            GDBDriver.$$$reportNull$$$0(227);
        }
        long commandToken = this.myCommandCounter.getAndIncrement();
        String requestWithToken = GDBDriver.format("%d%s", commandToken, request);
        String cmd = GDBDriver.format("%d-interpreter-exec %s %s %s", 0, GDBDriver.onThreadAndFrame(threadId, (int)frameIndex), "mi2", GDBDriver.stringify(requestWithToken));
        Request request2 = new Request(cmd).withCommandToken(commandToken);
        if (request2 == null) {
            GDBDriver.$$$reportNull$$$0(228);
        }
        return request2;
    }

    @NotNull
    private String onStoppedThreadAndFrame() {
        String string = GDBDriver.onThreadAndFrame(this.myStopPlace);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(229);
        }
        return string;
    }

    private static String onThreadAndFrame(@Nullable DebuggerDriver.StopPlace stopPlace) {
        long threadId = stopPlace == null ? -1L : stopPlace.thread.getId();
        int frameIndex = stopPlace == null ? -1 : stopPlace.frame.getIndex();
        return GDBDriver.onThreadAndFrame(threadId, frameIndex);
    }

    @Contract(pure=true)
    @NotNull
    private static String onThread(long threadId) {
        return threadId >= 0L ? GDBDriver.format("--thread %d", threadId) : "";
    }

    private static String onThreadAndFrame(long threadId, int frameIndex) {
        return threadId >= 0L ? GDBDriver.format("--thread %d --frame %d", threadId, frameIndex) : "";
    }

    private static String atSourceLine(@NotNull String source, int line) {
        if (source == null) {
            GDBDriver.$$$reportNull$$$0(230);
        }
        return GDBDriver.stringify(GDBDriver.format("%s:%d", source, line + 1));
    }

    private static String atAddress(@NotNull Address address) {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(231);
        }
        return GDBDriver.format("*%s", address);
    }

    private static String atFunction(@NotNull String func) {
        if (func == null) {
            GDBDriver.$$$reportNull$$$0(232);
        }
        return GDBDriver.format("--function %s", GDBDriver.stringify(func));
    }

    private static String withCondition(@Nullable String condition) {
        return condition != null ? GDBDriver.format("-c %s", GDBDriver.stringify(condition)) : "";
    }

    @Contract(pure=true)
    @NotNull
    protected Request buildRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(233);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(234);
        }
        return new Request(GDBDriver.format(command, args));
    }

    @NotNull
    protected Communication sendRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(235);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(236);
        }
        Communication communication = this.buildRequest(command, args).send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(237);
        }
        return communication;
    }

    @NotNull
    protected Response sendRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(238);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(239);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(240);
        }
        return response;
    }

    @NotNull
    protected Response sendRequestAndWaitForRunning(@PrintFormat @NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(241);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(242);
        }
        Response response = this.sendRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done, GDBResponse.ResultRecord.Type.running);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(243);
        }
        return response;
    }

    @NotNull
    private Communication sendSilentRequest(@PrintFormat @NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(244);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(245);
        }
        Communication communication = this.buildRequest(command, args).suppressAll().send();
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(246);
        }
        return communication;
    }

    @NotNull
    protected Response sendSilentRequestAndWaitForDone(@PrintFormat @NonNls @NotNull String command, Object ... args) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(247);
        }
        if (args == null) {
            GDBDriver.$$$reportNull$$$0(248);
        }
        Response response = this.sendSilentRequest(command, args).waitFor(GDBResponse.ResultRecord.Type.done);
        if (response == null) {
            GDBDriver.$$$reportNull$$$0(249);
        }
        return response;
    }

    protected void sendRequestOrSpecialCommunication(@NotNull String commandDisplayString, boolean tearDownRequest, @NotNull ThrowableRunnable<? extends com.intellij.execution.ExecutionException> r) throws com.intellij.execution.ExecutionException {
        if (commandDisplayString == null) {
            GDBDriver.$$$reportNull$$$0(250);
        }
        if (r == null) {
            GDBDriver.$$$reportNull$$$0(251);
        }
        GdbUtil.waitForSemaphore(this.myCommandSemaphore);
        this.throwIfTerminatedOrHasPendingErrors(tearDownRequest);
        this.myCommandSemaphore.down();
        this.myLastCommand = commandDisplayString;
        r.run();
    }

    private void throwIfTerminatedOrHasPendingErrors(boolean tearDownRequest) throws com.intellij.execution.ExecutionException {
        if (!tearDownRequest && this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated()) {
            throw new ExecutionFinishedException();
        }
        this.checkErrors();
    }

    @Override
    public void checkErrors() throws com.intellij.execution.ExecutionException {
        block5: {
            Communication communication = this.myResultMap.get(ASYNC_COMMAND_RESPONSE_TOKEN);
            if (communication != null && communication.responseFuture.isDone()) {
                Response response;
                try {
                    response = communication.responseFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
                }
                try {
                    response.checkError();
                }
                catch (com.intellij.execution.ExecutionException e) {
                    this.myResultMap.remove(ASYNC_COMMAND_RESPONSE_TOKEN);
                    if (ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class)) break block5;
                    throw e;
                }
            }
        }
    }

    @Override
    protected void handleDebuggerOutput(@Nls @NotNull String text, @NotNull Key type) {
        if (text == null) {
            GDBDriver.$$$reportNull$$$0(252);
        }
        if (type == null) {
            GDBDriver.$$$reportNull$$$0(253);
        }
        if (!this.myCommunication.suppressOutputEvent) {
            super.handleDebuggerOutput(text, type);
        }
    }

    @Override
    protected void handleRunning() {
        if (!this.myCommunication.suppressRunningEvent) {
            super.handleRunning();
        }
    }

    @Override
    protected void handleTargetTerminated(@NotNull DebuggerDriver.ExitStatus exitStatus) {
        if (exitStatus == null) {
            GDBDriver.$$$reportNull$$$0(254);
        }
        if (this.myCommunication.suppressTargetFinishedEvent) {
            return;
        }
        this.myStopSemaphore.up();
        super.handleTargetTerminated(exitStatus);
    }

    private boolean isTerminated() {
        return this.myProcessHandler.isProcessTerminating() || this.myProcessHandler.isProcessTerminated();
    }

    private void interruptGdbCommand(@NotNull CompletableFuture<?> future, @NotNull String command) {
        if (future == null) {
            GDBDriver.$$$reportNull$$$0(255);
        }
        if (command == null) {
            GDBDriver.$$$reportNull$$$0(256);
        }
        int signalCounter = 0;
        while (true) {
            ++signalCounter;
            this.signalGdb();
            try {
                future.get(10L, TimeUnit.MILLISECONDS);
                CidrDebuggerLog.LOG.debug("Expired command '" + command + "' has completed after " + signalCounter + " " + StringUtil.pluralize((String)"signal", (int)signalCounter));
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                CidrDebuggerLog.LOG.debug("Wait for completion of expired command '" + command + "' failed, stop waiting", (Throwable)e);
            }
            break;
        }
    }

    private void signalGdb() {
        int gdbPid = (int)this.myProcessHandler.getProcess().pid();
        UnixProcessManager.sendSignal((int)gdbPid, (int)2);
    }

    protected boolean checkIsInPromptModeWhenSettled(int timeoutMs) throws com.intellij.execution.ExecutionException {
        if (this.isInPromptMode()) {
            try {
                this.getLastCommunication().responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException | ExecutionException e) {
                throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
            }
        }
        return this.isInPromptMode();
    }

    private static com.intellij.execution.ExecutionException unexpectedResponse(Object response) {
        return new com.intellij.execution.ExecutionException(GDBBundle.message("error.unexpected.response", response));
    }

    private static boolean messageContains(@NotNull Exception e, @NotNull String string) {
        String message;
        if (e == null) {
            GDBDriver.$$$reportNull$$$0(257);
        }
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(258);
        }
        return (message = e.getMessage()) != null && message.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPromptLevel() {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            return this.myPromptLevelStack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPromptMode(int promptLevel) {
        Deque<Integer> deque = this.myPromptLevelStack;
        synchronized (deque) {
            Deque<Integer> stack = this.myPromptLevelStack;
            if (promptLevel > 0) {
                while (!stack.isEmpty() && stack.getLast() > promptLevel) {
                    stack.removeLast();
                }
                if (stack.isEmpty() || stack.getLast() < promptLevel) {
                    stack.addLast(promptLevel);
                }
            } else {
                stack.clear();
            }
        }
        this.handlePrompt(promptLevel);
    }

    private boolean enterPromptMode(String prompt) {
        if (!PROMPT.matcher(prompt).matches()) {
            return false;
        }
        CidrDebuggerLog.LOG.assertTrue(this.myIsConsoleCommand, (Object)"Prompt mode is only expected as a result of a console command");
        this.setPromptMode(prompt.length());
        this.myResultMap.get((Object)GDBDriver.CONSOLE_COMMAND_RESPONSE_TOKEN).responseFuture.complete(Response.NULL);
        this.myCommandSemaphore.up();
        return true;
    }

    @NotNull
    private Communication getLastCommunication() {
        Long token = this.myCommunication.commandToken;
        if (token != null || this.myCommandCounter.get() == 1L) {
            Communication communication = this.myCommunication;
            if (communication == null) {
                GDBDriver.$$$reportNull$$$0(259);
            }
            return communication;
        }
        token = this.myCommandCounter.get() - 1L;
        Communication communication = this.myResultMap.get(token);
        CidrDebuggerLog.LOG.assertTrue(communication != null, (Object)("Communication is not found in the result map for " + token));
        Communication communication2 = communication;
        if (communication2 == null) {
            GDBDriver.$$$reportNull$$$0(260);
        }
        return communication2;
    }

    private void processResponse(@NotNull String output) {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(261);
        }
        try (CidrEventSpan ignored = new CidrEventSpan("debug", "processResponse", output);){
            try {
                this.doProcessResponse(output);
            }
            catch (Throwable e) {
                CompletableFuture<Response> future = this.getLastCommunication().responseFuture;
                if (!future.isDone()) {
                    future.complete(new ErrorResponse(GDBBundle.message("error.cannot.process.mi.record", this.myCommunication.command, output), e));
                }
            }
        }
    }

    private void doProcessResponse(@NotNull String output) throws GDBResponse.ResponseParseException, com.intellij.execution.ExecutionException {
        if (output == null) {
            GDBDriver.$$$reportNull$$$0(262);
        }
        if (CidrDebuggerLog.LOG.isDebugEnabled()) {
            CidrDebuggerLog.LOG.debug(this.processSignature() + "<" + output);
        }
        if ("(gdb)".equals(output)) {
            CidrDebuggerLog.LOG.assertTrue(!this.isInPromptMode(), (Object)"Prompt mode should have been reset on ^result record");
            this.myCommandSemaphore.up();
            return;
        }
        if (output.startsWith("0^")) {
            return;
        }
        GDBResponse response = GDBResponse.parse(output);
        if (response instanceof GDBResponse.StreamRecord) {
            this.doProcessStreamRecord((GDBResponse.StreamRecord)response);
        } else if (response instanceof GDBResponse.ResultRecord) {
            this.doProcessResultRecord((GDBResponse.ResultRecord)response);
        } else if (response instanceof GDBResponse.AsyncRecord) {
            this.doProcessAsyncRecord((GDBResponse.AsyncRecord)response);
        } else {
            throw GDBDriver.unexpectedResponse(output);
        }
    }

    private void doProcessStreamRecord(GDBResponse.StreamRecord record) {
        String text = record.getText();
        switch (record.getCategory()) {
            case target: {
                this.handleTargetOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case console: {
                if (this.myIsConsoleCommand && this.enterPromptMode(text)) break;
                if (this.myGdbVersion == null) {
                    this.myGdbVersion = VersionUtil.parseVersion((String)text, (Pattern[])new Pattern[]{VERSION_PATTERN});
                    this.myWindowsIoRedirectionEnabled = this.isWindows() && !StringUtil.containsIgnoreCase((String)text, (String)"cygwin") && this.myGdbVersion != null && this.myGdbVersion.major >= 8 && !Registry.is((String)"cidr.debugger.gdb.workaround.windows.forceExternalConsole", (boolean)false) && !this.myUseExternalConsoleRequested;
                }
                this.myCommunication.consoleOutput.append(text);
                this.handleDebuggerOutput(text, ProcessOutputTypes.STDOUT);
                break;
            }
            case log: {
                String message;
                String warningPrefix = "warning: ";
                boolean isWarning = text.startsWith(warningPrefix);
                Key type = isWarning ? ProcessOutputTypes.STDERR : ProcessOutputTypes.STDOUT;
                this.handleDebuggerOutput(text, type);
                if (!isWarning || !(message = StringUtil.trimStart((String)text, (String)warningPrefix).trim()).startsWith("Can't open file") || !message.endsWith("during file-backed mapping note processing")) break;
                this.warnUser(message);
            }
        }
    }

    private void doProcessResultRecord(GDBResponse.ResultRecord record) {
        this.setPromptMode(0);
        switch ((GDBResponse.ResultRecord.Type)record.getType()) {
            case continuing: 
            case stepping: {
                return;
            }
            case running: {
                this.myStopPlace = null;
                this.handleRunning();
                if (!this.myCommunication.suppressRunningResult) break;
                return;
            }
        }
        Response r = this.myCommunication.createResponse(record);
        if (record.getCommandToken() != null) {
            this.myResultMap.get((Object)Long.valueOf((String)record.getCommandToken())).responseFuture.complete(r);
        }
    }

    private void doProcessAsyncRecord(GDBResponse.AsyncRecord record) throws com.intellij.execution.ExecutionException {
        block40: {
            String type = ((GDBResponse.AsyncRecord.Type)record.getType()).getValue();
            GDBTuple resultTuple = record.getResultList();
            block1 : switch ((GDBResponse.AsyncRecord.Category)record.getCategory()) {
                case notify: {
                    switch (type) {
                        case "library-loaded": {
                            String moduleName = resultTuple.getString("id");
                            if (moduleName != null) {
                                LLModule module = new LLModule(moduleName);
                                this.handleModulesLoaded(Collections.singletonList(module));
                                GDBTuple ranges = resultTuple.getTuple("ranges");
                                if (ranges != null) {
                                    for (Object o2 : ranges) {
                                        AddressRange addressRange;
                                        GDBTuple range = (GDBTuple)o2;
                                        Address from = range.getAddress("from");
                                        Address to = range.getAddress("to");
                                        if (from == null || to == null || (addressRange = AddressUtil.addressRangeExclusive(from, to)).isEmpty()) continue;
                                        this.myModuleMap.addModule(addressRange, module);
                                    }
                                }
                            }
                            String libraryPath = resultTuple.getString("host-name");
                            GdbIndexingSession indexingSession = this.myGdbIndexingSession;
                            if (libraryPath != null && indexingSession != null) {
                                GdbIndexer.getInstance().libraryLoaded(indexingSession, libraryPath);
                            }
                            this.mySectionsMap = null;
                            break;
                        }
                        case "library-unloaded": {
                            String moduleName = resultTuple.getString("id");
                            if (moduleName != null) {
                                LLModule module = new LLModule(moduleName);
                                this.handleModulesUnloaded(Collections.singletonList(module));
                                this.myModuleMap.removeModule(module);
                            }
                            this.mySectionsMap = null;
                            break;
                        }
                        case "breakpoint-modified": {
                            try {
                                DebuggerDriver.AddBreakpointResult breakpointRes = GDBDriver.readBreakpoint(resultTuple);
                                LLBreakpoint breakpoint = breakpointRes.getBreakpoint();
                                this.handleBreakpointUpdated(breakpoint);
                                this.handleBreakpointLocationsReplaced(breakpoint.getId(), breakpointRes.getBreakpointLocations());
                                break;
                            }
                            catch (DebuggerCommandException e) {
                                throw new com.intellij.execution.ExecutionException((Throwable)e);
                            }
                        }
                        case "thread-group-exited": {
                            this.myInferiorsMap.remove(resultTuple.getRequiredString("id"));
                            if (this.myInferiorsMap.isEmpty()) {
                                Integer code = resultTuple.getInteger("exit-code", null);
                                this.handleTargetTerminated(code != null ? new DebuggerDriver.ExitStatus(code) : DebuggerDriver.ExitStatus.UNKNOWN);
                                break;
                            }
                            break block40;
                        }
                        case "thread-group-started": {
                            LLInferior inferior;
                            String groupId = resultTuple.getRequiredString("id");
                            this.myExecutingInferior = inferior = new LLInferior(groupId, resultTuple.getRequiredInt("pid"));
                            this.myInferiorsMap.put(groupId, inferior);
                            break;
                        }
                        case "thread-created": {
                            Integer threadId = resultTuple.getRequiredInt("id");
                            String groupId = resultTuple.getRequiredString("group-id");
                            this.myThreadToInferiorMap.put(threadId, groupId);
                            break;
                        }
                        case "thread-selected": {
                            this.doReadSelectedFrameChangedAsync(resultTuple);
                            break;
                        }
                        case "thread-exited": {
                            GDBExclusiveThread indexingSession;
                            DebuggerDriver.TargetState state = this.getState();
                            if (state.ordinal() >= DebuggerDriver.TargetState.FINISHING.ordinal() || !((indexingSession = this.myExclusiveThread.get()) instanceof GDBExclusiveThread.Exclusive.Alive)) break block1;
                            GDBExclusiveThread.Exclusive.Alive current = (GDBExclusiveThread.Exclusive.Alive)indexingSession;
                            Integer exitedThreadId = resultTuple.getInteger("id", null);
                            if (exitedThreadId == null || current.getExclusiveThreadId() != exitedThreadId.longValue()) break block1;
                            this.myHandler.handleNotification(GDBBundle.message("notification.exclusive.thread.exited", new Object[0]), DebuggerDriver.NotificationType.INFO);
                            this.updateExclusiveThread(current, it -> new GDBExclusiveThread.Exclusive.Exited(current.getExclusiveThreadId()));
                            break;
                        }
                        case "cmd-param-changed": {
                            if ("architecture".equals(resultTuple.getString("param"))) {
                                this.myCachedArchInfo.set(null);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case exec: {
                    String threadId;
                    if (type.equals("running") && !(threadId = resultTuple.getRequiredString("thread-id")).equals("all")) {
                        String groupId = this.myThreadToInferiorMap.get(Integer.valueOf(threadId));
                        this.myExecutingInferior = this.myInferiorsMap.get(groupId);
                    }
                    if (!type.equals("stopped")) {
                        return;
                    }
                    if (ContainerUtil.exists(resultTuple.getAll("reason", String.class), o -> o.startsWith("exited"))) {
                        DebuggerDriver.TargetState state = this.getState();
                        CidrDebuggerLog.LOG.assertTrue(state == DebuggerDriver.TargetState.FINISHED, (Object)("Finished state should have been reported already: " + String.valueOf((Object)state)));
                        return;
                    }
                    if (this.myPendingForAttachNotification.tryUp() && this.myStarter.isContinueAfterAttachNeeded()) {
                        return;
                    }
                    boolean bl = this.myIsInterruptedStop = resultTuple.getString("reason", "").equals("signal-received") && (resultTuple.getString("signal-name", "").equals("SIGINT") || resultTuple.getString("signal-name", "").equals("SIGTRAP") || resultTuple.getString("signal-name", "").equals("SIG" + this.myInterruptSignalName));
                    if (this.myStopSemaphore.tryUp() && this.myIsInterruptedStop) {
                        return;
                    }
                    this.myProcessingStopPlace = true;
                    Communication originalCommunication = this.myCommunication;
                    this.doReadStopPlaceAsync(resultTuple).thenAccept(stopPlace -> this.executeAsyncCommand(() -> {
                        this.myStopPlace = stopPlace;
                        this.doProcessAsyncStopPlace((DebuggerDriver.StopPlace)stopPlace, resultTuple, originalCommunication);
                    }));
                    break;
                }
            }
        }
    }

    private void doProcessAsyncStopPlace(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple, @NotNull Communication communication) throws com.intellij.execution.ExecutionException {
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(263);
        }
        if (resultTuple == null) {
            GDBDriver.$$$reportNull$$$0(264);
        }
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(265);
        }
        this.initSupportsFreezeOtherThreads(stopPlace);
        this.initDisasmFlavor();
        switch (resultTuple.getString("reason", "")) {
            case "signal-received": {
                ++communication.receivedSignalCount;
                String signalName = resultTuple.getString("signal-name", "UNKNOWN");
                if (GDBDriver.isTargetTerminationSignal(signalName)) {
                    int signal = UnixProcessManager.getPortableSignalNumber((String)StringUtil.trimStart((String)signalName, (String)"SIG"));
                    this.handleTargetTerminated(signal == -1 ? DebuggerDriver.ExitStatus.UNKNOWN : DebuggerDriver.ExitStatus.fromSignal(signal));
                } else {
                    String meaning = resultTuple.getString("signal-meaning", "");
                    this.handleSignal(stopPlace, signalName, meaning);
                    this.tryToFlushOnWindows();
                }
                return;
            }
            case "breakpoint-hit": {
                this.processBreakpointHit(stopPlace, resultTuple, communication);
                this.tryToFlushOnWindows();
                return;
            }
            case "location-reached": {
                break;
            }
            case "function-finished": 
            case "end-stepping-range": {
                boolean shouldHandle = communication.myThreadPlan.onSteppingFinished(stopPlace);
                if (shouldHandle) break;
                return;
            }
            case "watchpoint-trigger": 
            case "read-watchpoint-trigger": 
            case "access-watchpoint-trigger": {
                String tupleKey;
                String[] tupleKeys = new String[]{"wpt", "hw-rwpt", "hw-awpt"};
                GDBTuple wpt = null;
                String[] stringArray = tupleKeys;
                int n = stringArray.length;
                for (int i = 0; i < n && (wpt = resultTuple.getTuple(tupleKey = stringArray[i])) == null; ++i) {
                }
                if (wpt == null) break;
                int number = wpt.getRequiredInt("number");
                this.handleWatchpoint(stopPlace, number);
                this.tryToFlushOnWindows();
                return;
            }
            case "watchpoint-scope": {
                int wpnum = resultTuple.getRequiredInt("wpnum");
                this.handleWatchpointScope(wpnum);
                this.tryToFlushOnWindows();
                return;
            }
        }
        this.handleInterrupted(stopPlace);
        this.tryToFlushOnWindows();
    }

    protected void tryToFlushOnWindows() throws com.intellij.execution.ExecutionException {
        if (this.myWindowsIoRedirectionEnabled && Registry.is((String)"cidr.debugger.gdb.workaround.windows.flushStreamsOnSuspend", (boolean)true) && this.getState() == DebuggerDriver.TargetState.SUSPENDED) {
            String fflushCall = "((int(*)(void*))fflush)(0)";
            String command = GDBDriver.format("0-data-evaluate-expression %s", "((int(*)(void*))fflush)(0)");
            new Communication(this, command).doInitiate();
        }
    }

    private void processBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull GDBTuple resultTuple, @NotNull Communication communication) throws com.intellij.execution.ExecutionException {
        int num;
        boolean shouldHandle;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(266);
        }
        if (resultTuple == null) {
            GDBDriver.$$$reportNull$$$0(267);
        }
        if (communication == null) {
            GDBDriver.$$$reportNull$$$0(268);
        }
        if (shouldHandle = communication.myThreadPlan.onBreakpointHit(stopPlace, num = resultTuple.getRequiredInt("bkptno"))) {
            this.handleBreakpoint(stopPlace, num);
        }
    }

    private void cleanupOnTermination() {
        OutputStream processInput = this.myProcessInput;
        if (processInput != null) {
            try {
                processInput.close();
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
        this.myProcessInput = null;
        CompletableFuture<Response> future = this.getLastCommunication().responseFuture;
        if (!future.isDone()) {
            future.complete(new ErrorResponse((NotNullProducer<com.intellij.execution.ExecutionException>)((NotNullProducer)ExecutionFinishedException::new)));
        }
        this.myCommandSemaphore.up();
        this.myStopSemaphore.up();
        this.myPendingForAttachNotification.up();
        GdbCommandExecutor commandExecutor = this.myCommandExecutor;
        if (commandExecutor != null) {
            this.myCommandExecutor.shutdown();
        }
    }

    protected <T> T executeCommandNoUserException(Command<T> c) throws com.intellij.execution.ExecutionException {
        UserExpirable userExpirable;
        long timeout = c.getTimeout();
        Expirable expirable = this.myExpirable.get();
        if (expirable instanceof UserExpirable && (userExpirable = (UserExpirable)expirable).canBeExpiredInUI() && this.supportsCommandCancellation()) {
            timeout = -1L;
        }
        try {
            CompletableFuture<T> future = this.doExecuteCommand(c, false);
            return timeout < 0L ? ExecutionResult.get(future) : ExecutionResult.get(future, timeout, TimeUnit.MILLISECONDS);
        }
        catch (com.intellij.execution.ExecutionException e) {
            CompletionException ce = (CompletionException)ExceptionUtil.findCause((Throwable)e, CompletionException.class);
            com.intellij.execution.ExecutionException cause = (com.intellij.execution.ExecutionException)((Object)ExceptionUtil.findCause((Throwable)(ce != null ? ce : e).getCause(), com.intellij.execution.ExecutionException.class));
            throw cause != null ? cause : e;
        }
        catch (RejectedExecutionException e) {
            throw new ExecutionFinishedException((Throwable)e);
        }
        catch (TimeoutException e) {
            CidrDebuggerLog.LOG.warn("Command timed out (" + timeout + "): " + this.myLastCommand);
            if (c instanceof EvaluationCommand) {
                throw new DebuggerEvaluationTimedOutException(((EvaluationCommand)c).getExpression());
            }
            throw new DebuggerCommandTimedOutException(CidrDebuggerBundle.message("debug.command.error.timedOut", new Object[0]));
        }
    }

    protected <T> T executeCommand(Command<T> c) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        try {
            return this.executeCommandNoUserException(c);
        }
        catch (com.intellij.execution.ExecutionException e) {
            DebuggerCommandException cause = (DebuggerCommandException)ExceptionUtil.findCause((Throwable)e, DebuggerCommandException.class);
            if (cause != null) {
                throw new DebuggerCommandException(cause.getMessage(), cause);
            }
            throw e;
        }
    }

    private <T> CompletableFuture<T> executeAsyncCommand(Command<T> c) {
        return this.doExecuteCommand(c, true);
    }

    private <T> CompletableFuture<T> doExecuteCommand(Command<T> c, boolean async) {
        return this.myCommandExecutor.executeCommand(() -> {
            CidrEventSpan ignored = new CidrEventSpan("debug", "doExecuteCommand", c.getClass().getName());
            try {
                if (c instanceof SuspendedCommand && this.getState() == DebuggerDriver.TargetState.RUNNING) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.notSuspended", new Object[0]));
                }
                this.myIsConsoleCommand = c instanceof ConsoleCommand;
                if (!this.myIsConsoleCommand && !(c instanceof DestroyCommand) && this.checkIsInPromptModeWhenSettled(500)) {
                    throw new DebuggerIllegalStateException(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]));
                }
                Object t = c.call();
                ignored.close();
                return t;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (async) {
                        Communication communication = new Communication(this, "");
                        communication.responseFuture.complete(new ErrorResponse(e));
                        this.myResultMap.put(ASYNC_COMMAND_RESPONSE_TOKEN, communication);
                    }
                    throw new CompletionException(e);
                }
            }
        });
    }

    @NotNull
    private static GdbVarId getGdbVarId(@NotNull String name, @Nullable String cidrId) {
        if (name == null) {
            GDBDriver.$$$reportNull$$$0(269);
        }
        return cidrId != null ? new GdbVarId(cidrId, true) : new GdbVarId(name, false);
    }

    @NotNull
    public static Pair<String, String> getDescriptionFromValue(@NotNull String value) {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(270);
        }
        GdbExtractedDescription description = GdbValueDescription.extractDescription(value, false);
        Pair pair = Pair.create((Object)description.getValue(), (Object)description.getDescription());
        if (pair == null) {
            GDBDriver.$$$reportNull$$$0(271);
        }
        return pair;
    }

    @NotNull
    GDBTuple loadPythonVarDetails(@NotNull String varId) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (varId == null) {
            GDBDriver.$$$reportNull$$$0(272);
        }
        Request request = this.createMI2RequestWithToken(GDBDriver.format("-cidr-var-read %s", varId), -1L, -1);
        Response response = request.send().waitFor(GDBResponse.ResultRecord.Type.done);
        GDBTuple gDBTuple = response.getResultList();
        if (gDBTuple == null) {
            GDBDriver.$$$reportNull$$$0(273);
        }
        return gDBTuple;
    }

    void setCidrVarRawEnabled(@NotNull String varId, boolean raw) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (varId == null) {
            GDBDriver.$$$reportNull$$$0(274);
        }
        Request request = this.createMI2RequestWithToken(GDBDriver.format("-cidr-var-set-raw %s %s", varId, raw ? "1" : "0"), -1L, -1);
        request.send().waitFor(GDBResponse.ResultRecord.Type.done);
    }

    @NotNull
    private Collection<String> doListFrameVariables(long threadId, int frameIndex) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        Response response = this.sendRequestAndWaitForDone("-stack-list-variables %s --no-values", GDBDriver.onThreadAndFrame(threadId, frameIndex));
        GDBTuple variables = response.getResultList().getRequiredTuple("variables");
        Collection collection = variables.stream().map(var -> ((GDBTuple)var).getString("name", "")).collect(Collectors.toCollection(LinkedHashSet::new));
        if (collection == null) {
            GDBDriver.$$$reportNull$$$0(275);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Pair<Boolean, String> doGetExpressionType(@NotNull String expr, long threadId, int n) throws com.intellij.execution.ExecutionException {
        void frameIndex;
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(276);
        }
        if (StringUtil.isEmptyOrSpaces((String)expr)) {
            return new Pair((Object)false, (Object)"<unknown>");
        }
        String command = GDBDriver.createConsoleCommand(GDBDriver.format("whatis/rmt %s", GDBDriver.escapeVariadicArgIfNeeded(expr)), threadId, (int)frameIndex);
        try {
            String output = this.sendSilentRequestAndWaitForDone("%s", command).getOutput();
            Matcher m = WHATIS_TYPE_OUTPUT.matcher(output);
            if (m.matches()) {
                String substring = m.group(1) != null ? m.group(1) : m.group(2);
                return new Pair((Object)true, (Object)StringUtil.convertLineSeparators((String)substring, (String)" ").trim());
            }
            return new Pair((Object)false, (Object)"<unknown>");
        }
        catch (DebuggerCommandException e) {
            String error = e.getMessage();
            if ("value has been optimized out".equals(error)) {
                return new Pair((Object)false, (Object)"<optimized out>");
            }
            return new Pair((Object)false, (Object)("error: " + error));
        }
    }

    @NotNull
    private static String escapeVariadicArgIfNeeded(@NotNull String expr) {
        if (expr == null) {
            GDBDriver.$$$reportNull$$$0(277);
        }
        if (StringUtil.containsChar((String)expr, (char)'#') && !StringUtil.containsChar((String)expr, (char)'\'')) {
            String string = "'" + expr + "'";
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(278);
            }
            return string;
        }
        String string = expr;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(279);
        }
        return string;
    }

    @NotNull
    private static String makeFVKey(@NotNull String frameAddr, @NotNull String name) {
        if (frameAddr == null) {
            GDBDriver.$$$reportNull$$$0(280);
        }
        if (name == null) {
            GDBDriver.$$$reportNull$$$0(281);
        }
        String string = frameAddr + "-" + name;
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(282);
        }
        return string;
    }

    @Override
    @NotNull
    public HostMachine getHostMachine() {
        HostMachine hostMachine = this.myStarter.getHostMachine();
        if (hostMachine == null) {
            GDBDriver.$$$reportNull$$$0(283);
        }
        return hostMachine;
    }

    @NotNull
    private String toEnvPath(@NotNull String path) {
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(284);
        }
        String string = this.myStarter.convertToEnvPath(path);
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(285);
        }
        return string;
    }

    private boolean isWindows() {
        return this.getHostMachine().getOS() == OS.Windows;
    }

    private boolean isMac() {
        return this.getHostMachine().getOS() == OS.macOS;
    }

    private boolean isUnix() {
        return !this.isWindows();
    }

    private boolean isMacOSSierra() {
        return !this.getHostMachine().isRemote() && SystemInfo.isMac;
    }

    private boolean isLinux() {
        return this.getHostMachine().getOS() == OS.Linux;
    }

    public void setThreadFrameInfoDriverDelegate(@NotNull ThreadFrameInfoDriverDelegate driverDelegate) {
        if (driverDelegate == null) {
            GDBDriver.$$$reportNull$$$0(286);
        }
        this.myThreadFrameInfoDriverDelegate = driverDelegate;
    }

    public void resetThreadFrameInfoDriverDelegate() {
        CidrDebuggerLog.LOG.info("Resetting thread frame info driver delegate");
        this.myThreadFrameInfoDriverDelegate = new ThreadFrameInfoDriverDelegate(){};
    }

    private void initSupportsFreezeOtherThreads(@NotNull DebuggerDriver.StopPlace stopPlace) throws com.intellij.execution.ExecutionException {
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(287);
        }
        if (this.mySupportsFreezeOtherThreads == null) {
            this.mySupportsFreezeOtherThreads = this.checkSupportsFreezeOtherThreads(stopPlace);
        }
    }

    private boolean checkSupportsFreezeOtherThreads(@NotNull DebuggerDriver.StopPlace stopPlace) throws com.intellij.execution.ExecutionException {
        GDBTuple defaultMode;
        if (stopPlace == null) {
            GDBDriver.$$$reportNull$$$0(288);
        }
        try {
            defaultMode = this.gdbShow("scheduler-locking");
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug("Failed to show scheduler-locking, assume it is not supported");
            return false;
        }
        this.myDefaultSchedulerLockingMode = defaultMode.getString("value");
        if (this.myDefaultSchedulerLockingMode == null) {
            CidrDebuggerLog.LOG.debug("Empty default scheduler-locking value, disable freeze thread support");
            return false;
        }
        if ("on".equals(this.myDefaultSchedulerLockingMode)) {
            this.myDefaultSchedulerLockingMode = "off";
            this.updateExclusiveThread(this.myExclusiveThread.get(), it -> new GDBExclusiveThread.Exclusive.Alive(stopPlace.thread.getId()));
            return true;
        }
        try {
            this.buildRequest("-gdb-set scheduler-locking on", new Object[0]).withNoWarningOnError().send().waitFor(GDBResponse.ResultRecord.Type.done);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug("Scheduler-locking is not supported");
            return false;
        }
        try {
            this.gdbSet("scheduler-locking", this.myDefaultSchedulerLockingMode);
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.warn("Failed to restore default scheduler-locking mode");
        }
        return true;
    }

    @Override
    public boolean supportsFreezeOtherThreads() {
        return (Boolean)ObjectUtils.notNull((Object)this.mySupportsFreezeOtherThreads, (Object)false);
    }

    @Override
    public void freezeOtherThreads(@NotNull LLThread thread) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(289);
        }
        this.gdbSet("scheduler-locking", "on");
        this.updateExclusiveThread(this.myExclusiveThread.get(), it -> new GDBExclusiveThread.Exclusive.Alive(thread.getId()));
    }

    @Override
    public void unfreezeAllThreads(@NotNull LLThread thread) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        GDBExclusiveThread exclusiveThread;
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(290);
        }
        if ((exclusiveThread = this.myExclusiveThread.get()) instanceof GDBExclusiveThread.Exclusive.Exited) {
            this.sendRequestAndWaitForDone("-thread-select %d", thread.getId());
        }
        this.gdbSet("scheduler-locking", this.myDefaultSchedulerLockingMode);
        this.updateExclusiveThread(exclusiveThread, it -> GDBExclusiveThread.None.INSTANCE);
    }

    @Override
    public boolean supportsDebuggingForkedProcess() {
        return this.isUnix();
    }

    @Override
    public boolean supportsDebuggingMultipleProcesses() {
        return this.isUnix();
    }

    @Override
    public void setFollowChildOnFork(boolean followChild) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            this.gdbSet("follow-fork-mode", followChild ? "child" : "parent");
            return null;
        });
    }

    @Override
    public void setDetachOnFork(boolean detach) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        this.executeCommand(() -> {
            this.gdbSet("detach-on-fork", detach);
            return null;
        });
    }

    @Override
    public void resize(int columns2, int rows) throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        if (this.myPty != null && !this.myPty.isClosed()) {
            try {
                this.myPty.setWindowSize(new WinSize(columns2, rows), null);
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn((Throwable)e);
            }
        }
    }

    private void updateExclusiveThread(@NotNull GDBExclusiveThread currentExclusiveThread, @NotNull Function<GDBExclusiveThread, GDBExclusiveThread> transition) {
        if (currentExclusiveThread == null) {
            GDBDriver.$$$reportNull$$$0(291);
        }
        if (transition == null) {
            GDBDriver.$$$reportNull$$$0(292);
        }
        GDBExclusiveThread newState = transition.apply(currentExclusiveThread);
        this.myExclusiveThread.compareAndSet(currentExclusiveThread, newState);
    }

    @Override
    public boolean supportsMemoryWrite() {
        return true;
    }

    @Override
    public void writeMemory(@NotNull Address address, byte[] bytes) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (address == null) {
            GDBDriver.$$$reportNull$$$0(293);
        }
        this.sendRequestAndWaitForDone("-data-write-memory-bytes %s \"%s\"", address, StringUtil.toHexString((byte[])bytes));
    }

    @Override
    public boolean supportsRegisters() {
        return true;
    }

    @Override
    @NotNull
    public List<LLValue> getRegisters(@NotNull LLThread thread, @NotNull LLFrame frame) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(294);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(295);
        }
        return this.getRegisters(thread.getId(), frame.getIndex(), Set.of());
    }

    @Override
    @NotNull
    public List<LLValue> getRegisters(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull Set<String> registerNames) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (thread == null) {
            GDBDriver.$$$reportNull$$$0(296);
        }
        if (frame == null) {
            GDBDriver.$$$reportNull$$$0(297);
        }
        if (registerNames == null) {
            GDBDriver.$$$reportNull$$$0(298);
        }
        return this.getRegisters(thread.getId(), frame.getIndex(), registerNames);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<LLValue> getRegisters(long threadId, int frameIndex, @NotNull Set<String> set) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void registerNames;
        if (set == null) {
            GDBDriver.$$$reportNull$$$0(299);
        }
        List list = this.executeCommand(() -> this.lambda$getRegisters$67(threadId, frameIndex, (Set)registerNames));
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(300);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<LLValue> doGetRegisters(long threadId, int frameIndex, @NotNull Set<String> set) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        void registerNames;
        if (set == null) {
            GDBDriver.$$$reportNull$$$0(301);
        }
        if (this.getState() != DebuggerDriver.TargetState.SUSPENDED) {
            List<LLValue> list = Collections.emptyList();
            if (list == null) {
                GDBDriver.$$$reportNull$$$0(302);
            }
            return list;
        }
        String regNums = "";
        List<String> names = this.getArchInfo().getRegisterNames();
        if (!registerNames.isEmpty()) {
            StringBuilder regNumsBuilder = new StringBuilder();
            for (int i = 0; i < names.size(); ++i) {
                String registerName = names.get(i);
                if (!registerNames.contains(registerName)) continue;
                regNumsBuilder.append(" ").append(i);
            }
            if (regNumsBuilder.isEmpty()) {
                List<LLValue> list = Collections.emptyList();
                if (list == null) {
                    GDBDriver.$$$reportNull$$$0(303);
                }
                return list;
            }
            regNums = regNumsBuilder.toString();
        }
        GDBTuple rawValues = this.sendRequestAndWaitForDone("-data-list-register-values --thread %d --frame %d --skip-unavailable r%s", threadId, frameIndex, regNums).getResultList().getTupleOrEmpty("register-values");
        GDBTuple naturalValues = this.sendRequestAndWaitForDone("-data-list-register-values --thread %d --frame %d --skip-unavailable N%s", threadId, frameIndex, regNums).getResultList().getTupleOrEmpty("register-values");
        ArrayList<LLValue> result = new ArrayList<LLValue>(rawValues.size());
        for (int i = 0; i < rawValues.size(); ++i) {
            String registerName;
            GDBTuple value = (GDBTuple)ObjectUtils.tryCast(rawValues.get(i), GDBTuple.class);
            if (value == null) continue;
            int regNumber = value.getInt("number", -1);
            String rawValue = value.getString("value", null);
            String string = registerName = 0 <= regNumber && regNumber < names.size() ? names.get(regNumber) : null;
            if (rawValue == null || registerName == null) continue;
            GDBTuple naturalValueTuple = i < naturalValues.size() ? (GDBTuple)ObjectUtils.tryCast(naturalValues.get(i), GDBTuple.class) : null;
            String naturalValue = naturalValueTuple != null ? naturalValueTuple.getString("value", null) : null;
            GDBRegisterValue parsedRawValue = GDBRegistersKt.parseRawValue(rawValue);
            boolean modifiable = true;
            if (parsedRawValue.isCompound || parsedRawValue.width >= 16) {
                modifiable = false;
                naturalValue = null;
            }
            if (naturalValue != null) {
                naturalValue = StringUtil.trimEnd((String)StringUtil.trimStart((String)naturalValue, (String)"["), (String)"]").trim();
            }
            LLValue register = new LLValue(registerName, "", null, null, "$" + registerName);
            register.putUserData(LLVALUE_DATA, new LLValueLoadedData(new GdbVarId(registerName, false), null, null, false, parsedRawValue.isCompound, parsedRawValue.hex, null, true, false, false));
            register.putUserData(CidrRegisterValue.IS_REGISTER_VALUE, true);
            register.putUserData(CidrRegisterValue.RAW_VALUE, parsedRawValue.hex);
            register.putUserData(CidrRegisterValue.ALTERNATIVE_VALUE, naturalValue);
            register.putUserData(CidrRegisterValue.MODIFIABLE, modifiable);
            if (parsedRawValue.isCompound) {
                LLValue childrenVar = new LLValue("$" + registerName, "", null, null, "");
                childrenVar.putUserData(LLVALUE_DATA_LOADER, new FrameValueLoader(registerName, threadId, frameIndex, this.myUsePythonToLoadData));
                register.putUserData(REGISTER_CHILDREN_VAR, (Object)childrenVar);
            }
            result.add(register);
        }
        ArrayList<LLValue> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(304);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getArchitecture() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        return this.getArchInfo().getArchitecture();
    }

    @Override
    @NotNull
    public List<LLRegisterSet> getRegisterSets() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        List<LLRegisterSet> list = this.getArchInfo().getRegisterSets();
        if (list == null) {
            GDBDriver.$$$reportNull$$$0(305);
        }
        return list;
    }

    @NotNull
    private GDBArchInfo getArchInfo() throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        GDBArchInfo result = this.myCachedArchInfo.get();
        if (result != null) {
            GDBArchInfo gDBArchInfo = result;
            if (gDBArchInfo == null) {
                GDBDriver.$$$reportNull$$$0(306);
            }
            return gDBArchInfo;
        }
        String architecture = this.executeCommand(() -> this.computeArchitecture());
        List<String> registerNames = this.computeRegisterNames();
        List<LLRegisterSet> registerSets = this.computeRegisterSets(architecture, registerNames);
        result = new GDBArchInfo(architecture, registerSets, registerNames);
        this.myCachedArchInfo.set(result);
        GDBArchInfo gDBArchInfo = result;
        if (gDBArchInfo == null) {
            GDBDriver.$$$reportNull$$$0(307);
        }
        return gDBArchInfo;
    }

    @NotNull
    private String computeArchitecture() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        String architecture = this.gdbShow("architecture").getString("value");
        if (StringUtil.isNotEmpty((String)architecture) && !architecture.equals("auto")) {
            String string = architecture;
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(308);
            }
            return string;
        }
        String showArchitectureOutput = this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("show architecture")).getOutput().trim();
        Matcher matcher = SHOW_ARCH_PATTERN.matcher(showArchitectureOutput);
        if (matcher.matches()) {
            String string = matcher.group(1).trim();
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(309);
            }
            return string;
        }
        matcher = SHOW_ARCH_PATTERN_GDB9.matcher(showArchitectureOutput);
        if (matcher.matches()) {
            String string = matcher.group(1).trim();
            if (string == null) {
                GDBDriver.$$$reportNull$$$0(310);
            }
            return string;
        }
        CidrDebuggerLog.LOG.debug("The 'show architecture' output doesn't match the pattern");
        Response response = this.sendRequestAndWaitForDone("%s", GDBDriver.createConsoleCommand("python print(gdb.selected_frame().architecture().name())"));
        String string = response.getOutput().trim();
        if (string == null) {
            GDBDriver.$$$reportNull$$$0(311);
        }
        return string;
    }

    @NotNull
    private List<String> computeRegisterNames() throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        GDBTuple names = this.sendRequestAndWaitForDone("-data-list-register-names", new Object[0]).getResultList().getTupleOrEmpty("register-names");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            String regName = (String)ObjectUtils.tryCast(names.get(i), String.class);
            result.add(StringUtil.notNullize((String)regName));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(312);
        }
        return arrayList;
    }

    @NotNull
    private List<LLRegisterSet> computeRegisterSets(@NotNull String architecture, @NotNull List<String> registerNames) throws com.intellij.execution.ExecutionException {
        List<LLRegisterSet> result;
        if (architecture == null) {
            GDBDriver.$$$reportNull$$$0(313);
        }
        if (registerNames == null) {
            GDBDriver.$$$reportNull$$$0(314);
        }
        return (result = GDBDriver.getUserFriendlyRegisterSets(architecture, registerNames)) != null ? result : this.getInternalGdbRegisterSets();
    }

    @Nullable
    private static List<LLRegisterSet> getUserFriendlyRegisterSets(@NotNull String architecture, @NotNull List<String> registerNames) {
        if (architecture == null) {
            GDBDriver.$$$reportNull$$$0(315);
        }
        if (registerNames == null) {
            GDBDriver.$$$reportNull$$$0(316);
        }
        try {
            List<LLRegisterSet> wellKnownSets = GDBDriver.getWellKnownRegisterSets(architecture);
            if (wellKnownSets != null) {
                ArrayList<LLRegisterSet> result = new ArrayList<LLRegisterSet>();
                LinkedHashSet<String> registers = new LinkedHashSet<String>(registerNames);
                registers.remove("");
                for (LLRegisterSet regSet : wellKnownSets) {
                    List availableRegisters = ContainerUtil.filter(regSet.getRegisters(), it -> registers.remove(it));
                    if (availableRegisters.isEmpty()) continue;
                    result.add(new LLRegisterSet(regSet.getName(), availableRegisters));
                }
                if (!registers.isEmpty()) {
                    result.add(new LLRegisterSet("Other", new ArrayList<String>(registers)));
                }
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static List<LLRegisterSet> getWellKnownRegisterSets(@Nullable String arch) {
        if (arch == null) {
            return null;
        }
        if (arch.contains("x86")) {
            return LLRegistersKt.getX86();
        }
        if (arch.contains("aarch64")) {
            return LLRegistersKt.getAarch64();
        }
        return null;
    }

    @NotNull
    private List<LLRegisterSet> getInternalGdbRegisterSets() throws com.intellij.execution.ExecutionException {
        String registerGroupsTable = this.executeCommandNoUserException(() -> this.sendSilentRequestAndWaitForDone("maintenance print register-groups", new Object[0]).getOutput());
        String[] lines = StringUtil.splitByLines((String)registerGroupsTable);
        if (lines.length == 0) {
            List<LLRegisterSet> list = Collections.emptyList();
            if (list == null) {
                GDBDriver.$$$reportNull$$$0(317);
            }
            return list;
        }
        LinkedHashMap<String, ArrayList<String>> groupRegisters = new LinkedHashMap<String, ArrayList<String>>();
        String header = lines[0];
        int columnCount = StringUtil.split((String)header, (String)" ").size();
        for (int i = 1; i < lines.length; ++i) {
            String regName;
            String line = lines[i];
            List columns2 = StringUtil.split((String)line, (String)" ");
            String string = regName = !columns2.isEmpty() ? (String)columns2.get(0) : null;
            if (regName == null || regName.startsWith("*") || regName.equals("''")) continue;
            String concatenatedGroupNames = columns2.size() < columnCount ? "other" : (String)ContainerUtil.getLastItem((List)columns2);
            for (String group : StringUtil.split((String)concatenatedGroupNames, (String)",")) {
                ArrayList<String> registers = (ArrayList<String>)groupRegisters.get(group);
                if (registers == null) {
                    registers = new ArrayList<String>();
                    groupRegisters.put(group, registers);
                }
                registers.add(regName);
            }
        }
        ArrayList<LLRegisterSet> result = new ArrayList<LLRegisterSet>();
        for (Map.Entry entry : groupRegisters.entrySet()) {
            String groupName = (String)entry.getKey();
            List registers = (List)entry.getValue();
            result.add(new LLRegisterSet(groupName, registers));
        }
        ArrayList<LLRegisterSet> arrayList = result;
        if (arrayList == null) {
            GDBDriver.$$$reportNull$$$0(318);
        }
        return arrayList;
    }

    @Override
    public void setExpirable(@Nullable Expirable expirable) {
        this.myExpirable.set(expirable);
    }

    private boolean isExpiredCommand() {
        Expirable expirable = this.myExpirable.get();
        return expirable != null && expirable.isExpired();
    }

    @Override
    public boolean supportsCommandCancellation() {
        return !this.getHostMachine().isRemote() && !SystemInfo.isWindows;
    }

    private void initDisasmFlavor() throws com.intellij.execution.ExecutionException {
        DebuggerDriver.DisasmFlavor disasmFlavor;
        GDBTuple flavorTuple;
        if (this.myDisasmFlavor != null) {
            return;
        }
        try {
            flavorTuple = this.gdbShow("disassembly-flavor");
        }
        catch (DebuggerCommandException e) {
            CidrDebuggerLog.LOG.debug("Failed to get disassembly-flavor, assume intel syntax is not supported");
            this.myDisasmFlavor = new DebuggerDriver.DisasmFlavor(null);
            return;
        }
        this.myDisasmFlavor = disasmFlavor = new DebuggerDriver.DisasmFlavor(flavorTuple.getString("value"));
        if (DebuggerDriver.DisasmFlavor.isX86DisasmFlavor(disasmFlavor)) {
            Boolean useIntelSyntax = CidrDisasmOptions.getUseIntelSyntax();
            if (useIntelSyntax == null) {
                return;
            }
            DebuggerDriver.DisasmFlavor requestedFlavor = DebuggerDriver.DisasmFlavor.getX86DisasmFlavor(useIntelSyntax);
            if (requestedFlavor.equals(disasmFlavor)) {
                return;
            }
            try {
                this.gdbSet("disassembly-flavor", requestedFlavor.getName());
                this.myDisasmFlavor = requestedFlavor;
            }
            catch (DebuggerCommandException e) {
                CidrDebuggerLog.LOG.warn("Failed to switch disassembly flavor", (Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public DebuggerDriver.DisasmFlavor getDisasmFlavor() {
        return this.myDisasmFlavor;
    }

    @Override
    public void setDisasmFlavor(@NotNull DebuggerDriver.DisasmFlavor flavor) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (flavor == null) {
            GDBDriver.$$$reportNull$$$0(319);
        }
        this.executeCommand(() -> this.gdbSet("disassembly-flavor", flavor.getName()));
        this.myDisasmFlavor = flavor;
    }

    void setGdbIndexingSession(@NotNull GdbIndexingSession session) {
        if (session == null) {
            GDBDriver.$$$reportNull$$$0(320);
        }
        this.myGdbIndexingSession = session;
    }

    @ApiStatus.Internal
    @Nullable
    public Version getGdbVersion() {
        return this.myGdbVersion;
    }

    @ApiStatus.Internal
    public boolean isUsePythonToLoadData() {
        return this.myUsePythonToLoadData;
    }

    @Override
    @NotNull
    public RawViewSupport getRawViewSupport() {
        RawViewSupport support = this.myRawViewSupport.get();
        if (support != null) {
            RawViewSupport rawViewSupport = support;
            if (rawViewSupport == null) {
                GDBDriver.$$$reportNull$$$0(321);
            }
            return rawViewSupport;
        }
        this.myRawViewSupport.compareAndSet(null, this.myUsePythonToLoadData ? new GdbRawViewSupport(this) : new DisabledRawViewSupport());
        RawViewSupport rawViewSupport = this.myRawViewSupport.get();
        if (rawViewSupport == null) {
            GDBDriver.$$$reportNull$$$0(322);
        }
        return rawViewSupport;
    }

    void markCidrValueForReload(@NotNull LLValue value) throws DebuggerCommandException, com.intellij.execution.ExecutionException {
        if (value == null) {
            GDBDriver.$$$reportNull$$$0(323);
        }
        if (value.getUserData(LLVALUE_DATA_LOADER) != null) {
            return;
        }
        final LLValueLoadedData data = this.doLoadVariable(value);
        if (!data.isCidrVar) {
            CidrDebuggerLog.LOG.warn("Cannot mark " + String.valueOf((Object)value) + " for reload, not a cidr var");
            return;
        }
        value.putUserData(LLVALUE_DATA_LOADER, new LLValueLoader(){

            @Override
            public void loadValue(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                if (value == null) {
                    18.$$$reportNull$$$0(0);
                }
                GDBTuple result = GDBDriver.this.loadPythonVarDetails(data.id);
                String newValue = result.getString("value", "");
                LLValueLoadedData newData = GDBDriver.doReadLoadedData(result, data.getGdbVarId(), data.fvKey, newValue, GDBDriver.this.myExtractRichStrings);
                GDBDriver.doUpdateLoadedData(value, newData);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$18", "loadValue"));
            }
        });
    }

    @Contract(value="null->null")
    @Nullable
    static String getFrameVarKey(@Nullable LLValue value) {
        return (String)FRAME_VAR_KEY.get((UserDataHolder)value);
    }

    @Contract(value="null->null")
    @Nullable
    static LLValue getParentValue(@Nullable LLValue value) {
        return (LLValue)((Object)PARENT_VALUE.get((UserDataHolder)value));
    }

    @Contract(value="null->null")
    @Nullable
    static String getEvaluatedExpression(@Nullable LLValue value) {
        return (String)EVALUATED_EXPRESSION.get((UserDataHolder)value);
    }

    @VisibleForTesting
    public void setExtractRichStrings(boolean extractRichStrings) {
        this.myExtractRichStrings = extractRichStrings;
    }

    @Override
    public boolean supportsQtRenderers() {
        return true;
    }

    private static boolean isErrorOpeningNonAsciiPath(@NotNull DebuggerCommandException error, @NotNull HostMachine hostMachine, @NotNull String path) {
        String message;
        if (error == null) {
            GDBDriver.$$$reportNull$$$0(324);
        }
        if (hostMachine == null) {
            GDBDriver.$$$reportNull$$$0(325);
        }
        if (path == null) {
            GDBDriver.$$$reportNull$$$0(326);
        }
        return (message = error.getMessage()) != null && message.contains(path) && message.contains("No such file or directory") && hostMachine.getOS() == OS.Windows && !hostMachine.isRemote() && FileUtil.exists((String)path) && !StandardCharsets.US_ASCII.newEncoder().canEncode(path);
    }

    private /* synthetic */ List lambda$getRegisters$67(long threadId, int frameIndex, Set registerNames) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        return this.doGetRegisters(threadId, frameIndex, registerNames);
    }

    private /* synthetic */ LLWatchpoint lambda$addWatchpoint$34(long threadId, int frameIndex, LLWatchpoint.Lifetime lifetime, String expr, LLWatchpoint.AccessType accessType) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (this.getState() == DebuggerDriver.TargetState.RUNNING) {
            throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.set.watchpoint.while.program.running", new Object[0]));
        }
        String watchpointExpression = this.doGetWatchpointExpression(threadId, frameIndex, lifetime, expr);
        Response response = this.sendRequestAndWaitForDone("-break-watch %s %s", accessType.getParamString(), GDBDriver.stringify(watchpointExpression));
        return GDBDriver.readWatchpoint(response.getResultList(), accessType);
    }

    static {
        CONSOLE_COMMAND_RESPONSE_TOKEN = -1L;
        ASYNC_COMMAND_RESPONSE_TOKEN = -2L;
        PROCESS_SIGNATURE_KEY = Key.create((String)"CidrDebugger.processSignature");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 11, 12, 19, 24, 34, 38, 44, 48, 50, 52, 54, 56, 61, 62, 64, 74, 77, 87, 88, 90, 92, 97, 99, 106, 110, 112, 113, 117, 119, 120, 121, 126, 127, 130, 131, 132, 133, 135, 138, 140, 141, 143, 145, 146, 149, 152, 153, 154, 156, 158, 160, 162, 172, 176, 179, 181, 184, 185, 186, 189, 196, 197, 199, 200, 202, 204, 208, 210, 212, 213, 214, 216, 217, 218, 226, 228, 229, 237, 240, 243, 246, 249, 259, 260, 271, 273, 275, 278, 279, 282, 283, 285, 300, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 317, 318, 321, 322 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architectureType";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 24: 
            case 34: 
            case 38: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 61: 
            case 62: 
            case 64: 
            case 74: 
            case 77: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 97: 
            case 99: 
            case 106: 
            case 110: 
            case 112: 
            case 113: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 126: 
            case 127: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 145: 
            case 146: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 172: 
            case 176: 
            case 179: 
            case 181: 
            case 184: 
            case 185: 
            case 186: 
            case 189: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 202: 
            case 204: 
            case 208: 
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 218: 
            case 226: 
            case 228: 
            case 229: 
            case 237: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 259: 
            case 260: 
            case 271: 
            case 273: 
            case 275: 
            case 278: 
            case 279: 
            case 282: 
            case 283: 
            case 285: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 317: 
            case 318: 
            case 321: 
            case 322: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 6: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 7: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setting";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installer";
                break;
            }
            case 21: 
            case 269: 
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreFile";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePathMappings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execSearchPaths";
                break;
            }
            case 29: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionScript";
                break;
            }
            case 30: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionDescription";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionString";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalCommands";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 43: 
            case 69: 
            case 73: 
            case 89: 
            case 284: 
            case 326: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 46: 
            case 49: 
            case 93: 
            case 207: 
            case 209: 
            case 211: 
            case 233: 
            case 235: 
            case 238: 
            case 241: 
            case 244: 
            case 247: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFileType";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 72: 
            case 75: 
            case 78: 
            case 118: 
            case 124: 
            case 128: 
            case 173: 
            case 289: 
            case 290: 
            case 294: 
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 68: 
            case 263: 
            case 266: 
            case 287: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 70: 
            case 76: 
            case 91: 
            case 95: 
            case 177: 
            case 182: 
            case 194: 
            case 231: 
            case 293: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 71: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 79: 
            case 84: 
            case 134: 
            case 136: 
            case 137: 
            case 147: 
            case 161: 
            case 163: 
            case 166: 
            case 270: 
            case 323: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 85: 
            case 276: 
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symBreakpoint";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 102: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 105: 
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopTuple";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tuple";
                break;
            }
            case 111: 
            case 264: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTuple";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadTuple";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclusiveThread";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tid";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameTuple";
                break;
            }
            case 123: 
            case 125: 
            case 129: 
            case 174: 
            case 295: 
            case 297: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 139: 
            case 142: 
            case 144: 
            case 150: 
            case 168: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 148: 
            case 272: 
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varId";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 155: 
            case 157: 
            case 171: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 159: 
            case 164: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varTuple";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 169: 
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 178: 
            case 183: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackRange";
                break;
            }
            case 180: 
            case 187: 
            case 195: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disassembleAddressArg";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addressString";
                break;
            }
            case 191: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disassembly";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 201: 
            case 261: 
            case 262: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPrefix";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onThreadAndFrame";
                break;
            }
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 234: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 250: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDisplayString";
                break;
            }
            case 251: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatus";
                break;
            }
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 265: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "communication";
                break;
            }
            case 280: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAddr";
                break;
            }
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverDelegate";
                break;
            }
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentExclusiveThread";
                break;
            }
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transition";
                break;
            }
            case 298: 
            case 299: 
            case 301: 
            case 314: 
            case 316: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerNames";
                break;
            }
            case 313: 
            case 315: {
                objectArray2 = objectArray3;
                objectArray3[0] = "architecture";
                break;
            }
            case 319: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 320: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 325: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterruptSignalName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "shellQuote";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "gdbShow";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoreDump";
                break;
            }
            case 34: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "loadForRemote";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createDupFdCall";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellWrapper";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellCommandLineString";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferiorArgs";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteParametersForIORedirectionOnWindows";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrorLinesFromOutput";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "listVarObjects";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastStopThread";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToLine";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToAddress";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "addWatchpoint";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetWatchpointExpression";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "addAddressBreakpoint";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "doGdbBreakInsert";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "addSymbolicBreakpoint";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadStopPlace";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadStopPlaceAsync";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetThreads";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "extractThreadId";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrames";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameVariables";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameAddr";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFrameVariables";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadFrameVariable";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetVariableChildren";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetPlainVariableChildren";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "doListChildren";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "doListChildrenPython";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetRegisterChildren";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetMapChildren";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateVarPython";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateVar";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadVariable";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadVariableStatic";
                break;
            }
            case 172: 
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "disassembleFunction";
                break;
            }
            case 181: {
                objectArray = objectArray2;
                objectArray2[1] = "disassemble";
                break;
            }
            case 184: 
            case 185: 
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "doDisassembleFunction";
                break;
            }
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "doDisassemble";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "doDataDisassemble";
                break;
            }
            case 197: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedModules";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSections";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetSectionsMap";
                break;
            }
            case 202: {
                objectArray = objectArray2;
                objectArray2[1] = "doReadSectionsMap";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpMemory";
                break;
            }
            case 208: 
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInterpreterCommand";
                break;
            }
            case 212: 
            case 213: 
            case 214: {
                objectArray = objectArray2;
                objectArray2[1] = "completeConsoleCommand";
                break;
            }
            case 216: 
            case 217: 
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompleteConsoleCommand";
                break;
            }
            case 226: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleCommand";
                break;
            }
            case 228: {
                objectArray = objectArray2;
                objectArray2[1] = "createMI2RequestWithToken";
                break;
            }
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "onStoppedThreadAndFrame";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequest";
                break;
            }
            case 240: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForDone";
                break;
            }
            case 243: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequestAndWaitForRunning";
                break;
            }
            case 246: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequest";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommunication";
                break;
            }
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFromValue";
                break;
            }
            case 273: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPythonVarDetails";
                break;
            }
            case 275: {
                objectArray = objectArray2;
                objectArray2[1] = "doListFrameVariables";
                break;
            }
            case 278: 
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeVariadicArgIfNeeded";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFVKey";
                break;
            }
            case 283: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnvPath";
                break;
            }
            case 300: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisters";
                break;
            }
            case 302: 
            case 303: 
            case 304: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetRegisters";
                break;
            }
            case 305: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterSets";
                break;
            }
            case 306: 
            case 307: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchInfo";
                break;
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: {
                objectArray = objectArray2;
                objectArray2[1] = "computeArchitecture";
                break;
            }
            case 312: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRegisterNames";
                break;
            }
            case 317: 
            case 318: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalGdbRegisterSets";
                break;
            }
            case 321: 
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawViewSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMIOutputFilterInTests";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 24: 
            case 34: 
            case 38: 
            case 44: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 61: 
            case 62: 
            case 64: 
            case 74: 
            case 77: 
            case 87: 
            case 88: 
            case 90: 
            case 92: 
            case 97: 
            case 99: 
            case 106: 
            case 110: 
            case 112: 
            case 113: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 126: 
            case 127: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: 
            case 145: 
            case 146: 
            case 149: 
            case 152: 
            case 153: 
            case 154: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 172: 
            case 176: 
            case 179: 
            case 181: 
            case 184: 
            case 185: 
            case 186: 
            case 189: 
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 202: 
            case 204: 
            case 208: 
            case 210: 
            case 212: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 218: 
            case 226: 
            case 228: 
            case 229: 
            case 237: 
            case 240: 
            case 243: 
            case 246: 
            case 249: 
            case 259: 
            case 260: 
            case 271: 
            case 273: 
            case 275: 
            case 278: 
            case 279: 
            case 282: 
            case 283: 
            case 285: 
            case 300: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 317: 
            case 318: 
            case 321: 
            case 322: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchpoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolsFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shellQuote";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "warnUser";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "gdbSet";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "gdbShow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadForLaunch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadForAttach";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadCoreDump";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "targetSelectCore";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadForRemote";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doAddPathMapping";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIndirectSymbols";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doLoadExecutable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createDupFdCall";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "doWrapExec";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getShellWrapper";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getShellCommandLineString";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getInferiorArgs";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "quoteParametersForIORedirectionOnWindows";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "doSelectWinBreakBinary";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "connectTo";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "extractErrorLinesFromOutput";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resume";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "stepInto";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "stepOver";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "stepOut";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "asyncStepOutUntilFrameWithDebugInfo";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "runTo";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "jumpToAddress";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "doJumpToAddress";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addPathMapping";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addForcedFileMapping";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addWatchpoint";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addAddressBreakpoint";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "interruptAndExecuteConsole";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "doInsertBreakpoint";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "doInsertAddressBreakpoint";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "doGdbBreakInsert";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "doInsertSymbolicBreakpoint";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepoints";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "readBreakpointLocation";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "readBreakpoint";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "doReadStopPlace";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getTopFrameFromThreadTuple";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "doReadReturnValue";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "doReadStopPlaceAsync";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "doReadSelectedFrameChangedAsync";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "doReadThreadInfo";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "extractThreadId";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "doReadFrame";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isIndirectSymbolFrame";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getFrameVariables";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getVariableChildren";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "doGetVariableChildren";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "doGetPlainVariableChildren";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "doListChildren";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "doListChildrenPython";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "doVisitCppClassChildren";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVarPython";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "doCreateVar";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "doReadVariable";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "doLoadVariableStatic";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "doLoadVariable";
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "doReadLoadedData";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultPrinterFailed";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateLoadedData";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 171: 
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "disassembleFunction";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 182: 
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "doDisassembleFunction";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "doDisassembleRange";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "doDisassemble";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "parseInstruction";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "parseOpcodeBytes";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "doGetFunctionStart";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "doDataDisassemble";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSections";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "doReadSectionsMap";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "dumpMemory";
                break;
            }
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "bytesFromString";
                break;
            }
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "executeShellCommand";
                break;
            }
            case 207: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "executeInterpreterCommand";
                break;
            }
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "completeConsoleCommand";
                break;
            }
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "doCompleteConsoleCommand";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "cancelSymbolsDownload";
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommand";
                break;
            }
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "createMI2RequestWithToken";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "atSourceLine";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "atAddress";
                break;
            }
            case 232: {
                objectArray = objectArray;
                objectArray[2] = "atFunction";
                break;
            }
            case 233: 
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "buildRequest";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 238: 
            case 239: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForDone";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestAndWaitForRunning";
                break;
            }
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequest";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "sendSilentRequestAndWaitForDone";
                break;
            }
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "sendRequestOrSpecialCommunication";
                break;
            }
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "handleDebuggerOutput";
                break;
            }
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetTerminated";
                break;
            }
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "interruptGdbCommand";
                break;
            }
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "messageContains";
                break;
            }
            case 261: {
                objectArray = objectArray;
                objectArray[2] = "processResponse";
                break;
            }
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "doProcessResponse";
                break;
            }
            case 263: 
            case 264: 
            case 265: {
                objectArray = objectArray;
                objectArray[2] = "doProcessAsyncStopPlace";
                break;
            }
            case 266: 
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "processBreakpointHit";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "getGdbVarId";
                break;
            }
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionFromValue";
                break;
            }
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "loadPythonVarDetails";
                break;
            }
            case 274: {
                objectArray = objectArray;
                objectArray[2] = "setCidrVarRawEnabled";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "doGetExpressionType";
                break;
            }
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "escapeVariadicArgIfNeeded";
                break;
            }
            case 280: 
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "makeFVKey";
                break;
            }
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "toEnvPath";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "setThreadFrameInfoDriverDelegate";
                break;
            }
            case 287: {
                objectArray = objectArray;
                objectArray[2] = "initSupportsFreezeOtherThreads";
                break;
            }
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "checkSupportsFreezeOtherThreads";
                break;
            }
            case 289: {
                objectArray = objectArray;
                objectArray[2] = "freezeOtherThreads";
                break;
            }
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "unfreezeAllThreads";
                break;
            }
            case 291: 
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "updateExclusiveThread";
                break;
            }
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "writeMemory";
                break;
            }
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "getRegisters";
                break;
            }
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "doGetRegisters";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "computeRegisterSets";
                break;
            }
            case 315: 
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyRegisterSets";
                break;
            }
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "setDisasmFlavor";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "setGdbIndexingSession";
                break;
            }
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "markCidrValueForReload";
                break;
            }
            case 324: 
            case 325: 
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "isErrorOpeningNonAsciiPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 11, 12, 19, 24, 34, 38, 44, 48, 50, 52, 54, 56, 61, 62, 64, 74, 77, 87, 88, 90, 92, 97, 99, 106, 110, 112, 113, 117, 119, 120, 121, 126, 127, 130, 131, 132, 133, 135, 138, 140, 141, 143, 145, 146, 149, 152, 153, 154, 156, 158, 160, 162, 172, 176, 179, 181, 184, 185, 186, 189, 196, 197, 199, 200, 202, 204, 208, 210, 212, 213, 214, 216, 217, 218, 226, 228, 229, 237, 240, 243, 246, 249, 259, 260, 271, 273, 275, 278, 279, 282, 283, 285, 300, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 317, 318, 321, 322 -> new IllegalStateException(string);
        };
    }

    public static interface MIResponseFilter
    extends BiFunction<String, String, String> {
        @Override
        public String apply(@NotNull String var1, @NotNull String var2);
    }

    private static class ModuleMap {
        @NotNull
        private final MutableAddressSpace<ModuleRegion> myAddressSpace = AddressSpaceKt.mutableAddressSpace();

        private ModuleMap() {
        }

        public synchronized void addModule(@NotNull AddressRange range, @NotNull LLModule module) {
            if (range == null) {
                ModuleMap.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleMap.$$$reportNull$$$0(1);
            }
            this.myAddressSpace.reallocate(new ModuleRegion(range, module));
        }

        public synchronized void removeModule(@NotNull LLModule module) {
            if (module == null) {
                ModuleMap.$$$reportNull$$$0(2);
            }
            this.myAddressSpace.filterRegions().forEach(region -> {
                if (region.getModule().equals(module)) {
                    this.myAddressSpace.unallocate((ModuleRegion)region);
                }
            });
        }

        @Nullable
        public synchronized LLModule findModuleByAddress(@NotNull Address address) {
            ModuleRegion region;
            if (address == null) {
                ModuleMap.$$$reportNull$$$0(3);
            }
            return (region = (ModuleRegion)this.myAddressSpace.getRegion(address)) != null ? region.getModule() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "address";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ModuleMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addModule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeModule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findModuleByAddress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class Communication {
        private static final String GDB_POKE_COMMAND = "0-gdb-set $__poke_gdb=1";
        @NotNull
        public final String command;
        @Nullable
        public Long commandToken;
        public final boolean suppressOutputEvent;
        public final boolean suppressRunningEvent;
        public final boolean suppressTargetFinishedEvent;
        public final boolean suppressRunningResult;
        public final boolean tearDownRequest;
        public final boolean forcePokeWorkaround;
        @NotNull
        public final ThreadPlan myThreadPlan;
        @NotNull
        public final StringBuffer consoleOutput;
        public int receivedSignalCount;
        @NotNull
        public final CompletableFuture<Response> responseFuture;
        private final boolean myLogErrorAsWarning;
        private final boolean myInterruptible;
        private volatile Communication myPromptingCommunication;
        final /* synthetic */ GDBDriver this$0;

        public Communication(@NotNull GDBDriver this$0, String command) {
            if (command == null) {
                Communication.$$$reportNull$$$0(0);
            }
            this(this$0, command, false, false, false, false, false, false, ThreadPlan.DEFAULT, null, true, true);
        }

        public Communication(@NotNull GDBDriver this$0, String command, boolean suppressOutputEvent, boolean suppressRunningEvent, boolean suppressTargetFinishedEvent, boolean suppressRunningResult, boolean tearDownRequest, @NotNull boolean forcePokeWorkaround, @Nullable ThreadPlan threadPlan, Long commandToken, boolean logErrorAsWarning, boolean interruptible) {
            if (command == null) {
                Communication.$$$reportNull$$$0(1);
            }
            if (threadPlan == null) {
                Communication.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            this.commandToken = null;
            this.consoleOutput = new StringBuffer();
            this.responseFuture = new CompletableFuture();
            this.myPromptingCommunication = null;
            this.command = command;
            CidrDebuggerLog.LOG.assertTrue(!StringUtil.containsLineBreak((CharSequence)command) || this.isMultilineCommand(), (Object)("MI command must not contain unescaped newlines: " + command));
            this.suppressOutputEvent = suppressOutputEvent;
            this.suppressRunningEvent = suppressRunningEvent;
            this.suppressTargetFinishedEvent = suppressTargetFinishedEvent;
            this.suppressRunningResult = suppressRunningResult;
            this.tearDownRequest = tearDownRequest;
            this.forcePokeWorkaround = forcePokeWorkaround;
            this.myThreadPlan = threadPlan;
            this.commandToken = commandToken;
            this.myLogErrorAsWarning = logErrorAsWarning;
            this.myInterruptible = interruptible;
        }

        protected boolean isMultilineCommand() {
            int promptLevel = this.this$0.getPromptLevel();
            return promptLevel == 1 && this.command.equals("end") || promptLevel == 0 && this.command.endsWith("\nend");
        }

        protected boolean usePokeCommandWorkaround() {
            if (this.forcePokeWorkaround) {
                return true;
            }
            if (this.this$0.isLinux() && this.command.contains("-exec-run")) {
                return true;
            }
            if (this.this$0.isLinux() && this.command.contains("-target-attach")) {
                return true;
            }
            return this.this$0.isWindows() && this.isMultilineCommand();
        }

        public void initiate() throws com.intellij.execution.ExecutionException {
            this.this$0.sendRequestOrSpecialCommunication(this.command, this.tearDownRequest, (ThrowableRunnable<? extends com.intellij.execution.ExecutionException>)((ThrowableRunnable)() -> {
                this.this$0.myPromptCommunication = new Communication(this.this$0, "");
                this.this$0.myResultMap.put(CONSOLE_COMMAND_RESPONSE_TOKEN, this.this$0.myPromptCommunication);
                if (this.commandToken != null) {
                    this.this$0.myResultMap.put(this.commandToken, this);
                } else if (!this.command.startsWith(String.valueOf(0))) {
                    boolean inPromptMode = this.this$0.checkIsInPromptModeWhenSettled(300);
                    if (inPromptMode) {
                        this.myPromptingCommunication = this.this$0.myCommunication;
                    } else {
                        this.commandToken = this.this$0.myCommandCounter.getAndIncrement();
                        this.this$0.myResultMap.put(this.commandToken, this);
                    }
                }
                this.this$0.myCommunication = this;
                this.doInitiate();
            }));
        }

        public void doInitiate() throws com.intellij.execution.ExecutionException {
            if (!this.command.startsWith(String.valueOf(0)) && this.commandToken != null) {
                this.doWrite(this.commandToken + this.command);
            } else {
                this.doWrite(this.command);
            }
            if (this.usePokeCommandWorkaround()) {
                this.doWrite(GDB_POKE_COMMAND);
            }
        }

        protected void doWrite(@NotNull String command) throws com.intellij.execution.ExecutionException {
            if (command == null) {
                Communication.$$$reportNull$$$0(3);
            }
            try {
                this.doWriteIO(command);
            }
            catch (IOException e) {
                if (this.this$0.isTerminated()) {
                    throw new ExecutionFinishedException((Throwable)e);
                }
                throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.cannot.send.request", new Object[0]), (Throwable)e);
            }
        }

        protected void doWriteIO(@NotNull String command) throws IOException {
            if (command == null) {
                Communication.$$$reportNull$$$0(4);
            }
            if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                CidrDebuggerLog.LOG.debug(this.this$0.processSignature() + ">" + command);
            }
            this.this$0.mySink.write(command + "\n");
            this.this$0.mySink.flush();
        }

        public Response createResponse(@NotNull GDBResponse.Record record) {
            if (record == null) {
                Communication.$$$reportNull$$$0(5);
            }
            return new ResultResponse(record, this.consoleOutput.toString(), this.receivedSignalCount);
        }

        public Response waitAndPokeForPrompt(int timeoutMs) throws com.intellij.execution.ExecutionException {
            return this.doWaitForResponse(true, timeoutMs);
        }

        @NotNull
        public Response waitFor(GDBResponse.ResultRecord.Type ... expectedTypes) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (expectedTypes == null) {
                Communication.$$$reportNull$$$0(6);
            }
            Response response = this.doWaitForResponse(false, 0);
            GDBResponse.Record result = response.getRecord();
            Object resultType = result.getType();
            if (expectedTypes.length == 0 || ArrayUtil.contains(resultType, (Object[])expectedTypes)) {
                Response response2 = response;
                if (response2 == null) {
                    Communication.$$$reportNull$$$0(7);
                }
                return response2;
            }
            String errorMessage = response.getGDBErrorMessage();
            if (!(!this.myLogErrorAsWarning || "-exec-interrupt".equals(this.command) && GDBDriver.INFERIOR_NOT_EXECUTING.equals(errorMessage))) {
                CidrDebuggerLog.LOG.warn("[UNEXPECTED] >" + this.command);
                CidrDebuggerLog.LOG.warn("[UNEXPECTED] <" + String.valueOf(result));
            }
            if (this.this$0.getState() != DebuggerDriver.TargetState.NOT_READY) {
                if ("ptrace: No such process.".equals(errorMessage)) {
                    this.this$0.handleTargetTerminated(DebuggerDriver.ExitStatus.UNKNOWN);
                    throw new ExecutionFinishedException();
                }
                if (this.this$0.getState() == DebuggerDriver.TargetState.FINISHED && ArrayUtil.contains((Object)GDBResponse.ResultRecord.Type.running, (Object[])expectedTypes)) {
                    throw new ExecutionFinishedException();
                }
            }
            if (resultType == GDBResponse.ResultRecord.Type.error) {
                throw response.createGDBError();
            }
            throw GDBDriver.unexpectedResponse(result);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private Response doWaitForResponse(boolean isConsoleCommand, int timeoutMs) throws com.intellij.execution.ExecutionException {
            try {
                Response response;
                CidrEventSpan ignored = new CidrEventSpan("debug", "doWaitForResponse", this.command);
                int timeoutElapsedMs = 0;
                int timeoutStepMs = 125;
                int EXP_BACK_OFF = 2;
                long checkExpirationIntervalMs = 25L;
                int counter = 1;
                while (true) {
                    long waitTime;
                    CompletableFuture<Object> future = CompletableFuture.anyOf(this.this$0.myResultMap.get((Object)GDBDriver.CONSOLE_COMMAND_RESPONSE_TOKEN).responseFuture, this.this$0.getLastCommunication().responseFuture);
                    Object response2 = null;
                    for (long elapsedTimeoutStepMs = 0L; elapsedTimeoutStepMs < (long)timeoutStepMs; elapsedTimeoutStepMs += waitTime) {
                        waitTime = Math.min(checkExpirationIntervalMs, (long)timeoutStepMs - elapsedTimeoutStepMs);
                        try {
                            response2 = future.get(waitTime, TimeUnit.MILLISECONDS);
                            break;
                        }
                        catch (TimeoutException e) {
                            if (!this.this$0.supportsCommandCancellation() || !this.this$0.isExpiredCommand() || !this.myInterruptible) continue;
                            this.this$0.interruptGdbCommand(future, this.command);
                            throw new DebuggerCommandExpiredException(this.command);
                        }
                    }
                    if (response2 == null) break block15;
                    if (!(response2 instanceof Response)) {
                        throw new DebuggerIllegalStateException("Response object of class " + String.valueOf(response2.getClass()) + ", but Response is expected.");
                    }
                    Response response3 = (Response)response2;
                    ignored.close();
                    response = response3;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        try {
                            ignored.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                {
                    block15: {
                        if (response != null) return response;
                        Communication.$$$reportNull$$$0(8);
                        return response;
                    }
                    if (timeoutMs > 0 && (timeoutElapsedMs += timeoutStepMs) > timeoutMs) {
                        throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.no.result.response.or.multiline.prompt.within.reasonable.amount.time", new Object[0]));
                    }
                    CidrDebuggerLog.LOG.debug("Waiting for '" + this.command + "' " + counter++ + " times.");
                    if (isConsoleCommand) {
                        this.doWrite("\n");
                    }
                    timeoutStepMs *= 2;
                    continue;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new com.intellij.execution.ExecutionException(GDBBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadPlan";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypes";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Communication";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "waitFor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doWaitForResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doWrite";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "doWriteIO";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createResponse";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "waitFor";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ThreadFrameInfoDriverDelegate {
        @NotNull
        default public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(0);
            }
            if (driver == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(1);
            }
            if (stopTuple == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(2);
            }
            CompletionStage completionStage = driver.executeAsyncCommand(() -> driver.doReadStopPlace(stopTuple)).handle((result, throwable) -> {
                if (throwable != null) {
                    CidrDebuggerLog.LOG.error(throwable);
                }
                return result;
            });
            if (completionStage == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(3);
            }
            return completionStage;
        }

        @NotNull
        default public List<LLThread> getThreads(@NotNull Bridge bridge, @NotNull GDBDriver driver) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(4);
            }
            if (driver == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(5);
            }
            List list = (List)bridge.executeCommand(() -> driver.doGetThreads());
            if (list == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        default public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(7);
            }
            if (thread == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(8);
            }
            DebuggerDriver.ResultList resultList = bridge.executeCommand(() -> bridge.doGetFrames(thread.getId(), from, count, untilFirstLineWithCode));
            if (resultList == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(9);
            }
            return resultList;
        }

        @NotNull
        default public List<LLValue> getVariables(@NotNull Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(10);
            }
            if (thread == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(11);
            }
            if (frame == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(12);
            }
            List list = (List)bridge.executeCommand(() -> bridge.doGetVariables(thread.getId(), frame.getIndex()));
            if (list == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(13);
            }
            return list;
        }

        @NotNull
        default public DebuggerDriver.FrameVariables getFrameVariables(@NotNull Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(14);
            }
            if (thread == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(15);
            }
            if (frame == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(16);
            }
            DebuggerDriver.FrameVariables frameVariables = (DebuggerDriver.FrameVariables)bridge.executeCommand(() -> bridge.doGetFrameVariables(thread.getId(), frame.getIndex()));
            if (frameVariables == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(17);
            }
            return frameVariables;
        }

        @NotNull
        default public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull Bridge bridge, @NotNull LLValue value, int from, int count) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(18);
            }
            if (value == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(19);
            }
            DebuggerDriver.ResultList resultList = (DebuggerDriver.ResultList)bridge.executeCommand(() -> bridge.doGetVariableChildren(value, from, count));
            if (resultList == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(20);
            }
            return resultList;
        }

        @NotNull
        default public LLValueData getData(@NotNull Bridge bridge, @NotNull LLValue var) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(21);
            }
            if (var == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(22);
            }
            LLValueData lLValueData = (LLValueData)bridge.executeCommand(() -> GDBDriver.doLoadVariableStatic((LLValue)var).data);
            if (lLValueData == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(23);
            }
            return lLValueData;
        }

        @NotNull
        default public LLValue evaluate(final @NotNull Bridge bridge, final @NotNull LLThread thread, final @NotNull LLFrame frame, final @NotNull String expression, final @Nullable DebuggerDriver.DebuggerLanguage language) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (bridge == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(24);
            }
            if (thread == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(25);
            }
            if (frame == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(26);
            }
            if (expression == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(27);
            }
            LLValue lLValue = bridge.executeCommand(new EvaluationCommand<LLValue>(expression){

                @Override
                public LLValue call() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
                    return bridge.doEvaluate(thread.getId(), frame.getIndex(), expression, language);
                }
            });
            if (lLValue == null) {
                ThreadFrameInfoDriverDelegate.$$$reportNull$$$0(28);
            }
            return lLValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 9, 13, 17, 20, 23, 28 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bridge";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopTuple";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 13: 
                case 17: 
                case 20: 
                case 23: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate";
                    break;
                }
                case 8: 
                case 11: 
                case 15: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 12: 
                case 16: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doReadStopPlaceAsync";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreads";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrames";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameVariables";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariableChildren";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doReadStopPlaceAsync";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 13: 
                case 17: 
                case 20: 
                case 23: 
                case 28: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getThreads";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrames";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariables";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrameVariables";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariableChildren";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 9, 13, 17, 20, 23, 28 -> new IllegalStateException(string);
            };
        }
    }

    public static interface Bridge {
        @NotNull
        public <T> CompletableFuture<T> executeAsyncCommand(@NotNull Command<T> var1);

        @NotNull
        public <T> T executeCommand(@NotNull Command<T> var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public String sendSilentRequestAndGetOutput(@PrintFormat @NonNls @NotNull String var1, Object ... var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public LLFrame doReadFrame(int var1, @NotNull GDBTuple var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> doGetFrames(long var1, int var3, int var4, boolean var5) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public List<LLValue> doGetVariables(long var1, int var3) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.FrameVariables doGetFrameVariables(long var1, int var3) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValueData doEvaluateAndLoad(long var1, int var3, String var4, @Nullable String var5) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @Nullable
        public DebuggerDriver.StopPlace getStopPlace();

        @NotNull
        public LLValueData doLoadVariableData(@NotNull LLValue var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public DebuggerDriver.ResultList<LLValue> doGetVariableChildren(@NotNull LLValue var1, int var2, int var3) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @NotNull
        public LLValue doEvaluate(long var1, int var3, String var4, @Nullable DebuggerDriver.DebuggerLanguage var5) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        @Nullable
        public LLValue doReadReturnValue(@NotNull GDBTuple var1, long var2, int var4) throws com.intellij.execution.ExecutionException, DebuggerCommandException;
    }

    protected static interface VoidCommand
    extends Command<Void> {
        @Override
        @Nullable
        default public Void call() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            this.run();
            return null;
        }

        public void run() throws com.intellij.execution.ExecutionException, DebuggerCommandException;
    }

    public static interface Command<T> {
        @Nullable
        public T call() throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        default public long getTimeout() {
            return DebuggerDriverTimeouts.getCommandTimeoutMs();
        }
    }

    protected static interface Response {
        public static final Response NULL = new Response(){

            @Override
            @NotNull
            public GDBResponse.Record getRecord() {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getOutput() {
                return "";
            }

            @Override
            public int getReceivedSignalCount() {
                throw new UnsupportedOperationException();
            }
        };

        @NotNull
        public GDBResponse.Record getRecord() throws com.intellij.execution.ExecutionException;

        @NotNull
        default public GDBTuple getResultList() throws com.intellij.execution.ExecutionException {
            GDBTuple gDBTuple = this.getRecord().getResultList();
            if (gDBTuple == null) {
                Response.$$$reportNull$$$0(0);
            }
            return gDBTuple;
        }

        @NlsSafe
        @NotNull
        public String getOutput() throws com.intellij.execution.ExecutionException;

        default public void checkError() throws com.intellij.execution.ExecutionException {
        }

        @NotNull
        default public DebuggerCommandException createGDBError() throws com.intellij.execution.ExecutionException {
            String errorMessage = this.getGDBErrorMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown GDB error";
            }
            return new GDBCommandException(this, errorMessage);
        }

        @Nullable
        default public String getGDBErrorMessage() throws com.intellij.execution.ExecutionException {
            return this.getRecord().getResultList().getString("msg");
        }

        public int getReceivedSignalCount() throws com.intellij.execution.ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Response", "getResultList"));
        }
    }

    private static class GDBCommandException
    extends DebuggerCommandException {
        @NotNull
        private final Response myResponse;

        GDBCommandException(@NotNull Response response, @NotNull String message) {
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(0);
            }
            if (message == null) {
                GDBCommandException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myResponse = response;
        }

        @NotNull
        public Response getResponse() {
            Response response = this.myResponse;
            if (response == null) {
                GDBCommandException.$$$reportNull$$$0(2);
            }
            return response;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBCommandException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    protected class Request {
        @NotNull
        private final String myCommand;
        private boolean mySuppressOutputEvent;
        private boolean mySuppressRunningEvent;
        private boolean mySuppressTargetFinishedEvent;
        private boolean mySuppressRunningResult;
        @NotNull
        private ThreadPlan myThreadPlan;
        private boolean myTearDownRequest;
        private boolean myForcePokeWorkaround;
        @Nullable
        private Long myCommandToken;
        private boolean myLogErrorAsWarning;
        private boolean myInterruptible;

        public Request(String command) {
            if (command == null) {
                Request.$$$reportNull$$$0(0);
            }
            this.myThreadPlan = ThreadPlan.DEFAULT;
            this.myLogErrorAsWarning = true;
            this.myInterruptible = true;
            this.myCommand = command;
        }

        @NotNull
        public Communication send() throws com.intellij.execution.ExecutionException {
            Communication communication = new Communication(GDBDriver.this, this.myCommand, this.mySuppressOutputEvent, this.mySuppressRunningEvent, this.mySuppressTargetFinishedEvent, this.mySuppressRunningResult, this.myTearDownRequest, this.myForcePokeWorkaround, this.myThreadPlan, this.myCommandToken, this.myLogErrorAsWarning, this.myInterruptible);
            communication.initiate();
            Communication communication2 = communication;
            if (communication2 == null) {
                Request.$$$reportNull$$$0(1);
            }
            return communication2;
        }

        @NotNull
        public String getCommand() {
            String string = this.myCommand;
            if (string == null) {
                Request.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Request suppressAll() {
            return this.suppressOutputEvent().suppressRunningEvent().suppressRunningResult();
        }

        public Request suppressOutputEvent() {
            return this.suppressOutputEvent(true);
        }

        public Request suppressOutputEvent(boolean suppressOutputEvent) {
            this.mySuppressOutputEvent = suppressOutputEvent;
            return this;
        }

        public Request suppressRunningEvent() {
            return this.suppressRunningEvent(true);
        }

        public Request suppressRunningEvent(boolean suppressRunningEvent) {
            this.mySuppressRunningEvent = suppressRunningEvent;
            return this;
        }

        public Request suppressTargetFinishedEvent() {
            return this.suppressTargetFinishedEvent(true);
        }

        public Request suppressTargetFinishedEvent(boolean suppressTargetFinishedEvent) {
            this.mySuppressTargetFinishedEvent = suppressTargetFinishedEvent;
            return this;
        }

        public Request suppressRunningResult() {
            return this.suppressRunningResult(true);
        }

        public Request suppressRunningResult(boolean suppressRunningResult) {
            this.mySuppressRunningResult = suppressRunningResult;
            return this;
        }

        private Request tearDownRequest(boolean tearDownRequest) {
            this.myTearDownRequest = tearDownRequest;
            return this;
        }

        public Request withThreadPlan(@Nullable ThreadPlan threadPlan) {
            this.myThreadPlan = threadPlan != null ? threadPlan : ThreadPlan.DEFAULT;
            return this;
        }

        @ApiStatus.Experimental
        public Request forcePokeWorkaround(boolean forcePokeWorkaround) {
            this.myForcePokeWorkaround = forcePokeWorkaround;
            return this;
        }

        @ApiStatus.Experimental
        public Request withCommandToken(@Nullable Long commandToken) {
            this.myCommandToken = commandToken;
            return this;
        }

        public Request onSteppingFinished(@Nullable ThreadPlan.SteppingFinished threadPlan) {
            return this.withThreadPlan(threadPlan);
        }

        @NotNull
        private Request withNoWarningOnError() {
            this.myLogErrorAsWarning = false;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(3);
            }
            return request;
        }

        @NotNull
        private Request uninterruptible() {
            this.myInterruptible = false;
            Request request = this;
            if (request == null) {
                Request.$$$reportNull$$$0(4);
            }
            return request;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "send";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNoWarningOnError";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uninterruptible";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface LoadingCommand
    extends StartCommand<Void>,
    VoidCommand {
    }

    protected static interface LaunchCommand
    extends StartCommand<Integer> {
    }

    protected static interface DestroyCommand
    extends Command<Boolean> {
        @Override
        default public long getTimeout() {
            return 1500L;
        }
    }

    protected static class LLValueLoadedData {
        @NotNull
        public final String id;
        final boolean isCidrVar;
        @Nullable
        public final String fvKey;
        @Nullable
        public final Integer childrenCount;
        public final boolean isDynamic;
        public final boolean hasDynamicChildren;
        public final boolean isMap;
        public final boolean isRegister;
        @NotNull
        public final LLValueData data;

        public LLValueLoadedData(@NotNull String id, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, @NotNull String value, @Nullable String displayHint) {
            if (id == null) {
                LLValueLoadedData.$$$reportNull$$$0(0);
            }
            if (value == null) {
                LLValueLoadedData.$$$reportNull$$$0(1);
            }
            this(new GdbVarId(id, false), fvKey, childrenCount, isDynamic, hasDynamicChildren, value, displayHint, false, false, false);
        }

        LLValueLoadedData(@NotNull GdbVarId varId, @Nullable String fvKey, @Nullable Integer childrenCount, boolean isDynamic, boolean hasDynamicChildren, @NotNull String value, @Nullable String displayHint, boolean isRegister, boolean isDefaultPrinterFailed, boolean extractRichStrings) {
            if (varId == null) {
                LLValueLoadedData.$$$reportNull$$$0(2);
            }
            if (value == null) {
                LLValueLoadedData.$$$reportNull$$$0(3);
            }
            this.id = varId.id;
            this.isCidrVar = varId.isCidrVar;
            this.fvKey = fvKey;
            this.childrenCount = childrenCount;
            this.isDynamic = isDynamic;
            this.hasDynamicChildren = hasDynamicChildren;
            this.isMap = displayHint != null && "map".equals(displayHint.split("=", 2)[0]);
            this.isRegister = isRegister;
            String descriptionFromDisplayHint = LLValueLoadedData.extractDescriptionFromDisplayHint(displayHint);
            if (descriptionFromDisplayHint != null && value.equals("{...}")) {
                value = descriptionFromDisplayHint;
            }
            GdbExtractedDescription valueAndDescription = GdbValueDescription.extractDescription(value, extractRichStrings);
            value = valueAndDescription.getValue();
            String description = valueAndDescription.getDescription();
            boolean hasLongerDescription = description.length() >= 256;
            boolean mayHaveChildren = childrenCount != null && childrenCount > 0 || hasDynamicChildren || isDynamic;
            String uiWarning = isDefaultPrinterFailed ? GDBBundle.message("warning.pretty.printer.failed", new Object[0]) : null;
            this.data = new LLValueData(value, description, hasLongerDescription, mayHaveChildren, isDynamic, uiWarning, valueAndDescription.isRichDescription());
        }

        public boolean mayHaveChildren() {
            return this.data.mayHaveChildren();
        }

        @NotNull
        private GdbVarId getGdbVarId() {
            return new GdbVarId(this.id, this.isCidrVar);
        }

        @Nullable
        private static String extractDescriptionFromDisplayHint(@Nullable String displayHint) {
            int eqIndex;
            if (displayHint != null && (eqIndex = displayHint.indexOf(61)) != -1) {
                return displayHint.substring(eqIndex + 1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "varId";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$LLValueLoadedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SuspendedCommand<T>
    extends Command<T> {
    }

    private class FrameValueLoader
    implements LLValueLoader {
        @NotNull
        private final String myFvKey;
        private final long myThreadId;
        private final int myFrameIndex;
        private final boolean myUsePython;

        /*
         * WARNING - void declaration
         */
        FrameValueLoader(String fvKey, long threadId, int frameIndex, boolean bl) {
            void usePython;
            if (fvKey == null) {
                FrameValueLoader.$$$reportNull$$$0(0);
            }
            this.myFvKey = fvKey;
            this.myThreadId = threadId;
            this.myFrameIndex = frameIndex;
            this.myUsePython = usePython;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            String cidrId;
            String gdbMiName;
            GDBTuple varObj;
            if (value == null) {
                FrameValueLoader.$$$reportNull$$$0(1);
            }
            String name = value.getName();
            if (this.myUsePython) {
                RawViewSupport rawViewSupport = GDBDriver.this.getRawViewSupport();
                boolean isRaw = rawViewSupport.isRawViewEnabled(value);
                varObj = GDBDriver.this.doCreateVarPython(name, this.myThreadId, this.myFrameIndex, isRaw).getResultList();
                gdbMiName = name;
                cidrId = varObj.getRequiredString("cidr-id");
            } else {
                varObj = GDBDriver.this.doCreateVar(name, this.myThreadId, this.myFrameIndex).getResultList();
                gdbMiName = varObj.getRequiredString("name");
                cidrId = null;
            }
            GdbVarId varId = GDBDriver.getGdbVarId(gdbMiName, cidrId);
            String v = varObj.getString("value", "");
            LLValueLoadedData data = GDBDriver.doReadLoadedData(varObj, varId, this.myFvKey, v, GDBDriver.this.myExtractRichStrings);
            GDBDriver.doUpdateLoadedData(value, data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fvKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$FrameValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MapElement {
        @NotNull
        private final LLValue myKey;
        @NotNull
        private final LLValue myValue;

        MapElement(@NotNull LLValue key, @NotNull LLValue value) {
            if (key == null) {
                MapElement.$$$reportNull$$$0(0);
            }
            if (value == null) {
                MapElement.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myValue = value;
        }

        @NotNull
        public LLValue getKey() {
            LLValue lLValue = this.myKey;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(2);
            }
            return lLValue;
        }

        @NotNull
        public LLValue getValue() {
            LLValue lLValue = this.myValue;
            if (lLValue == null) {
                MapElement.$$$reportNull$$$0(3);
            }
            return lLValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$MapElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class StructChildrenVisitor {
        private StructChildrenVisitor() {
        }

        boolean visitRealChild(@NotNull GDBTuple child) {
            if (child == null) {
                StructChildrenVisitor.$$$reportNull$$$0(0);
            }
            return true;
        }

        boolean visitFakeChild(@NotNull LLValue fakeChild, int childrenCount) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            if (fakeChild == null) {
                StructChildrenVisitor.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeChild";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$StructChildrenVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRealChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFakeChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GdbVarId {
        private final String id;
        private final boolean isCidrVar;

        private GdbVarId(@NotNull String id, boolean isCidrVar) {
            if (id == null) {
                GdbVarId.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.isCidrVar = isCidrVar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GdbVarId", "<init>"));
        }
    }

    private class CreatedValueLoader
    implements LLValueLoader {
        @NotNull
        private final LLValueLoadedData partialLoadedData;

        CreatedValueLoader(LLValueLoadedData partialLoadedData) {
            if (partialLoadedData == null) {
                CreatedValueLoader.$$$reportNull$$$0(0);
            }
            this.partialLoadedData = partialLoadedData;
        }

        @Override
        public void loadValue(@NotNull LLValue value) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            String val;
            GDBTuple varObj;
            if (value == null) {
                CreatedValueLoader.$$$reportNull$$$0(1);
            }
            String id = this.partialLoadedData.id;
            if (this.partialLoadedData.isCidrVar) {
                varObj = GDBDriver.this.loadPythonVarDetails(id);
                val = varObj.getString("value", "");
            } else {
                varObj = GDBDriver.this.sendRequestAndWaitForDone("-var-evaluate-expression %s", DebuggerDriver.stringify(id)).getResultList();
                val = varObj.getRequiredString("value");
            }
            String displayHint = varObj.getString("displayhint", "");
            boolean defaultPrinterFailed = GDBDriver.isDefaultPrinterFailed(varObj);
            GDBDriver.doUpdateLoadedData(value, new LLValueLoadedData(this.partialLoadedData.getGdbVarId(), this.partialLoadedData.fvKey, this.partialLoadedData.childrenCount, this.partialLoadedData.isDynamic, this.partialLoadedData.hasDynamicChildren, val, displayHint, false, defaultPrinterFailed, GDBDriver.this.myExtractRichStrings));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "partialLoadedData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$CreatedValueLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface LLValueLoader {
        public void loadValue(@NotNull LLValue var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;
    }

    private static class ErrorResponse
    implements Response {
        @NotNull
        private final NotNullProducer<com.intellij.execution.ExecutionException> myErrorSupplier;

        ErrorResponse(@Nullable Throwable throwable) {
            this((NotNullProducer<com.intellij.execution.ExecutionException>)((NotNullProducer)() -> new com.intellij.execution.ExecutionException(throwable)));
        }

        ErrorResponse(@NlsContexts.DialogMessage @Nullable String message, @Nullable Throwable throwable) {
            this((NotNullProducer<com.intellij.execution.ExecutionException>)((NotNullProducer)() -> new com.intellij.execution.ExecutionException(message, throwable)));
        }

        ErrorResponse(@NotNull NotNullProducer<com.intellij.execution.ExecutionException> errorSupplier) {
            if (errorSupplier == null) {
                ErrorResponse.$$$reportNull$$$0(0);
            }
            this.myErrorSupplier = errorSupplier;
        }

        @NotNull
        public com.intellij.execution.ExecutionException getError() {
            com.intellij.execution.ExecutionException executionException = (com.intellij.execution.ExecutionException)((Object)this.myErrorSupplier.produce());
            if (executionException == null) {
                ErrorResponse.$$$reportNull$$$0(1);
            }
            return executionException;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() throws com.intellij.execution.ExecutionException {
            throw this.getError();
        }

        @Override
        @NotNull
        public String getOutput() throws com.intellij.execution.ExecutionException {
            throw this.getError();
        }

        @Override
        public void checkError() throws com.intellij.execution.ExecutionException {
            throw this.getError();
        }

        @Override
        public int getReceivedSignalCount() throws com.intellij.execution.ExecutionException {
            throw this.getError();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ErrorResponse";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface ThreadPlan {
        public static final ThreadPlan DEFAULT = new ThreadPlan(){};

        default public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace stopPlace) throws com.intellij.execution.ExecutionException {
            if (stopPlace == null) {
                ThreadPlan.$$$reportNull$$$0(0);
            }
            return true;
        }

        default public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) throws com.intellij.execution.ExecutionException {
            if (stopPlace == null) {
                ThreadPlan.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "stopPlace";
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadPlan";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onSteppingFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onBreakpointHit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        @FunctionalInterface
        public static interface BreakpointHit
        extends ThreadPlan {
            @Override
            public boolean onBreakpointHit(@NotNull DebuggerDriver.StopPlace var1, int var2) throws com.intellij.execution.ExecutionException;
        }

        @FunctionalInterface
        public static interface SteppingFinished
        extends ThreadPlan {
            @Override
            public boolean onSteppingFinished(@NotNull DebuggerDriver.StopPlace var1) throws com.intellij.execution.ExecutionException;
        }
    }

    public static abstract class EvaluationCommand<T>
    implements SuspendedCommand<T> {
        @NotNull
        private final String myExpression;

        public EvaluationCommand(@NotNull String expression) {
            if (expression == null) {
                EvaluationCommand.$$$reportNull$$$0(0);
            }
            this.myExpression = expression;
        }

        @NotNull
        public String getExpression() {
            String string = this.myExpression;
            if (string == null) {
                EvaluationCommand.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public long getTimeout() {
            return DebuggerDriverTimeouts.getEvaluationTimeoutMs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$EvaluationCommand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class GDBArchInfo {
        private final String myArchitecture;
        private final List<LLRegisterSet> myRegisterSets;
        private final List<String> myRegisterNames;

        private GDBArchInfo(@NotNull String architecture, @NotNull List<LLRegisterSet> registerSets, @NotNull List<String> registerNames) {
            if (architecture == null) {
                GDBArchInfo.$$$reportNull$$$0(0);
            }
            if (registerSets == null) {
                GDBArchInfo.$$$reportNull$$$0(1);
            }
            if (registerNames == null) {
                GDBArchInfo.$$$reportNull$$$0(2);
            }
            this.myArchitecture = architecture;
            this.myRegisterSets = registerSets;
            this.myRegisterNames = registerNames;
        }

        @NotNull
        private String getArchitecture() {
            String string = this.myArchitecture;
            if (string == null) {
                GDBArchInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private List<LLRegisterSet> getRegisterSets() {
            List<LLRegisterSet> list = Collections.unmodifiableList(this.myRegisterSets);
            if (list == null) {
                GDBArchInfo.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private List<String> getRegisterNames() {
            List<String> list = Collections.unmodifiableList(this.myRegisterNames);
            if (list == null) {
                GDBArchInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "architecture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registerSets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registerNames";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBArchInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$GDBArchInfo";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArchitecture";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegisterSets";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegisterNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class ConsoleCommand<T>
    extends EvaluationCommand<T> {
        ConsoleCommand(@NotNull String expression) {
            if (expression == null) {
                ConsoleCommand.$$$reportNull$$$0(0);
            }
            super(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ConsoleCommand", "<init>"));
        }
    }

    private static class ModuleRegion
    implements AddressSpace.Region {
        @NotNull
        private final AddressRange myRange;
        @NotNull
        private final LLModule myModule;

        private ModuleRegion(@NotNull AddressRange range, @NotNull LLModule module) {
            if (range == null) {
                ModuleRegion.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleRegion.$$$reportNull$$$0(1);
            }
            this.myRange = range;
            this.myModule = module;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            AddressRange addressRange = this.myRange;
            if (addressRange == null) {
                ModuleRegion.$$$reportNull$$$0(2);
            }
            return addressRange;
        }

        @NotNull
        public LLModule getModule() {
            LLModule lLModule = this.myModule;
            if (lLModule == null) {
                ModuleRegion.$$$reportNull$$$0(3);
            }
            return lLModule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleRegion region = (ModuleRegion)o;
            return this.myRange.equals(region.myRange) && this.myModule.equals(region.myModule);
        }

        public int hashCode() {
            return Objects.hash(this.myRange, this.myModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ModuleRegion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ModuleRegion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ResultResponse
    implements Response {
        @NotNull
        private final GDBResponse.Record myRecord;
        @NotNull
        private final String myOutput;
        private final int myReceivedSignalCount;

        ResultResponse(@NotNull GDBResponse.Record record, @NotNull String output, int receivedSignalCount) {
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ResultResponse.$$$reportNull$$$0(1);
            }
            this.myRecord = record;
            this.myOutput = output;
            this.myReceivedSignalCount = receivedSignalCount;
        }

        @Override
        @NotNull
        public GDBResponse.Record getRecord() {
            GDBResponse.Record record = this.myRecord;
            if (record == null) {
                ResultResponse.$$$reportNull$$$0(2);
            }
            return record;
        }

        @Override
        @NotNull
        public String getOutput() {
            String string = this.myOutput;
            if (string == null) {
                ResultResponse.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public int getReceivedSignalCount() {
            return this.myReceivedSignalCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ResultResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecord";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    protected abstract class AttachConnectCommand
    implements LaunchCommand {
        protected AttachConnectCommand() {
        }

        @Override
        @NotNull
        public Integer call() throws com.intellij.execution.ExecutionException, DebuggerCommandException {
            int pid;
            GDBDriver.this.myPendingForAttachNotification.down();
            try {
                pid = this.attach();
                GdbUtil.waitForSemaphore(GDBDriver.this.myPendingForAttachNotification);
            }
            finally {
                GDBDriver.this.myPendingForAttachNotification.up();
            }
            GDBDriver.this.doReadTargetInfo();
            this.whenAttached();
            if (GDBDriver.this.myStarter.isContinueAfterAttachNeeded()) {
                GDBDriver.this.sendRequestAndWaitForRunning("-exec-continue", new Object[0]);
            }
            Integer n = pid;
            if (n == null) {
                AttachConnectCommand.$$$reportNull$$$0(0);
            }
            return n;
        }

        protected abstract int attach() throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        protected abstract void whenAttached() throws com.intellij.execution.ExecutionException, DebuggerCommandException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$AttachConnectCommand", "call"));
        }
    }

    protected static interface StartCommand<T>
    extends Command<T> {
        @Override
        default public long getTimeout() {
            return DebuggerDriverTimeouts.getLoadTimeoutMs();
        }
    }
}

