/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import org.jetbrains.annotations.NotNull;

public final class CidrDebuggerLanguageInjector
implements LanguageInjector {
    private static final Key<Language> ourInjectedLanguageKey = Key.create((String)"CidrDebuggerLanguageInjector.injectedLanguage");

    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            CidrDebuggerLanguageInjector.$$$reportNull$$$0(0);
        }
        if (injectionPlacesRegistrar == null) {
            CidrDebuggerLanguageInjector.$$$reportNull$$$0(1);
        }
        if (host instanceof GDBExpressionPlaceholder) {
            Language language;
            Document document = host.getContainingFile().getOriginalFile().getViewProvider().getDocument();
            CidrDebugProcess process = (CidrDebugProcess)CidrDebugProcess.DEBUG_PROCESS_KEY.get((UserDataHolder)document);
            if (process != null) {
                language = CidrDebuggerLanguageSupportManager.getInstance().getLanguage(process.getCurrentPosition());
                host.putCopyableUserData(ourInjectedLanguageKey, (Object)language);
            } else {
                language = (Language)host.getCopyableUserData(ourInjectedLanguageKey);
            }
            if (language != null && LanguageParserDefinitions.INSTANCE.forLanguage(language) != null) {
                injectionPlacesRegistrar.addPlace(language, new TextRange(0, host.getTextLength()), null, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "injectionPlacesRegistrar";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/lang/CidrDebuggerLanguageInjector";
        objectArray[2] = "getLanguagesToInject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

