/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrSymbolicBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrSymbolicBreakpointType(String id) {
        this(id, CidrDebuggerBundle.message("debug.symbolic.breakpoints", new Object[0]));
    }

    protected CidrSymbolicBreakpointType(String id, @Nls String title) {
        super(id, title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        String result;
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return CidrDebuggerBundle.message("debug.symbolic.breakpoint.invalid", new Object[0]);
        }
        String string = result = StringUtil.isEmpty((String)properties.getSymbolPattern()) ? CidrDebuggerBundle.message("debug.symbolic.breakpoint.emptySymbolName.title", new Object[0]) : properties.getSymbolPattern();
        if (properties.getModuleName() != null) {
            result = CidrDebuggerBundle.message("debug.symbolic.breakpoint.moduleAndSymbol.title", properties.getModuleName(), result);
        }
        return result;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @Nullable
    public Properties createProperties() {
        return new Properties();
    }

    @NotNull
    public XBreakpoint<Properties> addBreakpoint(Project project, JComponent parentComponent) {
        XBreakpoint xBreakpoint = XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties());
        if (xBreakpoint == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(3);
        }
        return xBreakpoint;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomTopPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(4);
        }
        return this.createSymbolicBreakpointPropertiesPanel(project);
    }

    protected abstract CidrSymbolicBreakpointPropertiesPanel createSymbolicBreakpointPropertiesPanel(@NotNull Project var1);

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<Properties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CidrSymbolicBreakpointType.$$$reportNull$$$0(6);
        }
        return CidrDebuggerLanguageSupportManager.getInstance().createEditor(breakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomTopPropertiesPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Nullable
        private String mySymbolPattern;
        @Nullable
        private String myModuleName;

        public Properties() {
        }

        public Properties(@Nullable String symbolPattern, @Nullable String moduleName) {
            this.mySymbolPattern = symbolPattern;
            this.myModuleName = moduleName;
        }

        @Nullable
        @NlsSafe
        public String getSymbolPattern() {
            return this.mySymbolPattern;
        }

        public void setSymbolPattern(@Nullable String symbolPattern) {
            this.mySymbolPattern = symbolPattern;
        }

        public boolean updateSymbolPattern(@Nullable String symbolPattern) {
            if (Objects.equals(this.mySymbolPattern, symbolPattern)) {
                return false;
            }
            this.setSymbolPattern(symbolPattern);
            return true;
        }

        @Nullable
        @NlsSafe
        public String getModuleName() {
            return this.myModuleName;
        }

        public void setModuleName(@Nullable String moduleName) {
            this.myModuleName = moduleName;
        }

        public boolean updateModuleName(@Nullable String moduleName) {
            if (Objects.equals(this.myModuleName, moduleName)) {
                return false;
            }
            this.setModuleName(moduleName);
            return true;
        }

        @NotNull
        public Properties getState() {
            Properties properties = this;
            if (properties == null) {
                Properties.$$$reportNull$$$0(0);
            }
            return properties;
        }

        public void loadState(@NotNull Properties state) {
            if (state == null) {
                Properties.$$$reportNull$$$0(1);
            }
            this.mySymbolPattern = state.mySymbolPattern;
            this.myModuleName = state.myModuleName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType$Properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType$Properties";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

