/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpParserTypes;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J:\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0 2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\"\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/lang/HexdumpFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "<init>", "()V", "DEBUG", "", "ELEMENTS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "COMMENTS", "SEPARATORS", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "traverse", "collapseConsequentNodes", "elements", "", "separators", "addFoldingDescriptor", "last", "intellij.cidr.debugger.core"})
public final class HexdumpFoldingBuilder
extends CustomFoldingBuilder {
    private final boolean DEBUG;
    @NotNull
    private final Set<IElementType> ELEMENTS;
    @NotNull
    private final Set<IElementType> COMMENTS;
    @NotNull
    private final Set<IElementType> SEPARATORS;

    public HexdumpFoldingBuilder() {
        Object[] objectArray = new IElementType[]{HexdumpParserTypes.FOLDING_PLACEHOLDER, HexdumpParserTypes.PARA};
        this.ELEMENTS = SetsKt.setOf((Object[])objectArray);
        objectArray = new IElementType[]{HexdumpParserTypes.BLOCK_COMMENT, HexdumpParserTypes.LINE_COMMENT};
        this.COMMENTS = SetsKt.setOf((Object[])objectArray);
        this.SEPARATORS = SetsKt.setOf((Object)TokenType.WHITE_SPACE);
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ASTNode aSTNode = root.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        this.traverse(aSTNode, descriptors);
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return StringsKt.repeat((CharSequence)"\u2500", (int)38);
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return true;
    }

    private final ASTNode traverse(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (!this.DEBUG) {
            return node;
        }
        if (this.ELEMENTS.contains(node.getElementType())) {
            return this.collapseConsequentNodes(node, (Collection<? extends IElementType>)this.COMMENTS, (Collection<? extends IElementType>)this.SEPARATORS, descriptors);
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            child = this.traverse(child, descriptors).getTreeNext();
        }
        return node;
    }

    private final ASTNode collapseConsequentNodes(ASTNode node, Collection<? extends IElementType> elements, Collection<? extends IElementType> separators, List<FoldingDescriptor> descriptors) {
        ASTNode last = node;
        for (ASTNode lastCandidate = last.getTreeNext(); lastCandidate != null; lastCandidate = lastCandidate.getTreeNext()) {
            IElementType lastCandidateType;
            Intrinsics.checkNotNullExpressionValue((Object)lastCandidate.getElementType(), (String)"getElementType(...)");
            if (separators.contains(lastCandidateType)) continue;
            if (!elements.contains(lastCandidateType)) break;
            last = lastCandidate;
        }
        this.addFoldingDescriptor(node, last, descriptors);
        return last;
    }

    private final void addFoldingDescriptor(ASTNode node, ASTNode last, List<FoldingDescriptor> descriptors) {
        int startOffset2 = node.getStartOffset();
        int endOffset2 = last.getStartOffset() + last.getTextLength();
        descriptors.add(new FoldingDescriptor(node, TextRange.create((int)startOffset2, (int)endOffset2), null, SetsKt.emptySet(), true));
    }
}

