/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.ipcUtils;

import com.google.protobuf.Message;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimedOutException;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.SequencedCollection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ProtobufServer<T extends Message> {
    private static final Logger LOG = CidrDebuggerLog.LOG;
    private static final AtomicInteger ourCount = new AtomicInteger(0);
    private final int myPort;
    private long myDefaultTimeout;
    @NotNull
    private final QueueProcessor<Message> myInboxProcessor;
    @NotNull
    private final QueueProcessor<Pair<Message, Consumer<? super Message>>> myOutboxProcessor;
    private final Deque<Pair<Consumer, Class>> myResponseHandlers;
    private final Object mySocketLock;
    private final List<Semaphore> myToRelease;
    private final int myUid;
    private final long myInitializationTime;
    private SocketChannel mySocketChannel;
    private ServerSocketChannel myServerSocket;
    private volatile boolean myCancelAcceptAttempts;
    private Future<?> myReaderThreadFuture;
    private ProtobufParser<T> myResponseParser;

    public int getPort() {
        return this.myPort;
    }

    private void readerThread(SocketChannel stream) throws IOException {
        try {
            ByteBuffer buffer = ProtobufServer.alloc(66560);
            while (true) {
                int read;
                try {
                    read = stream.read(buffer);
                }
                catch (IOException ignore) {
                    break;
                }
                if (read != -1) {
                    if (buffer.position() == 0) continue;
                    int begin = 0;
                    int end = buffer.position();
                    buffer.rewind();
                    int size = 0;
                    while (buffer.position() < end && end - buffer.position() >= 4) {
                        T compositeResponse;
                        size = buffer.getInt();
                        if (end - buffer.position() < size) break;
                        byte[] array = new byte[size];
                        buffer.get(array);
                        T finalCompositeResponse = compositeResponse = this.myResponseParser.parse(array);
                        this.debugLog(() -> "res(len=" + (array.length + 4) + "): ", (Message)finalCompositeResponse);
                        Message message = ProtobufUtils.unpackComposite(compositeResponse, this.myResponseParser::decompose);
                        this.myInboxProcessor.add((Object)message);
                        begin = buffer.position();
                    }
                    int remaining = end - begin;
                    buffer.position(begin);
                    byte[] remainingBytes = new byte[remaining];
                    buffer.get(remainingBytes);
                    if (size + 4 > buffer.capacity()) {
                        buffer = ProtobufServer.alloc(size + 4);
                    }
                    buffer.rewind();
                    buffer.put(remainingBytes);
                    continue;
                }
                break;
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static ByteBuffer alloc(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.myDefaultTimeout = defaultTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSendMessage(@NotNull Message generatedMessage) {
        if (generatedMessage == null) {
            ProtobufServer.$$$reportNull$$$0(0);
        }
        Object object = this.mySocketLock;
        synchronized (object) {
            if (this.mySocketChannel == null) {
                return false;
            }
            byte[] bytes = generatedMessage.toByteArray();
            ByteBuffer buf = ProtobufServer.alloc(bytes.length + 4);
            buf.putInt(bytes.length);
            buf.put(bytes);
            buf.rewind();
            this.debugLog(() -> "req(len=" + (bytes.length + 4) + "): ", generatedMessage);
            try {
                this.mySocketChannel.write(buf);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
    }

    private void debugLog(Supplier<String> prefix, Message message) {
        if (LOG.isDebugEnabled()) {
            long time = System.currentTimeMillis() - this.myInitializationTime;
            String messageString = ProtobufUtils.maskMessage(message);
            LOG.debug(("[protobuf client " + this.myUid + "] time=" + time + " " + prefix.get() + messageString).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startReaderThread() throws IOException {
        Object object = this.mySocketLock;
        synchronized (object) {
            this.myServerSocket = ServerSocketChannel.open();
            this.myServerSocket.configureBlocking(false);
            InetAddress inetAddress = InetAddress.getByName("0.0.0.0");
            this.myServerSocket.socket().bind(new InetSocketAddress(inetAddress, 0));
            int port = this.myServerSocket.socket().getLocalPort();
            this.myReaderThreadFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    SocketChannel socket;
                    Object object = this.mySocketLock;
                    synchronized (object) {
                        while (this.mySocketChannel == null) {
                            if (this.myCancelAcceptAttempts) {
                                return;
                            }
                            this.mySocketChannel = this.myServerSocket.accept();
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException e) {
                                return;
                            }
                        }
                        socket = this.mySocketChannel;
                    }
                    this.readerThread(socket);
                }
                catch (IOException e) {
                    this.handleIOException(e);
                }
            });
            return port;
        }
    }

    protected void handleIOException(IOException e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        this.releaseAll();
        this.myCancelAcceptAttempts = true;
        Object object = this.mySocketLock;
        synchronized (object) {
            try {
                if (this.mySocketChannel != null) {
                    this.mySocketChannel.close();
                }
                if (this.myServerSocket != null) {
                    this.myServerSocket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.mySocketChannel = null;
                this.myServerSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        this.myInboxProcessor.clear();
        this.myOutboxProcessor.clear();
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            for (Semaphore semaphore : this.myToRelease) {
                semaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void waitFor() {
        Object object = this.mySocketLock;
        synchronized (object) {
            if (this.myReaderThreadFuture != null && this.mySocketChannel == null) {
                try {
                    this.myReaderThreadFuture.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.myOutboxProcessor.waitFor();
        this.myInboxProcessor.waitFor();
    }

    public ProtobufServer(@NotNull Consumer<Message> inboxConsumer, ProtobufParser<T> responseParser) throws IOException {
        if (inboxConsumer == null) {
            ProtobufServer.$$$reportNull$$$0(1);
        }
        this.myDefaultTimeout = 30000L;
        this.myResponseHandlers = new ArrayDeque<Pair<Consumer, Class>>(100);
        this.mySocketLock = new Object();
        this.myToRelease = new ArrayList<Semaphore>();
        this.myUid = ourCount.incrementAndGet();
        this.myInitializationTime = System.currentTimeMillis();
        this.myResponseParser = responseParser;
        this.myInboxProcessor = new QueueProcessor(generatedMessage -> {
            Deque<Pair<Consumer, Class>> deque = this.myResponseHandlers;
            synchronized (deque) {
                Pair<Consumer, Class> responseHandler;
                Pair<Consumer, Class> pair = responseHandler = this.myResponseHandlers.isEmpty() ? null : this.myResponseHandlers.peekFirst();
                if (responseHandler != null && responseHandler.second == generatedMessage.getClass()) {
                    ((Consumer)responseHandler.first).consume(generatedMessage);
                    this.myResponseHandlers.removeFirst();
                    return;
                }
            }
            inboxConsumer.consume(generatedMessage);
        }, Conditions.alwaysFalse());
        this.myOutboxProcessor = new QueueProcessor(pair -> {
            boolean result = this.doSendMessage((Message)pair.first);
            if (pair.second != null) {
                ((Consumer)pair.second).consume(result ? pair.first : null);
            }
        }, Conditions.alwaysFalse());
        this.myPort = this.startReaderThread();
    }

    public <T extends Message> void sendMessageAndWaitUntilSent(Message request, @Nullable Class<T> responseClass, @Nullable Consumer<? super T> responseHandler) throws ProtobufTimedOutException {
        this.sendMessageAndWaitUntilSent(request, responseClass, responseHandler, this.myDefaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Message> void sendMessageAndWaitUntilSent(Message request, @Nullable Class<T> responseClass, @Nullable Consumer<? super T> responseHandler, long msTimeout) throws ProtobufTimedOutException {
        Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        this.sendMessage(request, responseClass, responseHandler, (Consumer<Message>)((Consumer)generatedMessage -> semaphore.release()));
        try {
            if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                throw new ProtobufTimedOutException();
            }
        }
        catch (InterruptedException interruptedException) {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        finally {
            list = this.myToRelease;
            synchronized (list) {
                this.myToRelease.remove(semaphore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends Message> void sendMessage(@NotNull Message message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<? super ResponseType> responseHandler, @Nullable Consumer<? super Message> sendHandler) {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(2);
        }
        if (responseClass != null && responseHandler != null) {
            Deque<Pair<Consumer, Class>> deque = this.myResponseHandlers;
            synchronized (deque) {
                this.myResponseHandlers.addLast((Pair<Consumer, Class>)new Pair(responseHandler, responseClass));
            }
        }
        this.myOutboxProcessor.add((Object)Pair.create((Object)message, sendHandler));
    }

    public <ResponseType extends Message> void sendMessage(@NotNull Message message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<? super ResponseType> responseHandler) {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(3);
        }
        this.sendMessage(message, responseClass, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends Message> void sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<ResponseType> responseClass, @NotNull Consumer<? super ResponseType> responseHandler, long msTimeout) throws ProtobufTimedOutException, ExecutionFinishedException {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(4);
        }
        if (responseClass == null) {
            ProtobufServer.$$$reportNull$$$0(5);
        }
        if (responseHandler == null) {
            ProtobufServer.$$$reportNull$$$0(6);
        }
        Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        boolean[] abandoned = new boolean[]{false};
        boolean[] failedToSend = new boolean[]{false};
        boolean[] done = new boolean[]{false};
        SequencedCollection<Object> sequencedCollection = this.myResponseHandlers;
        synchronized (sequencedCollection) {
            this.myResponseHandlers.addLast((Pair<Consumer, Class>)Pair.create(t -> {
                if (!abandoned[0]) {
                    responseHandler.consume((Object)((Message)t));
                    done[0] = true;
                }
                semaphore.release();
            }, responseClass));
        }
        this.myOutboxProcessor.add((Object)new Pair((Object)message, generatedMessage -> {
            if (generatedMessage == null) {
                failedToSend[0] = true;
                semaphore.release();
            }
        }));
        try {
            if (msTimeout > 0L) {
                if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                    abandoned[0] = true;
                    throw new ProtobufTimedOutException();
                }
            } else {
                semaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            abandoned[0] = true;
        }
        finally {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        if (failedToSend[0] || abandoned[0] || !done[0]) {
            throw new ExecutionFinishedException();
        }
    }

    public <T extends Message> void sendMessageAndWaitForReply(@NotNull Message message, @NotNull Class<T> responseClass, @NotNull Consumer<? super T> responseHandler) throws ProtobufTimedOutException, ExecutionFinishedException {
        if (message == null) {
            ProtobufServer.$$$reportNull$$$0(7);
        }
        if (responseClass == null) {
            ProtobufServer.$$$reportNull$$$0(8);
        }
        if (responseHandler == null) {
            ProtobufServer.$$$reportNull$$$0(9);
        }
        this.sendMessageAndWaitForReply(message, responseClass, responseHandler, 0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMessage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inboxConsumer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseClass";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseHandler";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/ipcUtils/ProtobufServer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doSendMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "sendMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "sendMessageAndWaitForReply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ProtobufParser<T extends Message> {
        public T parse(byte[] var1) throws IOException;

        public boolean decompose(Message var1);
    }
}

