/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.sdklib.devices.Abi;
import com.google.common.primitives.Bytes;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.cdt.utils.elf.Elf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbiFinder {
    private static final int EM_AARCH64 = 183;
    private static final int EM_ARM = 40;
    private static final int EM_386 = 3;
    private static final int EM_MIPS = 8;
    private static final int EM_X86_64 = 62;
    private static final int SHT_ARM_ATTRIBUTES = 0x70000003;
    private static final int PT_ARM_ARCHEXT_ARCH_UNKNOWN = 0;
    private static final int PT_ARM_ARCHEXT_ARCHv7 = 10;
    private static final int PT_ARM_ARCHEXT_ARCHv7EM = 13;
    private static final int Tag_CPU_rawname = 4;
    private static final int Tag_CPU_name = 5;
    private static final int Tag_CPU_arch = 6;
    private static final int Tag_File = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Abi findAbi(@NotNull File sharedObjectFilePath) throws IOException {
        if (!sharedObjectFilePath.isFile()) {
            throw new FileNotFoundException(String.format("Could not find file '%1$s'", sharedObjectFilePath.getPath()));
        }
        if (!"so".equals(FileUtilRt.getExtension((String)sharedObjectFilePath.getName()))) {
            throw new IllegalArgumentException(String.format("'%1$s' is not a .so (shared object) library", sharedObjectFilePath.getPath()));
        }
        Elf elf = new Elf(sharedObjectFilePath.getPath());
        try {
            Elf.ELFhdr fhdr = elf.getELFhdr();
            int machine = fhdr.e_machine;
            switch (machine) {
                case 183: {
                    Abi abi = Abi.ARM64_V8A;
                    return abi;
                }
                case 40: {
                    ByteOrder elfByteOrder = fhdr.e_ident[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                    for (Abi section : elf.getSections()) {
                        ArmAttributes armAttributes = AbiFinder.tryParseArmAttributes(elfByteOrder, (Elf.Section)section);
                        if (armAttributes == null) continue;
                        if (armAttributes.cpuArch != 10 && armAttributes.cpuArch != 13) break;
                        Abi abi = Abi.ARMEABI_V7A;
                        return abi;
                    }
                    Abi abi = Abi.ARMEABI;
                    return abi;
                }
                case 8: {
                    Abi abi = fhdr.e_entry instanceof Addr64 ? Abi.MIPS64 : Abi.MIPS;
                    return abi;
                }
                case 3: {
                    Abi abi = Abi.X86;
                    return abi;
                }
                case 62: {
                    Abi abi = Abi.X86_64;
                    return abi;
                }
            }
            return null;
        }
        finally {
            elf.dispose();
        }
    }

    @Nullable
    private static ArmAttributes tryParseArmAttributes(@NotNull ByteOrder order, @Nullable Elf.Section section) throws IOException {
        ArmAttributes result;
        if (section == null || section.sh_type != 0x70000003L) {
            return null;
        }
        try {
            ByteBuffer buffer = section.mapSectionData();
            buffer.order(order);
            byte formatVersion = buffer.get();
            if (formatVersion != 65) {
                return null;
            }
            while ((result = AbiFinder.parseVendorSubsection(buffer)) == null && buffer.position() < buffer.limit()) {
            }
        }
        catch (BufferOverflowException e) {
            return null;
        }
        return result;
    }

    @Nullable
    private static ArmAttributes parseVendorSubsection(@NotNull ByteBuffer buffer) throws IOException {
        ArmAttributes result = null;
        int startPosition = buffer.position();
        int vendorSubsectionSize = buffer.getInt();
        int endPosition = startPosition + vendorSubsectionSize;
        int minVendorSubsectionSize = 4;
        if (vendorSubsectionSize < 4) {
            throw new IOException("vendorSubsectionLength is too small. Corrupt ARM build attributes ELF section?");
        }
        String vendorName = AbiFinder.readString(buffer);
        if (vendorName.equals("aeabi")) {
            result = new ArmAttributes();
            int minTagsSize = 5;
            do {
                int tagsStartPosition = buffer.position();
                byte tagsScope = buffer.get();
                int tagsSize = buffer.getInt();
                if (tagsSize < 5) {
                    throw new IOException("tagsSize is too small. Corrupt ARM build attributes ELF section?");
                }
                int tagsEndPosition = tagsStartPosition + tagsSize;
                if (tagsScope == 1) {
                    do {
                        int tag = AbiFinder.readULeb128(buffer);
                        switch (tag) {
                            case 6: {
                                result.cpuArch = AbiFinder.readULeb128(buffer);
                                break;
                            }
                            case 5: {
                                result.cpuName = AbiFinder.readString(buffer);
                                break;
                            }
                            default: {
                                AbiFinder.skipAttribute(tag, buffer);
                            }
                        }
                    } while (buffer.position() < tagsEndPosition);
                }
                buffer.position(tagsEndPosition);
            } while (buffer.position() <= endPosition - 5);
        }
        buffer.position(endPosition);
        return result;
    }

    private static void skipAttribute(int tag, @NotNull ByteBuffer buffer) {
        boolean unknownStringTag;
        boolean bl = unknownStringTag = tag > 32 && tag % 2 == 1;
        if (tag == 4 || tag == 5 || unknownStringTag) {
            AbiFinder.readString(buffer);
        } else {
            AbiFinder.readULeb128(buffer);
        }
    }

    @NotNull
    private static String readString(@NotNull ByteBuffer buffer) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        byte lastByte = buffer.get();
        while (buffer.position() < buffer.limit() && lastByte != 0) {
            bytes.add(lastByte);
            lastByte = buffer.get();
        }
        return new String(Bytes.toArray(bytes), StandardCharsets.ISO_8859_1);
    }

    private static int readULeb128(@NotNull ByteBuffer buffer) {
        byte lastByte;
        int result = 0;
        int count = 0;
        do {
            lastByte = buffer.get();
            result |= (lastByte & 0x7F) << count * 7;
        } while ((lastByte & 0x80) != 0 && ++count < 5);
        if ((lastByte & 0x80) == 128) {
            throw new BufferOverflowException();
        }
        return result;
    }

    private static class ArmAttributes {
        public String cpuName = "";
        public int cpuArch = 0;

        private ArmAttributes() {
        }
    }
}

