/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.io.CancellableFileIo;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class AndroidSysroot {
    private static final String[] ourRequiredFiles = new String[]{"android/log.h"};
    private static final String[] ourForbiddenFiles = new String[]{"objc/Object.h", "NSSystemDirectories.h", "MacTypes.h", "winsock.h", "winnt.h"};

    public static boolean isValidAndroidSysroot(@NotNull Path sysrootDirectory) {
        Path includeRoot = sysrootDirectory.resolve("usr/include");
        return AndroidSysroot.containsAllFiles(ourRequiredFiles, includeRoot) && !AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeRoot);
    }

    public static boolean isValidAndroidSysrootUsrInclude(@NotNull Path includeDirectory) {
        return AndroidSysroot.containsAllFiles(ourRequiredFiles, includeDirectory) && !AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeDirectory);
    }

    public static boolean isPotentialNonAndroidSysrootUsrInclude(@NotNull Path includeDirectory) {
        return AndroidSysroot.containsAtLeastOneFile(ourForbiddenFiles, includeDirectory);
    }

    private static boolean containsAllFiles(String[] requiredFiles, @NotNull Path includeDirectory) {
        for (String filename : requiredFiles) {
            Path file = includeDirectory.resolve(filename);
            if (CancellableFileIo.exists((Path)file, (LinkOption[])new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    private static boolean containsAtLeastOneFile(String[] forbiddenFiles, @NotNull Path includeDirectory) {
        for (String filename : forbiddenFiles) {
            Path file = includeDirectory.resolve(filename);
            if (!CancellableFileIo.exists((Path)file, (LinkOption[])new LinkOption[0])) continue;
            return true;
        }
        return false;
    }
}

