/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.inspections.JavaJniMissingFunctionInspection;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/ndk/jni/inspections/JavaJniMissingFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "android-ndk"})
public final class JavaJniMissingFunctionInspection
extends JniInspectionTool {
    public JavaJniMissingFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.MISSING_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project) || !NdkHelper.isNdkProject(holder.getProject())) {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly, session);
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        } else {
            psiElementVisitor = (PsiElementVisitor)new JavaElementVisitor(this, holder){
                final /* synthetic */ JavaJniMissingFunctionInspection this$0;
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.this$0 = $receiver;
                    this.$holder = $holder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void visitMethod(PsiMethod method) {
                    void inspectionType$iv$iv;
                    void $this$reportJniPerf$iv$iv;
                    void this_$iv;
                    void psiElement$iv;
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    if (!JniUtilsKt.isNative((JvmMethod)method) || OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)method.getProject()).isEmpty()) {
                        return;
                    }
                    JniInspectionTool jniInspectionTool = this.this$0;
                    PsiElement psiElement = (PsiElement)method;
                    ProblemsHolder problemsHolder = this.$holder;
                    JavaJniMissingFunctionInspection javaJniMissingFunctionInspection = this.this$0;
                    boolean $i$f$reportPerf$android_ndk = false;
                    Project project = psiElement$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Project project2 = project;
                    JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                    int n = 100;
                    boolean $i$f$reportJniPerf = false;
                    JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                    Instant startTime$iv$iv = Instant.now();
                    try {
                        JvmMethodInfo jvmMethodInfo;
                        JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (JvmMethodInfo.Companion.fromJavaMethod(method) == null) {
                            return;
                        }
                        JvmMethodInfo jvmMethodInfo2 = jvmMethodInfo;
                        Project project3 = method.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                        if (JniMethodResolver.Companion.getInstance(project3).resolveJavaOrKotlinMethod(jvmMethodInfo2).stream().anyMatch(arg_0 -> buildVisitor.1.visitMethod$lambda$2$lambda$1(buildVisitor.1::visitMethod$lambda$2$lambda$0, arg_0))) {
                            return;
                        }
                        KotlinJniMissingFunctionInspection.Companion.registerMissingJniDefinitionProblem(problemsHolder, javaJniMissingFunctionInspection, jvmMethodInfo2);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        void inverseSampleRate$iv$iv;
                        if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                            Instant bl = Instant.now();
                            JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl).toMillis())));
                        }
                    }
                }

                private static final boolean visitMethod$lambda$2$lambda$0(NativeMethodInfo it) {
                    return it.isDefinition();
                }

                private static final boolean visitMethod$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
                    return (Boolean)$tmp0.invoke(p0);
                }
            };
        }
        return psiElementVisitor;
    }
}

