/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.reference.JvmClassReferenceProvider;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/reference/JniReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "<init>", "()V", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "android-ndk"})
public final class JniReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(OCLiteralExpression.class).with((PatternCondition)new PatternCondition<OCLiteralExpression>(){

            public boolean accepts(OCLiteralExpression element, ProcessingContext context) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement stringParent = element.getParent();
                if (stringParent instanceof OCArgumentList) {
                    JniCall jniCall;
                    PsiElement psiElement = ((OCArgumentList)stringParent).getParent();
                    OCCallExpression oCCallExpression = psiElement instanceof OCCallExpression ? (OCCallExpression)psiElement : null;
                    JniCall jniCall2 = jniCall = oCCallExpression != null ? JniCallKt.toJniCall(oCCallExpression) : null;
                    bl = jniCall instanceof FindClassCall ? Intrinsics.areEqual((Object)((FindClassCall)jniCall).getClassNameExpression(), (Object)element) : (jniCall instanceof GetMethodIdCall ? Intrinsics.areEqual((Object)((GetMethodIdCall)jniCall).getMethodNameExpression(), (Object)element) : (jniCall instanceof GetFieldIdCall ? Intrinsics.areEqual((Object)((GetFieldIdCall)jniCall).getFieldNameExpression(), (Object)element) : false));
                } else {
                    bl = stringParent instanceof OCCompoundInitializer ? JniUtilsKt.isMethodNameInJniNativeMethodInitializer(element, false) : false;
                }
                return bl;
            }
        }), (PsiReferenceProvider)new JvmClassReferenceProvider());
    }
}

