/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.intellij.xdebugger.XSourcePosition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

public class MethodCollector {
    private static final Logger LOG = Logger.getInstance(MethodCollector.class);
    private final List<JvmMethodInfo> myMethods = Lists.newLinkedList();
    private final List<PsiElement> myHighlightElements = Lists.newLinkedList();
    private Range<Integer> myLineRange;

    public MethodCollector(@NotNull Project project, @NotNull XSourcePosition pos) {
        this.doCollect(project, pos);
    }

    private void doCollect(@NotNull Project project, @NotNull XSourcePosition pos) {
        PsiElement parent;
        Document doc = FileDocumentManager.getInstance().getDocument(pos.getFile());
        if (doc == null) {
            LOG.warn("No document found when trying to collect methods in file " + String.valueOf(pos.getFile()));
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(doc);
        PsiElement element = DebuggerUtilsEx.findElementAt((PsiFile)psiFile, (int)pos.getOffset());
        if (element == null) {
            LOG.warn("No element found when trying to collect methods at offset " + pos.getOffset() + " in file " + String.valueOf(pos.getFile()));
            return;
        }
        while ((parent = element.getParent()) != null && parent.getTextOffset() >= pos.getOffset()) {
            element = parent;
        }
        int line = pos.getLine();
        if (line < 0) {
            LOG.warn("Invalid line number " + line + " in file " + String.valueOf(pos.getFile()));
            return;
        }
        int startOffset = doc.getLineStartOffset(line);
        final TextRange exprRange = new TextRange(startOffset, doc.getLineEndOffset(line));
        final Ref refExprRange = new Ref((Object)exprRange);
        Object elementVisitor = psiFile.getLanguage().isKindOf((Language)KotlinLanguage.INSTANCE) ? new KtTreeVisitorVoid(){

            public void visitExpression(@NotNull KtExpression expression) {
                TextRange range = expression.getTextRange();
                if (exprRange.intersects(range)) {
                    refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                }
                super.visitExpression(expression);
            }

            public void visitCallExpression(@NotNull KtCallExpression expression) {
                super.visitCallExpression(expression);
                if (!(expression.getCalleeExpression() instanceof KtNameReferenceExpression)) {
                    return;
                }
                KtNameReferenceExpression referenceExpression = (KtNameReferenceExpression)expression.getCalleeExpression();
                if (referenceExpression == null) {
                    return;
                }
                List<JvmMethodInfo> resolved = MethodCollector.this.resolveCalledFunction((PsiElement)referenceExpression);
                if (resolved.isEmpty()) {
                    return;
                }
                TextRange range = expression.getTextRange();
                refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                MethodCollector.this.myMethods.add(resolved.get(0));
                MethodCollector.this.myHighlightElements.add((PsiElement)referenceExpression);
            }

            public void visitConstructorCalleeExpression(@NotNull KtConstructorCalleeExpression expression) {
                super.visitConstructorCalleeExpression(expression);
                KtSimpleNameExpression referenceExpression = expression.getConstructorReferenceExpression();
                if (referenceExpression == null) {
                    return;
                }
                List<JvmMethodInfo> resolved = MethodCollector.this.resolveCalledFunction((PsiElement)referenceExpression);
                if (resolved.isEmpty()) {
                    return;
                }
                TextRange range = expression.getTextRange();
                refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                MethodCollector.this.myMethods.add(resolved.get(0));
                MethodCollector.this.myHighlightElements.add((PsiElement)referenceExpression);
            }
        } : new JavaRecursiveElementVisitor(){

            public void visitStatement(PsiStatement statement) {
                if (exprRange.intersects(statement.getTextRange())) {
                    super.visitStatement(statement);
                }
            }

            public void visitExpression(PsiExpression expression) {
                TextRange range = expression.getTextRange();
                if (exprRange.intersects(range)) {
                    refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                }
                super.visitExpression(expression);
            }

            public void visitCallExpression(PsiCallExpression expression) {
                super.visitCallExpression(expression);
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod == null) {
                    return;
                }
                TextRange range = expression.getTextRange();
                refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                MethodCollector.this.myMethods.add(JvmMethodInfo.fromJavaMethod(psiMethod));
                if (expression instanceof PsiMethodCallExpression) {
                    MethodCollector.this.myHighlightElements.add(((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement());
                } else if (expression instanceof PsiNewExpression) {
                    MethodCollector.this.myHighlightElements.add((PsiElement)((PsiNewExpression)expression).getClassOrAnonymousClassReference());
                } else {
                    MethodCollector.this.myHighlightElements.add((PsiElement)expression);
                }
            }
        };
        element.accept((PsiElementVisitor)elementVisitor);
        for (PsiElement sibling = element.getNextSibling(); sibling != null && exprRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
            sibling.accept((PsiElementVisitor)elementVisitor);
        }
        this.myLineRange = new Range((Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)refExprRange.get()).getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(((TextRange)refExprRange.get()).getEndOffset())));
    }

    @NotNull
    public List<JvmMethodInfo> getMethods() {
        return this.myMethods;
    }

    public List<PsiElement> getHighlightElements() {
        return this.myHighlightElements;
    }

    @Nullable
    public Range<Integer> getLineRange() {
        return this.myLineRange;
    }

    @NotNull
    private List<JvmMethodInfo> resolveCalledFunction(@NotNull PsiElement referenceExpression) {
        return Arrays.stream(referenceExpression.getReferences()).map(ref -> (JvmMethodInfo)MethodInfo.fromPsiElement(ref.resolve())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

