/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.debug.impl.java.StartJavaDebuggerSessionKt;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class JdwpConnector {
    private final ConsoleView myCustomConsole;
    private final Project myProject;
    private static final long ATTACH_TIMEOUT_MS = 30000L;
    private final Client myClient;
    private final boolean myLaunchMode;
    private boolean mySessionCreated = false;
    private final List<SessionListener> mySessionListeners = Lists.newLinkedList();
    private DebuggerSession myDebuggerSession = null;
    private static final Logger LOG = Logger.getInstance(JdwpConnector.class);

    public JdwpConnector(@NotNull Project project, @NotNull Client client, @Nullable ConsoleView customConsole, boolean launchMode) {
        this.myProject = project;
        this.myClient = client;
        this.myLaunchMode = launchMode;
        this.myCustomConsole = customConsole;
    }

    private AsyncPromise<DebuggerSession> internalConnect() throws com.intellij.execution.ExecutionException {
        LOG.debug("internalConnect called");
        final MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(DebuggerManagerListener.TOPIC, (Object)new DebuggerManagerListener(){

            public void sessionCreated(DebuggerSession session) {
                if (JdwpConnector.this.myProject.equals((Object)session.getProject()) && JdwpConnector.this.myClient.getDebuggerListenPort() == Integer.parseInt(session.getProcess().getConnection().getDebuggerAddress())) {
                    LOG.debug("session is created");
                    busConnection.disconnect();
                    JdwpConnector.this.runSessionCreatedListeners(session);
                    ProcessHandler debugProcessHandler = session.getProcess().getProcessHandler();
                    if (!debugProcessHandler.isStartNotified()) {
                        debugProcessHandler.startNotify();
                    }
                }
            }
        });
        return StartJavaDebuggerSessionKt.startAndroidJavaDebuggerSession((Project)this.myProject, (Client)this.myClient, (ConsoleView)this.myCustomConsole, (!this.myLaunchMode ? 1 : 0) != 0);
    }

    public DebuggerSession Connect() throws com.intellij.execution.ExecutionException {
        LOG.debug("Connecting");
        FutureResult connectResult = new FutureResult();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                this.internalConnect().onSuccess(arg_0 -> ((FutureResult)connectResult).set(arg_0));
            }
            catch (com.intellij.execution.ExecutionException e) {
                connectResult.setException((Throwable)e);
            }
        }, ModalityState.any());
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.myDebuggerSession = (DebuggerSession)connectResult.get(30000L, TimeUnit.MILLISECONDS);
            JdwpConnector.waitForAttach((DebugProcess)this.myDebuggerSession.getProcess(), stopwatch);
        }
        catch (TimeoutException e) {
            LOG.info("Timed out waiting for java debugger attach", (Throwable)e);
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for java debugger attach", (Throwable)e);
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.info("ExecutionException waiting for internalConnect result", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof com.intellij.execution.ExecutionException) {
                throw (com.intellij.execution.ExecutionException)cause;
            }
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        return this.myDebuggerSession;
    }

    private static void waitForAttach(DebugProcess process, Stopwatch stopwatch) throws InterruptedException, TimeoutException, com.intellij.execution.ExecutionException {
        WaitForAttachListener listener = new WaitForAttachListener();
        try {
            process.addDebugProcessListener((DebugProcessListener)listener);
            if (!process.isAttached() && (process.isDetached() || process.isDetaching() || !listener.waitForJdwpAttach(stopwatch))) {
                throw new com.intellij.execution.ExecutionException("Java debugger detached or detaching");
            }
        }
        finally {
            process.removeDebugProcessListener((DebugProcessListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSessionCreatedListeners(DebuggerSession debuggerSession) {
        List<SessionListener> list = this.mySessionListeners;
        synchronized (list) {
            assert (!this.mySessionCreated);
            for (SessionListener listener : this.mySessionListeners) {
                listener.sessionCreated(debuggerSession);
            }
            this.mySessionListeners.clear();
            this.mySessionCreated = true;
        }
    }

    public void dispose() {
        if (this.myDebuggerSession != null) {
            Disposer.dispose((Disposable)this.myDebuggerSession.getProcess().getExecutionResult().getExecutionConsole());
            this.myDebuggerSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(@NotNull SessionListener sessionListener) {
        List<SessionListener> list = this.mySessionListeners;
        synchronized (list) {
            assert (!this.mySessionCreated);
            this.mySessionListeners.add(sessionListener);
        }
    }

    private static class WaitForAttachListener
    implements DebugProcessListener {
        private final Object myLock = new Object();
        private boolean myAttached = false;
        private boolean myDetached = false;

        private WaitForAttachListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForJdwpAttach(Stopwatch stopwatch) throws InterruptedException, TimeoutException {
            Object object = this.myLock;
            synchronized (object) {
                while (!this.myAttached && !this.myDetached) {
                    long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    if (30000L > elapsed) {
                        this.myLock.wait(30000L - elapsed);
                        continue;
                    }
                    throw new TimeoutException("Timed out waiting for java debugger to attach");
                }
                return !this.myDetached;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processAttached(@NotNull DebugProcess process) {
            Object object = this.myLock;
            synchronized (object) {
                this.myAttached = true;
                this.myLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDetached = true;
                this.myLock.notifyAll();
            }
        }
    }

    public static interface SessionListener {
        public void sessionCreated(@NotNull DebuggerSession var1);
    }
}

