/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analytics;

import com.intellij.analytics.NullAndroidStudioAnalytics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidStudioAnalytics {
    public static AndroidStudioAnalytics getInstance() {
        Application app = ApplicationManager.getApplication();
        AndroidStudioAnalytics service = (AndroidStudioAnalytics)app.getService(AndroidStudioAnalytics.class);
        if (service != null) {
            return service;
        }
        if (PlatformUtils.isAndroidStudio() && !app.isHeadlessEnvironment()) {
            throw new IllegalStateException("AndroidStudioAnalytics service not found, despite running inside Android Studio");
        }
        return NullAndroidStudioAnalytics.INSTANCE;
    }

    public abstract void recordHighlightingLatency(Document var1, long var2);

    public abstract void logUpdateDialogOpenManually(@NotNull String var1);

    public abstract void logNotificationShown(@NotNull String var1);

    public abstract void logClickNotification(@NotNull String var1);

    public abstract void logUpdateDialogOpenFromNotification(@NotNull String var1);

    public abstract void logClickIgnore(String var1);

    public abstract void logClickLater(String var1);

    public abstract void logDownloadSuccess(String var1);

    public abstract void logDownloadFailure(String var1);

    public abstract void updateAndroidStudioMetrics();

    public abstract void initializeAndroidStudioUsageTrackerAndPublisher();

    public abstract boolean isAllowed();
}

