/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.responsiveActivity.src;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"mainActivityJava", "", "packageName", "applicationPackage", "activityClass", "appBarLayoutName", "contentMainLayoutName", "layoutName", "navHostFragmentId", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
public final class MainActivityJavaKt {
    @NotNull
    public static final String mainActivityJava(@NotNull String packageName, @Nullable String applicationPackage, @NotNull String activityClass, @NotNull String appBarLayoutName, @NotNull String contentMainLayoutName, @NotNull String layoutName, @NotNull String navHostFragmentId, boolean isViewBindingSupported) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)appBarLayoutName, (String)"appBarLayoutName");
        Intrinsics.checkNotNullParameter((Object)contentMainLayoutName, (String)"contentMainLayoutName");
        Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)navHostFragmentId, (String)"navHostFragmentId");
        String appBarMainBinding = TemplateHelpersKt.underscoreToLowerCamelCase(appBarLayoutName);
        String contentMainBinding = TemplateHelpersKt.underscoreToLowerCamelCase(contentMainLayoutName);
        return "\npackage " + packageName + ";\n\nimport android.os.Bundle;\nimport android.view.MenuItem;\nimport android.view.Menu;\nimport com.google.android.material.bottomnavigation.BottomNavigationView;\nimport com.google.android.material.snackbar.Snackbar;\nimport com.google.android.material.navigation.NavigationView;\nimport androidx.annotation.NonNull;\nimport androidx.navigation.NavController;\nimport androidx.navigation.Navigation;\nimport androidx.navigation.fragment.NavHostFragment;\nimport androidx.navigation.ui.AppBarConfiguration;\nimport androidx.navigation.ui.NavigationUI;\nimport androidx.appcompat.app.AppCompatActivity;\n" + ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName, Language.Java) + "\n\npublic class " + activityClass + " extends AppCompatActivity {\n\n    private AppBarConfiguration mAppBarConfiguration;\n\n    @Override\n    protected void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n\n        ActivityMainBinding binding = ActivityMainBinding.inflate(getLayoutInflater());\n        setContentView(binding.getRoot());\n\n        setSupportActionBar(binding." + appBarMainBinding + ".toolbar);\n        if (binding." + appBarMainBinding + ".fab != null) {\n            binding." + appBarMainBinding + ".fab.setOnClickListener(view -> Snackbar.make(view, \"Replace with your own action\", Snackbar.LENGTH_LONG)\n                    .setAction(\"Action\", null).setAnchorView(R.id.fab).show());\n        }\n        NavHostFragment navHostFragment = (NavHostFragment) getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment_content_main);\n        assert navHostFragment != null;\n        NavController navController = navHostFragment.getNavController();\n\n        NavigationView navigationView = binding.navView;\n        if (navigationView != null) {\n            mAppBarConfiguration = new AppBarConfiguration.Builder(\n                    R.id.nav_transform, R.id.nav_reflow, R.id.nav_slideshow, R.id.nav_settings)\n                    .setOpenableLayout(binding.drawerLayout)\n                    .build();\n            NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);\n            NavigationUI.setupWithNavController(navigationView, navController);\n        }\n\n        BottomNavigationView bottomNavigationView = binding." + appBarMainBinding + "." + contentMainBinding + ".bottomNavView;\n        if (bottomNavigationView != null) {\n            mAppBarConfiguration = new AppBarConfiguration.Builder(\n                    R.id.nav_transform, R.id.nav_reflow, R.id.nav_slideshow)\n                    .build();\n            NavigationUI.setupActionBarWithNavController(this, navController, mAppBarConfiguration);\n            NavigationUI.setupWithNavController(bottomNavigationView, navController);\n        }\n    }\n\n    @Override\n    public boolean onCreateOptionsMenu(Menu menu) {\n        boolean result = super.onCreateOptionsMenu(menu);\n        // Using findViewById because NavigationView exists in different layout files\n        // between w600dp and w1240dp\n        NavigationView navView = findViewById(R.id.nav_view);\n        if (navView == null) {\n            // The navigation drawer already has the items including the items in the overflow menu\n            // We only inflate the overflow menu if the navigation drawer isn't visible\n            getMenuInflater().inflate(R.menu.overflow, menu);\n        }\n        return result;\n    }\n\n    @Override\n    public boolean onOptionsItemSelected(@NonNull MenuItem item) {\n        if (item.getItemId() == R.id.nav_settings) {\n            NavController navController = Navigation.findNavController(this, R.id." + navHostFragmentId + ");\n            navController.navigate(R.id.nav_settings);\n        }\n        return super.onOptionsItemSelected(item);\n    }\n\n    @Override\n    public boolean onSupportNavigateUp() {\n        NavController navController = Navigation.findNavController(this, R.id." + navHostFragmentId + ");\n        return NavigationUI.navigateUp(navController, mAppBarConfiguration)\n                || super.onSupportNavigateUp();\n    }\n}\n";
    }
}

