/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.debugger;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.UtilsKt;
import com.android.tools.idea.execution.common.stats.RunStats;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gct.testrecorder.debugger.BreakpointCommand;
import com.google.gct.testrecorder.debugger.BreakpointDescriptor;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.ui.RecordingDialog;
import com.google.gct.testrecorder.util.GenerateTestHelperKt;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.awt.Component;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class TestRecorderDebugProcessListener
implements DebugProcessListener {
    private static final Logger LOGGER = Logger.getInstance(TestRecorderDebugProcessListener.class);
    private static final BreakpointDescriptor PRESS_BACK_EMULATOR_28_BREAKPOINT_DESCRIPTOR = new BreakpointDescriptor("PRESSED_BACK_EMULATOR_28", "android.app.Activity", "onBackPressed", "()V", false);
    private final Set<BreakpointDescriptor> myBreakpointDescriptors = Sets.newHashSet();
    private final Set<BreakpointCommand> myBreakpointCommands = Sets.newHashSet();
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final ExecutionEnvironment myEnvironment;
    private final boolean myIsRecordingTest;
    private IDevice myDevice;
    private final String myPackageName;
    private volatile DebuggerSession myDebuggerSession;
    private volatile RecordingDialog myRecordingDialog;
    private final String mySpecificActivityClass;

    public TestRecorderDebugProcessListener(AndroidFacet facet, ExecutionEnvironment environment, IDevice device, String packageName, boolean isRecordingTest, String specificActivityClass, DebuggerSession debugSession) {
        this.myFacet = facet;
        this.mySpecificActivityClass = specificActivityClass;
        this.myProject = environment.getProject();
        this.myPackageName = packageName;
        this.myDevice = device;
        this.myEnvironment = environment;
        this.myIsRecordingTest = isRecordingTest;
        this.myDebuggerSession = debugSession;
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_CLICKED", "android.view.View$PerformClick", "run", "()V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_LONG_CLICKED", "android.view.View", "performLongClick", "()Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("LIST_ITEM_CLICKED", "android.widget.AbsListView", "performItemClick", "(Landroid/view/View;IJ)Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_TEXT_CHANGED", "android.widget.TextView$ChangeWatcher", "beforeTextChanged", "(Ljava/lang/CharSequence;III)V", true));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_TEXT_CHANGED", "android.widget.TextView$ChangeWatcher", "onTextChanged", "(Ljava/lang/CharSequence;III)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PRESSED_BACK", "android.view.inputmethod.InputMethodManager", "invokeFinishedInputEventCallback", "(Landroid/view/inputmethod/InputMethodManager$PendingEvent;Z)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PRESSED_EDITOR_ACTION", "android.widget.TextView", "onEditorAction", "(I)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("VIEW_SWIPED", "android.support.v4.view.ViewPager", "smoothScrollTo", "(III)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("DELAYED_MESSAGE_POSTED", "android.os.Handler", "postDelayed", "(Ljava/lang/Runnable;J)Z", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("WINDOW_CONTENT_CHANGED", "android.view.ViewRootImpl$SendWindowContentChangedAccessibilityEvent", "run", "()V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("LAZY_CLASSES_LOADER", "android.os.Handler", "dispatchMessage", "(Landroid/os/Message;)V", false));
        this.myBreakpointDescriptors.add(new BreakpointDescriptor("PERMISSIONS_REQUEST", "android.app.Activity", "requestPermissions", "([Ljava/lang/String;I)V", false));
    }

    public void processAttached(DebugProcess process) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)TestRecorderDebugProcessListener.this.myProject).getDebugSessions()) {
                    debugSession.setBreakpointMuted(true);
                }
            }
        });
        this.scheduleBreakpointCommands(this.myDevice);
        if (this.myRecordingDialog == null) {
            String launchedActivityName = this.detectLaunchedActivityName();
            final CountDownLatch latch = new CountDownLatch(1);
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myRecordingDialog = new RecordingDialog(this.myFacet, this.myDevice, this.myPackageName, launchedActivityName, this.myIsRecordingTest, latch);
                this.myRecordingDialog.setDebuggerSession(this.myDebuggerSession);
                for (BreakpointCommand breakpointCommand : this.myBreakpointCommands) {
                    breakpointCommand.setEventListener(this.myRecordingDialog);
                }
                this.myRecordingDialog.show();
            });
            if (this.myDebuggerSession.isAttached() && this.myDevice.isOnline()) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Espresso test recorder running", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
                        try {
                            while (!latch.await(1L, TimeUnit.SECONDS)) {
                                indicator.checkCanceled();
                            }
                            if (TestRecorderDebugProcessListener.this.myRecordingDialog.isOK()) {
                                indicator.setText("Creating test file");
                                GenerateTestHelperKt.generateTest(this.myProject, TestRecorderDebugProcessListener.this.myRecordingDialog.getTestClassName(), TestRecorderDebugProcessListener.this.myRecordingDialog.getTestClassParent(), TestRecorderDebugProcessListener.this.myRecordingDialog.getSelectedLanguage(), TestRecorderDebugProcessListener.this.myFacet, TestRecorderDebugProcessListener.this.myRecordingDialog.getRootPanel(), TestRecorderDebugProcessListener.this.myRecordingDialog.getAllModelActions(), TestRecorderDebugProcessListener.this.myRecordingDialog.getLaunchedActivityName(), TestRecorderDebugProcessListener.this.myRecordingDialog.getWasEverPaused(), indicator);
                            }
                        }
                        catch (ProcessCanceledException | InterruptedException e) {
                            notificationsManager.showNotification(new Notification(((Object)((Object)this)).getClass().toString(), "Espresso test recorder", "Espresso test recorder interrupted", NotificationType.ERROR), this.myProject);
                        }
                        catch (Exception e) {
                            notificationsManager.showNotification(new Notification(((Object)((Object)this)).getClass().toString(), "Espresso test recorder", "Error recording espresso test", NotificationType.ERROR), this.myProject);
                        }
                    }

                    public void onCancel() {
                        if (latch.getCount() > 0L) {
                            TestRecorderDebugProcessListener.this.myRecordingDialog.doCancelAction();
                        }
                        TestRecorderDebugProcessListener.this.stopDebugger();
                        super.onCancel();
                    }

                    public void onFinished() {
                        TestRecorderDebugProcessListener.this.stopDebugger();
                        super.onFinished();
                    }
                });
            }
        } else {
            this.myRecordingDialog.setDebuggerSession(this.myDebuggerSession);
            for (BreakpointCommand breakpointCommand : this.myBreakpointCommands) {
                breakpointCommand.setEventListener(this.myRecordingDialog);
            }
        }
    }

    public void processDetached(DebugProcess process, boolean closedByUser) {
        if (this.myRecordingDialog != null && this.myRecordingDialog.isShowing()) {
            this.promptToRestartDebugging();
        }
    }

    @NotNull
    private String detectLaunchedActivityName() {
        if (!Strings.isNullOrEmpty((String)this.mySpecificActivityClass)) {
            return this.mySpecificActivityClass;
        }
        return (String)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode((Computable)new Computable<String>(){

            public String compute() {
                String activityName = "unknownPackage.unknownActivity";
                try {
                    activityName = new DefaultActivityLocator(TestRecorderDebugProcessListener.this.myFacet).getQualifiedActivityName(TestRecorderDebugProcessListener.this.myDevice);
                }
                catch (Exception e) {
                    return activityName;
                }
                if (Manifest.getMainManifest((AndroidFacet)TestRecorderDebugProcessListener.this.myFacet) == null || Manifest.getMainManifest((AndroidFacet)TestRecorderDebugProcessListener.this.myFacet).getApplication() == null) {
                    return activityName;
                }
                Application application = Manifest.getMainManifest((AndroidFacet)TestRecorderDebugProcessListener.this.myFacet).getApplication();
                for (Activity activity : application.getActivities()) {
                    if (!activityName.equals(ActivityLocatorUtils.getQualifiedName((Activity)activity))) continue;
                    return activityName;
                }
                for (ActivityAlias activityAlias : application.getActivityAliases()) {
                    String qualifiedName;
                    if (!activityName.equals(ActivityLocatorUtils.getQualifiedName((ActivityAlias)activityAlias))) continue;
                    PsiClass psiClass = (PsiClass)activityAlias.getTargetActivity().getValue();
                    if (psiClass != null && (qualifiedName = psiClass.getQualifiedName()) != null) {
                        return qualifiedName;
                    }
                    return activityName;
                }
                if (activityName.startsWith(".")) {
                    for (Activity activity : application.getActivities()) {
                        if (!ActivityLocatorUtils.getQualifiedName((Activity)activity).endsWith(activityName)) continue;
                        return ActivityLocatorUtils.getQualifiedName((Activity)activity);
                    }
                    activityName = activityName.substring(1);
                }
                return activityName;
            }
        });
    }

    private void promptToRestartDebugging() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = "Test Recorder has detached from the device VM";
                if (TestRecorderDebugProcessListener.this.isDeviceConnected()) {
                    Messages.showMessageDialog((Component)TestRecorderDebugProcessListener.this.myRecordingDialog.getRootPane(), (String)"Test Recorder stopped recording your actions because the app stopped.", (String)title, null);
                    return;
                }
                Object message = "Test Recorder stopped recording your actions because it has detached from the device VM.\nPlease fix the connection and click Resume to continue.";
                while (message != null) {
                    TestRecorderDebugProcessListener.this.myDebuggerSession = null;
                    if (TestRecorderDebugProcessListener.this.myRecordingDialog != null) {
                        TestRecorderDebugProcessListener.this.myRecordingDialog.setDebuggerSession(null);
                    }
                    boolean shouldResume = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message).yesText("Resume")).noText("Stop")).icon(null)).ask((Component)TestRecorderDebugProcessListener.this.myRecordingDialog.getRootPane());
                    message = null;
                    if (!shouldResume) continue;
                    try {
                        TestRecorderDebugProcessListener.this.restartDebugging();
                    }
                    catch (Exception e) {
                        message = "Could not reattach the debugger: " + e.getMessage();
                    }
                }
            }
        });
    }

    private void restartDebugging() throws ExecutionException {
        this.reconnectToDevice();
        String debugPort = Integer.toString(this.myDevice.getClient(this.myPackageName).getDebuggerListenPort());
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        RunProfileState state = new RunProfileState(this){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                return new DefaultExecutionResult();
            }
        };
        final RemoteDebugProcessHandler processHandler = new RemoteDebugProcessHandler(this.myProject);
        DefaultDebugEnvironment debugEnvironment = new DefaultDebugEnvironment(this, this.myEnvironment, state, connection, false){

            public ExecutionResult createExecutionResult() throws ExecutionException {
                return new DefaultExecutionResult(null, (ProcessHandler)processHandler);
            }
        };
        DebuggerManagerEx.getInstanceEx((Project)this.myProject).attachVirtualMachine((DebugEnvironment)debugEnvironment);
        if (this.myDebuggerSession == null) {
            throw new RuntimeException("Could not attach the virtual machine!");
        }
        XDebuggerManager.getInstance((Project)this.myProject).startSession(this.myEnvironment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                return JavaDebugProcess.create((XDebugSession)session2, (DebuggerSession)TestRecorderDebugProcessListener.this.myDebuggerSession);
            }
        });
        processHandler.startNotify();
    }

    private void scheduleBreakpointCommands(IDevice device) {
        this.myBreakpointCommands.clear();
        DebugProcessImpl debugProcess = this.myDebuggerSession.getProcess();
        for (BreakpointDescriptor breakpointDescriptor : this.myBreakpointDescriptors) {
            if (device.getVersion().getApiLevel() >= 28) {
                if (Objects.equals(breakpointDescriptor.eventType, "DELAYED_MESSAGE_POSTED")) continue;
                if (device.isEmulator() && Objects.equals(breakpointDescriptor.eventType, "PRESSED_BACK")) {
                    breakpointDescriptor = PRESS_BACK_EMULATOR_28_BREAKPOINT_DESCRIPTOR;
                }
            }
            BreakpointCommand breakpointCommand = new BreakpointCommand(debugProcess, breakpointDescriptor);
            this.myBreakpointCommands.add(breakpointCommand);
            debugProcess.getManagerThread().schedule((DebuggerCommandImpl)breakpointCommand);
        }
    }

    private Void stopTestRecorder() {
        this.stopDebugger();
        if (this.myDevice != null && TestRecorderSettings.getInstance().CLEAN_AFTER_FINISH) {
            try {
                UtilsKt.clearAppStorage((Project)this.myProject, (IDevice)this.myDevice, (String)this.myPackageName, (RunStats)RunStats.from((ExecutionEnvironment)this.myEnvironment));
            }
            catch (Exception e) {
                LOGGER.warn("Exception stopping the app", (Throwable)e);
            }
        }
        return null;
    }

    private void stopDebugger() {
        if (TestRecorderSettings.getInstance().STOP_APP_AFTER_RECORDING) {
            XDebugSession xDebugSession;
            if (this.myDebuggerSession != null && (xDebugSession = this.myDebuggerSession.getXDebugSession()) != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        xDebugSession.stop();
                    }
                });
            }
        } else {
            for (BreakpointCommand breakpointCommand : this.myBreakpointCommands) {
                breakpointCommand.disable();
            }
        }
    }

    private void reconnectToDevice() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        if (debugBridge == null) {
            throw new RuntimeException("Could not obtain the debug bridge!");
        }
        for (IDevice device : debugBridge.getDevices()) {
            if (!this.myDevice.getSerialNumber().equals(device.getSerialNumber())) continue;
            this.myDevice = device;
            return;
        }
        throw new RuntimeException("Could not find the original device to reconnect to!");
    }

    private boolean isDeviceConnected() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge((Project)this.myProject);
        if (debugBridge != null) {
            for (IDevice device : debugBridge.getDevices()) {
                if (!this.myDevice.getSerialNumber().equals(device.getSerialNumber())) continue;
                return true;
            }
        }
        return false;
    }
}

