/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.ui.screenshot.ScreenshotImage;
import com.android.tools.idea.ui.screenshot.ScreenshotProvider;
import com.android.tools.idea.ui.screenshot.ShellCommandScreenshotProvider;
import com.android.uiautomator.UiAutomatorModel;
import com.google.gct.testrecorder.ui.ScreenshotCallback;
import com.google.gct.testrecorder.ui.ScreenshotTask;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class TestRecorderScreenshotTask
extends ScreenshotTask {
    public static volatile boolean IS_UI_HIERARCHY_DUMPING = false;
    private static final String UI_HIERARCHY_FAILURE_DIALOG_TITLE = "Failed to get UI hierarchy";
    private final Project myProject;
    private final IDevice myDevice;
    private final String myPackageName;
    private final ScreenshotCallback myCallback;
    private File myUiHierarchyLocalFile;
    private boolean success = false;

    public TestRecorderScreenshotTask(Project project, IDevice device, String packageName, ScreenshotCallback callback) {
        super(project, (ScreenshotProvider)new ShellCommandScreenshotProvider(project, device.getSerialNumber()));
        this.myProject = project;
        this.myDevice = device;
        this.myPackageName = packageName;
        this.myCallback = callback;
    }

    @Override
    public void run(@NotNull ProgressIndicator indicator) {
        super.run(indicator);
        String errorMessage = this.getError();
        if (errorMessage != null) {
            this.showErrorMessage(errorMessage, "Failed to capture screenshot");
            return;
        }
        if (indicator.isCanceled()) {
            return;
        }
        indicator.setText("Creating temporary file for UI hierarchy...");
        try {
            this.myUiHierarchyLocalFile = File.createTempFile("ui_hierarchy", ".xml");
        }
        catch (Exception e) {
            this.showErrorMessage("Could not create a temporary file for UI hierarchy: " + e.getMessage(), UI_HIERARCHY_FAILURE_DIALOG_TITLE);
            return;
        }
        this.myUiHierarchyLocalFile.deleteOnExit();
        if (indicator.isCanceled()) {
            return;
        }
        indicator.setText("Dumping UI hierarchy on the device...");
        String uiHierarchyRemoteContainerPath = String.format("/sdcard/%s/files/testrecorder", this.myPackageName);
        String uiHierarchyRemotePath = uiHierarchyRemoteContainerPath + "/ui_hierarchy.xml";
        try {
            this.myDevice.executeShellCommand("mkdir -p " + uiHierarchyRemoteContainerPath, (IShellOutputReceiver)new CollectingOutputReceiver(), 3L, TimeUnit.SECONDS);
            IS_UI_HIERARCHY_DUMPING = true;
            this.myDevice.executeShellCommand("uiautomator dump " + uiHierarchyRemotePath, (IShellOutputReceiver)new CollectingOutputReceiver(), 10L, TimeUnit.SECONDS);
            IS_UI_HIERARCHY_DUMPING = false;
        }
        catch (Exception e) {
            this.showErrorMessage("Could not dump UI hierarchy on the device: " + e.getMessage(), UI_HIERARCHY_FAILURE_DIALOG_TITLE);
            return;
        }
        if (indicator.isCanceled()) {
            return;
        }
        indicator.setText("Pulling UI hierarchy from the device...");
        try {
            this.myDevice.pullFile(uiHierarchyRemotePath, this.myUiHierarchyLocalFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.showErrorMessage("Could not pull UI hierarchy file from the device: " + e.getMessage(), UI_HIERARCHY_FAILURE_DIALOG_TITLE);
            return;
        }
        if (indicator.isCanceled()) {
            return;
        }
        this.success = true;
    }

    private void showErrorMessage(@NotNull String errorMessage, @NotNull String title) {
        SwingUtilities.invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)errorMessage, (String)title));
    }

    public void onSuccess() {
        if (this.success) {
            ScreenshotImage screenshotImage = this.getScreenshot();
            BufferedImage image = screenshotImage == null ? null : screenshotImage.getImage();
            this.myCallback.onSuccess(image, new UiAutomatorModel(this.myUiHierarchyLocalFile));
        }
    }
}

