/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.SignedContextualAds;
import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdSelectionConfig
implements Parcelable {
    @NonNull
    public static final AdSelectionConfig EMPTY = new AdSelectionConfig();
    @NonNull
    private final AdTechIdentifier mSeller;
    @NonNull
    private final Uri mDecisionLogicUri;
    @NonNull
    private final List<AdTechIdentifier> mCustomAudienceBuyers;
    @NonNull
    private final AdSelectionSignals mAdSelectionSignals;
    @NonNull
    private final AdSelectionSignals mSellerSignals;
    @NonNull
    private final Map<AdTechIdentifier, AdSelectionSignals> mPerBuyerSignals;
    @NonNull
    private final Map<AdTechIdentifier, SignedContextualAds> mBuyerSignedContextualAds;
    @NonNull
    private final Uri mTrustedScoringSignalsUri;
    @NonNull
    public static final Parcelable.Creator<AdSelectionConfig> CREATOR = new Parcelable.Creator<AdSelectionConfig>(){

        @Override
        public AdSelectionConfig createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new AdSelectionConfig(in);
        }

        public AdSelectionConfig[] newArray(int size) {
            return new AdSelectionConfig[size];
        }
    };

    private AdSelectionConfig() {
        this.mSeller = AdTechIdentifier.fromString("");
        this.mDecisionLogicUri = Uri.EMPTY;
        this.mCustomAudienceBuyers = Collections.emptyList();
        this.mAdSelectionSignals = AdSelectionSignals.EMPTY;
        this.mSellerSignals = AdSelectionSignals.EMPTY;
        this.mPerBuyerSignals = Collections.emptyMap();
        this.mBuyerSignedContextualAds = Collections.emptyMap();
        this.mTrustedScoringSignalsUri = Uri.EMPTY;
    }

    private AdSelectionConfig(@NonNull AdTechIdentifier seller, @NonNull Uri decisionLogicUri, @NonNull List<AdTechIdentifier> customAudienceBuyers, @NonNull AdSelectionSignals adSelectionSignals, @NonNull AdSelectionSignals sellerSignals, @NonNull Map<AdTechIdentifier, AdSelectionSignals> perBuyerSignals, @NonNull Map<AdTechIdentifier, SignedContextualAds> perBuyerSignedContextualAds, @NonNull Uri trustedScoringSignalsUri) {
        this.mSeller = seller;
        this.mDecisionLogicUri = decisionLogicUri;
        this.mCustomAudienceBuyers = customAudienceBuyers;
        this.mAdSelectionSignals = adSelectionSignals;
        this.mSellerSignals = sellerSignals;
        this.mPerBuyerSignals = perBuyerSignals;
        this.mBuyerSignedContextualAds = perBuyerSignedContextualAds;
        this.mTrustedScoringSignalsUri = trustedScoringSignalsUri;
    }

    private AdSelectionConfig(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mSeller = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mDecisionLogicUri = Uri.CREATOR.createFromParcel(in);
        this.mCustomAudienceBuyers = in.createTypedArrayList(AdTechIdentifier.CREATOR);
        this.mAdSelectionSignals = AdSelectionSignals.CREATOR.createFromParcel(in);
        this.mSellerSignals = AdSelectionSignals.CREATOR.createFromParcel(in);
        this.mPerBuyerSignals = AdServicesParcelableUtil.readMapFromParcel(in, AdTechIdentifier::fromString, AdSelectionSignals.class);
        this.mBuyerSignedContextualAds = AdServicesParcelableUtil.readMapFromParcel(in, AdTechIdentifier::fromString, SignedContextualAds.class);
        this.mTrustedScoringSignalsUri = Uri.CREATOR.createFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mSeller.writeToParcel(dest, flags);
        this.mDecisionLogicUri.writeToParcel(dest, flags);
        dest.writeTypedList(this.mCustomAudienceBuyers);
        this.mAdSelectionSignals.writeToParcel(dest, flags);
        this.mSellerSignals.writeToParcel(dest, flags);
        AdServicesParcelableUtil.writeMapToParcel(dest, this.mPerBuyerSignals);
        AdServicesParcelableUtil.writeMapToParcel(dest, this.mBuyerSignedContextualAds);
        this.mTrustedScoringSignalsUri.writeToParcel(dest, flags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdSelectionConfig)) {
            return false;
        }
        AdSelectionConfig that = (AdSelectionConfig)o;
        return Objects.equals(this.mSeller, that.mSeller) && Objects.equals(this.mDecisionLogicUri, that.mDecisionLogicUri) && Objects.equals(this.mCustomAudienceBuyers, that.mCustomAudienceBuyers) && Objects.equals(this.mAdSelectionSignals, that.mAdSelectionSignals) && Objects.equals(this.mSellerSignals, that.mSellerSignals) && Objects.equals(this.mPerBuyerSignals, that.mPerBuyerSignals) && Objects.equals(this.mBuyerSignedContextualAds, that.mBuyerSignedContextualAds) && Objects.equals(this.mTrustedScoringSignalsUri, that.mTrustedScoringSignalsUri);
    }

    public int hashCode() {
        return Objects.hash(this.mSeller, this.mDecisionLogicUri, this.mCustomAudienceBuyers, this.mAdSelectionSignals, this.mSellerSignals, this.mPerBuyerSignals, this.mBuyerSignedContextualAds, this.mTrustedScoringSignalsUri);
    }

    @NonNull
    public Builder cloneToBuilder() {
        return new Builder().setSeller(this.getSeller()).setPerBuyerSignedContextualAds(this.getPerBuyerSignedContextualAds()).setAdSelectionSignals(this.getAdSelectionSignals()).setCustomAudienceBuyers(this.getCustomAudienceBuyers()).setDecisionLogicUri(this.getDecisionLogicUri()).setPerBuyerSignals(this.getPerBuyerSignals()).setSellerSignals(this.getSellerSignals()).setTrustedScoringSignalsUri(this.getTrustedScoringSignalsUri());
    }

    @NonNull
    public AdTechIdentifier getSeller() {
        return this.mSeller;
    }

    @NonNull
    public Uri getDecisionLogicUri() {
        return this.mDecisionLogicUri;
    }

    @NonNull
    public List<AdTechIdentifier> getCustomAudienceBuyers() {
        return new ArrayList<AdTechIdentifier>(this.mCustomAudienceBuyers);
    }

    @NonNull
    public AdSelectionSignals getAdSelectionSignals() {
        return this.mAdSelectionSignals;
    }

    @NonNull
    public AdSelectionSignals getSellerSignals() {
        return this.mSellerSignals;
    }

    @NonNull
    public Map<AdTechIdentifier, AdSelectionSignals> getPerBuyerSignals() {
        return new HashMap<AdTechIdentifier, AdSelectionSignals>(this.mPerBuyerSignals);
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
    @NonNull
    public Map<AdTechIdentifier, SignedContextualAds> getPerBuyerSignedContextualAds() {
        return new HashMap<AdTechIdentifier, SignedContextualAds>(this.mBuyerSignedContextualAds);
    }

    @NonNull
    public Uri getTrustedScoringSignalsUri() {
        return this.mTrustedScoringSignalsUri;
    }

    public static class Builder {
        private AdTechIdentifier mSeller;
        private Uri mDecisionLogicUri;
        private List<AdTechIdentifier> mCustomAudienceBuyers;
        private AdSelectionSignals mAdSelectionSignals = AdSelectionSignals.EMPTY;
        private AdSelectionSignals mSellerSignals = AdSelectionSignals.EMPTY;
        private Map<AdTechIdentifier, AdSelectionSignals> mPerBuyerSignals = Collections.emptyMap();
        private Map<AdTechIdentifier, SignedContextualAds> mBuyerSignedContextualAds = Collections.emptyMap();
        private Uri mTrustedScoringSignalsUri;

        @NonNull
        public Builder setSeller(@NonNull AdTechIdentifier seller) {
            Objects.requireNonNull(seller);
            this.mSeller = seller;
            return this;
        }

        @NonNull
        public Builder setDecisionLogicUri(@NonNull Uri decisionLogicUri) {
            Objects.requireNonNull(decisionLogicUri);
            this.mDecisionLogicUri = decisionLogicUri;
            return this;
        }

        @NonNull
        public Builder setCustomAudienceBuyers(@NonNull List<AdTechIdentifier> customAudienceBuyers) {
            Objects.requireNonNull(customAudienceBuyers);
            this.mCustomAudienceBuyers = customAudienceBuyers;
            return this;
        }

        @NonNull
        public Builder setAdSelectionSignals(@NonNull AdSelectionSignals adSelectionSignals) {
            Objects.requireNonNull(adSelectionSignals);
            this.mAdSelectionSignals = adSelectionSignals;
            return this;
        }

        @NonNull
        public Builder setSellerSignals(@NonNull AdSelectionSignals sellerSignals) {
            Objects.requireNonNull(sellerSignals);
            this.mSellerSignals = sellerSignals;
            return this;
        }

        @NonNull
        public Builder setPerBuyerSignals(@NonNull Map<AdTechIdentifier, AdSelectionSignals> perBuyerSignals) {
            Objects.requireNonNull(perBuyerSignals);
            this.mPerBuyerSignals = perBuyerSignals;
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
        @NonNull
        public Builder setPerBuyerSignedContextualAds(@NonNull Map<AdTechIdentifier, SignedContextualAds> buyerSignedContextualAds) {
            Objects.requireNonNull(buyerSignedContextualAds);
            this.mBuyerSignedContextualAds = buyerSignedContextualAds;
            return this;
        }

        @NonNull
        public Builder setTrustedScoringSignalsUri(@NonNull Uri trustedScoringSignalsUri) {
            Objects.requireNonNull(trustedScoringSignalsUri);
            this.mTrustedScoringSignalsUri = trustedScoringSignalsUri;
            return this;
        }

        @NonNull
        public AdSelectionConfig build() {
            Objects.requireNonNull(this.mSeller, "The seller has not been provided");
            Objects.requireNonNull(this.mDecisionLogicUri, "The decision logic URI has not been provided");
            Objects.requireNonNull(this.mCustomAudienceBuyers, "The custom audience buyers have not been provided");
            Objects.requireNonNull(this.mAdSelectionSignals, "The ad selection signals have not been provided");
            Objects.requireNonNull(this.mSellerSignals, "The seller signals have not been provided");
            Objects.requireNonNull(this.mPerBuyerSignals, "The per buyer signals have not been provided");
            Objects.requireNonNull(this.mBuyerSignedContextualAds, "The buyer signed contextual ads have not been provided");
            Objects.requireNonNull(this.mTrustedScoringSignalsUri, "The trusted scoring signals URI have not been provided");
            return new AdSelectionConfig(this.mSeller, this.mDecisionLogicUri, this.mCustomAudienceBuyers, this.mAdSelectionSignals, this.mSellerSignals, this.mPerBuyerSignals, this.mBuyerSignedContextualAds, this.mTrustedScoringSignalsUri);
        }
    }
}

