/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.adselection.PerBuyerConfiguration;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
public class SellerConfiguration
implements Parcelable {
    private final int mMaximumPayloadSizeBytes;
    private final Set<PerBuyerConfiguration> mPerBuyerConfigurations;
    @NonNull
    public static final Parcelable.Creator<SellerConfiguration> CREATOR = new Parcelable.Creator<SellerConfiguration>(){

        @Override
        public SellerConfiguration createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new SellerConfiguration(in);
        }

        public SellerConfiguration[] newArray(int size) {
            return new SellerConfiguration[size];
        }
    };

    private SellerConfiguration(Parcel in) {
        this.mMaximumPayloadSizeBytes = in.readInt();
        List perBuyerConfigurationList = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> in.createTypedArrayList(PerBuyerConfiguration.CREATOR));
        this.mPerBuyerConfigurations = Objects.nonNull(perBuyerConfigurationList) ? new HashSet<PerBuyerConfiguration>(perBuyerConfigurationList) : new HashSet<PerBuyerConfiguration>();
    }

    private SellerConfiguration(int maximumPayloadSizeBytes, Set<PerBuyerConfiguration> perBuyerConfigurations) {
        this.mMaximumPayloadSizeBytes = maximumPayloadSizeBytes;
        this.mPerBuyerConfigurations = perBuyerConfigurations;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mMaximumPayloadSizeBytes);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mPerBuyerConfigurations, (targetParcel, sourceSet) -> dest.writeTypedList(new ArrayList(sourceSet)));
    }

    public boolean equals(Object o) {
        if (o instanceof SellerConfiguration) {
            SellerConfiguration sellerConfiguration = (SellerConfiguration)o;
            return Objects.equals(this.mMaximumPayloadSizeBytes, sellerConfiguration.mMaximumPayloadSizeBytes) && Objects.equals(this.mPerBuyerConfigurations, sellerConfiguration.mPerBuyerConfigurations);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mMaximumPayloadSizeBytes, this.mPerBuyerConfigurations);
    }

    public int getMaximumPayloadSizeBytes() {
        return this.mMaximumPayloadSizeBytes;
    }

    @NonNull
    public Set<PerBuyerConfiguration> getPerBuyerConfigurations() {
        return this.mPerBuyerConfigurations;
    }

    public static class Builder {
        private int mMaximumPayloadSizeBytes;
        @NonNull
        private Set<PerBuyerConfiguration> mPerBuyerConfigurations = new HashSet<PerBuyerConfiguration>();

        @NonNull
        public Builder setMaximumPayloadSizeBytes(int maximumPayloadSizeBytes) {
            this.mMaximumPayloadSizeBytes = maximumPayloadSizeBytes;
            Preconditions.checkArgument(maximumPayloadSizeBytes > 0, "Maximum payload of size %d must be greater than 0.", maximumPayloadSizeBytes);
            return this;
        }

        @NonNull
        public Builder setPerBuyerConfigurations(@NonNull Set<PerBuyerConfiguration> perBuyerConfigurations) {
            this.mPerBuyerConfigurations = Objects.requireNonNull(perBuyerConfigurations, "Per Buyer Configurations cannot be null.");
            return this;
        }

        @NonNull
        public SellerConfiguration build() {
            if (this.mMaximumPayloadSizeBytes == 0) {
                throw new IllegalStateException("Maximum size must be set.");
            }
            return new SellerConfiguration(this.mMaximumPayloadSizeBytes, this.mPerBuyerConfigurations);
        }
    }
}

