/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.adselection;

import android.adservices.common.AdTechIdentifier;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import com.android.internal.util.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SetAdCounterHistogramOverrideInput
implements Parcelable {
    private final int mAdEventType;
    private final int mAdCounterKey;
    @NonNull
    private final List<Instant> mHistogramTimestamps;
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final String mCustomAudienceOwner;
    @NonNull
    private final String mCustomAudienceName;
    @NonNull
    public static final Parcelable.Creator<SetAdCounterHistogramOverrideInput> CREATOR = new Parcelable.Creator<SetAdCounterHistogramOverrideInput>(){

        @Override
        public SetAdCounterHistogramOverrideInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new SetAdCounterHistogramOverrideInput(in);
        }

        public SetAdCounterHistogramOverrideInput[] newArray(int size) {
            return new SetAdCounterHistogramOverrideInput[size];
        }
    };

    private SetAdCounterHistogramOverrideInput(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mAdEventType = builder.mAdEventType;
        this.mAdCounterKey = builder.mAdCounterKey;
        this.mHistogramTimestamps = builder.mHistogramTimestamps;
        this.mBuyer = builder.mBuyer;
        this.mCustomAudienceOwner = builder.mCustomAudienceOwner;
        this.mCustomAudienceName = builder.mCustomAudienceName;
    }

    private SetAdCounterHistogramOverrideInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mAdEventType = in.readInt();
        this.mAdCounterKey = in.readInt();
        this.mHistogramTimestamps = AdServicesParcelableUtil.readInstantListFromParcel(in);
        this.mBuyer = AdTechIdentifier.fromString(in.readString());
        this.mCustomAudienceOwner = in.readString();
        this.mCustomAudienceName = in.readString();
    }

    public int getAdEventType() {
        return this.mAdEventType;
    }

    @NonNull
    public int getAdCounterKey() {
        return this.mAdCounterKey;
    }

    @NonNull
    public List<Instant> getHistogramTimestamps() {
        return this.mHistogramTimestamps;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public String getCustomAudienceOwner() {
        return this.mCustomAudienceOwner;
    }

    @NonNull
    public String getCustomAudienceName() {
        return this.mCustomAudienceName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "SetAdCounterHistogramOverrideInput{mAdEventType=" + this.mAdEventType + ", mAdCounterKey=" + this.mAdCounterKey + ", mHistogramTimestamps=" + this.mHistogramTimestamps + ", mBuyer=" + this.mBuyer + ", mCustomAudienceOwner='" + this.mCustomAudienceOwner + "', mCustomAudienceName='" + this.mCustomAudienceName + "'}";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        dest.writeInt(this.mAdEventType);
        dest.writeInt(this.mAdCounterKey);
        AdServicesParcelableUtil.writeInstantListToParcel(dest, this.mHistogramTimestamps);
        dest.writeString(this.mBuyer.toString());
        dest.writeString(this.mCustomAudienceOwner);
        dest.writeString(this.mCustomAudienceName);
    }

    public static class Builder {
        private int mAdEventType = -1;
        private int mAdCounterKey;
        @NonNull
        private List<Instant> mHistogramTimestamps = new ArrayList<Instant>();
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private String mCustomAudienceOwner;
        @Nullable
        private String mCustomAudienceName;

        @NonNull
        public Builder setAdEventType(int adEventType) {
            this.mAdEventType = adEventType;
            return this;
        }

        @NonNull
        public Builder setAdCounterKey(int adCounterKey) {
            this.mAdCounterKey = adCounterKey;
            return this;
        }

        @NonNull
        public Builder setHistogramTimestamps(@NonNull List<Instant> histogramTimestamps) {
            Objects.requireNonNull(histogramTimestamps, "List of histogram timestamps must not be null");
            this.mHistogramTimestamps = histogramTimestamps;
            return this;
        }

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer, "Buyer must not be null");
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setCustomAudienceOwner(@NonNull String customAudienceOwner) {
            Objects.requireNonNull(customAudienceOwner, "Custom audience owner must not be null");
            this.mCustomAudienceOwner = customAudienceOwner;
            return this;
        }

        @NonNull
        public Builder setCustomAudienceName(@NonNull String customAudienceName) {
            Objects.requireNonNull(customAudienceName, "Custom audience name must not be null");
            this.mCustomAudienceName = customAudienceName;
            return this;
        }

        @NonNull
        public SetAdCounterHistogramOverrideInput build() throws NullPointerException, IllegalArgumentException {
            Preconditions.checkArgument(this.mAdEventType != -1, "Ad event type must be set");
            Objects.requireNonNull(this.mBuyer, "Buyer must not be null");
            Objects.requireNonNull(this.mCustomAudienceOwner, "Custom audience owner must not be null");
            Objects.requireNonNull(this.mCustomAudienceName, "Custom audience name must not be null");
            return new SetAdCounterHistogramOverrideInput(this);
        }
    }
}

