/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.adservices.common.AppInstallFilters;
import android.adservices.common.FrequencyCapFilters;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class AdFilters
implements Parcelable {
    public static final String FREQUENCY_CAP_FIELD_NAME = "frequency_cap";
    public static final String APP_INSTALL_FIELD_NAME = "app_install";
    @Nullable
    private final FrequencyCapFilters mFrequencyCapFilters;
    @Nullable
    private final AppInstallFilters mAppInstallFilters;
    @NonNull
    public static final Parcelable.Creator<AdFilters> CREATOR = new Parcelable.Creator<AdFilters>(){

        @Override
        public AdFilters createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new AdFilters(in);
        }

        public AdFilters[] newArray(int size) {
            return new AdFilters[size];
        }
    };

    private AdFilters(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mFrequencyCapFilters = builder.mFrequencyCapFilters;
        this.mAppInstallFilters = builder.mAppInstallFilters;
    }

    private AdFilters(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mFrequencyCapFilters = AdServicesParcelableUtil.readNullableFromParcel(in, FrequencyCapFilters.CREATOR::createFromParcel);
        this.mAppInstallFilters = AdServicesParcelableUtil.readNullableFromParcel(in, AppInstallFilters.CREATOR::createFromParcel);
    }

    @Nullable
    public FrequencyCapFilters getFrequencyCapFilters() {
        return this.mFrequencyCapFilters;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
    @Nullable
    public AppInstallFilters getAppInstallFilters() {
        return this.mAppInstallFilters;
    }

    public int getSizeInBytes() {
        int size = 0;
        if (this.mFrequencyCapFilters != null) {
            size += this.mFrequencyCapFilters.getSizeInBytes();
        }
        if (this.mAppInstallFilters != null) {
            size += this.mAppInstallFilters.getSizeInBytes();
        }
        return size;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject toReturn = new JSONObject();
        if (this.mFrequencyCapFilters != null) {
            toReturn.put(FREQUENCY_CAP_FIELD_NAME, this.mFrequencyCapFilters.toJson());
        }
        if (this.mAppInstallFilters != null) {
            toReturn.put(APP_INSTALL_FIELD_NAME, this.mAppInstallFilters.toJson());
        }
        return toReturn;
    }

    public static AdFilters fromJson(JSONObject json) throws JSONException {
        Builder builder = new Builder();
        if (json.has(FREQUENCY_CAP_FIELD_NAME)) {
            builder.setFrequencyCapFilters(FrequencyCapFilters.fromJson(json.getJSONObject(FREQUENCY_CAP_FIELD_NAME)));
        }
        if (json.has(APP_INSTALL_FIELD_NAME)) {
            builder.setAppInstallFilters(AppInstallFilters.fromJson(json.getJSONObject(APP_INSTALL_FIELD_NAME)));
        }
        return builder.build();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mFrequencyCapFilters, (targetParcel, sourceFilters) -> sourceFilters.writeToParcel(targetParcel, flags));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mAppInstallFilters, (targetParcel, sourceFilters) -> sourceFilters.writeToParcel(targetParcel, flags));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdFilters)) {
            return false;
        }
        AdFilters adFilters = (AdFilters)o;
        return Objects.equals(this.mFrequencyCapFilters, adFilters.mFrequencyCapFilters) && Objects.equals(this.mAppInstallFilters, adFilters.mAppInstallFilters);
    }

    public int hashCode() {
        return Objects.hash(this.mFrequencyCapFilters, this.mAppInstallFilters);
    }

    public String toString() {
        return "AdFilters{mFrequencyCapFilters=" + this.mFrequencyCapFilters + ", mAppInstallFilters=" + this.mAppInstallFilters + '}';
    }

    public static class Builder {
        @Nullable
        private FrequencyCapFilters mFrequencyCapFilters;
        @Nullable
        private AppInstallFilters mAppInstallFilters;

        @NonNull
        public Builder setFrequencyCapFilters(@Nullable FrequencyCapFilters frequencyCapFilters) {
            this.mFrequencyCapFilters = frequencyCapFilters;
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_ad_selection_filtering_enabled")
        @NonNull
        public Builder setAppInstallFilters(@Nullable AppInstallFilters appInstallFilters) {
            this.mAppInstallFilters = appInstallFilters;
            return this;
        }

        @NonNull
        public AdFilters build() {
            return new AdFilters(this);
        }
    }
}

