/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.common;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseIntArray;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.adservices.flags.adservices_enable_per_module_overrides_api")
public class UpdateAdServicesUserChoicesParams
implements Parcelable {
    private final SparseIntArray mAdServicesUserChoiceList;
    @NonNull
    public static final Parcelable.Creator<UpdateAdServicesUserChoicesParams> CREATOR = new Parcelable.Creator<UpdateAdServicesUserChoicesParams>(){

        @Override
        public UpdateAdServicesUserChoicesParams createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new UpdateAdServicesUserChoicesParams(in);
        }

        public UpdateAdServicesUserChoicesParams[] newArray(int size) {
            return new UpdateAdServicesUserChoicesParams[size];
        }
    };

    private UpdateAdServicesUserChoicesParams(SparseIntArray adServicesUserChoiceList) {
        this.mAdServicesUserChoiceList = adServicesUserChoiceList;
    }

    private UpdateAdServicesUserChoicesParams(Parcel in) {
        int length = in.readInt();
        int[] intKeys = new int[length];
        int[] intValues = new int[length];
        in.readIntArray(intKeys);
        in.readIntArray(intValues);
        this.mAdServicesUserChoiceList = new SparseIntArray(intKeys.length);
        for (int i = 0; i < intKeys.length; ++i) {
            this.mAdServicesUserChoiceList.append(intKeys[i], intValues[i]);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        int length = this.mAdServicesUserChoiceList.size();
        int[] keys = new int[length];
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            keys[i] = this.mAdServicesUserChoiceList.keyAt(i);
            values[i] = this.mAdServicesUserChoiceList.valueAt(i);
        }
        out.writeInt(keys.length);
        out.writeIntArray(keys);
        out.writeIntArray(values);
    }

    public int getUserChoice(int module) {
        return this.mAdServicesUserChoiceList.get(module, 0);
    }

    public Map<Integer, Integer> getUserChoiceMap() {
        int length = this.mAdServicesUserChoiceList.size();
        HashMap<Integer, Integer> userChoicemap = new HashMap<Integer, Integer>(length);
        for (int i = 0; i < length; ++i) {
            userChoicemap.put(this.mAdServicesUserChoiceList.keyAt(i), this.mAdServicesUserChoiceList.valueAt(i));
        }
        return userChoicemap;
    }

    public String toString() {
        return "UpdateAdIdRequest{mAdServicesUserChoiceList=" + this.mAdServicesUserChoiceList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAdServicesUserChoicesParams)) {
            return false;
        }
        UpdateAdServicesUserChoicesParams that = (UpdateAdServicesUserChoicesParams)o;
        return Objects.equals(this.mAdServicesUserChoiceList, that.mAdServicesUserChoiceList);
    }

    public int hashCode() {
        return Objects.hash(this.mAdServicesUserChoiceList);
    }

    public static class Builder {
        private final SparseIntArray mAdServicesUserChoiceList = new SparseIntArray();

        @NonNull
        public Builder setUserChoice(int module, int userChoice) {
            this.mAdServicesUserChoiceList.put(module, userChoice);
            return this;
        }

        @NonNull
        public UpdateAdServicesUserChoicesParams build() {
            return new UpdateAdServicesUserChoicesParams(this.mAdServicesUserChoiceList);
        }
    }
}

