/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdSelectionSignals;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.time.Instant;
import java.util.Objects;

public class FetchAndJoinCustomAudienceInput
implements Parcelable {
    @NonNull
    private final Uri mFetchUri;
    @NonNull
    private final String mCallerPackageName;
    @Nullable
    private final String mName;
    @Nullable
    private final Instant mActivationTime;
    @Nullable
    private final Instant mExpirationTime;
    @Nullable
    private final AdSelectionSignals mUserBiddingSignals;
    @NonNull
    public static final Parcelable.Creator<FetchAndJoinCustomAudienceInput> CREATOR = new Parcelable.Creator<FetchAndJoinCustomAudienceInput>(){

        @Override
        @NonNull
        public FetchAndJoinCustomAudienceInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new FetchAndJoinCustomAudienceInput(in);
        }

        @NonNull
        public FetchAndJoinCustomAudienceInput[] newArray(int size) {
            return new FetchAndJoinCustomAudienceInput[size];
        }
    };

    private FetchAndJoinCustomAudienceInput(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mFetchUri = builder.mFetchUri;
        this.mName = builder.mName;
        this.mActivationTime = builder.mActivationTime;
        this.mExpirationTime = builder.mExpirationTime;
        this.mUserBiddingSignals = builder.mUserBiddingSignals;
        this.mCallerPackageName = builder.mCallerPackageName;
    }

    private FetchAndJoinCustomAudienceInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mFetchUri = Uri.CREATOR.createFromParcel(in);
        this.mName = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> in.readString());
        this.mActivationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mExpirationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mUserBiddingSignals = AdServicesParcelableUtil.readNullableFromParcel(in, AdSelectionSignals.CREATOR::createFromParcel);
        this.mCallerPackageName = in.readString();
    }

    @NonNull
    public Uri getFetchUri() {
        return this.mFetchUri;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Instant getActivationTime() {
        return this.mActivationTime;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.mExpirationTime;
    }

    @Nullable
    public AdSelectionSignals getUserBiddingSignals() {
        return this.mUserBiddingSignals;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mFetchUri.writeToParcel(dest, flags);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mName, Parcel::writeString);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mActivationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mExpirationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mUserBiddingSignals, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
        dest.writeString(this.mCallerPackageName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FetchAndJoinCustomAudienceInput)) {
            return false;
        }
        FetchAndJoinCustomAudienceInput that = (FetchAndJoinCustomAudienceInput)o;
        return ((Object)this.mFetchUri).equals(that.mFetchUri) && this.mCallerPackageName.equals(that.mCallerPackageName) && Objects.equals(this.mName, that.mName) && Objects.equals(this.mActivationTime, that.mActivationTime) && Objects.equals(this.mExpirationTime, that.mExpirationTime) && Objects.equals(this.mUserBiddingSignals, that.mUserBiddingSignals);
    }

    public int hashCode() {
        return Objects.hash(this.mFetchUri, this.mCallerPackageName, this.mName, this.mActivationTime, this.mExpirationTime, this.mUserBiddingSignals);
    }

    public String toString() {
        return "FetchAndJoinCustomAudienceInput{fetchUri=" + this.mFetchUri + ", name=" + this.mName + ", activationTime=" + this.mActivationTime + ", expirationTime=" + this.mExpirationTime + ", userBiddingSignals=" + this.mUserBiddingSignals + ", callerPackageName=" + this.mCallerPackageName + '}';
    }

    public static class Builder {
        @NonNull
        private Uri mFetchUri;
        @NonNull
        private String mCallerPackageName;
        @Nullable
        private String mName;
        @Nullable
        private Instant mActivationTime;
        @Nullable
        private Instant mExpirationTime;
        @Nullable
        private AdSelectionSignals mUserBiddingSignals;

        public Builder(@NonNull Uri fetchUri, @NonNull String callerPackageName) {
            Objects.requireNonNull(fetchUri);
            Objects.requireNonNull(callerPackageName);
            this.mFetchUri = fetchUri;
            this.mCallerPackageName = callerPackageName;
        }

        @NonNull
        public Builder setFetchUri(@NonNull Uri fetchUri) {
            Objects.requireNonNull(fetchUri);
            this.mFetchUri = fetchUri;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setActivationTime(@Nullable Instant activationTime) {
            this.mActivationTime = activationTime;
            return this;
        }

        @NonNull
        public Builder setExpirationTime(@Nullable Instant expirationTime) {
            this.mExpirationTime = expirationTime;
            return this;
        }

        @NonNull
        public Builder setUserBiddingSignals(@Nullable AdSelectionSignals userBiddingSignals) {
            this.mUserBiddingSignals = userBiddingSignals;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public FetchAndJoinCustomAudienceInput build() {
            Objects.requireNonNull(this.mFetchUri);
            Objects.requireNonNull(this.mCallerPackageName);
            return new FetchAndJoinCustomAudienceInput(this);
        }
    }
}

