/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.customaudience.PartialCustomAudience;
import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;

public class ScheduleCustomAudienceUpdateInput
implements Parcelable {
    @NonNull
    private final Uri mUpdateUri;
    @NonNull
    private final String mCallerPackageName;
    @NonNull
    private final Duration mMinDelay;
    @NonNull
    private final List<PartialCustomAudience> mPartialCustomAudienceList;
    private final boolean mShouldReplacePendingUpdates;
    @NonNull
    public static final Parcelable.Creator<ScheduleCustomAudienceUpdateInput> CREATOR = new Parcelable.Creator<ScheduleCustomAudienceUpdateInput>(){

        @Override
        @NonNull
        public ScheduleCustomAudienceUpdateInput createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new ScheduleCustomAudienceUpdateInput(in);
        }

        @NonNull
        public ScheduleCustomAudienceUpdateInput[] newArray(int size) {
            return new ScheduleCustomAudienceUpdateInput[size];
        }
    };

    private ScheduleCustomAudienceUpdateInput(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mUpdateUri = builder.mUpdateUri;
        this.mCallerPackageName = builder.mCallerPackageName;
        this.mMinDelay = builder.mMinDelay;
        this.mPartialCustomAudienceList = builder.mPartialCustomAudienceList;
        this.mShouldReplacePendingUpdates = builder.mShouldReplacePendingUpdates;
    }

    private ScheduleCustomAudienceUpdateInput(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mUpdateUri = Uri.CREATOR.createFromParcel(in);
        this.mCallerPackageName = in.readString();
        this.mMinDelay = Duration.ofMillis(in.readLong());
        this.mPartialCustomAudienceList = in.createTypedArrayList(PartialCustomAudience.CREATOR);
        this.mShouldReplacePendingUpdates = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mUpdateUri.writeToParcel(dest, flags);
        dest.writeString(this.mCallerPackageName);
        dest.writeLong(this.mMinDelay.toMillis());
        dest.writeTypedList(this.mPartialCustomAudienceList);
        dest.writeBoolean(this.mShouldReplacePendingUpdates);
    }

    @NonNull
    public Uri getUpdateUri() {
        return this.mUpdateUri;
    }

    @NonNull
    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    @NonNull
    public Duration getMinDelay() {
        return this.mMinDelay;
    }

    public boolean shouldReplacePendingUpdates() {
        return this.mShouldReplacePendingUpdates;
    }

    @NonNull
    public List<PartialCustomAudience> getPartialCustomAudienceList() {
        return this.mPartialCustomAudienceList;
    }

    public int hashCode() {
        return Objects.hash(this.mUpdateUri, this.mCallerPackageName, this.mMinDelay, this.mPartialCustomAudienceList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleCustomAudienceUpdateInput)) {
            return false;
        }
        ScheduleCustomAudienceUpdateInput that = (ScheduleCustomAudienceUpdateInput)o;
        return ((Object)this.mUpdateUri).equals(that.mUpdateUri) && this.mCallerPackageName.equals(that.mCallerPackageName) && ((Object)this.mMinDelay).equals(that.mMinDelay) && Objects.equals(this.mPartialCustomAudienceList, that.mPartialCustomAudienceList) && this.mShouldReplacePendingUpdates == that.mShouldReplacePendingUpdates;
    }

    public String toString() {
        return "ScheduleCustomAudienceUpdateInput{mUpdateUri=" + this.mUpdateUri + ", mCallerPackageName=" + this.mCallerPackageName + ", mMinDelay=" + this.mMinDelay + ", mPartialCustomAudienceList=" + this.mPartialCustomAudienceList + ", mShouldReplacePendingUpdates=" + this.mShouldReplacePendingUpdates + '}';
    }

    public static class Builder {
        @NonNull
        private Uri mUpdateUri;
        @NonNull
        private Duration mMinDelay;
        @NonNull
        private String mCallerPackageName;
        @NonNull
        private List<PartialCustomAudience> mPartialCustomAudienceList;
        boolean mShouldReplacePendingUpdates;

        public Builder(@NonNull Uri updateUri, @NonNull String callerPackageName, @NonNull Duration minDelay, @NonNull List<PartialCustomAudience> partialCustomAudienceList) {
            Objects.requireNonNull(updateUri);
            Objects.requireNonNull(callerPackageName);
            Objects.requireNonNull(minDelay);
            Objects.requireNonNull(partialCustomAudienceList);
            this.mUpdateUri = updateUri;
            this.mCallerPackageName = callerPackageName;
            this.mMinDelay = minDelay;
            this.mPartialCustomAudienceList = partialCustomAudienceList;
        }

        @NonNull
        public Builder setUpdateUri(@NonNull Uri updateUri) {
            Objects.requireNonNull(updateUri);
            this.mUpdateUri = updateUri;
            return this;
        }

        @NonNull
        public Builder setCallerPackageName(@NonNull String callerPackageName) {
            Objects.requireNonNull(callerPackageName);
            this.mCallerPackageName = callerPackageName;
            return this;
        }

        @NonNull
        public Builder setMinDelay(@NonNull Duration minDelay) {
            Objects.requireNonNull(minDelay);
            this.mMinDelay = minDelay;
            return this;
        }

        @NonNull
        public Builder setPartialCustomAudienceList(@NonNull List<PartialCustomAudience> partialCustomAudiences) {
            this.mPartialCustomAudienceList = partialCustomAudiences;
            return this;
        }

        @NonNull
        public Builder setShouldReplacePendingUpdates(boolean shouldReplacePendingUpdates) {
            this.mShouldReplacePendingUpdates = shouldReplacePendingUpdates;
            return this;
        }

        @NonNull
        public ScheduleCustomAudienceUpdateInput build() {
            Objects.requireNonNull(this.mUpdateUri);
            Objects.requireNonNull(this.mCallerPackageName);
            Objects.requireNonNull(this.mMinDelay);
            Objects.requireNonNull(this.mPartialCustomAudienceList);
            return new ScheduleCustomAudienceUpdateInput(this);
        }
    }
}

