/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.customaudience.PartialCustomAudience;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.net.Uri;
import com.android.internal.util.Preconditions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="com.android.adservices.flags.fledge_schedule_custom_audience_update_enabled")
public class ScheduleCustomAudienceUpdateRequest {
    @NonNull
    private final Uri mUpdateUri;
    @NonNull
    private final Duration mMinDelay;
    @NonNull
    private final List<PartialCustomAudience> mPartialCustomAudienceList;
    private final boolean mShouldReplacePendingUpdates;

    private ScheduleCustomAudienceUpdateRequest(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mUpdateUri = builder.mUpdateUri;
        this.mMinDelay = builder.mMinDelay;
        this.mPartialCustomAudienceList = builder.mPartialCustomAudienceList;
        this.mShouldReplacePendingUpdates = builder.mShouldReplacePendingUpdates;
    }

    @NonNull
    public Uri getUpdateUri() {
        return this.mUpdateUri;
    }

    @NonNull
    public Duration getMinDelay() {
        return this.mMinDelay;
    }

    @NonNull
    public List<PartialCustomAudience> getPartialCustomAudienceList() {
        return this.mPartialCustomAudienceList;
    }

    public boolean shouldReplacePendingUpdates() {
        return this.mShouldReplacePendingUpdates;
    }

    public int hashCode() {
        return Objects.hash(this.mUpdateUri, this.mMinDelay, this.mPartialCustomAudienceList, this.mShouldReplacePendingUpdates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleCustomAudienceUpdateRequest)) {
            return false;
        }
        ScheduleCustomAudienceUpdateRequest that = (ScheduleCustomAudienceUpdateRequest)o;
        return this.mShouldReplacePendingUpdates == that.mShouldReplacePendingUpdates && ((Object)this.mUpdateUri).equals(that.mUpdateUri) && ((Object)this.mMinDelay).equals(that.mMinDelay) && this.mPartialCustomAudienceList.equals(that.mPartialCustomAudienceList);
    }

    public String toString() {
        return "ScheduleCustomAudienceUpdateRequest{mUpdateUri=" + this.mUpdateUri + ", mMinDelay=" + this.mMinDelay + ", mPartialCustomAudienceList=" + this.mPartialCustomAudienceList + ", mShouldReplacePendingUpdates=" + this.mShouldReplacePendingUpdates + '}';
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_schedule_custom_audience_update_enabled")
    public static class Builder {
        @NonNull
        private Uri mUpdateUri;
        @NonNull
        private Duration mMinDelay;
        @NonNull
        private List<PartialCustomAudience> mPartialCustomAudienceList;
        private boolean mShouldReplacePendingUpdates;

        @Deprecated
        public Builder(@NonNull Uri updateUri, @NonNull Duration minDelay, @NonNull List<PartialCustomAudience> partialCustomAudienceList) {
            this.setRequiredFields(updateUri, minDelay);
            this.setPartialCustomAudienceList(partialCustomAudienceList);
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_enable_schedule_custom_audience_default_partial_custom_audiences_constructor")
        public Builder(@NonNull Uri updateUri, @NonNull Duration minDelay) {
            this.setRequiredFields(updateUri, minDelay);
        }

        private void setRequiredFields(@NonNull Uri updateUri, @NonNull Duration minDelay) {
            this.mUpdateUri = Objects.requireNonNull(updateUri, "Update URI must not be null");
            this.mMinDelay = Objects.requireNonNull(minDelay, "Minimum delay must not be null");
            Preconditions.checkArgument(!minDelay.isNegative(), "Minimum delay %s must not be negative", minDelay);
        }

        @NonNull
        public Builder setUpdateUri(@NonNull Uri updateUri) {
            this.mUpdateUri = Objects.requireNonNull(updateUri, "Update URI must not be null");
            return this;
        }

        @NonNull
        public Builder setMinDelay(@NonNull Duration minDelay) {
            Objects.requireNonNull(minDelay, "Minimum delay must not be null");
            Preconditions.checkArgument(!minDelay.isNegative(), "Minimum delay %s must not be negative", minDelay);
            this.mMinDelay = minDelay;
            return this;
        }

        @NonNull
        public Builder setPartialCustomAudienceList(@NonNull List<PartialCustomAudience> partialCustomAudienceList) {
            this.mPartialCustomAudienceList = Objects.requireNonNull(partialCustomAudienceList, "Partial custom audience list must not be null");
            return this;
        }

        @NonNull
        public Builder setShouldReplacePendingUpdates(boolean shouldReplacePendingUpdates) {
            this.mShouldReplacePendingUpdates = shouldReplacePendingUpdates;
            return this;
        }

        @NonNull
        public ScheduleCustomAudienceUpdateRequest build() {
            if (Objects.isNull(this.mPartialCustomAudienceList)) {
                this.mPartialCustomAudienceList = Collections.emptyList();
            }
            return new ScheduleCustomAudienceUpdateRequest(this);
        }
    }
}

