/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.customaudience.AddCustomAudienceOverrideRequest;
import android.adservices.customaudience.CustomAudienceManager;
import android.adservices.customaudience.CustomAudienceOverrideCallback;
import android.adservices.customaudience.ICustomAudienceService;
import android.adservices.customaudience.RemoveCustomAudienceOverrideRequest;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import com.android.adservices.LoggerFactory;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class TestCustomAudienceManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    private final CustomAudienceManager mCustomAudienceManager;
    private final String mCallerPackageName;

    TestCustomAudienceManager(@NonNull CustomAudienceManager customAudienceManager, @NonNull String callerPackageName) {
        Objects.requireNonNull(customAudienceManager);
        Objects.requireNonNull(callerPackageName);
        this.mCustomAudienceManager = customAudienceManager;
        this.mCallerPackageName = callerPackageName;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void overrideCustomAudienceRemoteInfo(@NonNull AddCustomAudienceOverrideRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.overrideCustomAudienceRemoteInfo(this.mCallerPackageName, request.getBuyer(), request.getName(), request.getBiddingLogicJs(), request.getBiddingLogicJsVersion(), request.getTrustedBiddingSignals(), new CustomAudienceOverrideCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void removeCustomAudienceRemoteInfoOverride(@NonNull RemoveCustomAudienceOverrideRequest request, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.removeCustomAudienceRemoteInfoOverride(this.mCallerPackageName, request.getBuyer(), request.getName(), new CustomAudienceOverrideCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_CUSTOM_AUDIENCE")
    public void resetAllCustomAudienceOverrides(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            ICustomAudienceService service = this.mCustomAudienceManager.getService();
            service.resetAllCustomAudienceOverrides(new CustomAudienceOverrideCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }
}

