/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.annotation.NonNull;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DeletionParam
implements Parcelable {
    private final List<Uri> mOriginUris;
    private final List<Uri> mDomainUris;
    private final Instant mStart;
    private final Instant mEnd;
    private final String mAppPackageName;
    private final String mSdkPackageName;
    private final int mDeletionMode;
    private final int mMatchBehavior;
    @NonNull
    public static final Parcelable.Creator<DeletionParam> CREATOR = new Parcelable.Creator<DeletionParam>(){

        @Override
        public DeletionParam createFromParcel(Parcel in) {
            return new DeletionParam(in);
        }

        public DeletionParam[] newArray(int size) {
            return new DeletionParam[size];
        }
    };

    private DeletionParam(@NonNull Builder builder) {
        this.mOriginUris = builder.mOriginUris;
        this.mDomainUris = builder.mDomainUris;
        this.mDeletionMode = builder.mDeletionMode;
        this.mMatchBehavior = builder.mMatchBehavior;
        this.mStart = builder.mStart;
        this.mEnd = builder.mEnd;
        this.mAppPackageName = builder.mAppPackageName;
        this.mSdkPackageName = builder.mSdkPackageName;
    }

    private DeletionParam(Parcel in) {
        this.mAppPackageName = in.readString();
        this.mSdkPackageName = in.readString();
        this.mDomainUris = new ArrayList<Uri>();
        in.readTypedList(this.mDomainUris, Uri.CREATOR);
        this.mOriginUris = new ArrayList<Uri>();
        in.readTypedList(this.mOriginUris, Uri.CREATOR);
        boolean hasStart = in.readBoolean();
        this.mStart = hasStart ? Instant.parse(in.readString()) : null;
        boolean hasEnd = in.readBoolean();
        this.mEnd = hasEnd ? Instant.parse(in.readString()) : null;
        this.mDeletionMode = in.readInt();
        this.mMatchBehavior = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeString(this.mAppPackageName);
        out.writeString(this.mSdkPackageName);
        out.writeTypedList(this.mDomainUris);
        out.writeTypedList(this.mOriginUris);
        if (this.mStart != null) {
            out.writeBoolean(true);
            out.writeString(((Object)this.mStart).toString());
        } else {
            out.writeBoolean(false);
        }
        if (this.mEnd != null) {
            out.writeBoolean(true);
            out.writeString(((Object)this.mEnd).toString());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.mDeletionMode);
        out.writeInt(this.mMatchBehavior);
    }

    @NonNull
    public List<Uri> getOriginUris() {
        return this.mOriginUris;
    }

    @NonNull
    public List<Uri> getDomainUris() {
        return this.mDomainUris;
    }

    public int getDeletionMode() {
        return this.mDeletionMode;
    }

    public int getMatchBehavior() {
        return this.mMatchBehavior;
    }

    @NonNull
    public Instant getStart() {
        return this.mStart;
    }

    @NonNull
    public Instant getEnd() {
        return this.mEnd;
    }

    @NonNull
    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    @NonNull
    public String getSdkPackageName() {
        return this.mSdkPackageName;
    }

    public static class Builder {
        private final List<Uri> mOriginUris;
        private final List<Uri> mDomainUris;
        private final Instant mStart;
        private final Instant mEnd;
        private final String mAppPackageName;
        private final String mSdkPackageName;
        private int mDeletionMode;
        private int mMatchBehavior;

        public Builder(@NonNull List<Uri> originUris, @NonNull List<Uri> domainUris, @NonNull Instant start, @NonNull Instant end, @NonNull String appPackageName, @NonNull String sdkPackageName) {
            Objects.requireNonNull(originUris);
            Objects.requireNonNull(domainUris);
            Objects.requireNonNull(start);
            Objects.requireNonNull(end);
            Objects.requireNonNull(appPackageName);
            Objects.requireNonNull(sdkPackageName);
            this.mOriginUris = originUris;
            this.mDomainUris = domainUris;
            this.mStart = start;
            this.mEnd = end;
            this.mAppPackageName = appPackageName;
            this.mSdkPackageName = sdkPackageName;
        }

        @NonNull
        public Builder setDeletionMode(int deletionMode) {
            this.mDeletionMode = deletionMode;
            return this;
        }

        @NonNull
        public Builder setMatchBehavior(int matchBehavior) {
            this.mMatchBehavior = matchBehavior;
            return this;
        }

        @NonNull
        public DeletionParam build() {
            return new DeletionParam(this);
        }
    }
}

