/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.view.InputEvent;
import com.android.adservices.AdServicesParcelableUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SourceRegistrationRequest
implements Parcelable {
    private static final int REGISTRATION_URIS_MAX_COUNT = 20;
    @NonNull
    private final List<Uri> mRegistrationUris;
    @Nullable
    private final InputEvent mInputEvent;
    @NonNull
    public static final Parcelable.Creator<SourceRegistrationRequest> CREATOR = new Parcelable.Creator<SourceRegistrationRequest>(){

        @Override
        public SourceRegistrationRequest createFromParcel(Parcel in) {
            return new SourceRegistrationRequest(in);
        }

        public SourceRegistrationRequest[] newArray(int size) {
            return new SourceRegistrationRequest[size];
        }
    };

    private SourceRegistrationRequest(@NonNull Builder builder) {
        this.mRegistrationUris = builder.mRegistrationUris;
        this.mInputEvent = builder.mInputEvent;
    }

    private SourceRegistrationRequest(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        ArrayList<Uri> registrationsUris = new ArrayList<Uri>();
        if (_Original_Build.VERSION.SDK_INT < 33) {
            in.readList(registrationsUris, Uri.class.getClassLoader());
        } else {
            in.readList(registrationsUris, Uri.class.getClassLoader(), Uri.class);
        }
        this.mRegistrationUris = registrationsUris;
        this.mInputEvent = AdServicesParcelableUtil.readNullableFromParcel(in, InputEvent.CREATOR::createFromParcel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceRegistrationRequest)) {
            return false;
        }
        SourceRegistrationRequest that = (SourceRegistrationRequest)o;
        return Objects.equals(this.mRegistrationUris, that.mRegistrationUris) && Objects.equals(this.mInputEvent, that.mInputEvent);
    }

    public int hashCode() {
        return Objects.hash(this.mRegistrationUris, this.mInputEvent);
    }

    @NonNull
    public List<Uri> getRegistrationUris() {
        return this.mRegistrationUris;
    }

    @Nullable
    public InputEvent getInputEvent() {
        return this.mInputEvent;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        Objects.requireNonNull(out);
        out.writeList(this.mRegistrationUris);
        AdServicesParcelableUtil.writeNullableToParcel(out, this.mInputEvent, (target, event) -> event.writeToParcel(target, flags));
    }

    public static class Builder {
        @NonNull
        private final List<Uri> mRegistrationUris;
        @Nullable
        private InputEvent mInputEvent;

        public Builder(@NonNull List<Uri> registrationUris) {
            Objects.requireNonNull(registrationUris);
            if (registrationUris.isEmpty() || registrationUris.size() > 20) {
                throw new IllegalArgumentException(String.format("Requests should have at least 1 and at most %d URIs. Request has %d URIs.", 20, registrationUris.size()));
            }
            for (Uri registrationUri : registrationUris) {
                if (registrationUri.getScheme() != null && registrationUri.getScheme().equalsIgnoreCase("https")) continue;
                throw new IllegalArgumentException("registrationUri must have an HTTPS scheme");
            }
            this.mRegistrationUris = registrationUris;
        }

        @NonNull
        public Builder setInputEvent(@Nullable InputEvent inputEvent) {
            this.mInputEvent = inputEvent;
            return this;
        }

        @NonNull
        public SourceRegistrationRequest build() {
            return new SourceRegistrationRequest(this);
        }
    }
}

