/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.res.ConstantState;
import android.util.StateSet;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class StateListAnimator
implements Cloneable {
    private ArrayList<Tuple> mTuples = new ArrayList();
    private Tuple mLastMatch = null;
    private Animator mRunningAnimator = null;
    private WeakReference<View> mViewRef;
    private StateListAnimatorConstantState mConstantState;
    private AnimatorListenerAdapter mAnimatorListener;
    private int mChangingConfigurations;

    public StateListAnimator() {
        this.initAnimatorListener();
    }

    private void initAnimatorListener() {
        this.mAnimatorListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                animation.setTarget(null);
                if (StateListAnimator.this.mRunningAnimator == animation) {
                    StateListAnimator.this.mRunningAnimator = null;
                }
            }
        };
    }

    public void addState(int[] specs, Animator animator2) {
        Tuple tuple = new Tuple(specs, animator2);
        tuple.mAnimator.addListener(this.mAnimatorListener);
        this.mTuples.add(tuple);
        this.mChangingConfigurations |= animator2.getChangingConfigurations();
    }

    public Animator getRunningAnimator() {
        return this.mRunningAnimator;
    }

    public View getTarget() {
        return this.mViewRef == null ? null : (View)this.mViewRef.get();
    }

    public void setTarget(View view) {
        View current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.mViewRef = new WeakReference<View>(view);
        }
    }

    private void clearTarget() {
        int size = this.mTuples.size();
        for (int i = 0; i < size; ++i) {
            this.mTuples.get((int)i).mAnimator.setTarget(null);
        }
        this.mViewRef = null;
        this.mLastMatch = null;
        this.mRunningAnimator = null;
    }

    public StateListAnimator clone() {
        try {
            StateListAnimator clone = (StateListAnimator)super.clone();
            clone.mTuples = new ArrayList(this.mTuples.size());
            clone.mLastMatch = null;
            clone.mRunningAnimator = null;
            clone.mViewRef = null;
            clone.mAnimatorListener = null;
            clone.initAnimatorListener();
            int tupleSize = this.mTuples.size();
            for (int i = 0; i < tupleSize; ++i) {
                Tuple tuple = this.mTuples.get(i);
                Animator animatorClone = tuple.mAnimator.clone();
                animatorClone.removeListener(this.mAnimatorListener);
                clone.addState(tuple.mSpecs, animatorClone);
            }
            clone.setChangingConfigurations(this.getChangingConfigurations());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("cannot clone state list animator", e);
        }
    }

    public void setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches(tuple.mSpecs, state)) continue;
            match = tuple;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private void start(Tuple match) {
        match.mAnimator.setTarget(this.getTarget());
        this.mRunningAnimator = match.mAnimator;
        this.mRunningAnimator.start();
    }

    private void cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    public ArrayList<Tuple> getTuples() {
        return this.mTuples;
    }

    public void jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
        }
    }

    public int getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    public void setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    public void appendChangingConfigurations(int configs) {
        this.mChangingConfigurations |= configs;
    }

    public ConstantState<StateListAnimator> createConstantState() {
        return new StateListAnimatorConstantState(this);
    }

    public static class Tuple {
        final int[] mSpecs;
        final Animator mAnimator;

        private Tuple(int[] specs, Animator animator2) {
            this.mSpecs = specs;
            this.mAnimator = animator2;
        }

        public int[] getSpecs() {
            return this.mSpecs;
        }

        public Animator getAnimator() {
            return this.mAnimator;
        }
    }

    private static class StateListAnimatorConstantState
    extends ConstantState<StateListAnimator> {
        final StateListAnimator mAnimator;
        int mChangingConf;

        public StateListAnimatorConstantState(StateListAnimator animator2) {
            this.mAnimator = animator2;
            this.mAnimator.mConstantState = this;
            this.mChangingConf = this.mAnimator.getChangingConfigurations();
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConf;
        }

        @Override
        public StateListAnimator newInstance() {
            StateListAnimator clone = this.mAnimator.clone();
            clone.mConstantState = this;
            return clone;
        }
    }
}

