/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.net.Uri;
import android.os.FileUtils;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import libcore.io.ForwardingOs;
import libcore.io.IoUtils;

class AndroidForwardingOs
extends ForwardingOs {
    private static final String TAG = "AndroidForwardingOs";

    public static void install() {
        libcore.io.Os def;
        while (!libcore.io.Os.compareAndSetDefault(def = libcore.io.Os.getDefault(), new AndroidForwardingOs(def))) {
        }
    }

    private AndroidForwardingOs(libcore.io.Os os) {
        super(os);
    }

    private FileDescriptor openDeprecatedDataPath(String path, int mode) throws ErrnoException {
        Uri uri = ContentResolver.translateDeprecatedDataPath(path);
        Log.v(TAG, "Redirecting " + path + " to " + uri);
        ContentResolver cr = ActivityThread.currentActivityThread().getApplication().getContentResolver();
        try {
            FileDescriptor fd = new FileDescriptor();
            fd.setInt$(cr.openFileDescriptor(uri, FileUtils.translateModePosixToString(mode)).detachFd());
            return fd;
        }
        catch (SecurityException e) {
            throw new ErrnoException(e.getMessage(), OsConstants.EACCES);
        }
        catch (FileNotFoundException e) {
            throw new ErrnoException(e.getMessage(), OsConstants.ENOENT);
        }
    }

    private void deleteDeprecatedDataPath(String path) throws ErrnoException {
        Uri uri = ContentResolver.translateDeprecatedDataPath(path);
        Log.v(TAG, "Redirecting " + path + " to " + uri);
        ContentResolver cr = ActivityThread.currentActivityThread().getApplication().getContentResolver();
        try {
            if (cr.delete(uri, null, null) == 0) {
                throw new FileNotFoundException();
            }
        }
        catch (SecurityException e) {
            throw new ErrnoException(e.getMessage(), OsConstants.EACCES);
        }
        catch (FileNotFoundException e) {
            throw new ErrnoException(e.getMessage(), OsConstants.ENOENT);
        }
    }

    @Override
    public boolean access(String path, int mode) throws ErrnoException {
        if (path != null && path.startsWith("/mnt/content/")) {
            IoUtils.closeQuietly(this.openDeprecatedDataPath(path, FileUtils.translateModeAccessToPosix(mode)));
            return true;
        }
        return super.access(path, mode);
    }

    @Override
    public FileDescriptor open(String path, int flags, int mode) throws ErrnoException {
        if (path != null && path.startsWith("/mnt/content/")) {
            return this.openDeprecatedDataPath(path, mode);
        }
        return super.open(path, flags, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StructStat stat(String path) throws ErrnoException {
        if (path != null && path.startsWith("/mnt/content/")) {
            FileDescriptor fd = this.openDeprecatedDataPath(path, OsConstants.O_RDONLY);
            try {
                StructStat structStat = Os.fstat(fd);
                return structStat;
            }
            finally {
                IoUtils.closeQuietly(fd);
            }
        }
        return super.stat(path);
    }

    @Override
    public void unlink(String path) throws ErrnoException {
        if (path != null && path.startsWith("/mnt/content/")) {
            this.deleteDeprecatedDataPath(path);
        } else {
            super.unlink(path);
        }
    }

    @Override
    public void remove(String path) throws ErrnoException {
        if (path != null && path.startsWith("/mnt/content/")) {
            this.deleteDeprecatedDataPath(path);
        } else {
            super.remove(path);
        }
    }

    @Override
    public void rename(String oldPath, String newPath) throws ErrnoException {
        try {
            super.rename(oldPath, newPath);
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.EXDEV && oldPath.startsWith("/storage/emulated") && newPath.startsWith("/storage/emulated")) {
                Log.v(TAG, "Recovering failed rename " + oldPath + " to " + newPath);
                try {
                    Files.move(new File(oldPath).toPath(), new File(newPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e2) {
                    Log.e(TAG, "Rename recovery failed ", e2);
                    throw e;
                }
            }
            throw e;
        }
    }
}

