/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.Intent;
import android.icu.text.SimpleDateFormat;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Xml;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.WireTypeMismatchException;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.app.Flags;
import com.android.internal.util.XmlUtils;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class ApplicationStartInfo
implements Parcelable {
    public static final int STARTUP_STATE_STARTED = 0;
    public static final int STARTUP_STATE_ERROR = 1;
    public static final int STARTUP_STATE_FIRST_FRAME_DRAWN = 2;
    public static final int START_REASON_ALARM = 0;
    public static final int START_REASON_BACKUP = 1;
    public static final int START_REASON_BOOT_COMPLETE = 2;
    public static final int START_REASON_BROADCAST = 3;
    public static final int START_REASON_CONTENT_PROVIDER = 4;
    public static final int START_REASON_JOB = 5;
    public static final int START_REASON_LAUNCHER = 6;
    public static final int START_REASON_LAUNCHER_RECENTS = 7;
    public static final int START_REASON_OTHER = 8;
    public static final int START_REASON_PUSH = 9;
    public static final int START_REASON_SERVICE = 10;
    public static final int START_REASON_START_ACTIVITY = 11;
    public static final int START_TYPE_UNSET = 0;
    public static final int START_TYPE_COLD = 1;
    public static final int START_TYPE_WARM = 2;
    public static final int START_TYPE_HOT = 3;
    public static final int LAUNCH_MODE_STANDARD = 0;
    public static final int LAUNCH_MODE_SINGLE_TOP = 1;
    public static final int LAUNCH_MODE_SINGLE_INSTANCE = 2;
    public static final int LAUNCH_MODE_SINGLE_TASK = 3;
    public static final int LAUNCH_MODE_SINGLE_INSTANCE_PER_TASK = 4;
    public static final int START_TIMESTAMP_RESERVED_RANGE_SYSTEM = 20;
    public static final int START_TIMESTAMP_RESERVED_RANGE_DEVELOPER_START = 21;
    public static final int START_TIMESTAMP_RESERVED_RANGE_DEVELOPER = 30;
    public static final int START_TIMESTAMP_LAUNCH = 0;
    public static final int START_TIMESTAMP_FORK = 1;
    public static final int START_TIMESTAMP_APPLICATION_ONCREATE = 2;
    public static final int START_TIMESTAMP_BIND_APPLICATION = 3;
    public static final int START_TIMESTAMP_FIRST_FRAME = 4;
    public static final int START_TIMESTAMP_FULLY_DRAWN = 5;
    public static final int START_TIMESTAMP_INITIAL_RENDERTHREAD_FRAME = 6;
    public static final int START_TIMESTAMP_SURFACEFLINGER_COMPOSITION_COMPLETE = 7;
    @FlaggedApi(value="android.app.app_start_info_component")
    public static final int START_COMPONENT_ACTIVITY = 1;
    @FlaggedApi(value="android.app.app_start_info_component")
    public static final int START_COMPONENT_BROADCAST = 2;
    @FlaggedApi(value="android.app.app_start_info_component")
    public static final int START_COMPONENT_CONTENT_PROVIDER = 3;
    @FlaggedApi(value="android.app.app_start_info_component")
    public static final int START_COMPONENT_SERVICE = 4;
    @FlaggedApi(value="android.app.app_start_info_component")
    public static final int START_COMPONENT_OTHER = 5;
    private long mMonotonicCreationTimeMs;
    private int mStartupState;
    private int mPid;
    private int mRealUid;
    private int mPackageUid;
    private int mDefiningUid;
    private String mPackageName;
    private String mProcessName;
    private int mReason;
    private ArrayMap<Integer, Long> mStartupTimestampsNs;
    private int mStartType;
    private Intent mStartIntent;
    private int mLaunchMode;
    private boolean mWasForceStopped;
    private int mStartComponent;
    @NonNull
    public static final Parcelable.Creator<ApplicationStartInfo> CREATOR = new Parcelable.Creator<ApplicationStartInfo>(){

        @Override
        public ApplicationStartInfo createFromParcel(Parcel in) {
            return new ApplicationStartInfo(in);
        }

        public ApplicationStartInfo[] newArray(int size) {
            return new ApplicationStartInfo[size];
        }
    };
    private static final String PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMPS = "timestamps";
    private static final String PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMP = "timestamp";
    private static final String PROTO_SERIALIZER_ATTRIBUTE_KEY = "key";
    private static final String PROTO_SERIALIZER_ATTRIBUTE_TS = "ts";
    private static final String PROTO_SERIALIZER_ATTRIBUTE_INTENT = "intent";

    public void setStartupState(int startupState) {
        this.mStartupState = startupState;
    }

    public void setPid(int pid) {
        this.mPid = pid;
    }

    public void setRealUid(int uid) {
        this.mRealUid = uid;
    }

    public void setPackageUid(int uid) {
        this.mPackageUid = uid;
    }

    public void setDefiningUid(int uid) {
        this.mDefiningUid = uid;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = ApplicationStartInfo.intern(packageName);
    }

    public void setProcessName(String processName) {
        this.mProcessName = ApplicationStartInfo.intern(processName);
    }

    public void setReason(int reason) {
        this.mReason = reason;
    }

    public void addStartupTimestamp(int key, long timestampNs) {
        if (key < 0 || key > 30) {
            return;
        }
        if (this.mStartupTimestampsNs == null) {
            this.mStartupTimestampsNs = new ArrayMap();
        }
        this.mStartupTimestampsNs.put(key, timestampNs);
    }

    public void setStartType(int startType) {
        this.mStartType = startType;
    }

    public void setIntent(Intent startIntent) {
        if (startIntent != null) {
            this.mStartIntent = startIntent.canStripForHistory() ? startIntent.maybeStripForHistory() : (startIntent.getExtras() != null ? startIntent.cloneFilter() : new Intent(startIntent));
            if (this.mStartIntent.getOriginalIntent() != null) {
                this.mStartIntent.setOriginalIntent(null);
            }
        }
    }

    public void setLaunchMode(int launchMode) {
        this.mLaunchMode = launchMode;
    }

    public void setForceStopped(boolean wasForceStopped) {
        this.mWasForceStopped = wasForceStopped;
    }

    public void setStartComponent(int startComponent) {
        this.mStartComponent = startComponent;
    }

    public int getStartupState() {
        return this.mStartupState;
    }

    public long getMonotonicCreationTimeMs() {
        return this.mMonotonicCreationTimeMs;
    }

    public int getPid() {
        return this.mPid;
    }

    public int getRealUid() {
        return this.mRealUid;
    }

    public int getPackageUid() {
        return this.mPackageUid;
    }

    public int getDefiningUid() {
        return this.mDefiningUid;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getProcessName() {
        return this.mProcessName;
    }

    public int getReason() {
        return this.mReason;
    }

    @NonNull
    public Map<Integer, Long> getStartupTimestamps() {
        if (this.mStartupTimestampsNs == null) {
            this.mStartupTimestampsNs = new ArrayMap();
        }
        return this.mStartupTimestampsNs;
    }

    public int getStartType() {
        return this.mStartType;
    }

    @SuppressLint(value={"IntentBuilderName"})
    @Nullable
    public Intent getIntent() {
        return this.mStartIntent;
    }

    public int getLaunchMode() {
        return this.mLaunchMode;
    }

    @FlaggedApi(value="android.content.pm.stay_stopped")
    public boolean wasForceStopped() {
        return this.mWasForceStopped;
    }

    @FlaggedApi(value="android.app.app_start_info_component")
    public int getStartComponent() {
        return this.mStartComponent;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStartupState);
        dest.writeInt(this.mPid);
        dest.writeInt(this.mRealUid);
        dest.writeInt(this.mPackageUid);
        dest.writeInt(this.mDefiningUid);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mProcessName);
        dest.writeInt(this.mReason);
        dest.writeInt(this.mStartupTimestampsNs == null ? 0 : this.mStartupTimestampsNs.size());
        if (this.mStartupTimestampsNs != null) {
            for (int i = 0; i < this.mStartupTimestampsNs.size(); ++i) {
                dest.writeInt(this.mStartupTimestampsNs.keyAt(i));
                dest.writeLong(this.mStartupTimestampsNs.valueAt(i));
            }
        }
        dest.writeInt(this.mStartType);
        dest.writeParcelable(this.mStartIntent, flags);
        dest.writeInt(this.mLaunchMode);
        dest.writeBoolean(this.mWasForceStopped);
        dest.writeLong(this.mMonotonicCreationTimeMs);
        dest.writeInt(this.mStartComponent);
    }

    public ApplicationStartInfo(long monotonicCreationTimeMs) {
        this.mMonotonicCreationTimeMs = monotonicCreationTimeMs;
    }

    public ApplicationStartInfo(ApplicationStartInfo other) {
        this.mStartupState = other.mStartupState;
        this.mPid = other.mPid;
        this.mRealUid = other.mRealUid;
        this.mPackageUid = other.mPackageUid;
        this.mDefiningUid = other.mDefiningUid;
        this.mPackageName = other.mPackageName;
        this.mProcessName = other.mProcessName;
        this.mReason = other.mReason;
        this.mStartupTimestampsNs = other.mStartupTimestampsNs;
        this.mStartType = other.mStartType;
        this.mStartIntent = other.mStartIntent;
        this.mLaunchMode = other.mLaunchMode;
        this.mWasForceStopped = other.mWasForceStopped;
        this.mMonotonicCreationTimeMs = other.mMonotonicCreationTimeMs;
        this.mStartComponent = other.mStartComponent;
    }

    @VisibleForTesting
    public ApplicationStartInfo(@NonNull Parcel in) {
        this.mStartupState = in.readInt();
        this.mPid = in.readInt();
        this.mRealUid = in.readInt();
        this.mPackageUid = in.readInt();
        this.mDefiningUid = in.readInt();
        this.mPackageName = ApplicationStartInfo.intern(in.readString());
        this.mProcessName = ApplicationStartInfo.intern(in.readString());
        this.mReason = in.readInt();
        int starupTimestampCount = in.readInt();
        for (int i = 0; i < starupTimestampCount; ++i) {
            int key = in.readInt();
            long val = in.readLong();
            this.addStartupTimestamp(key, val);
        }
        this.mStartType = in.readInt();
        this.mStartIntent = in.readParcelable(Intent.class.getClassLoader(), Intent.class);
        this.mLaunchMode = in.readInt();
        this.mWasForceStopped = in.readBoolean();
        this.mMonotonicCreationTimeMs = in.readLong();
        this.mStartComponent = in.readInt();
    }

    private static String intern(@Nullable String source) {
        return source != null ? source.intern() : null;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId, ByteArrayOutputStream byteArrayOutputStream, ObjectOutputStream objectOutputStream, TypedXmlSerializer typedXmlSerializer) throws IOException {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.mPid);
        proto.write(1120986464258L, this.mRealUid);
        proto.write(1120986464259L, this.mPackageUid);
        proto.write(1120986464260L, this.mDefiningUid);
        proto.write(1138166333445L, this.mProcessName);
        proto.write(1159641169926L, this.mStartupState);
        proto.write(1159641169927L, this.mReason);
        if (this.mStartupTimestampsNs != null && this.mStartupTimestampsNs.size() > 0) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            typedXmlSerializer = Xml.resolveSerializer(objectOutputStream);
            typedXmlSerializer.startDocument(null, true);
            typedXmlSerializer.startTag(null, PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMPS);
            for (int i = 0; i < this.mStartupTimestampsNs.size(); ++i) {
                typedXmlSerializer.startTag(null, PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMP);
                typedXmlSerializer.attributeInt(null, PROTO_SERIALIZER_ATTRIBUTE_KEY, this.mStartupTimestampsNs.keyAt(i));
                typedXmlSerializer.attributeLong(null, PROTO_SERIALIZER_ATTRIBUTE_TS, this.mStartupTimestampsNs.valueAt(i));
                typedXmlSerializer.endTag(null, PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMP);
            }
            typedXmlSerializer.endTag(null, PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMPS);
            typedXmlSerializer.endDocument();
            proto.write(1151051235336L, byteArrayOutputStream.toByteArray());
            objectOutputStream.close();
        }
        proto.write(1159641169929L, this.mStartType);
        if (this.mStartIntent != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            typedXmlSerializer = Xml.resolveSerializer(objectOutputStream);
            typedXmlSerializer.startDocument(null, true);
            typedXmlSerializer.startTag(null, PROTO_SERIALIZER_ATTRIBUTE_INTENT);
            this.mStartIntent.saveToXml(typedXmlSerializer);
            typedXmlSerializer.endTag(null, PROTO_SERIALIZER_ATTRIBUTE_INTENT);
            typedXmlSerializer.endDocument();
            proto.write(1151051235338L, byteArrayOutputStream.toByteArray());
            objectOutputStream.close();
        }
        proto.write(1159641169931L, this.mLaunchMode);
        proto.write(1133871366156L, this.mWasForceStopped);
        proto.write(1112396529677L, this.mMonotonicCreationTimeMs);
        proto.write(1120986464270L, this.mStartComponent);
        proto.end(token);
    }

    public void readFromProto(ProtoInputStream proto, long fieldId, ByteArrayInputStream byteArrayInputStream, ObjectInputStream objectInputStream, TypedXmlPullParser typedXmlPullParser) throws IOException, WireTypeMismatchException, ClassNotFoundException {
        long token = proto.start(fieldId);
        while (proto.nextField() != -1) {
            switch (proto.getFieldNumber()) {
                case 1: {
                    this.mPid = proto.readInt(0x10500000001L);
                    break;
                }
                case 2: {
                    this.mRealUid = proto.readInt(1120986464258L);
                    break;
                }
                case 3: {
                    this.mPackageUid = proto.readInt(1120986464259L);
                    break;
                }
                case 4: {
                    this.mDefiningUid = proto.readInt(1120986464260L);
                    break;
                }
                case 5: {
                    this.mProcessName = ApplicationStartInfo.intern(proto.readString(1138166333445L));
                    break;
                }
                case 6: {
                    this.mStartupState = proto.readInt(1159641169926L);
                    break;
                }
                case 7: {
                    this.mReason = proto.readInt(1159641169927L);
                    break;
                }
                case 8: {
                    byteArrayInputStream = new ByteArrayInputStream(proto.readBytes(1151051235336L));
                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    this.mStartupTimestampsNs = new ArrayMap();
                    try {
                        typedXmlPullParser = Xml.resolvePullParser(objectInputStream);
                        XmlUtils.beginDocument(typedXmlPullParser, PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMPS);
                        int depth = typedXmlPullParser.getDepth();
                        while (XmlUtils.nextElementWithin(typedXmlPullParser, depth)) {
                            if (!PROTO_SERIALIZER_ATTRIBUTE_TIMESTAMP.equals(typedXmlPullParser.getName())) continue;
                            int key = typedXmlPullParser.getAttributeInt(null, PROTO_SERIALIZER_ATTRIBUTE_KEY);
                            long ts = typedXmlPullParser.getAttributeLong(null, PROTO_SERIALIZER_ATTRIBUTE_TS);
                            this.mStartupTimestampsNs.put(key, ts);
                        }
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                    objectInputStream.close();
                    break;
                }
                case 9: {
                    this.mStartType = proto.readInt(1159641169929L);
                    break;
                }
                case 10: {
                    byteArrayInputStream = new ByteArrayInputStream(proto.readBytes(1151051235338L));
                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    try {
                        typedXmlPullParser = Xml.resolvePullParser(objectInputStream);
                        XmlUtils.beginDocument(typedXmlPullParser, PROTO_SERIALIZER_ATTRIBUTE_INTENT);
                        this.mStartIntent = Intent.restoreFromXml(typedXmlPullParser);
                    }
                    catch (XmlPullParserException xmlPullParserException) {
                        // empty catch block
                    }
                    objectInputStream.close();
                    break;
                }
                case 11: {
                    this.mLaunchMode = proto.readInt(1159641169931L);
                    break;
                }
                case 12: {
                    this.mWasForceStopped = proto.readBoolean(1133871366156L);
                    break;
                }
                case 13: {
                    this.mMonotonicCreationTimeMs = proto.readLong(1112396529677L);
                    break;
                }
                case 14: {
                    this.mStartComponent = proto.readInt(1120986464270L);
                }
            }
        }
        proto.end(token);
    }

    public void dump(@NonNull PrintWriter pw, @Nullable String prefix, @Nullable String seqSuffix, @NonNull SimpleDateFormat sdf) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("ApplicationStartInfo ").append(seqSuffix).append(':').append('\n').append(" monotonicCreationTimeMs=").append(this.mMonotonicCreationTimeMs).append('\n').append(" pid=").append(this.mPid).append(" realUid=").append(this.mRealUid).append(" packageUid=").append(this.mPackageUid).append(" definingUid=").append(this.mDefiningUid).append(" user=").append(UserHandle.getUserId(this.mPackageUid)).append('\n').append(" package=").append(this.mPackageName).append(" process=").append(this.mProcessName).append(" startupState=").append(this.mStartupState).append(" reason=").append(ApplicationStartInfo.reasonToString(this.mReason)).append(" startType=").append(ApplicationStartInfo.startTypeToString(this.mStartType)).append(" launchMode=").append(this.mLaunchMode).append(" wasForceStopped=").append(this.mWasForceStopped);
        if (Flags.appStartInfoComponent()) {
            sb.append(" startComponent=").append(ApplicationStartInfo.startComponentToString(this.mStartComponent));
        }
        sb.append('\n');
        if (this.mStartIntent != null) {
            sb.append(" intent=").append(this.mStartIntent.toString()).append('\n');
        }
        if (this.mStartupTimestampsNs != null && this.mStartupTimestampsNs.size() > 0) {
            sb.append(" timestamps: ");
            for (int i = 0; i < this.mStartupTimestampsNs.size(); ++i) {
                sb.append(this.mStartupTimestampsNs.keyAt(i)).append("=").append(this.mStartupTimestampsNs.valueAt(i)).append(" ");
            }
            sb.append('\n');
        }
        pw.print(sb.toString());
    }

    private static String reasonToString(int reason) {
        String string2;
        switch (reason) {
            case 0: {
                string2 = "ALARM";
                break;
            }
            case 1: {
                string2 = "BACKUP";
                break;
            }
            case 2: {
                string2 = "BOOT COMPLETE";
                break;
            }
            case 3: {
                string2 = "BROADCAST";
                break;
            }
            case 4: {
                string2 = "CONTENT PROVIDER";
                break;
            }
            case 5: {
                string2 = "JOB";
                break;
            }
            case 6: {
                string2 = "LAUNCHER";
                break;
            }
            case 7: {
                string2 = "LAUNCHER RECENTS";
                break;
            }
            case 8: {
                string2 = "OTHER";
                break;
            }
            case 9: {
                string2 = "PUSH";
                break;
            }
            case 10: {
                string2 = "SERVICE";
                break;
            }
            case 11: {
                string2 = "START ACTIVITY";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    private static String startTypeToString(int startType) {
        String string2;
        switch (startType) {
            case 0: {
                string2 = "UNSET";
                break;
            }
            case 1: {
                string2 = "COLD";
                break;
            }
            case 2: {
                string2 = "WARM";
                break;
            }
            case 3: {
                string2 = "HOT";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    @FlaggedApi(value="android.app.app_start_info_component")
    private static String startComponentToString(int startComponent) {
        String string2;
        switch (startComponent) {
            case 1: {
                string2 = "ACTIVITY";
                break;
            }
            case 2: {
                string2 = "BROADCAST";
                break;
            }
            case 3: {
                string2 = "CONTENT PROVIDER";
                break;
            }
            case 4: {
                string2 = "SERVICE";
                break;
            }
            case 5: {
                string2 = "OTHER";
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || !(other instanceof ApplicationStartInfo)) {
            return false;
        }
        ApplicationStartInfo o = (ApplicationStartInfo)other;
        boolean intentEquals = true;
        if (com.android.internal.hidden_from_bootclasspath.android.content.flags.Flags.intentSaveToXmlPackage()) {
            intentEquals = this.mStartIntent == null ? o.mStartIntent == null : this.mStartIntent.filterEquals(o.mStartIntent);
        }
        return this.mPid == o.mPid && this.mRealUid == o.mRealUid && this.mPackageUid == o.mPackageUid && this.mDefiningUid == o.mDefiningUid && this.mReason == o.mReason && this.mStartupState == o.mStartupState && this.mStartType == o.mStartType && this.mLaunchMode == o.mLaunchMode && TextUtils.equals(this.mPackageName, o.mPackageName) && TextUtils.equals(this.mProcessName, o.mProcessName) && this.timestampsEquals(o) && this.mWasForceStopped == o.mWasForceStopped && this.mMonotonicCreationTimeMs == o.mMonotonicCreationTimeMs && this.mStartComponent == o.mStartComponent && intentEquals;
    }

    public int hashCode() {
        return Objects.hash(this.mPid, this.mRealUid, this.mPackageUid, this.mDefiningUid, this.mReason, this.mStartupState, this.mStartType, this.mLaunchMode, this.mPackageName, this.mProcessName, this.mStartupTimestampsNs, this.mMonotonicCreationTimeMs, this.mStartComponent, com.android.internal.hidden_from_bootclasspath.android.content.flags.Flags.intentSaveToXmlPackage() ? this.mStartIntent : null);
    }

    private boolean timestampsEquals(@NonNull ApplicationStartInfo other) {
        if (this.mStartupTimestampsNs == null && other.mStartupTimestampsNs == null) {
            return true;
        }
        if (this.mStartupTimestampsNs == null || other.mStartupTimestampsNs == null) {
            return false;
        }
        return this.mStartupTimestampsNs.equals(other.mStartupTimestampsNs);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartComponent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LaunchMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StartupState {
    }
}

