/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import java.util.Objects;

@FlaggedApi(value="android.companion.enable_task_continuity")
public class HandoffActivityData
implements Parcelable {
    @NonNull
    private ComponentName mComponentName;
    @NonNull
    private PersistableBundle mExtras;
    @Nullable
    private Uri mFallbackUri;
    @NonNull
    public static final Parcelable.Creator<HandoffActivityData> CREATOR = new Parcelable.Creator<HandoffActivityData>(){

        @Override
        public HandoffActivityData createFromParcel(Parcel in) {
            return new HandoffActivityData(in);
        }

        public HandoffActivityData[] newArray(int size) {
            return new HandoffActivityData[size];
        }
    };

    private HandoffActivityData(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mComponentName = builder.mComponentName;
        this.mExtras = builder.mExtras;
        this.mFallbackUri = builder.mFallbackUri;
    }

    private HandoffActivityData(Parcel in) {
        this.mComponentName = ComponentName.CREATOR.createFromParcel(in);
        this.mExtras = in.readPersistableBundle(this.getClass().getClassLoader());
        if (in.readInt() != 0) {
            this.mFallbackUri = Uri.CREATOR.createFromParcel(in);
        }
    }

    @NonNull
    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    @NonNull
    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    @Nullable
    public Uri getFallbackUri() {
        return this.mFallbackUri;
    }

    public int hashCode() {
        return Objects.hash(this.mComponentName, this.mExtras, this.mFallbackUri);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HandoffActivityData) {
            HandoffActivityData other = (HandoffActivityData)obj;
            return Objects.equals(this.mComponentName, other.mComponentName) && Objects.equals(this.mExtras, other.mExtras) && Objects.equals(this.mFallbackUri, other.mFallbackUri);
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.mComponentName.writeToParcel(dest, flags);
        dest.writePersistableBundle(this.mExtras);
        if (this.mFallbackUri != null) {
            dest.writeInt(1);
            this.mFallbackUri.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    @FlaggedApi(value="android.companion.enable_task_continuity")
    public static class Builder {
        @NonNull
        private ComponentName mComponentName;
        @NonNull
        private PersistableBundle mExtras;
        @Nullable
        private Uri mFallbackUri;

        public Builder(@NonNull ComponentName componentName) {
            this.mComponentName = Objects.requireNonNull(componentName);
            this.mExtras = new PersistableBundle();
            this.mFallbackUri = null;
        }

        @NonNull
        public Builder setExtras(@NonNull PersistableBundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder setFallbackUri(@Nullable Uri fallbackUri) {
            this.mFallbackUri = fallbackUri;
            return this;
        }

        @NonNull
        public HandoffActivityData build() {
            return new HandoffActivityData(this);
        }
    }
}

