/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;

public interface ICallNotificationEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ICallNotificationEventCallback";

    public void onCallNotificationPosted(String var1, UserHandle var2) throws RemoteException;

    public void onCallNotificationRemoved(String var1, UserHandle var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICallNotificationEventCallback {
        static final int TRANSACTION_onCallNotificationPosted = 1;
        static final int TRANSACTION_onCallNotificationRemoved = 2;

        public Stub() {
            this.attachInterface(this, ICallNotificationEventCallback.DESCRIPTOR);
        }

        public static ICallNotificationEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICallNotificationEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICallNotificationEventCallback) {
                return (ICallNotificationEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCallNotificationPosted";
                }
                case 2: {
                    return "onCallNotificationRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICallNotificationEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallNotificationPosted(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallNotificationRemoved(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICallNotificationEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICallNotificationEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallNotificationPosted(String packageName, UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallNotificationEventCallback.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallNotificationRemoved(String packageName, UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallNotificationEventCallback.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(userHandle, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICallNotificationEventCallback {
        @Override
        public void onCallNotificationPosted(String packageName, UserHandle userHandle) throws RemoteException {
        }

        @Override
        public void onCallNotificationRemoved(String packageName, UserHandle userHandle) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

