/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.IActivityManager;
import android.app.StackTrace;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.AndroidException;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.IResultReceiver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class PendingIntent
implements Parcelable {
    private static final String TAG = "PendingIntent";
    @NonNull
    private final IIntentSender mTarget;
    private IBinder mWhitelistToken;
    @Nullable
    private ActivityManager.PendingIntentInfo mCachedInfo;
    @GuardedBy(value={"mTarget"})
    @Nullable
    private CancelListerInfo mCancelListerInfo;
    static final long PENDING_INTENT_EXPLICIT_MUTABILITY_REQUIRED = 160794467L;
    public static final long BLOCK_MUTABLE_IMPLICIT_PENDING_INTENT = 236704164L;
    public static final long PENDING_INTENT_OPTIONS_CHECK = 320664730L;
    public static final int FLAG_ONE_SHOT = 0x40000000;
    public static final int FLAG_NO_CREATE = 0x20000000;
    public static final int FLAG_CANCEL_CURRENT = 0x10000000;
    public static final int FLAG_UPDATE_CURRENT = 0x8000000;
    public static final int FLAG_IMMUTABLE = 0x4000000;
    public static final int FLAG_MUTABLE = 0x2000000;
    @Deprecated
    public static final int FLAG_MUTABLE_UNAUDITED = 0x2000000;
    public static final int FLAG_ALLOW_UNSAFE_IMPLICIT_INTENT = 0x1000000;
    private static final ThreadLocal<List<OnMarshaledListener>> sOnMarshaledListener = ThreadLocal.withInitial(ArrayList::new);
    @NonNull
    public static final Parcelable.Creator<PendingIntent> CREATOR = new Parcelable.Creator<PendingIntent>(){

        @Override
        public PendingIntent createFromParcel(Parcel in) {
            IBinder target = in.readStrongBinder();
            return target != null ? new PendingIntent(target, in.getClassCookie(PendingIntent.class)) : null;
        }

        public PendingIntent[] newArray(int size) {
            return new PendingIntent[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static void setOnMarshaledListener(OnMarshaledListener listener) {
        List<OnMarshaledListener> listeners = sOnMarshaledListener.get();
        listeners.clear();
        if (listener != null) {
            listeners.add(listener);
        }
    }

    static void addOnMarshaledListener(OnMarshaledListener listener) {
        sOnMarshaledListener.get().add(listener);
    }

    static void removeOnMarshaledListener(OnMarshaledListener listener) {
        sOnMarshaledListener.get().remove(listener);
    }

    private static void checkPendingIntent(int flags, @NonNull Intent intent, @NonNull Context context, boolean isActivityResultType) {
        boolean isFlagImmutableSet = (flags & 0x4000000) != 0;
        boolean isFlagMutableSet = (flags & 0x2000000) != 0;
        String packageName = context.getPackageName();
        if (isFlagImmutableSet && isFlagMutableSet) {
            throw new IllegalArgumentException("Cannot set both FLAG_IMMUTABLE and FLAG_MUTABLE for PendingIntent");
        }
        if (Compatibility.isChangeEnabled(160794467L) && !isFlagImmutableSet && !isFlagMutableSet) {
            String msg = packageName + ": Targeting S+ (version " + 31 + " and above) requires that one of FLAG_IMMUTABLE or FLAG_MUTABLE be specified when creating a PendingIntent.\nStrongly consider using FLAG_IMMUTABLE, only use FLAG_MUTABLE if some functionality depends on the PendingIntent being mutable, e.g. if it needs to be used with inline replies or bubbles.";
            throw new IllegalArgumentException(msg);
        }
        if (PendingIntent.isNewMutableDisallowedImplicitPendingIntent(flags, intent, isActivityResultType) && !Compatibility.isChangeEnabled(236704164L)) {
            String msg = "New mutable implicit PendingIntent: pkg=" + packageName + ", action=" + intent.getAction() + ", featureId=" + context.getAttributionTag() + ". This will be blocked once the app targets U+ for security reasons.";
            Log.w(TAG, new StackTrace(msg));
        }
    }

    public static boolean isNewMutableDisallowedImplicitPendingIntent(int flags, @NonNull Intent intent, boolean isActivityResultType) {
        if (isActivityResultType) {
            return false;
        }
        boolean isFlagNoCreateSet = (flags & 0x20000000) != 0;
        boolean isFlagMutableSet = (flags & 0x2000000) != 0;
        boolean isImplicit = intent.getComponent() == null && intent.getPackage() == null;
        boolean isFlagAllowUnsafeImplicitIntentSet = (flags & 0x1000000) != 0;
        return !isFlagNoCreateSet && isFlagMutableSet && isImplicit && !isFlagAllowUnsafeImplicitIntentSet;
    }

    public static PendingIntent getActivity(Context context, int requestCode, Intent intent, int flags) {
        return PendingIntent.getActivity(context, requestCode, intent, flags, null);
    }

    public static PendingIntent getActivity(Context context, int requestCode, @NonNull Intent intent, int flags, @Nullable Bundle options) {
        UserHandle user = context.getUser();
        return PendingIntent.getActivityAsUser(context, requestCode, intent, flags, options, user != null ? user : UserHandle.of(context.getUserId()));
    }

    @UnsupportedAppUsage
    public static PendingIntent getActivityAsUser(Context context, int requestCode, @NonNull Intent intent, int flags, Bundle options, UserHandle user) {
        String packageName = context.getPackageName();
        String resolvedType = intent.resolveTypeIfNeeded(context.getContentResolver());
        PendingIntent.checkPendingIntent(flags, intent, context, false);
        try {
            String[] stringArray;
            intent.migrateExtraStreamToClipData(context);
            intent.prepareToLeaveProcess(context);
            IActivityManager iActivityManager = ActivityManager.getService();
            String string2 = context.getAttributionTag();
            Intent[] intentArray = new Intent[]{intent};
            if (resolvedType != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = resolvedType;
            } else {
                stringArray = null;
            }
            IIntentSender target = iActivityManager.getIntentSenderWithFeature(2, packageName, string2, null, null, requestCode, intentArray, stringArray, flags, options, user.getIdentifier());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static PendingIntent getActivities(Context context, int requestCode, @NonNull Intent[] intents, int flags) {
        return PendingIntent.getActivities(context, requestCode, intents, flags, null);
    }

    public static PendingIntent getActivities(Context context, int requestCode, @NonNull Intent[] intents, int flags, @Nullable Bundle options) {
        UserHandle user = context.getUser();
        return PendingIntent.getActivitiesAsUser(context, requestCode, intents, flags, options, user != null ? user : UserHandle.of(context.getUserId()));
    }

    public static PendingIntent getActivitiesAsUser(Context context, int requestCode, @NonNull Intent[] intents, int flags, Bundle options, UserHandle user) {
        String packageName = context.getPackageName();
        String[] resolvedTypes = new String[intents.length];
        for (int i = 0; i < intents.length; ++i) {
            intents[i].migrateExtraStreamToClipData(context);
            intents[i].prepareToLeaveProcess(context);
            resolvedTypes[i] = intents[i].resolveTypeIfNeeded(context.getContentResolver());
            PendingIntent.checkPendingIntent(flags, intents[i], context, false);
        }
        try {
            IIntentSender target = ActivityManager.getService().getIntentSenderWithFeature(2, packageName, context.getAttributionTag(), null, null, requestCode, intents, resolvedTypes, flags, options, user.getIdentifier());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static PendingIntent getBroadcast(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return PendingIntent.getBroadcastAsUser(context, requestCode, intent, flags, context.getUser());
    }

    @UnsupportedAppUsage
    public static PendingIntent getBroadcastAsUser(Context context, int requestCode, Intent intent, int flags, UserHandle userHandle) {
        String packageName = context.getPackageName();
        String resolvedType = intent.resolveTypeIfNeeded(context.getContentResolver());
        PendingIntent.checkPendingIntent(flags, intent, context, false);
        try {
            String[] stringArray;
            intent.prepareToLeaveProcess(context);
            IActivityManager iActivityManager = ActivityManager.getService();
            String string2 = context.getAttributionTag();
            Intent[] intentArray = new Intent[]{intent};
            if (resolvedType != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = resolvedType;
            } else {
                stringArray = null;
            }
            IIntentSender target = iActivityManager.getIntentSenderWithFeature(1, packageName, string2, null, null, requestCode, intentArray, stringArray, flags, null, userHandle.getIdentifier());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static PendingIntent getService(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return PendingIntent.buildServicePendingIntent(context, requestCode, intent, flags, 4);
    }

    public static PendingIntent getForegroundService(Context context, int requestCode, @NonNull Intent intent, int flags) {
        return PendingIntent.buildServicePendingIntent(context, requestCode, intent, flags, 5);
    }

    private static PendingIntent buildServicePendingIntent(Context context, int requestCode, Intent intent, int flags, int serviceKind) {
        String packageName = context.getPackageName();
        String resolvedType = intent.resolveTypeIfNeeded(context.getContentResolver());
        PendingIntent.checkPendingIntent(flags, intent, context, false);
        try {
            String[] stringArray;
            intent.prepareToLeaveProcess(context);
            IActivityManager iActivityManager = ActivityManager.getService();
            String string2 = context.getAttributionTag();
            Intent[] intentArray = new Intent[]{intent};
            if (resolvedType != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = resolvedType;
            } else {
                stringArray = null;
            }
            IIntentSender target = iActivityManager.getIntentSenderWithFeature(serviceKind, packageName, string2, null, null, requestCode, intentArray, stringArray, flags, null, context.getUserId());
            return target != null ? new PendingIntent(target) : null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public IntentSender getIntentSender() {
        return new IntentSender(this.mTarget, this.mWhitelistToken);
    }

    public void cancel() {
        try {
            ActivityManager.getService().cancelIntentSender(this.mTarget);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void send() throws CanceledException {
        this.send(null, 0, null, null, null, null, null);
    }

    public void send(int code) throws CanceledException {
        this.send(null, code, null, null, null, null, null);
    }

    public void send(Context context, int code, @Nullable Intent intent) throws CanceledException {
        this.send(context, code, intent, null, null, null, null);
    }

    public void send(@Nullable Bundle options) throws CanceledException {
        this.send(null, 0, null, null, null, null, options);
    }

    public void send(int code, @Nullable OnFinished onFinished, @Nullable Handler handler) throws CanceledException {
        this.send(null, code, null, onFinished, handler, null, null);
    }

    public void send(Context context, int code, @Nullable Intent intent, @Nullable OnFinished onFinished, @Nullable Handler handler) throws CanceledException {
        this.send(context, code, intent, onFinished, handler, null, null);
    }

    public void send(Context context, int code, @Nullable Intent intent, @Nullable OnFinished onFinished, @Nullable Handler handler, @Nullable String requiredPermission) throws CanceledException {
        this.send(context, code, intent, onFinished, handler, requiredPermission, null);
    }

    public void send(Context context, int code, @Nullable Intent intent, @Nullable OnFinished onFinished, @Nullable Handler handler, @Nullable String requiredPermission, @Nullable Bundle options) throws CanceledException {
        if (this.sendAndReturnResult(context, code, intent, onFinished, handler, requiredPermission, options) < 0) {
            throw new CanceledException();
        }
    }

    public int sendAndReturnResult(Context context, int code, @Nullable Intent intent, @Nullable OnFinished onFinished, @Nullable Handler handler, @Nullable String requiredPermission, @Nullable Bundle options) throws CanceledException {
        try {
            String resolvedType;
            if (intent != null) {
                intent.collectExtraIntentKeys();
            }
            String string2 = resolvedType = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
            if (context != null && this.isActivity()) {
                ActivityOptions activityOptions = options != null ? new ActivityOptions(options) : ActivityOptions.makeBasic();
                activityOptions.setCallerDisplayId(context.getDisplayId());
                options = activityOptions.toBundle();
            }
            ActivityThread.ApplicationThread app = ActivityThread.currentActivityThread().getApplicationThread();
            return ActivityManager.getService().sendIntentSender(app, this.mTarget, this.mWhitelistToken, code, intent, resolvedType, onFinished != null ? new FinishedDispatcher(this, onFinished, handler) : null, requiredPermission, options);
        }
        catch (RemoteException e) {
            throw new CanceledException(e);
        }
    }

    @Deprecated
    @Nullable
    public String getTargetPackage() {
        return this.getCreatorPackage();
    }

    @Nullable
    public String getCreatorPackage() {
        return this.getCachedInfo().getCreatorPackage();
    }

    public int getCreatorUid() {
        return this.getCachedInfo().getCreatorUid();
    }

    @Deprecated
    public void registerCancelListener(@NonNull CancelListener cancelListener) {
        if (!this.addCancelListener(Runnable::run, cancelListener)) {
            cancelListener.onCanceled(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public boolean addCancelListener(@NonNull Executor executor, @NonNull CancelListener cancelListener) {
        IIntentSender iIntentSender = this.mTarget;
        synchronized (iIntentSender) {
            if (this.mCancelListerInfo != null && this.mCancelListerInfo.mCanceled) {
                return false;
            }
            if (this.mCancelListerInfo == null) {
                this.mCancelListerInfo = new CancelListerInfo();
            }
            CancelListerInfo cli = this.mCancelListerInfo;
            boolean wasEmpty = cli.mCancelListeners.isEmpty();
            cli.mCancelListeners.add(Pair.create(executor, cancelListener));
            if (wasEmpty) {
                boolean success;
                try {
                    success = ActivityManager.getService().registerIntentSenderCancelListenerEx(this.mTarget, cli);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                if (!success) {
                    cli.mCanceled = true;
                }
                return success;
            }
            return !cli.mCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCancelListeners() {
        ArraySet<Pair<Executor, CancelListener>> cancelListeners;
        IIntentSender iIntentSender = this.mTarget;
        synchronized (iIntentSender) {
            CancelListerInfo cli = this.mCancelListerInfo;
            cli.mCanceled = true;
            cancelListeners = new ArraySet<Pair<Executor, CancelListener>>(cli.mCancelListeners);
            cli.mCancelListeners.clear();
        }
        int size = cancelListeners.size();
        for (int i = 0; i < size; ++i) {
            Pair<Executor, CancelListener> pair = cancelListeners.valueAt(i);
            ((Executor)pair.first).execute(() -> ((CancelListener)pair.second).onCanceled(this));
        }
    }

    @Deprecated
    public void unregisterCancelListener(CancelListener cancelListener) {
        this.removeCancelListener(cancelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void removeCancelListener(@NonNull CancelListener cancelListener) {
        IIntentSender iIntentSender = this.mTarget;
        synchronized (iIntentSender) {
            CancelListerInfo cli = this.mCancelListerInfo;
            if (cli == null || cli.mCancelListeners.size() == 0) {
                return;
            }
            for (int i = cli.mCancelListeners.size() - 1; i >= 0; --i) {
                if (cli.mCancelListeners.valueAt((int)i).second != cancelListener) continue;
                cli.mCancelListeners.removeAt(i);
            }
            if (cli.mCancelListeners.isEmpty()) {
                try {
                    ActivityManager.getService().unregisterIntentSenderCancelListener(this.mTarget, cli);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @NonNull
    public UserHandle getCreatorUserHandle() {
        int uid = this.getCachedInfo().getCreatorUid();
        return UserHandle.getUserHandleForUid(uid);
    }

    public boolean isTargetedToPackage() {
        try {
            return ActivityManager.getService().isIntentSenderTargetedToPackage(this.mTarget);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isImmutable() {
        return this.getCachedInfo().isImmutable();
    }

    public boolean isActivity() {
        return this.getCachedInfo().getIntentSenderType() == 2;
    }

    public boolean isForegroundService() {
        return this.getCachedInfo().getIntentSenderType() == 5;
    }

    public boolean isService() {
        return this.getCachedInfo().getIntentSenderType() == 4;
    }

    public boolean isBroadcast() {
        return this.getCachedInfo().getIntentSenderType() == 1;
    }

    @UnsupportedAppUsage
    public Intent getIntent() {
        try {
            return ActivityManager.getService().getIntentForIntentSender(this.mTarget);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public String getTag(String prefix) {
        try {
            return ActivityManager.getService().getTagForIntentSender(this.mTarget, prefix);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.GET_INTENT_SENDER_INTENT")
    @NonNull
    public List<ResolveInfo> queryIntentComponents(int flags) {
        try {
            ParceledListSlice parceledList = ActivityManager.getService().queryIntentComponentsForIntentSender(this.mTarget, flags);
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.GET_INTENT_SENDER_INTENT")
    public boolean intentFilterEquals(@Nullable PendingIntent other) {
        if (other == null) {
            return false;
        }
        try {
            return ActivityManager.getService().getIntentForIntentSender(other.mTarget).filterEquals(this.getIntent());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj instanceof PendingIntent) {
            return this.mTarget.asBinder().equals(((PendingIntent)otherObj).mTarget.asBinder());
        }
        return false;
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PendingIntent{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(": ");
        sb.append(this.mTarget.asBinder());
        sb.append('}');
        return sb.toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mTarget.asBinder().toString());
        proto.end(token);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeStrongBinder(this.mTarget.asBinder());
        List<OnMarshaledListener> listeners = sOnMarshaledListener.get();
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            listeners.get(i).onMarshaled(this, out, flags);
        }
    }

    public static void writePendingIntentOrNullToParcel(@Nullable PendingIntent sender, @NonNull Parcel out) {
        out.writeStrongBinder(sender != null ? sender.mTarget.asBinder() : null);
        if (sender != null) {
            List<OnMarshaledListener> listeners = sOnMarshaledListener.get();
            int numListeners = listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                listeners.get(i).onMarshaled(sender, out, 0);
            }
        }
    }

    @Nullable
    public static PendingIntent readPendingIntentOrNullFromParcel(@NonNull Parcel in) {
        IBinder b = in.readStrongBinder();
        return b != null ? new PendingIntent(b, in.getClassCookie(PendingIntent.class)) : null;
    }

    public PendingIntent(IIntentSender target) {
        this.mTarget = Objects.requireNonNull(target);
    }

    PendingIntent(IBinder target, Object cookie) {
        this.mTarget = Objects.requireNonNull(IIntentSender.Stub.asInterface(target));
        if (cookie != null) {
            this.mWhitelistToken = (IBinder)cookie;
        }
    }

    public IIntentSender getTarget() {
        return this.mTarget;
    }

    public IBinder getWhitelistToken() {
        return this.mWhitelistToken;
    }

    private ActivityManager.PendingIntentInfo getCachedInfo() {
        if (this.mCachedInfo == null) {
            try {
                this.mCachedInfo = ActivityManager.getService().getInfoForIntentSender(this.mTarget);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mCachedInfo;
    }

    public static interface OnFinished {
        public void onSendFinished(PendingIntent var1, Intent var2, int var3, String var4, Bundle var5);
    }

    public static class CanceledException
    extends AndroidException {
        public CanceledException() {
        }

        public CanceledException(String name) {
            super(name);
        }

        public CanceledException(Exception cause) {
            super(cause);
        }
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final PendingIntent mPendingIntent;
        private final OnFinished mWho;
        private final Handler mHandler;
        private Intent mIntent;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;
        private static Handler sDefaultSystemHandler;

        FinishedDispatcher(PendingIntent pi, OnFinished who, Handler handler) {
            this.mPendingIntent = pi;
            this.mWho = who;
            if (handler == null && ActivityThread.isSystem()) {
                if (sDefaultSystemHandler == null) {
                    sDefaultSystemHandler = new Handler(Looper.getMainLooper());
                }
                this.mHandler = sDefaultSystemHandler;
            } else {
                this.mHandler = handler;
            }
        }

        @Override
        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean serialized, boolean sticky, int sendingUser) {
            this.mIntent = intent;
            this.mResultCode = resultCode;
            this.mResultData = data;
            this.mResultExtras = extras;
            if (this.mHandler == null) {
                this.run();
            } else {
                this.mHandler.post(this);
            }
        }

        @Override
        public void run() {
            this.mWho.onSendFinished(this.mPendingIntent, this.mIntent, this.mResultCode, this.mResultData, this.mResultExtras);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface CancelListener {
        public void onCanceled(@NonNull PendingIntent var1);
    }

    private class CancelListerInfo
    extends IResultReceiver.Stub {
        private final ArraySet<Pair<Executor, CancelListener>> mCancelListeners = new ArraySet();
        private boolean mCanceled;

        private CancelListerInfo() {
        }

        @Override
        public void send(int resultCode, Bundle resultData) throws RemoteException {
            PendingIntent.this.notifyCancelListeners();
        }
    }

    public static interface OnMarshaledListener {
        public void onMarshaled(PendingIntent var1, Parcel var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

