/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.RemoteAction;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class RecoverableSecurityException
extends SecurityException
implements Parcelable {
    private static final String TAG = "RecoverableSecurityException";
    private final CharSequence mUserMessage;
    private final RemoteAction mUserAction;
    @NonNull
    public static final Parcelable.Creator<RecoverableSecurityException> CREATOR = new Parcelable.Creator<RecoverableSecurityException>(){

        @Override
        public RecoverableSecurityException createFromParcel(Parcel source) {
            return new RecoverableSecurityException(source);
        }

        public RecoverableSecurityException[] newArray(int size) {
            return new RecoverableSecurityException[size];
        }
    };

    public RecoverableSecurityException(Parcel in) {
        this(new SecurityException(in.readString()), in.readCharSequence(), RemoteAction.CREATOR.createFromParcel(in));
    }

    public RecoverableSecurityException(@NonNull Throwable cause, @NonNull CharSequence userMessage, @NonNull RemoteAction userAction) {
        super(cause.getMessage());
        this.mUserMessage = Objects.requireNonNull(userMessage);
        this.mUserAction = Objects.requireNonNull(userAction);
    }

    @NonNull
    public CharSequence getUserMessage() {
        return this.mUserMessage;
    }

    @NonNull
    public RemoteAction getUserAction() {
        return this.mUserAction;
    }

    public void showAsNotification(Context context, String channelId) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        Notification.Builder builder = new Notification.Builder(context, channelId).setSmallIcon(17302979).setContentTitle(this.mUserAction.getTitle()).setContentText(this.mUserMessage).setContentIntent(this.mUserAction.getActionIntent()).setCategory("err");
        nm.notify(TAG, this.mUserAction.getActionIntent().getCreatorUid(), builder.build());
    }

    public void showAsDialog(Activity activity) {
        LocalDialog dialog = new LocalDialog();
        Bundle args = new Bundle();
        args.putParcelable(TAG, this);
        dialog.setArguments(args);
        String tag = "RecoverableSecurityException_" + this.mUserAction.getActionIntent().getCreatorUid();
        FragmentManager fm = activity.getFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Fragment old = fm.findFragmentByTag(tag);
        if (old != null) {
            ft.remove(old);
        }
        ft.add(dialog, tag);
        ft.commitAllowingStateLoss();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMessage());
        dest.writeCharSequence(this.mUserMessage);
        this.mUserAction.writeToParcel(dest, flags);
    }

    public static class LocalDialog
    extends DialogFragment {
        @Override
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            RecoverableSecurityException e = this.getArguments().getParcelable(RecoverableSecurityException.TAG, RecoverableSecurityException.class);
            return new AlertDialog.Builder(this.getActivity()).setMessage(e.mUserMessage).setPositiveButton(e.mUserAction.getTitle(), (dialog, which) -> {
                try {
                    e.mUserAction.getActionIntent().send();
                }
                catch (PendingIntent.CanceledException canceledException) {
                    // empty catch block
                }
            }).setNegativeButton(0x1040000, null).create();
        }
    }
}

