/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.app.PendingIntent;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.PrintWriter;
import java.util.Objects;

public class RemoteAction
implements Parcelable {
    private static final String TAG = "RemoteAction";
    private final Icon mIcon;
    private final CharSequence mTitle;
    private final CharSequence mContentDescription;
    private final PendingIntent mActionIntent;
    private boolean mEnabled;
    private boolean mShouldShowIcon;
    @NonNull
    public static final Parcelable.Creator<RemoteAction> CREATOR = new Parcelable.Creator<RemoteAction>(){

        @Override
        public RemoteAction createFromParcel(Parcel in) {
            return new RemoteAction(in);
        }

        public RemoteAction[] newArray(int size) {
            return new RemoteAction[size];
        }
    };

    RemoteAction(Parcel in) {
        this.mIcon = Icon.CREATOR.createFromParcel(in);
        this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mActionIntent = PendingIntent.CREATOR.createFromParcel(in);
        this.mEnabled = in.readBoolean();
        this.mShouldShowIcon = in.readBoolean();
    }

    public RemoteAction(@NonNull Icon icon, @NonNull CharSequence title, @NonNull CharSequence contentDescription, @NonNull PendingIntent intent) {
        if (icon == null || title == null || contentDescription == null || intent == null) {
            throw new IllegalArgumentException("Expected icon, title, content description and action callback");
        }
        this.mIcon = icon;
        this.mTitle = title;
        this.mContentDescription = contentDescription;
        this.mActionIntent = intent;
        this.mEnabled = true;
        this.mShouldShowIcon = true;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setShouldShowIcon(boolean shouldShowIcon) {
        this.mShouldShowIcon = shouldShowIcon;
    }

    public boolean shouldShowIcon() {
        return this.mShouldShowIcon;
    }

    @NonNull
    public Icon getIcon() {
        return this.mIcon;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @NonNull
    public PendingIntent getActionIntent() {
        return this.mActionIntent;
    }

    public RemoteAction clone() {
        RemoteAction action = new RemoteAction(this.mIcon, this.mTitle, this.mContentDescription, this.mActionIntent);
        action.setEnabled(this.mEnabled);
        action.setShouldShowIcon(this.mShouldShowIcon);
        return action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteAction)) {
            return false;
        }
        RemoteAction that = (RemoteAction)o;
        return this.mEnabled == that.mEnabled && this.mShouldShowIcon == that.mShouldShowIcon && this.mIcon.equals(that.mIcon) && this.mTitle.equals(that.mTitle) && this.mContentDescription.equals(that.mContentDescription) && this.mActionIntent.equals(that.mActionIntent);
    }

    public int hashCode() {
        return Objects.hash(this.mIcon, this.mTitle, this.mContentDescription, this.mActionIntent, this.mEnabled, this.mShouldShowIcon);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mIcon.writeToParcel(out, 0);
        TextUtils.writeToParcel(this.mTitle, out, flags);
        TextUtils.writeToParcel(this.mContentDescription, out, flags);
        this.mActionIntent.writeToParcel(out, flags);
        out.writeBoolean(this.mEnabled);
        out.writeBoolean(this.mShouldShowIcon);
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("title=" + this.mTitle);
        pw.print(" enabled=" + this.mEnabled);
        pw.print(" contentDescription=" + this.mContentDescription);
        pw.print(" icon=" + this.mIcon);
        pw.print(" action=" + this.mActionIntent.getIntent());
        pw.print(" shouldShowIcon=" + this.mShouldShowIcon);
        pw.println();
    }
}

