/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.app.Activity;
import android.app.ActivityTaskManager;
import android.app.IScreenCaptureObserver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArrayMap;
import java.util.concurrent.Executor;

public class ScreenCaptureCallbackHandler {
    private final IBinder mActivityToken;
    private final ScreenCaptureObserver mObserver;
    private final ArrayMap<Activity.ScreenCaptureCallback, ScreenCaptureRegistration> mScreenCaptureRegistrations = new ArrayMap();

    public ScreenCaptureCallbackHandler(@NonNull IBinder activityToken) {
        this.mActivityToken = activityToken;
        this.mObserver = new ScreenCaptureObserver(this.mScreenCaptureRegistrations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScreenCaptureCallback(@NonNull Executor executor, @NonNull Activity.ScreenCaptureCallback callback) {
        ScreenCaptureRegistration registration = new ScreenCaptureRegistration(executor, callback);
        ArrayMap<Activity.ScreenCaptureCallback, ScreenCaptureRegistration> arrayMap = this.mScreenCaptureRegistrations;
        synchronized (arrayMap) {
            if (this.mScreenCaptureRegistrations.containsKey(callback)) {
                throw new IllegalStateException("Capture observer already registered with the activity");
            }
            this.mScreenCaptureRegistrations.put(callback, registration);
            if (this.mScreenCaptureRegistrations.size() == 1) {
                try {
                    ActivityTaskManager.getService().registerScreenCaptureObserver(this.mActivityToken, this.mObserver);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterScreenCaptureCallback(@NonNull Activity.ScreenCaptureCallback callback) {
        ArrayMap<Activity.ScreenCaptureCallback, ScreenCaptureRegistration> arrayMap = this.mScreenCaptureRegistrations;
        synchronized (arrayMap) {
            if (!this.mScreenCaptureRegistrations.containsKey(callback)) {
                throw new IllegalStateException("Capture observer not registered with the activity");
            }
            this.mScreenCaptureRegistrations.remove(callback);
            if (this.mScreenCaptureRegistrations.size() == 0) {
                try {
                    ActivityTaskManager.getService().unregisterScreenCaptureObserver(this.mActivityToken, this.mObserver);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }
    }

    private static class ScreenCaptureObserver
    extends IScreenCaptureObserver.Stub {
        ArrayMap<Activity.ScreenCaptureCallback, ScreenCaptureRegistration> mRegistrations;

        ScreenCaptureObserver(ArrayMap<Activity.ScreenCaptureCallback, ScreenCaptureRegistration> registrations) {
            this.mRegistrations = registrations;
        }

        @Override
        public void onScreenCaptured() {
            for (ScreenCaptureRegistration registration : this.mRegistrations.values()) {
                registration.mExecutor.execute(() -> registration.mCallback.onScreenCaptured());
            }
        }
    }

    private static class ScreenCaptureRegistration {
        Executor mExecutor;
        Activity.ScreenCaptureCallback mCallback;

        ScreenCaptureRegistration(Executor executor, Activity.ScreenCaptureCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }
    }
}

