/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.database.AbstractCursor;
import android.database.MatrixCursor;

@SystemApi
public class StatsCursor
extends AbstractCursor {
    private final MatrixCursor mMatrixCursor;
    private final int[] mColumnTypes;
    private final String[] mColumnNames;
    private final int mRowCount;

    public StatsCursor(String[] queryData, String[] columnNames, int[] columnTypes, int rowCount) {
        this.mColumnTypes = columnTypes;
        this.mColumnNames = columnNames;
        this.mRowCount = rowCount;
        this.mMatrixCursor = new MatrixCursor(columnNames);
        for (int i = 0; i < rowCount; ++i) {
            MatrixCursor.RowBuilder builder = this.mMatrixCursor.newRow();
            for (int j = 0; j < columnNames.length; ++j) {
                int dataIndex = i * columnNames.length + j;
                builder.add(columnNames[j], (Object)queryData[dataIndex]);
            }
        }
    }

    @Override
    public int getCount() {
        return this.mRowCount;
    }

    @Override
    @NonNull
    public String[] getColumnNames() {
        return this.mColumnNames;
    }

    @Override
    @NonNull
    public String getString(int column) {
        return this.mMatrixCursor.getString(column);
    }

    @Override
    @SuppressLint(value={"NoByteOrShort"})
    public short getShort(int column) {
        return this.mMatrixCursor.getShort(column);
    }

    @Override
    public int getInt(int column) {
        return this.mMatrixCursor.getInt(column);
    }

    @Override
    public long getLong(int column) {
        return this.mMatrixCursor.getLong(column);
    }

    @Override
    public float getFloat(int column) {
        return this.mMatrixCursor.getFloat(column);
    }

    @Override
    public double getDouble(int column) {
        return this.mMatrixCursor.getDouble(column);
    }

    @Override
    public boolean isNull(int column) {
        return this.mMatrixCursor.isNull(column);
    }

    @Override
    public int getType(int column) {
        return this.mColumnTypes[column];
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        return this.mMatrixCursor.moveToPosition(newPosition);
    }
}

