/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.admin.PolicyKey;
import android.app.admin.PolicyState;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class DevicePolicyState
implements Parcelable {
    private final Map<UserHandle, Map<PolicyKey, PolicyState<?>>> mPolicies;
    @NonNull
    public static final Parcelable.Creator<DevicePolicyState> CREATOR = new Parcelable.Creator<DevicePolicyState>(){

        @Override
        public DevicePolicyState createFromParcel(Parcel source) {
            return new DevicePolicyState(source);
        }

        public DevicePolicyState[] newArray(int size) {
            return new DevicePolicyState[size];
        }
    };

    public DevicePolicyState(Map<UserHandle, Map<PolicyKey, PolicyState<?>>> policies) {
        this.mPolicies = Objects.requireNonNull(policies);
    }

    private DevicePolicyState(Parcel source) {
        this.mPolicies = new HashMap();
        int usersSize = source.readInt();
        for (int i = 0; i < usersSize; ++i) {
            UserHandle userHandle = UserHandle.of(source.readInt());
            this.mPolicies.put(userHandle, new HashMap());
            int policiesSize = source.readInt();
            for (int j = 0; j < policiesSize; ++j) {
                PolicyKey policyKey = (PolicyKey)source.readParcelable(PolicyKey.class.getClassLoader());
                PolicyState policyState = (PolicyState)source.readParcelable(PolicyState.class.getClassLoader());
                this.mPolicies.get(userHandle).put(policyKey, policyState);
            }
        }
    }

    @NonNull
    public Map<UserHandle, Map<PolicyKey, PolicyState<?>>> getPoliciesForAllUsers() {
        return this.mPolicies;
    }

    @NonNull
    public Map<PolicyKey, PolicyState<?>> getPoliciesForUser(@NonNull UserHandle user) {
        return this.mPolicies.containsKey(user) ? this.mPolicies.get(user) : new HashMap();
    }

    public String toString() {
        return "DevicePolicyState { mPolicies= " + this.mPolicies + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mPolicies.size());
        for (UserHandle user : this.mPolicies.keySet()) {
            dest.writeInt(user.getIdentifier());
            dest.writeInt(this.mPolicies.get(user).size());
            for (PolicyKey key : this.mPolicies.get(user).keySet()) {
                dest.writeParcelable(key, flags);
                dest.writeParcelable(this.mPolicies.get(user).get(key), flags);
            }
        }
    }
}

