/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.admin.Authority;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class EnforcingAdmin
implements Parcelable {
    private final String mPackageName;
    private final Authority mAuthority;
    private final UserHandle mUserHandle;
    private final ComponentName mComponentName;
    @NonNull
    public static final Parcelable.Creator<EnforcingAdmin> CREATOR = new Parcelable.Creator<EnforcingAdmin>(){

        @Override
        public EnforcingAdmin createFromParcel(Parcel source) {
            return new EnforcingAdmin(source);
        }

        public EnforcingAdmin[] newArray(int size) {
            return new EnforcingAdmin[size];
        }
    };

    public EnforcingAdmin(@NonNull String packageName, @NonNull Authority authority, @NonNull UserHandle userHandle) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mAuthority = Objects.requireNonNull(authority);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mComponentName = null;
    }

    public EnforcingAdmin(@NonNull String packageName, @NonNull Authority authority, @NonNull UserHandle userHandle, @Nullable ComponentName componentName) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mAuthority = Objects.requireNonNull(authority);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mComponentName = componentName;
    }

    private EnforcingAdmin(Parcel source) {
        this.mPackageName = Objects.requireNonNull(source.readString());
        this.mUserHandle = new UserHandle(source.readInt());
        this.mAuthority = Objects.requireNonNull((Authority)source.readParcelable(Authority.class.getClassLoader()));
        this.mComponentName = (ComponentName)source.readParcelable(ComponentName.class.getClassLoader());
    }

    @NonNull
    public Authority getAuthority() {
        return this.mAuthority;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @Nullable
    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnforcingAdmin other = (EnforcingAdmin)o;
        return Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mAuthority, other.mAuthority) && Objects.equals(this.mUserHandle, other.mUserHandle) && Objects.equals(this.mComponentName, other.mComponentName);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mAuthority, this.mUserHandle);
    }

    public String toString() {
        return "EnforcingAdmin { mPackageName= " + this.mPackageName + ", mAuthority= " + this.mAuthority + ", mUserHandle= " + this.mUserHandle + ", mComponentName= " + this.mComponentName + " }";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mUserHandle.getIdentifier());
        dest.writeParcelable(this.mAuthority, flags);
        dest.writeParcelable(this.mComponentName, flags);
    }
}

