/*
 * Decompiled with CFR 0.152.
 */
package android.app.adservices.consent;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ConsentParcel
implements Parcelable {
    public static final int UNKNOWN = 0;
    public static final int ALL_API = 1;
    public static final int TOPICS = 2;
    public static final int FLEDGE = 3;
    public static final int MEASUREMENT = 4;
    private final boolean mIsGiven;
    private final int mConsentApiType;
    @NonNull
    public static final Parcelable.Creator<ConsentParcel> CREATOR = new Parcelable.Creator<ConsentParcel>(){

        @Override
        public ConsentParcel createFromParcel(Parcel in) {
            return new ConsentParcel(in);
        }

        public ConsentParcel[] newArray(int size) {
            return new ConsentParcel[size];
        }
    };

    private ConsentParcel(@NonNull Builder builder) {
        this.mIsGiven = builder.mIsGiven;
        this.mConsentApiType = builder.mConsentApiType;
    }

    private ConsentParcel(@NonNull Parcel in) {
        this.mConsentApiType = in.readInt();
        this.mIsGiven = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mConsentApiType);
        out.writeBoolean(this.mIsGiven);
    }

    public int getConsentApiType() {
        return this.mConsentApiType;
    }

    public boolean isIsGiven() {
        return this.mIsGiven;
    }

    public static ConsentParcel createRevokedConsent(int consentApiType) {
        return new Builder().setConsentApiType(consentApiType).setIsGiven(false).build();
    }

    public static ConsentParcel createGivenConsent(int consentApiType) {
        return new Builder().setConsentApiType(consentApiType).setIsGiven(true).build();
    }

    public static class Builder {
        private int mConsentApiType = 0;
        private boolean mIsGiven = false;

        @NonNull
        public Builder setConsentApiType(int consentApiType) {
            this.mConsentApiType = consentApiType;
            return this;
        }

        @NonNull
        public Builder setIsGiven(Boolean isGiven) {
            this.mIsGiven = isGiven != null ? isGiven : false;
            return this;
        }

        @NonNull
        public ConsentParcel build() {
            if (this.mConsentApiType == 0) {
                throw new IllegalArgumentException("One must set the valid ConsentApiType");
            }
            return new ConsentParcel(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConsentApiType {
    }
}

