/*
 * Decompiled with CFR 0.152.
 */
package android.app.ambientcontext;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.app.ambientcontext.AmbientContextEventRequest;
import android.app.ambientcontext.IAmbientContextObserver;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IAmbientContextManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ambientcontext.IAmbientContextManager";

    public void registerObserver(AmbientContextEventRequest var1, PendingIntent var2, RemoteCallback var3) throws RemoteException;

    @RequiresPermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void registerObserverWithCallback(AmbientContextEventRequest var1, String var2, IAmbientContextObserver var3) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_AMBIENT_CONTEXT_EVENT")
    public void unregisterObserver(String var1) throws RemoteException;

    public void queryServiceStatus(int[] var1, String var2, RemoteCallback var3) throws RemoteException;

    public void startConsentActivity(int[] var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAmbientContextManager {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_registerObserver = 1;
        static final int TRANSACTION_registerObserverWithCallback = 2;
        static final int TRANSACTION_unregisterObserver = 3;
        static final int TRANSACTION_queryServiceStatus = 4;
        static final int TRANSACTION_startConsentActivity = 5;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IAmbientContextManager.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAmbientContextManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAmbientContextManager.DESCRIPTOR);
            if (iin != null && iin instanceof IAmbientContextManager) {
                return (IAmbientContextManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerObserver";
                }
                case 2: {
                    return "registerObserverWithCallback";
                }
                case 3: {
                    return "unregisterObserver";
                }
                case 4: {
                    return "queryServiceStatus";
                }
                case 5: {
                    return "startConsentActivity";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAmbientContextManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AmbientContextEventRequest _arg0 = data.readTypedObject(AmbientContextEventRequest.CREATOR);
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerObserver(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    AmbientContextEventRequest _arg0 = data.readTypedObject(AmbientContextEventRequest.CREATOR);
                    String _arg1 = data.readString();
                    IAmbientContextObserver _arg2 = IAmbientContextObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerObserverWithCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.queryServiceStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.startConsentActivity(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void unregisterObserver_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_AMBIENT_CONTEXT_EVENT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IAmbientContextManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAmbientContextManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeTypedObject(resultPendingIntent, 0);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerObserverWithCallback(AmbientContextEventRequest request, String packageName, IAmbientContextObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterObserver(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryServiceStatus(int[] eventTypes, String callingPackage, RemoteCallback statusCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeIntArray(eventTypes);
                    _data.writeString(callingPackage);
                    _data.writeTypedObject(statusCallback, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startConsentActivity(int[] eventTypes, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAmbientContextManager.DESCRIPTOR);
                    _data.writeIntArray(eventTypes);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAmbientContextManager {
        @Override
        public void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void registerObserverWithCallback(AmbientContextEventRequest request, String packageName, IAmbientContextObserver observer) throws RemoteException {
        }

        @Override
        public void unregisterObserver(String callingPackage) throws RemoteException {
        }

        @Override
        public void queryServiceStatus(int[] eventTypes, String callingPackage, RemoteCallback statusCallback) throws RemoteException {
        }

        @Override
        public void startConsentActivity(int[] eventTypes, String callingPackage) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

