/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.RequiresPermission;
import android.app.appfunctions.ExecuteAppFunctionAidlRequest;
import android.app.appfunctions.IAppFunctionEnabledCallback;
import android.app.appfunctions.IExecuteAppFunctionCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;

public interface IAppFunctionManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.appfunctions.IAppFunctionManager";

    @RequiresPermission(value="android.permission.EXECUTE_APP_FUNCTIONS", conditional=true)
    public ICancellationSignal executeAppFunction(ExecuteAppFunctionAidlRequest var1, IExecuteAppFunctionCallback var2) throws RemoteException;

    public void setAppFunctionEnabled(String var1, String var2, UserHandle var3, int var4, IAppFunctionEnabledCallback var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppFunctionManager {
        static final int TRANSACTION_executeAppFunction = 1;
        static final int TRANSACTION_setAppFunctionEnabled = 2;

        public Stub() {
            this.attachInterface(this, IAppFunctionManager.DESCRIPTOR);
        }

        public static IAppFunctionManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAppFunctionManager.DESCRIPTOR);
            if (iin != null && iin instanceof IAppFunctionManager) {
                return (IAppFunctionManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "executeAppFunction";
                }
                case 2: {
                    return "setAppFunctionEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAppFunctionManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ExecuteAppFunctionAidlRequest _arg0 = data.readTypedObject(ExecuteAppFunctionAidlRequest.CREATOR);
                    IExecuteAppFunctionCallback _arg1 = IExecuteAppFunctionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.executeAppFunction(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg3 = data.readInt();
                    IAppFunctionEnabledCallback _arg4 = IAppFunctionEnabledCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setAppFunctionEnabled(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAppFunctionManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAppFunctionManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal executeAppFunction(ExecuteAppFunctionAidlRequest request, IExecuteAppFunctionCallback callback) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppFunctionManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAppFunctionEnabled(String callingPackage, String functionIdentifier, UserHandle userHandle, int enabledState, IAppFunctionEnabledCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppFunctionManager.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(functionIdentifier);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(enabledState);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAppFunctionManager {
        @Override
        public ICancellationSignal executeAppFunction(ExecuteAppFunctionAidlRequest request, IExecuteAppFunctionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public void setAppFunctionEnabled(String callingPackage, String functionIdentifier, UserHandle userHandle, int enabledState, IAppFunctionEnabledCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

