/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GetSchemaResponseCreator;
import android.app.appsearch.InternalVisibilityConfig;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.SchemaVisibilityConfig;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="GetSchemaResponseCreator")
public class GetSchemaResponse
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<GetSchemaResponse> CREATOR = new GetSchemaResponseCreator();
    @SafeParcelable.Field(id=1, getter="getVersion")
    private final int mVersion;
    @SafeParcelable.Field(id=2)
    final List<AppSearchSchema> mSchemas;
    @SafeParcelable.Field(id=3)
    @Nullable
    final List<InternalVisibilityConfig> mVisibilityConfigs;
    @Nullable
    private Set<AppSearchSchema> mSchemasCached;
    @Nullable
    private Set<String> mSchemasNotDisplayedBySystemCached;
    @Nullable
    private Map<String, Set<PackageIdentifier>> mSchemasVisibleToPackagesCached;
    @Nullable
    private Map<String, Set<Set<Integer>>> mSchemasVisibleToPermissionsCached;
    @Nullable
    private Map<String, PackageIdentifier> mPubliclyVisibleSchemasCached;
    @Nullable
    private Map<String, Set<SchemaVisibilityConfig>> mSchemasVisibleToConfigsCached;

    @SafeParcelable.Constructor
    GetSchemaResponse(@SafeParcelable.Param(id=1) int version, @SafeParcelable.Param(id=2) @NonNull List<AppSearchSchema> schemas, @SafeParcelable.Param(id=3) @Nullable List<InternalVisibilityConfig> visibilityConfigs) {
        this.mVersion = version;
        this.mSchemas = Objects.requireNonNull(schemas);
        this.mVisibilityConfigs = visibilityConfigs;
    }

    public int getVersion() {
        return this.mVersion;
    }

    @NonNull
    public Set<AppSearchSchema> getSchemas() {
        if (this.mSchemasCached == null) {
            this.mSchemasCached = Collections.unmodifiableSet(new ArraySet<AppSearchSchema>(this.mSchemas));
        }
        return this.mSchemasCached;
    }

    @NonNull
    public Set<String> getSchemaTypesNotDisplayedBySystem() {
        List<InternalVisibilityConfig> visibilityConfigs = this.getVisibilityConfigsOrThrow();
        if (this.mSchemasNotDisplayedBySystemCached == null) {
            ArraySet<String> copy = new ArraySet<String>();
            for (int i = 0; i < visibilityConfigs.size(); ++i) {
                if (!visibilityConfigs.get(i).isNotDisplayedBySystem()) continue;
                copy.add(visibilityConfigs.get(i).getSchemaType());
            }
            this.mSchemasNotDisplayedBySystemCached = Collections.unmodifiableSet(copy);
        }
        return this.mSchemasNotDisplayedBySystemCached;
    }

    @NonNull
    public Map<String, Set<PackageIdentifier>> getSchemaTypesVisibleToPackages() {
        List<InternalVisibilityConfig> visibilityConfigs = this.getVisibilityConfigsOrThrow();
        if (this.mSchemasVisibleToPackagesCached == null) {
            ArrayMap<String, Set<PackageIdentifier>> copy = new ArrayMap<String, Set<PackageIdentifier>>();
            for (int i = 0; i < visibilityConfigs.size(); ++i) {
                InternalVisibilityConfig visibilityConfig = visibilityConfigs.get(i);
                List<PackageIdentifier> visibleToPackages = visibilityConfig.getVisibilityConfig().getAllowedPackages();
                if (visibleToPackages.isEmpty()) continue;
                copy.put(visibilityConfig.getSchemaType(), Collections.unmodifiableSet(new ArraySet<PackageIdentifier>(visibleToPackages)));
            }
            this.mSchemasVisibleToPackagesCached = Collections.unmodifiableMap(copy);
        }
        return this.mSchemasVisibleToPackagesCached;
    }

    @SuppressLint(value={"RequiresPermission"})
    @NonNull
    public Map<String, Set<Set<Integer>>> getRequiredPermissionsForSchemaTypeVisibility() {
        List<InternalVisibilityConfig> visibilityConfigs = this.getVisibilityConfigsOrThrow();
        if (this.mSchemasVisibleToPermissionsCached == null) {
            ArrayMap<String, Set<Set<Integer>>> copy = new ArrayMap<String, Set<Set<Integer>>>();
            for (int i = 0; i < visibilityConfigs.size(); ++i) {
                InternalVisibilityConfig visibilityConfig = visibilityConfigs.get(i);
                Set<Set<Integer>> visibleToPermissions = visibilityConfig.getVisibilityConfig().getRequiredPermissions();
                if (visibleToPermissions.isEmpty()) continue;
                copy.put(visibilityConfig.getSchemaType(), Collections.unmodifiableSet(visibleToPermissions));
            }
            this.mSchemasVisibleToPermissionsCached = Collections.unmodifiableMap(copy);
        }
        return this.mSchemasVisibleToPermissionsCached;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_publicly_visible_schema")
    @NonNull
    public Map<String, PackageIdentifier> getPubliclyVisibleSchemas() {
        List<InternalVisibilityConfig> visibilityConfigs = this.getVisibilityConfigsOrThrow();
        if (this.mPubliclyVisibleSchemasCached == null) {
            ArrayMap<String, PackageIdentifier> copy = new ArrayMap<String, PackageIdentifier>();
            for (int i = 0; i < visibilityConfigs.size(); ++i) {
                InternalVisibilityConfig visibilityConfig = visibilityConfigs.get(i);
                PackageIdentifier publiclyVisibleTargetPackage = visibilityConfig.getVisibilityConfig().getPubliclyVisibleTargetPackage();
                if (publiclyVisibleTargetPackage == null) continue;
                copy.put(visibilityConfig.getSchemaType(), publiclyVisibleTargetPackage);
            }
            this.mPubliclyVisibleSchemasCached = Collections.unmodifiableMap(copy);
        }
        return this.mPubliclyVisibleSchemasCached;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
    @NonNull
    public Map<String, Set<SchemaVisibilityConfig>> getSchemaTypesVisibleToConfigs() {
        List<InternalVisibilityConfig> visibilityConfigs = this.getVisibilityConfigsOrThrow();
        if (this.mSchemasVisibleToConfigsCached == null) {
            ArrayMap<String, Set<SchemaVisibilityConfig>> copy = new ArrayMap<String, Set<SchemaVisibilityConfig>>();
            for (int i = 0; i < visibilityConfigs.size(); ++i) {
                InternalVisibilityConfig visibilityConfig = visibilityConfigs.get(i);
                Set<SchemaVisibilityConfig> nestedVisibilityConfigs = visibilityConfig.getVisibleToConfigs();
                if (nestedVisibilityConfigs.isEmpty()) continue;
                copy.put(visibilityConfig.getSchemaType(), Collections.unmodifiableSet(nestedVisibilityConfigs));
            }
            this.mSchemasVisibleToConfigsCached = Collections.unmodifiableMap(copy);
        }
        return this.mSchemasVisibleToConfigsCached;
    }

    @NonNull
    private List<InternalVisibilityConfig> getVisibilityConfigsOrThrow() {
        List<InternalVisibilityConfig> visibilityConfigs = this.mVisibilityConfigs;
        if (visibilityConfigs == null) {
            throw new UnsupportedOperationException("Get visibility setting is not supported with this backend/Android API level combination.");
        }
        return visibilityConfigs;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        GetSchemaResponseCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private int mVersion = 0;
        private ArrayList<AppSearchSchema> mSchemas = new ArrayList();
        @Nullable
        private Map<String, InternalVisibilityConfig.Builder> mVisibilityConfigBuilders;
        private boolean mBuilt = false;

        public Builder() {
            this.setVisibilitySettingSupported(true);
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull GetSchemaResponse getSchemaResponse) {
            this.setVisibilitySettingSupported(true);
            this.mVersion = getSchemaResponse.mVersion;
            this.mSchemas.addAll(getSchemaResponse.mSchemas);
            if (getSchemaResponse.mVisibilityConfigs != null) {
                int count = getSchemaResponse.mVisibilityConfigs.size();
                for (int i = 0; i < count; ++i) {
                    InternalVisibilityConfig config = getSchemaResponse.mVisibilityConfigs.get(i);
                    this.mVisibilityConfigBuilders.put(config.getSchemaType(), new InternalVisibilityConfig.Builder(config));
                }
            }
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setVersion(int version) {
            Preconditions.checkArgument(version >= 0, "Version must be a non-negative number.");
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addSchema(@NonNull AppSearchSchema schema) {
            Objects.requireNonNull(schema);
            this.resetIfBuilt();
            this.mSchemas.add(schema);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSchemas() {
            this.resetIfBuilt();
            this.mSchemas.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder addSchemaTypeNotDisplayedBySystem(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getOrCreateVisibilityConfigBuilder(schemaType);
            visibilityConfigBuilder.setNotDisplayedBySystem(true);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSchemaTypeNotDisplayedBySystem(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getVisibilityConfigBuilder(schemaType);
            if (visibilityConfigBuilder != null) {
                visibilityConfigBuilder.setNotDisplayedBySystem(false);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setSchemaTypeVisibleToPackages(@NonNull String schemaType, @NonNull Set<PackageIdentifier> packageIdentifiers) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifiers);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getOrCreateVisibilityConfigBuilder(schemaType);
            for (PackageIdentifier packageIdentifier : packageIdentifiers) {
                visibilityConfigBuilder.addVisibleToPackage(packageIdentifier);
            }
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSchemaTypeVisibleToPackages(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getVisibilityConfigBuilder(schemaType);
            if (visibilityConfigBuilder != null) {
                visibilityConfigBuilder.clearVisibleToPackages();
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder", "RequiresPermission"})
        @NonNull
        public Builder setRequiredPermissionsForSchemaTypeVisibility(@NonNull String schemaType, @NonNull Set<Set<Integer>> visibleToPermissionSets) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(visibleToPermissionSets);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getOrCreateVisibilityConfigBuilder(schemaType);
            for (Set<Integer> visibleToPermissions : visibleToPermissionSets) {
                visibilityConfigBuilder.addVisibleToPermissions(visibleToPermissions);
            }
            return this;
        }

        @SuppressLint(value={"RequiresPermission"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearRequiredPermissionsForSchemaTypeVisibility(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getVisibilityConfigBuilder(schemaType);
            if (visibilityConfigBuilder != null) {
                visibilityConfigBuilder.clearVisibleToPermissions();
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_set_publicly_visible_schema")
        @NonNull
        public Builder setPubliclyVisibleSchema(@NonNull String schemaType, @NonNull PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifier);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getOrCreateVisibilityConfigBuilder(schemaType);
            visibilityConfigBuilder.setPubliclyVisibleTargetPackage(packageIdentifier);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearPubliclyVisibleSchema(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getVisibilityConfigBuilder(schemaType);
            if (visibilityConfigBuilder != null) {
                visibilityConfigBuilder.setPubliclyVisibleTargetPackage(null);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
        @NonNull
        public Builder setSchemaTypeVisibleToConfigs(@NonNull String schemaType, @NonNull Set<SchemaVisibilityConfig> visibleToConfigs) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(visibleToConfigs);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getOrCreateVisibilityConfigBuilder(schemaType);
            for (SchemaVisibilityConfig visibleToConfig : visibleToConfigs) {
                visibilityConfigBuilder.addVisibleToConfig(visibleToConfig);
            }
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSchemaTypeVisibleToConfigs(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            InternalVisibilityConfig.Builder visibilityConfigBuilder = this.getVisibilityConfigBuilder(schemaType);
            if (visibilityConfigBuilder != null) {
                visibilityConfigBuilder.clearVisibleToConfig();
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setVisibilitySettingSupported(boolean visibilitySettingSupported) {
            this.mVisibilityConfigBuilders = visibilitySettingSupported ? new ArrayMap<String, InternalVisibilityConfig.Builder>() : null;
            return this;
        }

        @NonNull
        public GetSchemaResponse build() {
            ArrayList<InternalVisibilityConfig> visibilityConfigs = null;
            if (this.mVisibilityConfigBuilders != null) {
                visibilityConfigs = new ArrayList<InternalVisibilityConfig>();
                for (InternalVisibilityConfig.Builder builder : this.mVisibilityConfigBuilders.values()) {
                    visibilityConfigs.add(builder.build());
                }
            }
            this.mBuilt = true;
            return new GetSchemaResponse(this.mVersion, this.mSchemas, visibilityConfigs);
        }

        @NonNull
        private InternalVisibilityConfig.Builder getOrCreateVisibilityConfigBuilder(@NonNull String schemaType) {
            if (this.mVisibilityConfigBuilders == null) {
                throw new IllegalStateException("GetSchemaResponse is not configured withvisibility setting support");
            }
            InternalVisibilityConfig.Builder builder = this.mVisibilityConfigBuilders.get(schemaType);
            if (builder == null) {
                builder = new InternalVisibilityConfig.Builder(schemaType);
                this.mVisibilityConfigBuilders.put(schemaType, builder);
            }
            return builder;
        }

        @Nullable
        private InternalVisibilityConfig.Builder getVisibilityConfigBuilder(@NonNull String schemaType) {
            if (this.mVisibilityConfigBuilders == null) {
                throw new IllegalStateException("GetSchemaResponse is not configured withvisibility setting support");
            }
            return this.mVisibilityConfigBuilders.get(schemaType);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSchemas = new ArrayList<AppSearchSchema>(this.mSchemas);
                this.mBuilt = false;
            }
        }
    }
}

