/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.ReportUsageRequestCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.lang.System_Delegate;
import java.util.Objects;

@SafeParcelable.Class(creator="ReportUsageRequestCreator")
public class ReportUsageRequest
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<ReportUsageRequest> CREATOR = new ReportUsageRequestCreator();
    @SafeParcelable.Field(id=1, getter="getNamespace")
    @NonNull
    private final String mNamespace;
    @SafeParcelable.Field(id=2, getter="getDocumentId")
    @NonNull
    private final String mDocumentId;
    @SafeParcelable.Field(id=3, getter="getUsageTimestampMillis")
    private final long mUsageTimestampMillis;

    @SafeParcelable.Constructor
    ReportUsageRequest(@SafeParcelable.Param(id=1) @NonNull String namespace, @SafeParcelable.Param(id=2) @NonNull String documentId, @SafeParcelable.Param(id=3) long usageTimestampMillis) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mDocumentId = Objects.requireNonNull(documentId);
        this.mUsageTimestampMillis = usageTimestampMillis;
    }

    @NonNull
    public String getNamespace() {
        return this.mNamespace;
    }

    @NonNull
    public String getDocumentId() {
        return this.mDocumentId;
    }

    public long getUsageTimestampMillis() {
        return this.mUsageTimestampMillis;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        ReportUsageRequestCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private final String mNamespace;
        private final String mDocumentId;
        private Long mUsageTimestampMillis;

        public Builder(@NonNull String namespace, @NonNull String documentId) {
            this.mNamespace = Objects.requireNonNull(namespace);
            this.mDocumentId = Objects.requireNonNull(documentId);
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setUsageTimestampMillis(long usageTimestampMillis) {
            this.mUsageTimestampMillis = usageTimestampMillis;
            return this;
        }

        @NonNull
        public ReportUsageRequest build() {
            if (this.mUsageTimestampMillis == null) {
                this.mUsageTimestampMillis = System_Delegate.currentTimeMillis();
            }
            return new ReportUsageRequest(this.mNamespace, this.mDocumentId, this.mUsageTimestampMillis);
        }
    }
}

